
Class gingerfast Expands KFMonster;

#exec MESH MODELIMPORT MESH=GingerFast MODELFILE=Models\GingerFast.psk
#exec MESH LODPARAMS MESH=GingerFast HYSTERESIS=0.00 STRENGTH=0.01 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN MESH=GingerFast X=0 Y=0 Z=45 YAW=194 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=GoreFast_Anim ANIMFILE=Models\GoreFast_Anim.psa COMPRESS=1
#exec MESHMAP SCALE MESHMAP=GingerFast X=1.0 Y=1.0 Z=1.0

#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=PistolWhip STARTFRAME=0 		NUMFRAMES=44 	RATE=44
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Punch 		STARTFRAME=44 		NUMFRAMES=42 	RATE=42
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Jump2 		STARTFRAME=869 	NUMFRAMES=40 	RATE=40
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Walk 		STARTFRAME=1082 	NUMFRAMES=91 	RATE=91
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=WalkFire 	STARTFRAME=2027 	NUMFRAMES=120 	RATE=120
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Dead1 		STARTFRAME=86 		NUMFRAMES=80 	RATE=80
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Hit 			STARTFRAME=447 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=GutHit 		STARTFRAME=447 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=LeftHit 	STARTFRAME=488 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=RightHit 	STARTFRAME=529 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Breath2 	STARTFRAME=1040 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Charge 		STARTFRAME=2147 	NUMFRAMES=120 	RATE=120
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=CockGun 	STARTFRAME=654 	NUMFRAMES=201 	RATE=201
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Fighter 	STARTFRAME=0 		NUMFRAMES=1 	RATE=1
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=GutShot 	STARTFRAME=654 	NUMFRAMES=201 	RATE=201
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=HeadHit 	STARTFRAME=591 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=StillLook 	STARTFRAME=366 	NUMFRAMES=81 	RATE=81
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Precharg 	STARTFRAME=570 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Sleep 		STARTFRAME=166 	NUMFRAMES=200 	RATE=200
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=StillFire 	STARTFRAME=366 	NUMFRAMES=81 	RATE=81
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=T8 			STARTFRAME=366 	NUMFRAMES=81 	RATE=81

/* unused
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=GoreAttack1 STARTFRAME=0 NUMFRAMES=44 RATE=44
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=GoreAttack2 STARTFRAME=44 NUMFRAMES=42 RATE=42
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=KnockDown STARTFRAME=86 NUMFRAMES=80 RATE=80
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=ZombieFeed STARTFRAME=166 NUMFRAMES=200 RATE=200
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=HeadLoss STARTFRAME=366 NUMFRAMES=81 RATE=81
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=HitF2 STARTFRAME=447 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=HitF3 STARTFRAME=488 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=HitF STARTFRAME=529 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=HitReactionB STARTFRAME=570 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=HitReactionF STARTFRAME=591 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=HitReactionL STARTFRAME=612 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=HitReactionR STARTFRAME=633 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=GoreIdle STARTFRAME=654 NUMFRAMES=201 RATE=201
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Jump STARTFRAME=855 NUMFRAMES=14 RATE=14
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Jump2 STARTFRAME=869 NUMFRAMES=40 RATE=40
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=InAir STARTFRAME=909 NUMFRAMES=10 RATE=10
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=Landed STARTFRAME=919 NUMFRAMES=7 RATE=7
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=ZombieRun STARTFRAME=926 NUMFRAMES=114 RATE=114
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=TurnLeft STARTFRAME=1040 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=TurnRight STARTFRAME=1061 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=GoreWalk STARTFRAME=1082 NUMFRAMES=91 RATE=91
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=RunL STARTFRAME=1173 NUMFRAMES=91 RATE=91
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=RunR STARTFRAME=1264 NUMFRAMES=91 RATE=91
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=WalkF_Headless STARTFRAME=1355 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=WalkB_Headless STARTFRAME=1655 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=DodgeB STARTFRAME=1955 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=DodgeF STARTFRAME=1964 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=DodgeL STARTFRAME=1973 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=DodgeR STARTFRAME=1982 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=DoorBash STARTFRAME=1991 NUMFRAMES=36 RATE=36
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=WalkF_Fire STARTFRAME=2027 NUMFRAMES=120 RATE=120
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=WalkB_Fire STARTFRAME=2147 NUMFRAMES=120 RATE=120
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=WalkL_Fire STARTFRAME=2267 NUMFRAMES=120 RATE=120
#exec ANIM SEQUENCE ANIM=GoreFast_Anim SEQ=WalkR_Fire STARTFRAME=2387 NUMFRAMES=120 RATE=120
*/

#exec ANIM DIGEST ANIM=GoreFast_Anim
#exec MESH DEFAULTANIM MESH=GingerFast ANIM=GoreFast_Anim

//Adds
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=WalkFire 		TIME=0.18 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=WalkFire 		TIME=0.68 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=StillFire 		TIME=0.5 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=Punch 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=GutShot 		TIME=0.3 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=GutShot 		TIME=0.6 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=Charge 			TIME=0.25 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=Charge 			TIME=0.75 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=GoreFast_Anim 	SEQ=Charge 			TIME=0.01 	FUNCTION=GingerRoar

var(Sounds) sound GingerRoar1;
var(Sounds) sound GingerRoar2;

function GingerRoar()
{
   if (FRand() < 0.5)
      PlaySound(GingerRoar1, SLOT_Interact);
   else
      PlaySound(GingerRoar2, SLOT_Interact);
}

//Single death anim on this model
function PlayBigDeath(name DamageType)
{
   PlaySound(Die2, SLOT_Talk, 4 * TransientSoundVolume);
   PlayAnim('Dead1',0.7,0.1);
}

function PlayHeadDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die3, SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayLeftDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die4,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayRightDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

//Slow things down
function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.3 + 0.5 * FRand();

   decision = FRand();
   if (AnimSequence == 'Sleep')
   {
      if (decision < 0.07)
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',0.5, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep', 0.2,0.4);
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',0.2,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', 0.3);
      else if (decision < 0.55)
         PlayAnim('CockGun', 0.3);
      else
         PlayAnim('Breath2', 0.5, 0.4);
   }
   else if (decision < 0.1)
      PlayAnim('StillLook', 0.3, 0.4);
   else
      PlayAnim('Breath2', 0.5, 0.4);
    
   if (AnimSequence == 'StillLook')
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else
      SetAlertness(0.0);
}

function PlayRunning()
{
   if (Focus == Destination)
   {
      LoopAnim('Walk', 0.3,,0.4);
      return;
   }

   LoopAnim('Walk', 0.3,,0.3);
}

state Charging
{
	ignores SeePlayer, HearNoise;

   function AnimEnd()
   {
      If (bBerserk)
         LoopAnim('Charge', 0.5,,0.5);
      else
         PlayCombatMove();
   }

   function Timer()
   {
      if (bBerserk && bLongBerserk && (FRand() < 0.3))
      {
         AccelRate = Default.AccelRate;
         GroundSpeed = Default.GroundSpeed;
         AmbientSound=None;
         bBerserk = false;
      }
      bLongBerserk = bBerserk;
    
      Super.Timer();
   }
            
   function BeginState()
   {
      GoBerserk();
      Super.BeginState();
   }

   function EndState()
   {
      if (bBerserk)
      {
         GroundSpeed = Default.GroundSpeed;
         AccelRate = Default.AccelRate;
      }
      Super.EndState();
   }
}

function PlayMeleeAttack()
{
   local float decision;
    
   decision = FRand();
   If (decision < 0.5)
   {
   	if (FRand() < 0.5)
        	PlaySound(PistolWhip, SLOT_Interact);
      else
			PlaySound(PistolWhip1, SLOT_Interact);
      PlayAnim('PistolWhip',0.5, 0.4);
   }
   else
   {
   	if (FRand() < 0.5)
        	PlaySound(Punch, SLOT_Interact);
      else
			PlaySound(Punch1, SLOT_Interact);
      PlayAnim('Punch',0.5, 0.4);
   }
}

defaultproperties
{
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'GingerFast'
   Multiskins(0)=gingerfast
   Multiskins(1)=
   Multiskins(2)=
   CollisionRadius=20.000000
   CollisionHeight=46.000000

   Health=340
   WhipDamage=20
   PunchDamage=20
   bHasRangedAttack=False
   bMovingRangedAttack=False
   bLeadTarget=True
   bCanStrafe=True
   RangedProjectile=Class''
 	ProjectileSpeed=700.000000
   MeleeRange=70.000000
   GroundSpeed=140.000000
   WaterSpeed=100.000000
   SightRadius=1500.000000

   footstep=Sound''
   Footstep2=Sound''
   PistolWhip=Sound'GoreAttack1'
   PistolWhip1=Sound'GoreAttack2'
   Punch=Sound'GoreAttack3'
   Punch1=Sound'GoreAttack4'
   PistolHit=Sound'UnrealShare.Brute.pstlhit1br'
   Die=Sound'GoreDeath1'
   Die2=Sound'GoreDeath2'
   Die3=Sound'GoreDeath3'
   Die4=Sound'GoreDeath4'
   HitSound1=Sound'GorePain1'
   HitSound2=Sound'GorePain2'
   Acquire=Sound'GoreAcquire'
   Fear=Sound'GoreFear'
   Roam=Sound'GoreRoam'
   Threaten=Sound'GoreThreaten'
	AmbientSound=Sound'UnrealShare.Brute.amb1br'
   Land=Sound'GoreJump'
   GingerRoar1=Sound'GoreRoar1'
   GingerRoar2=Sound'GoreRoar2'

   CarcassType=Class'UnrealShare.BruteCarcass'
}