
Class jackfrost Expands KFMonster;

#exec MESH MODELIMPORT MESH=JackFrost MODELFILE=Models\JackFrost.psk
#exec MESH LODPARAMS MESH=JackFrost HYSTERESIS=0.00 STRENGTH=0.01 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN MESH=JackFrost X=0 Y=0 Z=53 YAW=194 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=Burns_anim ANIMFILE=Models\jackfrost.psa COMPRESS=1
#exec MESHMAP SCALE MESHMAP=JackFrost X=1.0 Y=1.0 Z=1.0

#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Punch 		STARTFRAME=40 		NUMFRAMES=46 	RATE=46
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Fighter 	STARTFRAME=86 		NUMFRAMES=1 	RATE=1
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=GutHit 		STARTFRAME=86 		NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=HeadHit 	STARTFRAME=86 		NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Hit 			STARTFRAME=127 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=LeftHit 	STARTFRAME=251 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=RightHit 	STARTFRAME=272 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Breath2 	STARTFRAME=293 	NUMFRAMES=181 	RATE=181
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=CockGun 	STARTFRAME=293 	NUMFRAMES=181 	RATE=181
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=StillLook 	STARTFRAME=293 	NUMFRAMES=181 	RATE=181
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Sleep 		STARTFRAME=293 	NUMFRAMES=181 	RATE=181
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Jump2 		STARTFRAME=498 	NUMFRAMES=40 	RATE=40
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Dead1 		STARTFRAME=638 	NUMFRAMES=7 	RATE=7
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Dead2 		STARTFRAME=538 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Dead3 		STARTFRAME=638 	NUMFRAMES=7 	RATE=7
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Dead4 		STARTFRAME=538 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=T8 			STARTFRAME=645 	NUMFRAMES=61 	RATE=61
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=GutShot 	STARTFRAME=645 	NUMFRAMES=61 	RATE=61
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=StillFire 	STARTFRAME=645 	NUMFRAMES=61 	RATE=61
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=PistolWhip STARTFRAME=706 	NUMFRAMES=46 	RATE=46
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Precharg 	STARTFRAME=773 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Walk 		STARTFRAME=1274 	NUMFRAMES=180 	RATE=180
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=WalkFire 	STARTFRAME=1454 	NUMFRAMES=300 	RATE=300
#exec ANIM SEQUENCE ANIM=Burns_anim SEQ=Charge 		STARTFRAME=1454 	NUMFRAMES=300 	RATE=300

#exec ANIM DIGEST ANIM=Burns_anim
#exec MESH DEFAULTANIM MESH=JackFrost ANIM=Burns_anim

//Adds
//Line nulled, no gun on that side
//#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=WalkFire 		TIME=0.18 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=WalkFire 		TIME=0.4 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=StillFire 		TIME=0.4 	FUNCTION=SpawnLeftShot

#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=T8 				TIME=0.4 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=GutShot 		TIME=0.4 	FUNCTION=SpawnLeftShot


#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=Punch 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=Dead2 			TIME=0.5 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=Dead3 			TIME=0.52 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=Dead4 			TIME=0.71 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=Charge 			TIME=0.25 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=Charge 			TIME=0.75 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Burns_anim 	SEQ=Charge 			TIME=0.01 	FUNCTION=JackRoar

var(Sounds) sound JackRoar1;
var(Sounds) sound JackRoar2;

function JackRoar()
{
   if (FRand() < 0.5)
      PlaySound(JackRoar1, SLOT_Interact);
   else
      PlaySound(JackRoar2, SLOT_Interact);
}

//Slow things down
function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.3 + 0.5 * FRand();

   decision = FRand();
   if (AnimSequence == 'Sleep')
   {
      if (decision < 0.07)
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',0.5, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep', 0.3,0.4);
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',0.3,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', 0.3);
      else if (decision < 0.55)
         PlayAnim('CockGun', 0.5);
      else
         PlayAnim('Breath2', 0.5, 0.4);
   }
   else if (decision < 0.1)
      PlayAnim('StillLook', 0.3, 0.4);
   else
      PlayAnim('Breath2', 0.5, 0.4);
    
   if (AnimSequence == 'StillLook')
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else
      SetAlertness(0.0);
}

state Charging
{
	ignores SeePlayer, HearNoise;

   function AnimEnd()
   {
      If (bBerserk)
         LoopAnim('Charge', 0.5,,0.5);
      else
         PlayCombatMove();
   }

   function Timer()
   {
      if (bBerserk && bLongBerserk && (FRand() < 0.3))
      {
         AccelRate = Default.AccelRate;
         GroundSpeed = Default.GroundSpeed;
         AmbientSound=None;
         bBerserk = false;
      }
      bLongBerserk = bBerserk;
    
      Super.Timer();
   }
            
   function BeginState()
   {
      GoBerserk();
      Super.BeginState();
   }

   function EndState()
   {
      if (bBerserk)
      {
         GroundSpeed = Default.GroundSpeed;
         AccelRate = Default.AccelRate;
      }
      Super.EndState();
   }
}

function PlayRunning()
{
   if (Focus == Destination)
   {
      LoopAnim('Walk', 0.3,,0.4);
      return;
   }

   LoopAnim('Walk', 0.3,,0.3);
}

function PlayRangedAttack()
{
   if ((AnimSequence == 'T8') || (VSize(Target.Location - Location) > 230))
   {
      PlayAnim('StillFire');
//      SpawnLeftShot();
   }
   else
   {
      PlayAnim('StillFire');
//      SpawnLeftShot();
   }
}

function PlayWalking()
{
   LoopAnim('Walk', 0.3,,0.4);
}

function JackFireProjectile(vector StartOffset, float Accuracy)
{
   local vector X,Y,Z, projStart;
   local Projectile OneProj;

   MakeNoise(1.0);
   GetAxes(Rotation,X,Y,Z);
   projStart = Location + StartOffset.X * CollisionRadius * X + StartOffset.Y * CollisionRadius * Y + StartOffset.Z * CollisionRadius * Z;
	Spawn(Class'ParticleBurst2',,,projStart);
   Spawn(Class'JackFire',,,projStart);
   OneProj = spawn(class'SnowBigRock',self,'',projStart,AdjustAim(ProjectileSpeed, projStart, Accuracy, bLeadTarget, bWarnTarget));
   if(OneProj != None)
      OneProj.SetPhysics(PHYS_Projectile);
}

function SpawnLeftShot()
{
   JackFireProjectile( vect(1.2,0.7,0.4), 750);
}

defaultproperties
{
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'JackFrost'
   Multiskins(0)=HuskSnowman
   Multiskins(1)=
   Multiskins(2)=
   CollisionRadius=25.000000
   CollisionHeight=54.000000
   Health=340
   WhipDamage=20
   PunchDamage=20
   bHasRangedAttack=True
   bMovingRangedAttack=False
   bLeadTarget=True
   bCanStrafe=False
 	ProjectileSpeed=700.000000
   MeleeRange=70.000000
   GroundSpeed=140.000000
   WaterSpeed=100.000000
   SightRadius=1500.000000
   footstep=Sound'UnrealI.Mercenary.walk2mr'
   Footstep2=Sound'UnrealI.Mercenary.walk2mr'
   PistolWhip=Sound'JackAttack1'
   PistolWhip1=Sound'JackAttack2'
   Punch=Sound'JackAttack3'
   Punch1=Sound'JackAttack4'
   PistolHit=Sound'UnrealShare.Brute.pstlhit1br'
   Die=Sound'JackDeath1'
   Die2=Sound'JackDeath2'
   Die3=Sound'JackDeath3'
   Die4=Sound'JackDeath4'
   HitSound1=Sound'JackPain1'
   HitSound2=Sound'JackPain2'
   Acquire=Sound'JackAcquire'
   Fear=Sound'JackFear'
   Roam=Sound'JackRoam'
   Threaten=Sound'JackThreaten'
	AmbientSound=Sound'UnrealShare.Brute.amb1br'
   Land=Sound'JackJump'
   JackRoar1=Sound'JackRoar1'
   JackRoar2=Sound'JackRoar2'
   CarcassType=Class'JackCarcass'
}