
Class scrake Expands KFMonster;

#exec MESH MODELIMPORT MESH=ScrakeFrost MODELFILE=Models\ScrakeFrost.psk
#exec MESH LODPARAMS MESH=ScrakeFrost HYSTERESIS=0.00 STRENGTH=0.01 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN MESH=ScrakeFrost X=0 Y=0 Z=60 YAW=194 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=scrake_anim ANIMFILE=Models\scrake_anim.psa COMPRESS=1
#exec MESHMAP SCALE MESHMAP=ScrakeFrost X=1.0 Y=1.0 Z=1.0

#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Dead1 			STARTFRAME=2328 	NUMFRAMES=101 	RATE=101
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Sleep 			STARTFRAME=0 		NUMFRAMES=300 	RATE=300
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Breath2 		STARTFRAME=0 		NUMFRAMES=300 	RATE=300
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=PistolWhip 	STARTFRAME=300 	NUMFRAMES=40 	RATE=40
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Punch 			STARTFRAME=340 	NUMFRAMES=51 	RATE=51
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Hit 			STARTFRAME=514 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=HeadHit 		STARTFRAME=514 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=GutHit 		STARTFRAME=535 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=LeftHit 		STARTFRAME=556 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=RightHit 		STARTFRAME=577 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Jump2 			STARTFRAME=598 	NUMFRAMES=15 	RATE=15
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Walk 			STARTFRAME=674 	NUMFRAMES=181 	RATE=181
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Charge 		STARTFRAME=1186 	NUMFRAMES=95 	RATE=95
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=WalkFire 		STARTFRAME=1186 	NUMFRAMES=95 	RATE=95
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=CockGun 		STARTFRAME=1128 	NUMFRAMES=16 	RATE=16
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Fighter 		STARTFRAME=1144 	NUMFRAMES=1 	RATE=1
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=GutShot 		STARTFRAME=1144 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=StillLook 	STARTFRAME=0 		NUMFRAMES=300 	RATE=300
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Precharg 		STARTFRAME=1128 	NUMFRAMES=16 	RATE=16
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=StillFire 	STARTFRAME=1186 	NUMFRAMES=95 	RATE=95
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=T8 				STARTFRAME=1186 	NUMFRAMES=95 	RATE=95



/*
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=SawZombieIdle STARTFRAME=0 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=SawZombieAttack1 STARTFRAME=300 NUMFRAMES=40 RATE=40
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=SawZombieAttack2 STARTFRAME=340 NUMFRAMES=51 RATE=51
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=HitF STARTFRAME=391 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=HitF2 STARTFRAME=432 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=HitF3 STARTFRAME=473 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=HitReactionB STARTFRAME=514 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=HitReactionF STARTFRAME=535 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=HitReactionL STARTFRAME=556 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=HitReactionR STARTFRAME=577 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Jump STARTFRAME=598 NUMFRAMES=15 RATE=15
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=InAir STARTFRAME=613 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Landed STARTFRAME=622 NUMFRAMES=7 RATE=7
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=Jump2 STARTFRAME=629 NUMFRAMES=45 RATE=45
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=SawZombieWalk STARTFRAME=674 NUMFRAMES=181 RATE=181
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=WalkB STARTFRAME=855 NUMFRAMES=91 RATE=91
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=RunL STARTFRAME=946 NUMFRAMES=91 RATE=91
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=RunR STARTFRAME=1037 NUMFRAMES=91 RATE=91
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=SawImpaleLoop STARTFRAME=1128 NUMFRAMES=16 RATE=16
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=TurnLeft STARTFRAME=1144 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=TurnRight STARTFRAME=1165 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=ChargeF STARTFRAME=1186 NUMFRAMES=95 RATE=95
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=WalkF_Headless STARTFRAME=1281 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=WalkB_Headless STARTFRAME=1581 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=DodgeF STARTFRAME=1881 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=DodgeB STARTFRAME=1890 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=DodgeL STARTFRAME=1899 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=DodgeR STARTFRAME=1908 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=DoorBash STARTFRAME=1917 NUMFRAMES=51 RATE=51
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=WalkF_Fire STARTFRAME=1968 NUMFRAMES=90 RATE=90
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=WalkL_Fire STARTFRAME=2058 NUMFRAMES=90 RATE=90
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=WalkR_Fire STARTFRAME=2148 NUMFRAMES=90 RATE=90
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=WalkB_Fire STARTFRAME=2238 NUMFRAMES=90 RATE=90
#exec ANIM SEQUENCE ANIM=scrake_anim SEQ=KnockDown STARTFRAME=2328 NUMFRAMES=101 RATE=101
*/

#exec ANIM DIGEST ANIM=scrake_anim
#exec MESH DEFAULTANIM MESH=ScrakeFrost ANIM=scrake_anim

//Adds
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=WalkFire 		TIME=0.18 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=WalkFire 		TIME=0.68 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=StillFire 		TIME=0.5 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=Punch 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=GutShot 		TIME=0.3 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=GutShot 		TIME=0.6 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=Charge 			TIME=0.25 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=Charge 			TIME=0.75 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=scrake_anim 	SEQ=Charge 			TIME=0.01 	FUNCTION=ScrakeRoar

var(Sounds) sound ScrakeRoar1;
var(Sounds) sound ScrakeRoar2;

function ScrakeRoar()
{
   if (FRand() < 0.5)
      PlaySound(ScrakeRoar1, SLOT_Interact);
   else
      PlaySound(ScrakeRoar2, SLOT_Interact);
}

//Single death anim on this model
function PlayBigDeath(name DamageType)
{
   PlaySound(Die2, SLOT_Talk, 4 * TransientSoundVolume);
   PlayAnim('Dead1',0.7,0.1);
}

function PlayHeadDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die3, SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayLeftDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die4,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayRightDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

//Slow things down
function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.3 + 0.5 * FRand();

   decision = FRand();
   if (AnimSequence == 'Sleep')
   {
      if (decision < 0.07)
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',0.2, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep', 0.2,0.4);
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',0.2,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', 0.2);
      else if (decision < 0.55)
         PlayAnim('CockGun', 0.5);
      else
         PlayAnim('Breath2', 0.2, 0.4);
   }
   else if (decision < 0.1)
      PlayAnim('StillLook', 0.2, 0.4);
   else
      PlayAnim('Breath2', 0.2, 0.4);
    
   if (AnimSequence == 'StillLook')
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else
      SetAlertness(0.0);
}

function PlayRunning()
{
   if (Focus == Destination)
   {
      LoopAnim('Walk', 0.3,,0.4);
      return;
   }

   LoopAnim('Walk', 0.3,,0.3);
}

state Charging
{
	ignores SeePlayer, HearNoise;

   function AnimEnd()
   {
      If (bBerserk)
         LoopAnim('Charge', 0.5,,0.5);
      else
         PlayCombatMove();
   }

   function Timer()
   {
      if (bBerserk && bLongBerserk && (FRand() < 0.3))
      {
         AccelRate = Default.AccelRate;
         GroundSpeed = Default.GroundSpeed;
         AmbientSound=None;
         bBerserk = false;
      }
      bLongBerserk = bBerserk;
    
      Super.Timer();
   }
            
   function BeginState()
   {
      GoBerserk();
      Super.BeginState();
   }

   function EndState()
   {
      if (bBerserk)
      {
         GroundSpeed = Default.GroundSpeed;
         AccelRate = Default.AccelRate;
      }
      Super.EndState();
   }
}


defaultproperties
{
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'ScrakeFrost'
   Multiskins(0)=scrakefrost
   Multiskins(1)=
   Multiskins(2)=
   CollisionRadius=26.000000
   CollisionHeight=60.000000

   Health=340
   WhipDamage=20
   PunchDamage=20
   bHasRangedAttack=False
   bMovingRangedAttack=False
   bLeadTarget=True
   bCanStrafe=True
   RangedProjectile=Class''
 	ProjectileSpeed=700.000000
   MeleeRange=70.000000
   GroundSpeed=140.000000
   WaterSpeed=100.000000
   SightRadius=1500.000000

   footstep=Sound''
   Footstep2=Sound''
   PistolWhip=Sound'ScrakeAttack1'
   PistolWhip1=Sound'ScrakeAttack2'
   Punch=Sound'ScrakeAttack3'
   Punch1=Sound'ScrakeAttack4'
   PistolHit=Sound'UnrealShare.Brute.pstlhit1br'
   Die=Sound'ScrakeDeath1'
   Die2=Sound'ScrakeDeath2'
   Die3=Sound'ScrakeDeath3'
   Die4=Sound'ScrakeDeath4'
   HitSound1=Sound'ScrakePain1'
   HitSound2=Sound'ScrakePain2'
   Acquire=Sound'ScrakeAcquire'
   Fear=Sound'ScrakeFear'
   Roam=Sound'ScrakeRoam'
   Threaten=Sound'ScrakeThreaten'
	AmbientSound=Sound'UnrealShare.Brute.amb1br'
   Land=Sound'ScrakeJump'
   ScrakeRoar1=Sound'ScrakeRoar1'
   ScrakeRoar2=Sound'ScrakeRoar2'

   CarcassType=Class'ScrakeCarcass'
}