
class Relic expands Mutator abstract;


#exec AUDIO IMPORT FILE="Sounds\new_mutant.WAV" NAME="Gonew_mutant"
#exec TEXTURE IMPORT NAME=RelicBlue   FILE=Textures\RelicBlue.bmp

#exec mesh import mesh=oneupA anivfile=Models\oneupA_a.3d datafile=Models\oneupA_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=oneupA x=0 y=0 z=0
#exec mesh sequence mesh=oneupA seq=All startframe=0 numframes=1

#exec meshmap new meshmap=oneupA mesh=oneupA
#exec meshmap scale meshmap=oneupA x=0.06250 y=0.06250 z=0.12500

var class<RelicInventory> RelicClass;
var int NumPoints;
var bool Initialized;
var RelicInventory SpawnedRelic;
var int NavPoint;

function PostBeginPlay()
{
	local NavigationPoint NP;

	if (Initialized)
		return;
	Initialized = True;

	// Calculate number of navigation points.
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
	{
		if (NP.IsA('PathNode'))
			NumPoints++;
	}

	SpawnRelic(0);
	SetTimer(5.0, True);
}

function SpawnRelic(int RecurseCount)
{
	local int PointCount;
	local NavigationPoint NP;
	local RelicInventory Touching;

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
	{
		if ( NP.IsA('PathNode') )
		{
			if (PointCount == NavPoint)
			{
				// check that there are no other relics here
				if ( RecurseCount < 3 )
					ForEach VisibleCollidingActors(class'RelicInventory', Touching, 40, NP.Location)
					{
						SpawnRelic(RecurseCount + 1);	
						return;
					}

				// Spawn it here.
				SpawnedRelic = Spawn(RelicClass, , , NP.Location);
				SpawnedRelic.MyRelic = Self;
				return;
			}
			PointCount++;
		}
	}
}

function Mutate(string MutateString, PlayerPawn Sender)
{
   local Inventory S;

   if (MutateString ~= "TossRelic")
   {
      S = Sender.FindInventoryType(RelicClass);
      if (S != None)
      {
         if (S.isA('RelicRadiationInventory'))
         {
            BroadcastMessage("This relic cannot be tossed.");
            return;
         }
         if (S.isA('RelicInvulnerableInventory'))
         {
            BroadcastMessage("This relic cannot be tossed.");
            return;
         }
         RelicInventory(S).DropInventory();
         Sender.DeleteInventory(S);
      }
   }

   if ( NextMutator != None )
      NextMutator.Mutate(MutateString, Sender);
}

function Timer()
{

	if ( (SpawnedRelic != None) && (SpawnedRelic.Owner == None) )
	{
		SpawnedRelic.IdleTime += 5;
		if ( SpawnedRelic.IdleTime >= 30 )
		{
			SpawnedRelic.IdleTime = 0;
			Spawn(class'RelicSpawnEffect', SpawnedRelic,, SpawnedRelic.Location, SpawnedRelic.Rotation);
			SpawnedRelic.Destroy();
		}
	}
}

defaultproperties
{
}
