// Credits to Azura for the playermove code
class MHExtrasMod expands Mutator config(MHExtrasMod);

var bool bInitialized;
var config string HurtAllMonsters;
var config string HealAllMonsters;
var config string TeleportGun;
var config string GetList;
var config string Home;
var config string Warp;
var config string EndsOff;
var config string EndsOn;
var config string TeleBlock;
var config string TeleUnBlock;

var private Pawn sendPawn;

event PreBeginPlay()
{
	if (bInitialized)
		return;
	bInitialized = True;
	
	Level.Game.RegisterDamageMutator(Self);
	
	log("MH Extras mod fired up (testing version)",'MHExtrasMod');

	SaveConfig();
	
	if ( NextMutator != None )
      NextMutator.PostBeginPlay();
}

function Mutate(string MutateString, PlayerPawn Sender)
{
	local int i, paramNumber;
   local Pawn p;
	local string paramString;
	local NavigationPoint startSpot;
	local bool foundStart;
	local Trigger TR;
	local Teleporter TE;
	
	Super.Mutate(mutateString, Sender);

	if(!Sender.PlayerReplicationInfo.bIsSpectator || Sender.PlayerReplicationInfo.bWaitingPlayer)
	{
		if(MutateString ~= HurtAllMonsters)
		{
			HurtThemAll();
			Sender.ClientMessage("Monster health cut in half, action logged to server");
			Sender.ClientMessage("Monsters with low health will be skipped.");
			log("## Monster health cut by player:"@Sender.PlayerReplicationInfo.PlayerName);
		}
		else if(MutateString ~= HealAllMonsters)
		{
			HealThemAll();
			Sender.ClientMessage("Monster health doubled, action logged to server");
			Sender.ClientMessage("Monster with high health will be skipped.");
			log("## Monster health doubled by player:"@Sender.PlayerReplicationInfo.PlayerName);
		}
		else if(MutateString ~= TeleportGun)
      {
      	GiveWeapon(Sender,class'MHExtrasMod.PortalGun');
         Sender.ClientMessage("Awarding Teleport Gun, action logged to server");
      }
		else if(MutateString ~= GetList)
		{
			p = Level.PawnList;
			if( p == none )
			{
				Sender.ClientMessage("No players found");
				return;
			}
			while (p != none)
			{
				if((p.IsA('PlayerPawn') || p.IsA('Bot')) && !p.PlayerReplicationInfo.bIsSpectator)
					Sender.ClientMessage("PID:" @ P.PlayerReplicationInfo.PlayerID @ "Name:" @ p.PlayerReplicationInfo.PlayerName);
				p = p.nextPawn;
			}
		}
		else if(Left(Caps(MutateString), 4) ~= Warp)
		{
			paramNumber = int(Mid(MutateString, 4));

			if(paramNumber >= 0 && paramNumber <= 32)
			{
				p = getPawnFromPID(paramNumber);

				if(p == none)
				{
					Sender.ClientMessage("This playerID doesn't seem to correspond to an existing player. Please try again");
					return;
				}
				else
				{
					Sender.ClientMessage(p.PlayerReplicationInfo.PlayerName @ "was chosen as the player to be moved.");
					sendPawn = p;

					if(p != none)
					{
						//Effects at the point of leaving
         			Spawn(Class'ParticleBurst2',,,sendPawn.Location);
         			Spawn(Class'ReSpawn',,,sendPawn.Location);

						sendPawn.SetLocation(Sender.Location + 50 * Vector(Sender.Rotation) +vect(0,0,0)+Velocity*0.01);

						//Effects at the point of arriving
						Spawn(Class'ParticleBurst2',,,Sender.Location + 50 * Vector(Sender.Rotation) +vect(0,0,0)+Velocity*0.01);
         			Spawn(Class'ReSpawn',,,Sender.Location + 50 * Vector(Sender.Rotation) +vect(0,0,0)+Velocity*0.01);


						Sender.ClientMessage( "Player has been sent." );
						sendPawn = none;
					}
					else
						Sender.ClientMessage("Send failure...");
				}
			}
		}

		else if(Left(Caps(MutateString), 4) ~= Home)
		{
			paramNumber = int(Mid(MutateString, 4));

			if(paramNumber >= 0 && paramNumber <= 32)
			{
				p = getPawnFromPID(paramNumber);

				if(p == none)
				{
					Sender.ClientMessage("This playerID doesn't seem to be valid now. Please try again");
					return;
				}
				else
				{
					Sender.ClientMessage(p.PlayerReplicationInfo.PlayerName @ "was chosen as the player to be sent to start.");
					sendPawn = p;

					if(p != none)
					{
						startSpot = FindPlayerStart(None, 255);
						if(startSpot == None)
						{
							Sender.ClientMessage( "Can't find a valid playerstart." );
							return;
						}
						foundStart = sendPawn.SetLocation(startSpot.Location);
						if( foundStart )
						{
							startSpot.PlayTeleportEffect(sendPawn, true);
							sendPawn.SetRotation(startSpot.Rotation);
							sendPawn.ViewRotation = sendPawn.Rotation;
							sendPawn.Acceleration = vect(0,0,0);
							sendPawn.Velocity = vect(0,0,0);
							sendPawn.ClientSetRotation( startSpot.Rotation );
						}
						Sender.ClientMessage( "Player has been sent." );
						sendPawn = none;
					}
					else
						Sender.ClientMessage("Send failure...");
				}
			}
		}
		else if(MutateString ~= EndsOff)
		{
			Sender.ClientMessage( "Map ends have been touch disabled." );
			log("## MonsterEnds turned off by player:"@Sender.PlayerReplicationInfo.PlayerName);
			
			ForEach AllActors(class'Trigger', TR)
			{
				if(InStr(TR.Name, "MonsterEnd") != -1)
					TR.SetCollision(false,false,false);
			}
		}
		else if(MutateString ~= EndsOn)
		{
			Sender.ClientMessage( "Map ends have been enabled to touch." );
			log("## MonsterEnds turned on by player:"@Sender.PlayerReplicationInfo.PlayerName);
			
			ForEach AllActors(class'Trigger', TR)
			{
				if(InStr(TR.Name, "MonsterEnd") != -1)
					TR.SetCollision(true,false,false);
			}
		}
		else if(MutateString ~= TeleBlock)
		{
			Sender.ClientMessage( "Teleporters have been blocked for monsters." );
			log("## Teleporters blocked by player:"@Sender.PlayerReplicationInfo.PlayerName);
			
			ForEach AllActors(class'Teleporter', TE)
			{
				if(InStr(TE.Name, "Teleporter") != -1)
					TE.SetCollision(true,true,false);
			}
		}
		else if(MutateString ~= TeleUnBlock)
		{
			Sender.ClientMessage( "Teleporters have been unblocked for monsters." );
			log("## Teleporters blocked by player:"@Sender.PlayerReplicationInfo.PlayerName);
			
			ForEach AllActors(class'Teleporter', TE)
			{
				if(InStr(TE.Name, "Teleporter") != -1)
					TE.SetCollision(true,false,false);
			}
		}
	}
	if (NextMutator != None)
      NextMutator.Mutate(MutateString, Sender);
}

//Cuts all monster's health by half
function HurtThemAll()
{
   local ScriptedPawn S;
   local Pawn P;

   for (P=Level.PawnList; P!=None; P=P.nextPawn)
   {
      if(P.IsA('ScriptedPawn'))
      	if (P != None)
      		if (P.Health > 100)
        			P.TakeDamage(0.50 * P.Health, None, Location, vect(0,0,0), 'Fell');
	}
}

//Doubles monster health on all of them
function HealThemAll()
{
   local ScriptedPawn S;
   local Pawn P;

   for (P=Level.PawnList; P!=None; P=P.nextPawn)
   {
      if(P.IsA('ScriptedPawn'))
      	if (P != None)
      		if (P.Health > 0)
      			if(P.Health < 100000)
        				P.Health += P.Health;
	}
}

//creates playerID list
function Pawn getPawnFromPID(int PlayerID)
{
   local Pawn p;

   p = Level.PawnList;
   while (p != none)
   {
      if(p.IsA('PlayerPawn') || P.IsA('Bot'))
         if(P.PlayerReplicationInfo.PlayerID == PlayerID)
            return p;
      p = p.nextPawn;
   }
	return none;
}

//legacy code, unused for now
function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
	Super.PreventDeath(Killed,Killer,DamageType,HitLocation);

	if(Killer.Style == STY_Translucent && Killer.bBlockPlayers == false)
	{
		Killer.SetDisplayProperties( STY_Normal, Killer.Texture, Killer.bUnLit, Killer.bMeshEnviromap );
		Killer.SetCollision(true, true, true);
		return true;
	}
	return false;
}

//properly awards the portalgun to the summoner
function GiveWeapon(Pawn PlayerPawn, class<TournamentWeapon> WeaponClass )
{
   local Weapon NewWeapon;

   if(PlayerPawn.FindInventoryType(WeaponClass) != None)
      return;
   newWeapon = Spawn(WeaponClass);
   if(newWeapon != None)
   {
      newWeapon.RespawnTime = 0.0;
      newWeapon.GiveTo(PlayerPawn);
      newWeapon.bHeldItem = true;
      newWeapon.SetSwitchPriority(PlayerPawn);
      newWeapon.WeaponSet(PlayerPawn);
      newWeapon.AmbientGlow = 0;
      PlayerPawn.PendingWeapon = None;
      if (!newWeapon.IsA('ImpactHammer') && !newWeapon.IsA('Translocator'))
      {
	 		newWeapon.GiveAmmo(PlayerPawn);
	 		newWeapon.AmmoType.AmmoAmount = newWeapon.AmmoType.MaxAmmo;
      }
   }
}

//used to iterate the playerstarts and find a good one
function NavigationPoint FindPlayerStart(Pawn Player, optional byte InTeam, optional string incomingName)
{
   local PlayerStart Dest, Candidate[8], Best;
   local float Score[8], BestScore, NextDist;
   local pawn OtherPlayer;
   local int i, num;
   local Teleporter Tel;

   num = 0;

   foreach AllActors(class 'PlayerStart', Dest)
   {
      if (Dest.bEnabled && Dest.bCoopStart)
      {
         if (num<4)
            Candidate[num] = Dest;
         else if (Rand(num) < 4)
            Candidate[Rand(4)] = Dest;
         num++;
      }
   }
   if (num == 0)
	{
		foreach AllActors( class 'PlayerStart', Dest )
		{
			if (Dest.bSinglePlayerStart || Dest.bCoopStart)
			{
				if (num<4)
					Candidate[num] = Dest;
				else if (Rand(num) < 4)
					Candidate[Rand(4)] = Dest;
				num++;
			}
		}
	}

   if (num>4) num = 4;
   else if (num == 0)
   return None;

   //assess candidates
   for (i=0;i<num;i++)
      Score[i] = 4000 * FRand(); //randomize

   foreach AllActors( class 'Pawn', OtherPlayer )
   {
      if (OtherPlayer.bIsPlayer)
      {
         for (i=0;i<num;i++)
         {
            NextDist = VSize(OtherPlayer.Location - Candidate[i].Location);
            Score[i] += NextDist;
            if (NextDist < OtherPlayer.CollisionRadius + OtherPlayer.CollisionHeight)
               Score[i] -= 1000000.0;
         }
      }
   }

   BestScore = Score[0];
   Best = Candidate[0];
   for (i=1;i<num;i++)
   {
      if (Score[i] > BestScore)
      {
         BestScore = Score[i];
         Best = Candidate[i];
      }
   }
   return Best;
}

defaultproperties
{
	HurtAllMonsters=hit
	HealAllMonsters=help
	TeleportGun=gun
	GetList=list
	Home=home
	Warp=warp
	EndsOff=deny
	EndsOn=okay
	TeleBlock=teleblock
	TeleUnBlock=teleunblock
}
