
class HGPBolt extends PBolt;

#exec TEXTURE IMPORT NAME=HGpbolt0 FILE=Textures\HGpbolt0.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=HGpbolt1 FILE=Textures\HGpbolt1.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=HGpbolt2 FILE=Textures\HGpbolt2.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=HGpbolt3 FILE=Textures\HGpbolt3.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=HGpbolt4 FILE=Textures\HGpbolt4.bmp GROUP=Skins LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=pbolt NUM=0 TEXTURE=HGpbolt0

#exec AUDIO IMPORT FILE="Sounds\PulseBolt2.WAV" NAME="PulseBolt2"
#exec AUDIO IMPORT FILE="Sounds\HGhealed.wav" NAME="HGhealed"

var() texture SpriteAnim[5];
var int SpriteFrame;
var HGPBolt PlasmaBeam;
var PlasmaCap WallEffect;
var int Position;
var vector FireOffset;
var float BeamSize;
var bool bRight, bCenter;
var float AccumulatedDamage, LastHitTime;
var Actor DamagedActor;
var() int HGHealingAmount;


replication
{
   unreliable if( Role==ROLE_Authority )
      bRight, bCenter;
}

simulated function Destroyed()
{
   Super.Destroyed();
   if ( PlasmaBeam != None )
      PlasmaBeam.Destroy();
   if ( WallEffect != None )
      WallEffect.Destroy();
}

simulated function CheckBeam(vector X, float DeltaTime)
{
   local actor HitActor;
   local vector HitLocation, HitNormal;

   HitActor = Trace(HitLocation, HitNormal, Location + BeamSize * X, Location, true);
   if ( (HitActor != None) && (HitActor != Instigator)
   && (HitActor.bProjTarget || (HitActor == Level) || (HitActor.bBlockActors && HitActor.bBlockPlayers))
   && ((Pawn(HitActor) == None) || Pawn(HitActor).AdjustHitLocation(HitLocation, Velocity)) )
   {
      if ( HitActor.bIsPawn && Pawn(HitActor).bIsPlayer )
      {
         if ( WallEffect != None )
            WallEffect.Destroy();
         Damage=0;
         if ( Pawn(HitActor).Health < 500)
         {
            Pawn(HitActor).Health += HGHealingAmount;
            Pawn(HitActor).ReceiveLocalizedMessage( class'HGHealMessage',, Pawn(HitActor).PlayerReplicationInfo, Pawn(HitActor).PlayerReplicationInfo );
            Instigator.PlayerReplicationInfo.Score +=1;
            PlaySound (sound 'HGhealed',,2.0);
            spawn(class'HGUT_SpriteSmokePuff',,,HitLocation+HitNormal*9);
         }
      }
      else if ( (WallEffect == None) || WallEffect.bDeleteMe )
         WallEffect = Spawn(class'HGPlasmaHit',,, HitLocation - 5 * X);
      else if ( !WallEffect.IsA('HGPlasmaHit') )
      {
         WallEffect.Destroy();
         WallEffect = Spawn(class'HGPlasmaHit',,, HitLocation - 5 * X);
      }
      else
         WallEffect.SetLocation(HitLocation - 5 * X);
      if ( (WallEffect != None) && (Level.NetMode != NM_DedicatedServer) )
         Spawn(ExplosionDecal,,,HitLocation,rotator(HitNormal));
      if ( PlasmaBeam != None )
      {
         AccumulatedDamage += PlasmaBeam.AccumulatedDamage;
         PlasmaBeam.Destroy();
         PlasmaBeam = None;
      }
      return;
   }
   if ( Position >= 9 )
   {
      if ( (WallEffect == None) || WallEffect.bDeleteMe )
         WallEffect = Spawn(class'HGPlasmaCap',,, Location + (BeamSize - 4) * X);
      else if ( WallEffect.IsA('HGPlasmaHit') )
      {
         WallEffect.Destroy();
         WallEffect = Spawn(class'HGPlasmaCap',,, Location + (BeamSize - 4) * X);
      }
      else
         WallEffect.SetLocation(Location + (BeamSize - 4) * X);
   }
   else
   {
      if ( WallEffect != None )
      {
         WallEffect.Destroy();
         WallEffect = None;
      }
      if ( PlasmaBeam == None )
      {
         PlasmaBeam = Spawn(class'HGPBolt',,, Location + BeamSize * X);
         PlasmaBeam.Position = Position + 1;
      }
      else
         PlasmaBeam.UpdateBeamA(self, X, DeltaTime);
   }
}

simulated function UpdateBeamA(HGPBolt ParentBolt, vector Dir, float DeltaTime)
{
   local actor HitActor;
   local vector HitLocation, HitNormal;

   SpriteFrame = ParentBolt.SpriteFrame;
   Skin = SpriteAnim[SpriteFrame];
   SetLocation(ParentBolt.Location + BeamSize * Dir);
   SetRotation(ParentBolt.Rotation);
   CheckBeam(Dir, DeltaTime);
}

defaultproperties
{
   HGHealingAmount=1
   ExplosionDecal=class'Botpack.BoltScorch'
   MyDamageType=zapped
   SpriteAnim(0)=Texture'HGpbolt0'
   SpriteAnim(1)=Texture'HGpbolt1'
   SpriteAnim(2)=Texture'HGpbolt2'
   SpriteAnim(3)=Texture'HGpbolt3'
   SpriteAnim(4)=Texture'HGpbolt4'
   Skin=Texture'HGpbolt0'
   Texture=Texture'HGpbolt0'
   BeamSize=81.00
   bUnlit=true
   FireOffset=(X=16.000000,Y=-14.000000,Z=-8.00000)
   DrawType=DT_Mesh
   Mesh=pbolt
   Style=STY_Translucent
   RemoteRole=ROLE_None
   MaxSpeed=+00000.000000
   SoundVolume=0
   CollisionRadius=+00000.000000
   CollisionHeight=+00000.000000
   bCollideActors=False
   bCollideWorld=False
   bNetTemporary=False
   bGameRelevant=true
   Physics=PHYS_None
   LifeSpan=+60.000000
   Damage=+72.000
   MomentumTransfer=8500
   bRight=True
   AmbientSound=Sound'PulseBolt2'
   SoundRadius=12
   SoundVolume=255
}
