
class MH2Base expands Mutator config(MonsterHunt2Gold);

#exec AUDIO IMPORT FILE="Sounds\HitsoundEnemy.wav" NAME="HitsoundEnemy" GROUP="QFeedback"
#exec AUDIO IMPORT FILE="Sounds\QFeedbackArmourWav.wav" NAME="QFeedbackArmourWav" GROUP="QFeedback"
#exec AUDIO IMPORT FILE="Sounds\HitsoundTeam.wav" NAME="HitsoundTeam" GROUP="QFeedback"

//Christmas imports
#exec TEXTURE IMPORT NAME=Blue FILE=Textures\Blue.bmp
#exec TEXTURE IMPORT NAME=Red FILE=Textures\Red.bmp
#exec TEXTURE IMPORT NAME=Green FILE=Textures\Green.bmp
#exec TEXTURE IMPORT NAME=Gold FILE=Textures\Gold.bmp
#exec TEXTURE IMPORT NAME=Black FILE=Textures\Black.bmp
#exec TEXTURE IMPORT NAME=White FILE=Textures\White.bmp
#exec TEXTURE IMPORT NAME=Purple FILE=Textures\Purple.bmp
#exec TEXTURE IMPORT NAME=Brown FILE=Textures\Brown.bmp
#exec TEXTURE IMPORT NAME=Button FILE=Textures\Button.bmp
#exec TEXTURE IMPORT NAME=HatDeco FILE=Textures\Hatdeco.bmp
#exec TEXTURE IMPORT NAME=InvisDeco FILE=Textures\Invisdeco.bmp
#exec TEXTURE IMPORT NAME=DrumDeco1 FILE=Textures\Drumdeco1.bmp
#exec TEXTURE IMPORT NAME=DrumDeco2 FILE=Textures\Drumdeco2.bmp
#exec TEXTURE IMPORT NAME=SantaHome FILE=Textures\SantaHome.bmp
#exec TEXTURE IMPORT NAME=SantaCapt FILE=Textures\SantaCapt.bmp
#exec TEXTURE IMPORT NAME=SantaDown FILE=Textures\SantaDown.bmp

//Setup
var bool Initialized;
var int AmpCount;
var int kakuCount;
var int HealthCount;
var bool bFirstBlood;
var config String bServerInfo;
var float LastMonsterAttackTime;
var bool bHaveQueenDests;
var config bool AdjustFactories;
var config int bCapacity;
var config bool ChangeCovertToFalse;

//Awards
var config int AmpSpawnTime;
var config int DeemerSpawnTime;
var config int HealthAwardTime;
var config bool bGiveArmor;

//Weapons and Ammo
var config bool bUseRandomWeapon;
var config bool bUseRegenAmmo;
var config int AmmoInterval;
var config bool GiveAllWeapons;
var config bool Use2k4Deemer;
var config bool UseAltSniper;

//Health regen
var config int DefaultHealth;
var config int HealthRegenPerSec;
var config int MaxHealth;
var config bool bUseRegenHealth;
var config int MaxRegenHealth;
var config int HealthRegenPerKill;

//Admin options and various settings
var config bool bUseAntiBoost;
var config bool bGhostCarcass;
var config bool bHitsounds;
var config bool bAltScoring;
var config bool bCheckMonsterAttack;
var config bool stopPlayerCollision;
var config bool ReplaceInvis;
var config float HitVolume;
var config bool VisibleMonsterEnds;
var config float retainScoreOnDeathPercent;
var config bool bDropWeaponsOnDeath;
var config bool UseMHTranslocator;
var config bool UseLimeLight;
var config bool UseServerStats;
var config bool UseMH2JumpBoots;
var config int MaxDamage;

//Mutate commands
var config string CommandOpen;
var config string CommandClose;
var config string HealGunSummon;

var String MH2NaliFruit;
var String MH2MedBox;
var String MH2HealthPack;
var String MH2UnrealHealth;
var String MH2HealthVial;
var String MH2ShieldBelt;
var String MH2UDamage;
var String MH2JumpBoots;

//Double Jump
var config bool DoubleJump;
var config int maxJumps;
var config int jumpType;
var config float jumpHeight;

//Spawn protection
var() globalconfig bool bUseSpawnProt;
var() globalconfig int SpawnProtDuration;

//Mover fix
var config bool bFixCrushingMover;

//Christmas replacements
var int VialCount, MedCount;

function PreBeginPlay()
{
   local NavigationPoint NP;

      if ( Initialized )
         return;

   Super.PreBeginPlay();

   if(UseServerStats)
      Level.Game.BaseMutator.AddMutator(Level.Spawn(class'Stats'));

   NP = Level.NavigationPointList;

   while (!bHaveQueenDests && NP != None) // Check to see if the queen needs a fix
   {
      if (QueenDest(NP) != None)
         bHaveQueenDests = True;

      NP = NP.nextNavigationPoint;
   }

   if ( NextMutator != None )
      NextMutator.PreBeginPlay();
}

function PostBeginPlay()
{
   local string newhud;
   local class newclass;
   local NavigationPoint NP;
   local MonsterEnd ME;
   local ScriptedPawn S;
   local MonsterWaypoint MW;

   if (Initialized)
      return;

   Log("*** MonsterHunt2Gold Gametype and Mutator is loaded ");

   Initialized = True;
   kakuCount = 0;
   HealthCount = 0;

   if(DefaultHealth < 1)
      DefaultHealth = 100;

   SetTimer(1, True);

   if(Level.Game.HUDType !=none)
      Level.Game.HUDType = class'MH2HUD';

   if(Level.Game.ScoreBoardType !=none)
   {
      if(UseServerStats)
         Level.Game.ScoreBoardType=Class'MH2ScoreBoard1';
      else
         Level.Game.ScoreBoardType=Class'MH2ScoreBoard';
   }

   Level.Game.RegisterDamageMutator(Spawn(class'SpawnProt'));
   Level.Game.RegisterDamageMutator(Self);

   TournamentGameInfo(Level.Game).GameName = bServerInfo;

   fixmover();

   if(VisibleMonsterEnds) fixmymonsterend();

   if(AdjustFactories) CheckFactories();

   foreach AllActors(class'MonsterWaypoint', MW)
      MW.Destroy();

   if ( NextMutator != None )
      NextMutator.PostBeginPlay();
}

function CheckFactories()
{
   local CreatureFactory C;
   local ThingFactory T;

   foreach AllActors( class 'CreatureFactory', C)
   {
      if(C !=none)
      {
         if(C.Capacity < 0)
            C.Capacity=bCapacity;
         else if (C.Capacity > bCapacity)
            C.Capacity=bCapacity;
         if(ChangeCovertToFalse)
            if(C.bCovert==True)
               C.bCovert=False;
      }
   }
   foreach AllActors( class 'ThingFactory', T)
   {
      if(T !=none)
      {
         if(T.Capacity < 0)
            T.Capacity=bCapacity;
         else if (T.Capacity > bCapacity)
            T.Capacity=bCapacity;
         if(ChangeCovertToFalse)
            if(T.bCovert==True)
               T.bCovert=False;
      }
   }
}

function fixmover()
{
   local mover M;
   foreach AllActors( class 'Mover', M)
   {
      if(bFixCrushingMover)
      {
         if(M.bTriggerOnceOnly && M.MoverEncroachType == ME_ReturnWhenEncroach)
	    M.MoverEncroachType = ME_IgnoreWhenEncroach;
      }
      if(M.bUseTriggered == True)
	 M.bUseTriggered = False;
   }
}

function fixmymonsterend()
{
   local MonsterEnd T;

   foreach AllActors( class 'MonsterEnd', T)
   {
      if(T.bHidden == True)
         T.bHidden = False;
   }
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
   local int randm;
   local int randn;
   local int randj;

   if (Other.isA('Weapon') && Other.Instigator != None && Other.Instigator.IsA('ScriptedPawn'))
   {
      return true;
   }
   if(Other.IsA('Pickup'))
   {
      Pickup(Other).bAutoActivate=True;
   }
   if(Other.Class==Class'NaliFruit')
   {
      ReplaceWith(Other,MH2NaliFruit);
      return false;
   }
   if(Other.Class==Class'Bandages')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.MH2Bandages");
      return false;
   }
   if(Other.Class==Class'Health')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.MH2U1Health");
      return false;
   }
   if(Other.Class==Class'SuperHealth')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.MH2SuperHealth");
      return false;
   }
   if(Other.Class==Class'MedBox')
   {
		if ( MedCount == 0 )
      {
         ReplaceWith(Other,"MonsterHunt2GoldCE.XmasMedBoxBlue");
         MedCount = 1;
         return false;
      }
		else if ( MedCount == 1 )
		{
         ReplaceWith(Other,"MonsterHunt2GoldCE.XmasMedBoxGold");
			MedCount = 2;
         return false;
		}
		else if ( MedCount == 2 )
		{
         ReplaceWith(Other,"MonsterHunt2GoldCE.XmasMedBoxGreen");
			MedCount = 3;
         return false;
		}
		else if ( MedCount == 3 )
		{
         ReplaceWith(Other,"MonsterHunt2GoldCE.XmasMedBoxRed");
			MedCount = 0;
         return false;
		}
	}
   if(Other.Class==Class'HealthPack')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.XmasHealthPack");
      return false;
   }
   if(Other.Class==Class'HealthVial')
   {
   	if ( VialCount == 0 )
      {
         ReplaceWith(Other,"MonsterHunt2GoldCE.XmasVialBlue");
         VialCount = 1;
			return false;
		}
		else if ( VialCount == 1 )
		{
         ReplaceWith(Other,"MonsterHunt2GoldCE.XmasVialGold");
         VialCount = 2;
			return false;
		}
		else if ( VialCount == 2 )
		{
         ReplaceWith(Other,"MonsterHunt2GoldCE.XmasVialGreen");
         VialCount = 3;
			return false;
		}
		else if ( VialCount == 3 )
		{
         ReplaceWith(Other,"MonsterHunt2GoldCE.XmasVialRed");
         VialCount = 0;
			return false;
		}
   }
   if(Other.Class==Class'ShieldBelt')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.XmasShieldBelt");
      return false;
   }
   if(Other.Class==Class'PowerShield')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.XmasShieldBelt");
      return false;
   }
   if(Other.Class==Class'UT_ShieldBelt')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.XmasShieldBelt");
      return false;
   }
   if(Other.Class==Class'ThighPads')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.xmasThighPads");
      return false;
   }
   if(Other.Class==Class'Armor2')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.XmasArmor");
      return false;
   }
   if(UseLimeLight)
   {
      if(Other.IsA('Flashlight') && !Other.IsA('LimeLight'))
      {
         ReplaceWith(Other,"MonsterHunt2GoldCE.LimeLight");
	 return false;
      }
   }
   if(UseMH2JumpBoots)
   {
   	if(Other.Class==Class'JumpBoots')
      {
      	 ReplaceWith(Other,"MonsterHunt2GoldCE.xmasJumpboots");
         return false;
      }
   }
	if(Other.Class==Class'UT_JumpBoots')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.xmasJumpboots");
      return false;
   }
   if(ReplaceInvis)
   {
      if(Other.Class==Class'Invisibility')
      {
         ReplaceWith(Other,"MonsterHunt2GoldCE.XmasMedBoxGreen");
      	return false;
   	}
   }
   
   if (Other.Class==Class'UDamage')
	{
	  ReplaceWith(Other,"MonsterHunt2GoldCE.xmasUDamage");
		return false;
	}
	if (Other.Class==Class'Amplifier')
	{
	  ReplaceWith(Other,"MonsterHunt2GoldCE.xmasUDamage");
		return false;
	}
   if(Other.Class==Class'SCUBAgear')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.MH2Scuba");
      return false;
   }
   if(Other.IsA('Carcass'))
   {
      if(bGhostCarcass)
      {
         Other.Style = STY_Translucent;
            Other.SetCollision(False);
         return True;
      }
   }
   if (Other.Class==Class'BiterFishSchool')
   {
      ReplaceWith(Other,"MonsterHunt2GoldCE.MH2BiterFishSchool");
      return False;
   }
   if(Other.Class==Class'QuadShot') //Quad has buggy graphics
   {
      ReplaceWith(Other,"Botpack.UT_FlakCannon");
      return false;
   }
   if(Use2k4Deemer)
   {
      if(Other.Class==Class'WarHeadLauncher')
      {
         ReplaceWith(Other,"MonsterHunt2GoldCE.MH2WarheadLauncher");
         return false;
      }
   }
   if ( Other.IsA('Weapon') )
   {
      if ( Other.IsA('TournamentWeapon') )
      return true;
      if ( Other.IsA('UIWeapon') )
      return true;
      if(Other.Class==Class'Stinger')
      {
         ReplaceWith(Other, "MonsterHunt.OLStinger");
         return false;
      }
      if(Other.Class==Class'Rifle')
      {
         ReplaceWith( Other, "MonsterHunt.OLRifle" );
         Return false;
      }
      if(Other.Class==Class'Razorjack')
      {
         ReplaceWith(Other, "MonsterHunt.OLRazorjack");
         Return false;
      }
      if(Other.Class==Class'Minigun')
      {
         ReplaceWith( Other, "MonsterHunt.OLMinigun" );
         return false;
      }
      if(Other.Class==Class'AutoMag')
      {
         ReplaceWith( Other, "MonsterHunt.OLAutoMag" );
         return false;
      }
      if(Other.Class==Class'Eightball')
      {
         ReplaceWith( Other, "MonsterHunt.OLEightball" );
         return false;
      }
      if(Other.Class==Class'FlakCannon')
      {
         ReplaceWith( Other, "MonsterHunt.OLFlakCannon" );
         return false;
      }
      if(Other.Class==Class'ASMD')
      {
         ReplaceWith( Other, "MonsterHunt.OLASMD" );
         return false;
      }
      if(Other.Class==Class'GesBioRifle')
      {
         ReplaceWith( Other, "MonsterHunt.OLGESBioRifle" );
         return false;
      }
   }
   bSuperRelevant = 0;
   return true;
}

function GiveAmp(Pawn PlayerPawn)
{
   local UDamage damage;

   if( (PlayerPawn.FindInventoryType(class'UDamage') != None) || (PlayerPawn.Health <= 0) )
      return;
   damage = spawn(class'UDamage',PlayerPawn,,PlayerPawn.Location);
   if( damage != None )
   {
      damage.RespawnTime = 0.0;
      damage.GiveTo(PlayerPawn);
      damage.Activate();
   }
}

function MutatorTakeDamage (out int ActualDamage,Pawn Victim,Pawn InstigatedBy,out Vector HitLocation,out Vector Momentum,name DamageType)
{
   local Pawn P;

   if(bUseAntiBoost)
   {
      if(Victim != None && InstigatedBy != None)
      {
         if (InstigatedBy.IsA('PlayerPawn') && Victim.IsA('PlayerPawn'))
         {
	    Momentum = Vect(0,0,0);
            ActualDamage = 0;
            if (string(DamageType)=="RedeemerDeath")
            {
	       Velocity = Vect(0,0,0);
	       Victim.Velocity = (Victim.Velocity * 0);
            }
         }
      }
   }
   if(bHitsounds)
   {
      if(Victim != None && InstigatedBy != None)
      {
         if ( InstigatedBy.IsA('PlayerPawn') && (Victim != InstigatedBy) )
         {
            if( Victim.IsA('PlayerPawn') || Victim.IsA('Bot') )  // When player shoot other player
            {
	       PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_None, HitVolume, false);
	       PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interface, HitVolume, false);
	       PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interact, HitVolume, false);
            }
            if( Victim.IsA('ScriptedPawn') )  // When player shoots a monster
            {   	// Cows and rabbits are friends
	       if(Victim.IsA('Cow')|| Victim.IsA('BabyCow')|| Victim.IsA('NaliRabbit'))
               {
                  PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_None, HitVolume, false);
	          PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interface, HitVolume, false);
	          PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interact, HitVolume, false);
	       }
               else // ScriptedPawn is an enemy
	       {
		  PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_None, HitVolume, false);
		  PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_Interface, HitVolume, false);
		  PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_Interact, HitVolume, false);
	       }
            }
         }
      }
   }
   if(bAltScoring) // Scoring by damage
   {
      if (Victim != None && InstigatedBy != None)
      {
         if ( Victim.IsA('ScriptedPawn') && instigatedBy.IsA('ScriptedPawn') || Victim == instigatedBy && Victim.IsA('ScriptedPawn'))
            actualDamage=0;
         if ( actualDamage < 0 )
            return;
         else if ( actualDamage > 1000 )
            actualDamage=MaxDamage;
         if (ActualDamage > Victim.Health)
            ActualDamage = Victim.Health;
         if (Victim != None && InstigatedBy != None && Victim != InstigatedBy)
         {
	    if (Victim.IsA('ScriptedPawn') && InstigatedBy.bIsPlayer)
            {
               InstigatedBy.PlayerReplicationInfo.Score += ActualDamage;
            }
         }
      }
   }
   if ( NextDamageMutator != None )
      NextDamageMutator.MutatorTakeDamage(ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

function ModifyPlayer(Pawn Other)
{
   local int randm;
   local inventory inv;
   local class<DJ_InventoryItem> InventoryClass;
   local DJ_InventoryItem DJ_Inv;

   if(!Other.IsA('TournamentPlayer'))return;
   TournamentPlayer(Other).PlayerReplicationInfo.Team = 0; // kyouseitekini team 0

   Other.Health = DefaultHealth;

   if (stopPlayerCollision == true)
      Other.bBlockPlayers = false;

   if(UseMHTranslocator)
      DeathMatchPlus(Level.Game).GiveWeapon(Other,"MonsterHunt2GoldCE.MHTranslocator");

   InventoryClass = class<DJ_InventoryItem>(DynamicLoadObject("MonsterHunt2GoldCE.DJ_InventoryItem", class'Class'));

   if(UseAltSniper)
      GiveWeapon(Other,class'MH2Rifle');

   if(DoubleJump)
   {
      DJ_Inv = Spawn(class'DJ_InventoryItem', Other,, Other.Location);
      if( DJ_Inv != None )
      {
         DJ_Inv.RespawnTime = 0.0;
         DJ_Inv.GiveTo(Other);
         DJ_Inv.maxJumps = maxJumps;
         DJ_Inv.jumpType = jumpType;
         DJ_Inv.jumpHeight = jumpHeight;
      }
   }
   if (bUseSpawnProt)
   {
      Inv = Other.FindInventoryType(class'SpawnProtEffect');
      if ( Inv != None )
         SpawnProtEffect(Inv).Duration = SpawnProtDuration;
      else
      {
         inv = Spawn(class'SpawnProtEffect');
         if( inv != None )
         {
            SpawnProtEffect(Inv).Duration = SpawnProtDuration;
            inv.GiveTo(Other);
            inv.Activate();
         }
      }
   }
   if(GiveAllWeapons)
   {
      GiveWeapon(Other,class'PulseGun');
      GiveWeapon(Other,class'ShockRifle');
      GiveWeapon(Other,class'UT_FlakCannon');
      GiveWeapon(Other,class'Botpack.UT_BioRifle');
      GiveWeapon(Other,class'Botpack.Minigun2');
      GiveWeapon(Other,class'Botpack.Ripper');
      GiveWeapon(Other,class'Botpack.UT_Eightball');
      if(UseAltSniper)
         GiveWeapon(Other,class'MH2Rifle');
      else
         GiveWeapon(Other,class'Botpack.SniperRifle');
   }
   if (bUseRandomWeapon && Other.IsA('TournamentPlayer'))
   {
      randm = Rand(10);
      switch(randm)
      {
         case 0:
            GiveWeapon(Other,class'UT_Biorifle');
            break;
         case 1:
            GiveWeapon(Other,class'Shockrifle');
            break;
         case 2:
            GiveWeapon(Other,class'Pulsegun');
            break;
         case 3:
            GiveWeapon(Other,class'ripper');
            break;
         case 4:
            GiveWeapon(Other,class'minigun2');
            break;
         case 5:
            GiveWeapon(Other,class'UT_Flakcannon');
	    break;
         case 6:
            GiveWeapon(Other,class'UT_EightBall');
           break;
	 case 7:
            if(UseAltSniper)
               GiveWeapon(Other,class'MH2Rifle');
            else
               GiveWeapon(Other,class'SniperRifle');
            break;
         case 8:
            if(Use2k4Deemer)
               GiveWeapon(Other,class'MH2WarheadLauncher');
            else
               GiveWeapon(Other,class'WarHeadLauncher');
	       Other.Health += 200;
            break;
         case 9:
	       GiveWeapon(Other,class'ImpactHammer');
	       Other.Health += 200;
            break;
      }
      if(bGiveArmor)
      {
         inv = Spawn(class'MH2Armor2');
         if( inv != None )
	 {
	    inv.bHeldItem = true;
	    inv.RespawnTime = 0.0;
	    inv.GiveTo(Other);
	    inv.Charge = Inv.Default.Charge;
         }
      }
      Other.ReceiveLocalizedMessage( class'MH2GetWeaponMessage', randm, Other.PlayerReplicationInfo, Other.PlayerReplicationInfo );
   }
   if ( NextMutator != None )
      NextMutator.ModifyPlayer(Other);
}

function GiveWeapon(Pawn PlayerPawn, class<TournamentWeapon> WeaponClass )
{
   local Weapon NewWeapon;

   if( PlayerPawn.FindInventoryType(WeaponClass) != None )
      return;
   newWeapon = Spawn(WeaponClass);
   if( newWeapon != None )
   {
      newWeapon.RespawnTime = 0.0;
      newWeapon.GiveTo(PlayerPawn);
      newWeapon.bHeldItem = true;
      newWeapon.SetSwitchPriority(PlayerPawn);
      newWeapon.WeaponSet(PlayerPawn);
      newWeapon.AmbientGlow = 0;
      PlayerPawn.PendingWeapon = None;
      if ( !newWeapon.IsA('ImpactHammer') && !newWeapon.IsA('Translocator') )
      {
	 newWeapon.GiveAmmo(PlayerPawn);
	 newWeapon.AmmoType.AmmoAmount = newWeapon.AmmoType.MaxAmmo;
      }
   }
}

function ScoreKill(Pawn Killer, Pawn Other)
{
   if(Killer == None)return;
   if(!Killer.bIsHuman)return;
   if(Killer.PlayerReplicationInfo.bIsABot) return;
   if(Killer.IsA('ScreptedPawn'))return;
   if(Killer.IsA('ScreptedPawn') && Other.IsA('ScreptedPawn'))return;
   if ( (Killer == None) && (Other == None) )return;
   if ( Killer.bIsPlayer && Other.bIsPlayer )return;

   if ( Other.Spree > 1 && Other.bIsPlayer)
     EndSpree(Killer, Other);
   if(Other.bIsPlayer)Other.Spree = 0;
   if ( (Killer != None) && Killer.bIsPlayer && (Killer != Other) )
   {
      if(Killer.Health <= MaxHealth)
      {
         Killer.Health += HealthRegenPerKill;
      }
      if(Killer.Health > MaxHealth)
      {
         Killer.Health = MaxHealth;
      }
      Killer.Spree+=1;
      if ( Killer.Spree > 14 )
         NotifySpree(Killer, Killer.Spree);
      if ( (TournamentPlayer(Killer).Level.TimeSeconds - TournamentPlayer(Killer).LastKillTime < 3))
      {
	 TournamentPlayer(Killer).MultiLevel++;
	 if(TournamentPlayer(Killer).MultiLevel >= 41)TournamentPlayer(Killer).MultiLevel = 40;
	 TournamentPlayer(Killer).ReceiveLocalizedMessage( class'MH2MultiKillMessage', TournamentPlayer(Killer).MultiLevel );
	 CheckBroadCast(Killer,TournamentPlayer(Killer).MultiLevel);
      }
      else TournamentPlayer(Killer).MultiLevel = 0;
      TournamentPlayer(Killer).LastKillTime = TournamentPlayer(Killer).Level.TimeSeconds;
   }
}

function CheckBroadCast(Pawn Killer,int num)
{
   if(Killer.bIsPlayer && !Killer.PlayerReplicationInfo.bIsABot)
      BroadCastMessage(Killer.PlayerReplicationInfo.PlayerName@GetText(num));
}

function string GetText(int Switch)
{
   switch (Switch)
   {
      case 1:
	 return " has Double Kill!";
	 break;
      case 2:
	 return " has Multi Kill!";
	 break;
      case 3:
	 return " has Mega Kill!";
	 break;
      case 4:
	 return " has ULTRA KILL!!";
	 break;
      case 5:
	 return " has M O N S T E R  K I L L !!!";
	 break;
      case 6:
	 return " has L U D I C R O U S  K I L L !!!!";
	 break;
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 37:
      case 38:
      case 39:
         return " has H  O  L  Y   S  H  I  T !!!!!!!";
	 break;
      case 40:
	 return " is still going.... !!!!!!!!!!!";
	 break;
   }
   return "";
}

function NotifySpree(Pawn Other, int num)
{
   local Pawn P;

   if ( num == 30 )
      num = 0;
   else if ( num == 45 )
      num = 1;
   else if ( num == 60 )
      num = 2;
   else if ( num == 90 )
      num = 3;
   else if ( num == 125 )
      num = 4;
   else if ( num == 250 )
      num = 5;
   else if ( num == 500 )
      num = 6;
   else if ( num == 1000 )
      num = 7;
   else
      return;

   for ( P=Level.PawnList; P!=None; P=P.NextPawn )
   if ( P.IsA('TournamentPlayer') )
      P.ReceiveLocalizedMessage( class'MH2KillingSpreeMessage', Num, Other.PlayerReplicationInfo );
}

function EndSpree(Pawn Killer, Pawn Other)
{
   local Pawn P;

   if ( !Other.bIsPlayer || Killer.PlayerReplicationInfo.bIsABot)
      return;
   for ( P=Level.PawnList; P!=None; P=P.NextPawn )
   if ( P.IsA('TournamentPlayer') )
   {
      if(Other.IsA('ScriptedPawn'))
	 P.ReceiveLocalizedMessage( class'MH2KillingSpreeMessage', Other.Spree, Killer.PlayerReplicationInfo,  Killer.PlayerReplicationInfo );
      else
         P.ReceiveLocalizedMessage( class'MH2KillingSpreeMessage', Other.Spree, Killer.PlayerReplicationInfo, Other.PlayerReplicationInfo );
   }
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name DamageType, Vector HitLocation)
{
   local bool pd;

   pd=Super.PreventDeath(Killed,Killer,DamageType,HitLocation);

   if (Killed != none && !pd)
   {
      if (!Killed.IsA('ScriptedPawn'))
      {
         if(bDropWeaponsOnDeath)
         {
            if (Killer != none && Killer.IsA('ScriptedPawn'))
    	       DiscardInventory(Killed);
         }
         if (Killed.bIsPlayer)
            Killed.PlayerReplicationInfo.Score *= retainScoreOnDeathPercent;
      }
   }
   return pd;
}

function DiscardInventory (Pawn Other)
{
   local Actor dropped;
   local Inventory Inv;
   local class<Weapon> Initial1;
   local class<Weapon> Initial2;

   if (Other != none)
   {
      if ( Other.DropWhenKilled != None )
      {
         dropped=Spawn(Other.DropWhenKilled,,,Other.Location);
         Inv=Inventory(dropped);
         if ( Inv != None )
         {
            Inv.RespawnTime=0.00;
            Inv.BecomePickup();
    	 }
         if ( dropped != None )
         {
            dropped.RemoteRole=ROLE_DumbProxy;
            dropped.SetPhysics(PHYS_Falling);
            dropped.bCollideWorld=True;
            dropped.Velocity=Other.Velocity + VRand() * 280;
    	 }
         if ( Inv != None )
         {
            Inv.GotoState('Pickup','dropped');
    	 }
      }
      Inv=Other.Inventory;
      JL0111:
         if ( Inv != None )
    	 {
            if ( Inv.IsA('Weapon') )
    	    {
    	       if ( (Inv.Class != Level.Game.BaseMutator.MutatedDefaultWeapon()) && ((Weapon(Inv).AmmoType == None) || (Weapon(Inv).AmmoType.AmmoAmount > 0)) && Weapon(Inv).bCanThrow)
               {
                  if (Inv.class != class'Enforcer' && Inv.Class != class'DoubleEnforcer')
                     DropWeapon(Other,Inv);
    	       }
            }
    	    Inv.Destroy();
            Inv=Inv.Inventory;
            goto JL0111;
         }
   }
}

function DropWeapon (Pawn Other, Inventory Inv)
{
   local Inventory DropInv;
   local int DropPitch;
   local int DropYaw;
   local Rotator DropRot;

   DropInv=Spawn(Inv.Class,,,Other.Location);
   if ( DropInv == None )
   {
      return;
   }
   DropRot=Other.ViewRotation;
   DropPitch=Rand(32768);
   DropYaw=Rand(65536);
   DropRot.Pitch=DropPitch;
   DropRot.Yaw=DropYaw;
   Weapon(DropInv).bWeaponStay = false;
   DropInv.Velocity=vector(DropRot) * (Rand(250) + 250);
   DropInv.RespawnTime=0.00;
   DropInv.BecomePickup();
   DropInv.NetPriority=2.50;
   DropInv.RemoteRole=ROLE_DumbProxy;
   DropInv.SetPhysics(PHYS_Falling);
   DropInv.bCollideWorld=True;
   DropInv.GotoState('Pickup','dropped');
}

simulated function Tick (float DT)
{
   Super.Tick(DT);

   if ( Level.Game.bGameEnded ) return;

   if ((bCheckMonsterAttack) && (LastMonsterAttackTime < Level.TimeSeconds)) 
      MonsterAttackCheck();
}

function Timer() 
{
   local Pawn P, PRand;
   local Inventory Inv;
   local skaarjtrooper sp;

   if (Level.Game.bGameEnded) return;

   for (P = Level.PawnList; P != None; P = P.NextPawn)
   {
      if (P.IsA('skaarjtrooper'))
      {
         sp = skaarjtrooper(P);
         sp.bIsPlayer = False;
         if (sp.weapontype == none)
            GiveWeapon(sp, Class 'botpack.minigun2');
         if (sp.weapon != none)
            sp.weapon.bCanThrow = False;
      }
   }

   if (AmpCount < AmpSpawnTime) AmpCount++;

   else if (AmpCount == AmpSpawnTime)
   {
      BroadcastLocalizedMessage(class 'MH2AmpMessage', , , None, None);
      for (P = Level.PawnList; P != None; P = P.NextPawn)
      {
         if (P.IsA('Bot') || P.IsA('TournamentPlayer')) GiveAmp(P);
      }
      AmpCount = 0;
   }

   for (P = Level.PawnList; P != None; P = P.NextPawn)
   {
      if (P.IsA('Bot') || P.IsA('TournamentPlayer'))
      {
         if (P.Health > 0)
         {
            if (bUseRegenAmmo)
            {
               for (Inv = P.Inventory; Inv != None; Inv = Inv.Inventory)
               {
                  if ((Ammo(Inv) != None) && (P.bFire == 0) && (P.bAltFire == 0))
                  {
                     if (Ammo(Inv).AmmoAmount < Ammo(Inv).MaxAmmo * 10)
                     {
                        Ammo(Inv).AmmoAmount += (Ammo(Inv).Default.AmmoAmount / AmmoInterval);
                        if (Ammo(Inv).AmmoAmount > Ammo(Inv).MaxAmmo * 10)
                           Ammo(Inv).AmmoAmount = Ammo(Inv).MaxAmmo * 10;
                     }
                  }
               }
            }
            if (bUseRegenHealth)
            {
               if (P.Health < MaxRegenHealth && P.Region.Zone != None && !P.Region.Zone.bWaterZone) // waterzone stoppage of health regen
               {
                  if (P.IsInState('FeigningDeath'))
                     P.Health = FMin(MaxRegenHealth, P.Health + (3 * HealthRegenPerSec));
                  else
                     P.Health = FMin(MaxRegenHealth, P.Health + HealthRegenPerSec);
               }
            }
         }

         PRand = GetRandomPlayer();
         if (PRand != None)
         {
            if (kakuCount < DeemerSpawnTime) kakuCount++;
            if (HealthCount < HealthAwardTime) HealthCount++;
            if (DeemerSpawnTime - kakuCount < 5 && DeemerSpawnTime - kakuCount > 0)
            {
               BroadcastLocalizedMessage(class 'MH2RandomDeemerMsg', DeemerSpawnTime - kakuCount, PRand.PlayerReplicationInfo);
            }
            if (HealthAwardTime - HealthCount < 5 && HealthAwardTime - HealthCount > 0)
            {
               BroadcastLocalizedMessage(class 'MH2RandomHealthMsg', HealthAwardTime - HealthCount, PRand.PlayerReplicationInfo);
            }
            if (kakuCount >= DeemerSpawnTime)
            {
               kakuCount = 0;
               PRand = GetRandomPlayer();
               if (PRand != None && PRand.bIsPlayer)
               {
                  BroadcastLocalizedMessage(class 'MH2RandomDeemerMsg', kakuCount, PRand.PlayerReplicationInfo);
                  if (Use2k4Deemer)
                     GiveRedeemer(PRand);
                  else
                     GiveOldRedeemer(PRand);
               }
            }
            if (HealthCount >= HealthAwardTime)
            {
               HealthCount = 0;
               PRand = GetRandomPlayer();
               if (PRand != None && PRand.bIsPlayer)
               {
                  BroadcastLocalizedMessage(class 'MH2RandomHealthMsg', HealthCount, PRand.PlayerReplicationInfo);
                  GiveHealth(PRand);
               }
            }
         }
      }
   }
}

function GiveRedeemer(Pawn PlayerPawn)
{
   local MH2WarheadLauncher  rede;
   local bool NoNeed;

   rede= spawn(class'MH2WarheadLauncher');
   if( rede!= None )
   {
      if (PlayerPawn.FindInventoryType(class'MH2WarheadLauncher') != None)
         NoNeed = true;

      rede.RespawnTime = 0.0;
      rede.GiveTo(PlayerPawn);
      rede.SetSwitchPriority(PlayerPawn);
      PlayerPawn.AddInventory(rede);
      rede.PickupAmmoCount = 1;
      rede.GiveAmmo(PlayerPawn);
      if (NoNeed)
         rede.Destroy();
   }
}

function GiveOldRedeemer(Pawn PlayerPawn)
{
   local Warheadlauncher  redeA;
   local bool NoNeed;

   redeA= spawn(class'Warheadlauncher');
   if( redeA!= None )
   {
      if (PlayerPawn.FindInventoryType(class'Warheadlauncher') != None)
         NoNeed = true;

      redeA.RespawnTime = 0.0;
      redeA.GiveTo(PlayerPawn);
      redeA.SetSwitchPriority(PlayerPawn);
      PlayerPawn.AddInventory(redeA);
      redeA.PickupAmmoCount = 1;
      redeA.GiveAmmo(PlayerPawn);
      if (NoNeed)
         redeA.Destroy();
   }
}

function MonsterAttackCheck()
{
   local ScriptedPawn S;
   local Queen Q;
   local Pawn P;

   for ( P=Level.PawnList; P!=None; P=P.nextPawn )
   {
      S = ScriptedPawn(P);
      Q = Queen(P);

      if (S != None && S.Enemy != None && S.Enemy.IsA('ScriptedPawn'))
      {
         S.Hated = None;
         S.Enemy = None;
         if (S.OldEnemy!=None && S.OldEnemy.IsA('ScriptedPawn'))
            S.OldEnemy = none;
         S.WhatToDoNext('Waiting','');
      }
      if (!bHaveQueenDests)
      {
         Q = Queen(P);
         if (Q != none)
         {
            if (Q.IsInState('Teleporting'))
               Q.GotoState('Attacking');
         }
      }
   }
   LastMonsterAttackTime = Level.TimeSeconds;
}

function GiveHealth(Pawn PlayerPawn)
{
   PlayerPawn.Health+=500;
}

function Pawn GetRandomPlayer()
{
   local Pawn N;
   local PlayerPawn Dest;
   local Pawn Candidate[32];
   local int num;

   for (N=Level.PawnList; N!=None; N=N.NextPawn)
   {
      Dest=PlayerPawn(N);
      if (Dest!=None && Dest.bIsPlayer && !Dest.PlayerReplicationInfo.bIsSpectator)
      {
         if (num<32) Candidate[num] = Dest;
         else if (Rand(num) < 32) Candidate[Rand(32)] = Dest;
         num++;
      }
   }
   if(num==0) return None;
   return Candidate[Rand(Min(32,num))];
}

function Mutate(string MutateString, PlayerPawn Sender)
{
   local mover M;

   if(!Sender.PlayerReplicationInfo.bIsSpectator || !Sender.PlayerReplicationInfo.bWaitingPlayer)
   {
      if(MutateString ~= HealGunSummon)
      {
         spawn(class'MonsterHunt2GoldCE.HealingGun',,,Sender.Location);
      }
      if(MutateString~="light")
      {
         Sender.ClientMessage("Toggling personal light on");
         Sender.AmbientGlow = 254;
         Sender.LightEffect=LE_NonIncidence;
         Sender.LightBrightness=255;
         Sender.LightHue=210;
         Sender.LightRadius=30;
         Sender.LightSaturation=200;
         Sender.LightType=LT_Steady;
      }
      if(MutateString~="dark")
      {
         Sender.ClientMessage("Toggling personal light off");
         Sender.AmbientGlow = Owner.Default.AmbientGlow;
         Sender.LightType = LT_None;
      }
      if(MutateString ~= CommandOpen)
      {
         Sender.ClientMessage("Movers in range opened (Action was logged to the server admin)...");
         foreach RadiusActors(class'Mover', M, 250, Sender.Location)
         {
            log("## ADMIN- Mover opened:"@M@" by player:"@Sender.PlayerReplicationInfo.PlayerName);
            M.DoOpen();
         }
      }
      else if(MutateString ~= CommandClose)
      {
         Sender.ClientMessage("Movers in range closed (Action was logged to the server admin)...");
         foreach RadiusActors(class'Mover', M, 250, Sender.Location)
         {
            log("## ADMIN- Mover closed:"@M@" by player:"@Sender.PlayerReplicationInfo.PlayerName);
            M.DoClose();
         }
      }
   }
   if ( NextMutator != None )
      NextMutator.Mutate(MutateString, Sender);
}

simulated function bool AlwaysKeep(Actor Other)
{
   if(Other.IsA('ScriptedPawn')) return true;  //ADD
   if (Other.IsA('ScriptedPawn'))
      ScriptedPawn(Other).bIsPlayer = False;
   if (PlayerPawn(Other) != None)
   {
      Pawn(Other).PlayerReplicationInfoClass=Class'IPRI';
      return True;
   }
   if ( NextMutator != None )
      return ( NextMutator.AlwaysKeep(Other) );
   return false;
}

defaultproperties
{
   AmpSpawnTime=400
   DeemerSpawnTime=120
   HealthAwardTime=500
   bUseRandomWeapon=True
   HealthRegenPerSec=10
   MaxHealth=500
   bUseRegenAmmo=True
   bUseRegenHealth=True
   bGiveArmor=True
   MaxRegenHealth=500
   HealthRegenPerKill=10
   DefaultHealth=100
   bUseAntiBoost=False
   bGhostCarcass=True
   AmmoInterval=3
   bHitsounds=True
   bAltScoring=True
   bCheckMonsterAttack=True
   stopPlayerCollision=True
   ReplaceInvis=True
   VisibleMonsterEnds=True
   GiveAllWeapons=True
   DoubleJump=True
   maxJumps=3
   jumpType=2
   jumpHeight=2.00
   bDropWeaponsOnDeath=True
   retainScoreOnDeathPercent=0.75
   bUseSpawnProt=True
   SpawnProtDuration=10
   UseMHTranslocator=True
   HitVolume=16.00
   bFixCrushingMover=False
   Use2k4Deemer=True
   UseAltSniper=False
   UseLimeLight=False
   UseMH2JumpBoots=False
   MaxDamage=1000
   UseServerStats=True
   bServerInfo="Default message"
   MH2NaliFruit="MonsterHunt2GoldCE.MH2NaliFruit"
   MH2MedBox="MonsterHunt2GoldCE.MH2MedBox"
   MH2HealthPack="MonsterHunt2GoldCE.MH2HealthPack"
   MH2UnrealHealth="MonsterHunt2GoldCE.MH2UnrealHealth"
   MH2HealthVial="MonsterHunt2GoldCE.MH2HealthVial"
// New
   AdjustFactories=False
   bCapacity=500
   ChangeCovertToFalse=True
}
