
class MH2UnrealHealth extends Health config(MonsterHunt2Gold);

var config int MaxHealth;

var() int HealingAmount;
var() bool bSuperHeal;

event float BotDesireability(Pawn Bot)
{
   local float desire;

   if (bSuperHeal) MaxHealth = MaxHealth * 2.0;
      desire = Min(HealingAmount, MaxHealth - Bot.Health);
   if ( (Bot.Weapon != None) && (Bot.Weapon.AIRating > 0.5) )
      desire *= 1.7;
   if ( Bot.Health < 40 )
      return ( FMin(0.03 * desire, 2.2) );
   else
      return ( FMin(0.015 * desire, 2.0) );
}

auto state Pickup
{
   function Touch( actor Other )
   {
      local Pawn P;

      if ( ValidTouch(Other) )
      {
         P = Pawn(Other);
         if (bSuperHeal) MaxHealth = MaxHealth * 2.0;
         if (P.Health < MaxHealth)
         {
            if (Level.Game.LocalLog != None)
               Level.Game.LocalLog.LogPickup(Self, P);
            if (Level.Game.WorldLog != None)
	       Level.Game.WorldLog.LogPickup(Self, P);
            P.Health += HealingAmount;
	    if (P.Health > MaxHealth) P.Health = MaxHealth;
            PlayPickupMessage(P);
	    PlaySound (PickupSound,,2.5);
	    if ( Level.Game.Difficulty > 1 )
	       Other.MakeNoise(0.1 * Level.Game.Difficulty);
            SetRespawn();
       	 }
      }
   }
}

defaultproperties
{
   MaxHealth=500
   HealingAmount=20
}
