
#exec OBJ LOAD File="..\System\MonsterHunt.u"

class MonsterHunt expands TeamGamePlus config(MonsterHunt2Gold);

var config bool bUseTeamSkins;

var config int MonsterSkill;

var config int Lives;
var bool bUseLives;

var string TimeOutMessage;

var int LivePpl;
var int PlainPpl;

var int LastPoint;
var int NumPoints;
var int MonstersTotal;
var int HuntersTotal;

var config string StartUpMessage;
var config float MaxMonsterHealth;

function PostBeginPlay()
{
	local int i;
	local ScriptedPawn S;
	local pawn pawnlink;
	local MonsterWaypoint WP;
	local MonsterEnd ME;
	local MH2MonsterEnd ex;
        local Queen Q;
        local QueenDest QD;

	LastPoint = 0;

	foreach AllActors(class'MonsterWaypoint', WP)
		NumPoints ++;

	foreach AllActors(class'ScriptedPawn', S)
	{
		MonstersTotal ++;
		if ( !S.IsA('Nali') && !S.IsA('Cow') && !S.IsA('NaliRabbit') )
			S.AttitudeToPlayer=ATTITUDE_Hate;
		if (S.Shadow == None)
			SetPawnDifficulty(MonsterSkill, S);
	}

        foreach AllActors(class'MonsterEnd', ME)
	{
		if(ME !=none)
	   {
		ex=Spawn(class'MH2MonsterEnd',,,ME.location+vect(-1,-1,-1)); // right next to it
		if(ME.Tag !='')
                ex.tag=ME.Tag;
                if(ME.Event !='')
		ex.event=ME.Event;
		if(ME.AttachTag !='')
		ex.AttachTag=ME.AttachTag;
		ex.SetCollisionSize(ME.CollisionRadius, ME.CollisionHeight);

		if (ME.bInitiallyActive)
			ex.bInitiallyActive=True;
		else
			ex.bInitiallyActive=False;
	    }
	}

	MonsterReplicationInfo(GameReplicationInfo).Monsters = MonstersTotal;
	MonsterReplicationInfo(GameReplicationInfo).Lives = Lives;
	MonsterReplicationInfo(GameReplicationInfo).bUseTeamSkins = bUseTeamSkins;
	if ( MonsterReplicationInfo(GameReplicationInfo).Lives <= 0 )
		MonsterReplicationInfo(GameReplicationInfo).bUseLives = False;
	else
		MonsterReplicationInfo(GameReplicationInfo).bUseLives = True;

	Super.PostBeginPlay();
}

function SetPawnDifficulty( int Diff, ScriptedPawn S )
{
	local int DiffScale;

	switch (Diff)
	{
		case 0:
			DiffScale = 80;
			break;
		case 1:
			DiffScale = 90;
			break;
		case 2:
			DiffScale = 100;
			break;
		case 3:
			DiffScale = 110;
			break;
		case 4:
			DiffScale = 120;
			break;
		case 5:
			DiffScale = 130;
			break;
		case 6:
			DiffScale = 140;
			break;
		case 7:
			DiffScale = 150;
			break;
	}
	S.Health = (S.Health * DiffScale) / 100;
	if (S.Health > MaxMonsterHealth) S.Health = MaxMonsterHealth;
	S.SightRadius = (S.SightRadius * DiffScale) / 100;
	S.Aggressiveness = (S.Aggressiveness * DiffScale) / 100;
	S.ReFireRate = (S.ReFireRate * DiffScale) / 100;
	S.CombatStyle = (S.CombatStyle * DiffScale) / 100;
	S.ProjectileSpeed = (S.ProjectileSpeed * DiffScale) / 100;
	S.GroundSpeed = (S.GroundSpeed * DiffScale) / 100;
	S.AirSpeed = (S.AirSpeed * DiffScale) / 100;
	S.WaterSpeed = (S.WaterSpeed * DiffScale) / 100;

	if (S.Shadow == None)
		S.Shadow = Spawn(class'MonsterShadow', S);
}

function AddDefaultInventory( pawn PlayerPawn )
{
	bUseTranslocator = false;
	Super.AddDefaultInventory(PlayerPawn);
}

event InitGame( string Options, out string Error )
{
	local string InOpt;
	local Mutator M, last;
	local class<Mutator> MutatorClass;
	local int i;

	MaxTeams = Min(MaxTeams,MaxAllowedTeams);

	for (M = BaseMutator; M != None; M = M.NextMutator)
	{
		if (M.class == class'Botpack.LowGrav')
		{
			last.NextMutator = M.NextMutator;
			M.Destroy();M = last;
		}
		if (M.class == class'Botpack.InstaGibDM')
		{
			last.NextMutator = M.NextMutator;
			M.Destroy();
			M = last;
		}
	}

	Super(TournamentGameInfo).InitGame(Options, Error);

	RemainingTime = 60 * TimeLimit;
	SetGameSpeed(GameSpeed);
	FragLimit = GetIntOption( Options, "FragLimit", FragLimit );
	TimeLimit = GetIntOption( Options, "TimeLimit", TimeLimit );
	MaxCommanders = GetIntOption( Options, "MaxCommanders", MaxCommanders );
	InOpt = ParseOption( Options, "CoopWeaponMode");
	if ( InOpt != "" ) bCoopWeaponMode = bool(InOpt);
	IDnum = -1;
	IDnum = GetIntOption( Options, "Tournament", IDnum );
	if ( IDnum > 0 ){
		bRatedGame = true;
		TimeLimit = 0;
		RemainingTime = 0;}
	if ( Level.NetMode == NM_StandAlone ){
		bRequireReady = true;
		CheckReady();}
	if ( Level.NetMode == NM_StandAlone ){
		bRequireReady = true;
		CountDown = 1;}
	if ( !bRequireReady && (Level.NetMode != NM_Standalone) ){
		bRequireReady = true;
		bNetReady = true;}

	bJumpMatch = False;
	bNoMonsters = False;
}

function bool SetEndCams(string Reason)
{
	local TeamInfo BestTeam;
	local int i;
	local pawn P, Best;
	local PlayerPawn player;
	local bool bGood;
        local ScriptedPawn W;
        local Carcass C;

	bGood = True;

	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
			Best = P;

	if ( Reason == "No Hunters" )
	{
		bGood = False;
		GameEndedMessage = "All players are lost, game over!";
	}

	if ( (RemainingTime == 0) && (TimeLimit >= 1) )
	{
		bGood = False;
		GameReplicationInfo.GameEndedComments = TimeOutMessage;
	}
	else
		GameReplicationInfo.GameEndedComments = GameEndedMessage;

	EndTime = Level.TimeSeconds + 3.0;
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		player = PlayerPawn(P);
		if ( Player != None )
		{
                        //Attempt to stop the sliding player at map end
                        player.SetLocation(player.Location);
                        player.Velocity.X = 0;
                        player.Velocity.Y = 0;
                        player.Velocity.Z = 0;
			if (!bTutorialGame)
				PlayWinMessage(Player, bGood);
			player.bBehindView = true;
			if ( Player == Best )
				Player.ViewTarget = None;
			else
				Player.ViewTarget = Best;
			player.ClientGameEnded();
		}
		P.GotoState('GameEnded');
	}
        // clean up the end game screen, removes leftover monsters and carcass
        foreach AllActors(class'ScriptedPawn', W)
		W.Destroy();

        foreach AllActors(class'Carcass', C)
                C.Destroy();

	CalcEndStats();
	return true;
}

function PlayStartUpMessage(PlayerPawn NewPlayer)
{
	local int i;
	local color Green, DarkGreen;

	NewPlayer.ClearProgressMessages();

	Green.G = 255;
	Green.B = 128;
	DarkGreen.G = 200;
	DarkGreen.B = 64;

	NewPlayer.SetProgressColor(Green, i);

	NewPlayer.SetProgressMessage(GameName, i++);
	if ( bRequireReady && (Level.NetMode != NM_Standalone) )
	{
		NewPlayer.SetProgressColor(Green, i);
		NewPlayer.SetProgressMessage(TourneyMessage, i++);
	}
	else
	{
		NewPlayer.SetProgressColor(Green, i);
		NewPlayer.SetProgressMessage(StartUpMessage, i++);
	}

	if ( Level.NetMode == NM_Standalone )
		NewPlayer.SetProgressMessage(SingleWaitingMessage, i++);
}

function playerpawn Login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
local PlayerPawn newPlayer;
local NavigationPoint StartSpot;
local int i;

	newPlayer = Super.Login(Portal, Options, Error, SpawnClass);
	if ( newPlayer == None)
		return None;

	if ( bSpawnInTeamArea )
	{
		StartSpot = FindPlayerStart(NewPlayer,0, Portal);
		if ( StartSpot != None )
		{
			NewPlayer.SetLocation(StartSpot.Location);
			NewPlayer.SetRotation(StartSpot.Rotation);
			NewPlayer.ViewRotation = StartSpot.Rotation;
			NewPlayer.ClientSetRotation(NewPlayer.Rotation);
			StartSpot.PlayTeleportEffect( NewPlayer, true );
		}
	}
	PlayerTeamNum = NewPlayer.PlayerReplicationInfo.Team;

	if (bUseLives)
		if ( (NewPlayer != None) && !NewPlayer.IsA('Spectator') )
			NewPlayer.PlayerReplicationInfo.Deaths = MonsterReplicationInfo(GameReplicationInfo).Lives;

	CountHunters();

	return newPlayer;
}

function bool RestartPlayer( pawn aPlayer )	
{
	local NavigationPoint startSpot;
	local bool foundStart;
	local Pawn P;

	if (MonsterReplicationInfo(GameReplicationInfo).bUseLives)
	{
		if( bRestartLevel && Level.NetMode!=NM_DedicatedServer && Level.NetMode!=NM_ListenServer )
			return true;

		if ( aPlayer.PlayerReplicationInfo.Deaths < 1 )
		{
			BroadcastMessage(aPlayer.PlayerReplicationInfo.PlayerName$" has been lost!", true, 'MonsterCriticalEvent');
			For ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.bIsPlayer && (P.PlayerReplicationInfo.Deaths >= 1) )
					P.PlayerReplicationInfo.Deaths += 0.00001;
			if ( aPlayer.IsA('Bot') )
			{
				aPlayer.PlayerReplicationInfo.bIsSpectator = true;
				aPlayer.PlayerReplicationInfo.bWaitingPlayer = true;
				aPlayer.GotoState('GameEnded');
				return false;
			}
		}

		startSpot = FindPlayerStart(None, 255);
		if( startSpot == None )
			return false;
			
		foundStart = aPlayer.SetLocation(startSpot.Location);
		if( foundStart )
		{
			startSpot.PlayTeleportEffect(aPlayer, true);
			aPlayer.SetRotation(startSpot.Rotation);
			aPlayer.ViewRotation = aPlayer.Rotation;
			aPlayer.Acceleration = vect(0,0,0);
			aPlayer.Velocity = vect(0,0,0);
			aPlayer.Health = aPlayer.Default.Health;
			aPlayer.ClientSetRotation( startSpot.Rotation );
			aPlayer.bHidden = false;
			aPlayer.SoundDampening = aPlayer.Default.SoundDampening;
			if ( aPlayer.PlayerReplicationInfo.Deaths < 1 )
			{
				aPlayer.bHidden = true;
				aPlayer.PlayerRestartState = 'PlayerSpectating';
			} 
			else
			{
				aPlayer.SetCollision( true, true, true );
				AddDefaultInventory(aPlayer);
			}
		}
		return foundStart;
	}
	else 
		return Super.RestartPlayer(aPlayer);
}

function CheckEndGame()
{
	local Pawn PawnLink;
	local int StillPlaying;
	local bool bStillHuman;
	local bot B, D;

	if ( bGameEnded )
		return;

	LivePpl = 0;
	PlainPpl = 0;
	for ( PawnLink=Level.PawnList; PawnLink!=None; PawnLink=PawnLink.nextPawn )
		if ( PawnLink.bIsPlayer )
		{
			if ( ( PawnLink.PlayerReplicationInfo.Deaths >= 1 ) && 
				!PawnLink.PlayerReplicationInfo.bIsSpectator )
				LivePpl ++;
			if ( PawnLink.IsA('PlayerPawn') &&
				(PawnLink.PlayerReplicationInfo.Deaths >= 1) )
				PlainPpl ++;
		}

	if ( LivePpl < 1 )
		EndGame("No Hunters");
	else if ( PlainPpl < 1 )
	{
		for ( PawnLink=Level.PawnList; PawnLink!=None; PawnLink=PawnLink.NextPawn )
		{
			B = Bot(PawnLink);
			if ( (B != None) && (B.Health > 0) )
				B.SetOrders('Attack', None,true);
		}
	}		
}

function Killed( pawn killer, pawn Other, name damageType )
{
     if ((Killer != None) && (Other !=None))    //added check for access nones showing on server logs
     {
          if ((Killer != Other) && (DamageType == 'Decapitated'))
          {
               if ( FRand() < 0.4 )
               {
	            switch(Rand(5))
                    {
                         case 0 :
			      Killer.ReceiveLocalizedMessage(class'MH2HeadShotMessage5');
                              break;
			 case 1 :
			      Killer.ReceiveLocalizedMessage(class'MH2HeadShotMessage4');
			      break;
			 case 2 :
			      Killer.ReceiveLocalizedMessage(class'MH2HeadShotMessage3');
			      break;
			 case 3 :
			      Killer.ReceiveLocalizedMessage(class'MH2HeadShotMessage2');
			      break;
		         default :
			      Killer.ReceiveLocalizedMessage(class'MH2HeadShotMessage');
			      break;
		     }
	        }
          }
     }
     Super(GameInfo).Killed(Killer, Other, DamageType);

     if (!bFirstBlood)
     {
          if (Killer.bIsPlayer && (Killer != Other))
          {
	       bFirstBlood = True;
               BroadcastLocalizedMessage(class'MH2FirstBloodMessage', 0, Killer.PlayerReplicationInfo);
          }
     }

     if ( Killer == Other )
        Other.PlayerReplicationInfo.Score -= 4;

     if ( Killer.IsA('ScriptedPawn') && Other.bIsPlayer && !MonsterReplicationInfo(GameReplicationInfo).bUseLives)
        Other.PlayerReplicationInfo.Score -= 5;

     if (MonsterReplicationInfo(GameReplicationInfo).bUseLives && Other.bIsPlayer)
     {
	Other.PlayerReplicationInfo.Deaths -= 1;
	CheckEndGame();
     }
}

function ScoreKill(pawn Killer, pawn Other)
{
     local ScriptedPawn S;
     local Pawn P;

     if ((Killer != none) && (Other != none))
     {
	if ( (Killer == None) || (Killer == Other) || !Other.bIsPlayer 
		|| (Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team) )
		Super.ScoreKill(Killer, Other);

	MonstersTotal = 0;

	for (P=Level.PawnList; P!=None; P=P.NextPawn)
	{
	    S=ScriptedPawn(P);

	    if(S!=None)
	       {
		  if (S.Health >= 1)
	          MonstersTotal ++;
		  if (S.Shadow == None)
	          SetPawnDifficulty(MonsterSkill, S);
	       }
	}

	MonsterReplicationInfo(GameReplicationInfo).Monsters = MonstersTotal;

	if (Other.bIsPlayer && MonsterReplicationInfo(GameReplicationInfo).bUseLives)
		Other.PlayerReplicationInfo.Deaths -= 1;

 	if(!Other.IsA('ScriptedPawn')) return;

	if(Killer!=None)
 	{
    		BroadcastMessage(Killer.GetHumanName()@"killed"$Other.GetHumanName());
 	}

	if ( (Killer.bIsPlayer) && ( (Other.IsA('Titan')) || (Other.IsA('Queen')) || (Other.IsA('WarLord')) ) )
		Killer.PlayerReplicationInfo.Score += 4;
	if ( (Killer.bIsPlayer) && ( (Other.IsA('GiantGasBag')) || (Other.IsA('GiantManta')) ) )
		Killer.PlayerReplicationInfo.Score += 3;
	if ( (Killer.bIsPlayer) && ( (Other.IsA('SkaarjWarrior')) || (Other.IsA('MercenaryElite')) || (Other.IsA('Brute')) ) )
		Killer.PlayerReplicationInfo.Score += 2;
	if ( (Killer.bIsPlayer) && ( (Other.IsA('SkaarjTrooper')) || ( (Other.IsA('Mercenary')) && (!Other.IsA('MercenaryElite')) ) || (Other.IsA('Krall')) || (Other.IsA('Slith')) || ( (Other.IsA('GasBag')) && (!Other.IsA('GiantGasBag')) ) ) )
		Killer.PlayerReplicationInfo.Score += 1;

	if ( (Killer.bIsPlayer) && ( (Other.IsA('Nali')) || (Other.IsA('Cow')) || (Other.IsA('NaliRabbit')) ) )
		Killer.PlayerReplicationInfo.Score -= 6;
        // Tracks total monsters killed in the map (shown in scoreboard)
        if ( (Killer.IsA('PlayerPawn')) && (Other.IsA('ScriptedPawn')))
		IPRI(PlayerPawn(Killer).PlayerReplicationInfo).KilledMonsters += 1;

	if (Other.IsA('ScriptedPawn'))
		S = ScriptedPawn(Other);
	if ( (Killer.bIsPlayer) && ( S.bIsBoss ) )
		Killer.PlayerReplicationInfo.Score += 9;
   }
}

function AddToTeam( int num, Pawn Other )
{
local teaminfo aTeam;
local Pawn P;
local bool bSuccess;
local string SkinName, FaceName;
local int i;

        if ( Other != None )
	{
		aTeam = Teams[0];
		aTeam.Size++;
		Other.PlayerReplicationInfo.Team = 0;
		Other.PlayerReplicationInfo.TeamName = aTeam.TeamName;
		bSuccess = false;
		if ( Other.IsA('PlayerPawn') )
		{
			Other.PlayerReplicationInfo.TeamID = 0;
			PlayerPawn(Other).ClientChangeTeam(Other.PlayerReplicationInfo.Team);
		}
		else
			Other.PlayerReplicationInfo.TeamID = 1;

		while ( !bSuccess )
		{
			bSuccess = true;
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.bIsPlayer && (P != Other) && (!P.IsA('SkaarjTrooper')
					&& (P.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team)
					&& (P.PlayerReplicationInfo.TeamId == Other.PlayerReplicationInfo.TeamId) )  )
			{	
				Other.PlayerReplicationInfo.TeamID++;
				bSuccess = False;
			}
		}

		if (MonsterReplicationInfo(GameReplicationInfo).bUseLives)
			Other.PlayerReplicationInfo.Deaths = MonsterReplicationInfo(GameReplicationInfo).Lives;

		if (MonsterReplicationInfo(GameReplicationInfo).bUseTeamSkins)
		{
			Other.static.GetMultiSkin(Other, SkinName, FaceName);
			Other.static.SetMultiSkin(Other, SkinName, FaceName, 0);
		}
	}
}

function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
    Damage = Super.ReduceDamage(Damage, DamageType, injured, instigatedBy);
    
    if ( instigatedBy == None )
        return Damage;

    if (injured.IsA('SkaarjTrooper'))
        return Damage;

    if ( (instigatedBy != injured) && injured.bIsPlayer && instigatedBy.bIsPlayer 
        && (injured.PlayerReplicationInfo.Team == instigatedBy.PlayerReplicationInfo.Team))
    {
        if ( injured.IsA('Bot') )
            Bot(Injured).YellAt(instigatedBy);
        return (Damage * FriendlyFireScale);
    }
    else
        return Damage;
}

function StartMatch()
{
	local ScriptedPawn S;

	CountHunters();
	super.StartMatch();
}

function Timer()
{
	CountHunters();
	Super.Timer();
}
function CountHunters()
{
	local Bot B;
	local TournamentPlayer TP;
	local Pawn P;

	HuntersTotal = 0;

	for (P=Level.PawnList; P!=None; P=P.NextPawn)
	{
	   B=Bot(P);
	   TP=TournamentPlayer(P);
	   
	   if ((B!=None) && (TP!=None))
		if (!TP.PlayerReplicationInfo.bIsSpectator || !B.PlayerReplicationInfo.bIsSpectator)
			HuntersTotal ++;
	}
	MonsterReplicationInfo(GameReplicationInfo).Hunters = HuntersTotal;
}

function bool FindSpecialAttractionFor(Bot aBot)
{
	local MonsterWaypoint W;
	local MonsterEnd E;
	local MonsterWaypoint NextPoint;
	local bool bFound;
	local ScriptedPawn S;

	if ((aBot != None) && (aBot.Health < 1))
	{
		aBot.GotoState('GameEnded');
		return false;
	}

	if ( aBot.LastAttractCheck == Level.TimeSeconds )
		return false;

	if(aBot==None)
		return false;

	foreach AllActors( class'ScriptedPawn', S )
	{
		if ( S.CanSee(aBot) )
		{
			if ( ((S.Enemy == None) || ((S.Enemy.IsA('PlayerPawn')) || ((!S.Enemy.IsA('Spectator'))) && (FRand() >= 0.5))) && (S.Health >= 1) )
			{
				S.Hated = aBot;
				S.Enemy = aBot;
				aBot.Enemy = S;
				S.GotoState('Attacking');
				If (FRand() >= 0.35)
				{
					aBot.GotoState('Attacking');
					return false;
				}
			}
		}
		else
		if (aBot.CanSee(S) && (FRand() >= 0.35) && (S.Health >= 1))
		{
			aBot.Enemy = S;
			aBot.GotoState('Attacking');
			S.Enemy = aBot;
			S.GotoState('Attacking');
			return false;
		}
	}

	aBot.LastAttractCheck = Level.TimeSeconds;

	if ( (aBot.Orders == 'Attack') || ((aBot.Orders == 'Freelance') && (FRand() > 0.2)) )
	{
		foreach AllActors( class'MonsterWaypoint', W )
		{
			if (!W.bVisited && (W.Position == LastPoint + 1))
			{
				NextPoint = W;
				if ( aBot.ActorReachable(NextPoint) )
					aBot.MoveTarget = NextPoint;
				else
					aBot.MoveTarget = aBot.FindPathToward(NextPoint);
				NumPoints --;
				SetAttractionStateFor(aBot);
				return True;
			}
		}

		if (NumPoints <= 0)
		{
			foreach AllActors( class'MonsterEnd', E )
			{
				if ( aBot.ActorReachable(E) )
					aBot.MoveTarget = E;
				else
					aBot.MoveTarget = aBot.FindPathToward(E);
				SetAttractionStateFor(aBot);
				return True;
			}
		}
	}

	return false;
}

defaultproperties
{
     MonsterSkill=7
     Lives=30
     TimeOutMessage="Times up, you failed!"
     bSpawnInTeamArea=True
     bBalanceTeams=False
     bPlayersBalanceTeams=False
     MaxTeams=1
     MaxAllowedTeams=1
     MaxTeamSize=24
     StartUpTeamMessage="Welcome to the server!"
     FragLimit=0
     NetWait=2
     RestartWait=5
     bUseTranslocator=False
     StartUpMessage="Use your skills to defeat the monsters and solve the puzzles!"
     StartMessage="The game has been started!"
     GameEndedMessage="You have won!!!"
     SingleWaitingMessage="Press Fire to start the game."
     ExplodeMessage=" was blown up"
     BurnedMessage=" was incinerated"
     CorrodedMessage=" was slimed"
     HackedMessage=" was hacked"
     bNoMonsters=False
     bCoopWeaponMode=True
     DefaultWeapon=Class'Botpack.ChainSaw'
     AdminPassword="ichangedit"
     ScoreBoardType=Class'MonsterHunt.MonsterBoard'
     BotMenuType="MonsterHunt.MonsterBotConfig"
     RulesMenuType="MonsterHunt2GoldCE.MonsterHuntRules"
     SettingsMenuType="MonsterHunt.MonsterSettings"
     HUDType=Class'MonsterHunt2GoldCE.MH2HUD'
     MapListType=Class'MonsterHunt.MonsterMapList'
     MapPrefix="MH"
     BeaconName="MH"
     LeftMessage=" left the game (Quitter!)."
     EnteredMessage=" has joined the game!"
     GameName="Monster Hunt"
     MaxPlayers=10
     DMMessageClass=Class'MonsterHunt.HuntMessage'
     MutatorClass=Class'MonsterHunt2GoldCE.MH2Base'
     GameReplicationInfoClass=Class'MonsterHunt.MonsterReplicationInfo'
     MaxMonsterHealth=5000.00
}
