
// Brought this class in in the hopes of fixing the forced red team that MH has.
// Unfortunately it breaks the replication of the radar and scoreboard if you alter
// the assigned team. Feel free to try to fix this but remember many outside mods
// depend on this replication data to be accurate.

class MonsterHuntRules expands UTRulesCWindow config(MonsterHunt2Gold);

#exec TEXTURE IMPORT NAME=MHRulesBG FILE=Textures\MHRulesBG.PCX GROUP=Rules LODSET=0

function Created()
{
   Super.Created();
   if(ForceRespawnCheck != None)
      ForceRespawnCheck.HideWindow();
}

function LoadCurrentValues()
{
   Super.LoadCurrentValues();

   if(TimeEdit != None)
      TimeEdit.SetValue(string(Class<MonsterHunt>(BotmatchParent.GameClass).Default.TimeLimit));

   if(MaxPlayersEdit != None)
      MaxPlayersEdit.SetValue(string(Class<MonsterHunt>(BotmatchParent.GameClass).Default.MaxPlayers));

   if(MaxSpectatorsEdit != None)
      MaxSpectatorsEdit.SetValue(string(Class<MonsterHunt>(BotmatchParent.GameClass).Default.MaxSpectators));

   if((BotmatchParent.bNetworkGame) && (WeaponsCheck != none))
      WeaponsCheck.bChecked = Class<MonsterHunt>(BotmatchParent.GameClass).Default.bMultiWeaponStay;
   else
      WeaponsCheck.bChecked = Class<MonsterHunt>(BotmatchParent.GameClass).Default.bCoopWeaponMode;

   if(FragEdit != None)
      FragEdit.SetValue(string(Class<MonsterHunt>(BotmatchParent.GameClass).Default.Lives));

   if(TourneyCheck != None)
      TourneyCheck.bChecked = Class<MonsterHunt>(BotmatchParent.GameClass).Default.bUseTeamSkins;
}

function Paint(Canvas C, float X, float Y)
{
   Super.Paint(C, X, Y);
   DrawStretchedTexture(C, 0, 0, WinWidth, WinHeight, Texture'MHRulesBG');
}

function FragChanged()
{
   Class<MonsterHunt>(BotmatchParent.GameClass).Default.Lives = int(FragEdit.GetValue());
}

function TourneyChanged()
{
   Class<MonsterHunt>(BotmatchParent.GameClass).Default.bUseTeamSkins = TourneyCheck.bChecked;
}

function TimeChanged()
{
   Class<MonsterHunt>(BotmatchParent.GameClass).Default.TimeLimit = int(TimeEdit.GetValue());
}

function WeaponsChecked()
{
   if(BotmatchParent.bNetworkGame)
      Class<MonsterHunt>(BotmatchParent.GameClass).Default.bMultiWeaponStay = WeaponsCheck.bChecked;
   else
      Class<MonsterHunt>(BotmatchParent.GameClass).Default.bCoopWeaponMode = WeaponsCheck.bChecked;
}

defaultproperties
{
   TourneyText="Force team colours"
   TourneyHelp="If enabled, players will use red team skins and HUD, otherwise they will use their own skin and HUD settings."
   FragText="Lives"
   FragHelp="Set the number of lives each hunter starts with for each round. Set it to 0 for no limit."
}

