
class PostalBabesMusic extends AmbientSound;

#exec AUDIO IMPORT FILE="Sounds\andywilliams.WAV" NAME="ClubEndMusic"
#exec AUDIO IMPORT FILE="Sounds\bingrudolph.WAV" NAME="GhettoEndMusic"
#exec AUDIO IMPORT FILE="Sounds\darlenelove.WAV" NAME="TechnoEndMusic"
#exec AUDIO IMPORT FILE="Sounds\littlesaintnick.wav" NAME="SaxyFrench"
#exec AUDIO IMPORT FILE="Sounds\muppetsjinglebellrock.WAV" NAME="sexyhouse"
#exec AUDIO IMPORT FILE="Sounds\needalittlechristmas.wav" NAME="GreaseMonkey"

var byte MusicIndex;
var sound MusicSound[6];

replication
{
   reliable if ( Role == ROLE_Authority )
      MusicIndex;
}

function BeginPlay()
{
   MusicIndex = Rand(6);
   AmbientSound = MusicSound[MusicIndex];
   Super.BeginPlay();
}

simulated function PostNetBeginPlay()
{
   AmbientSound = MusicSound[MusicIndex];
}

function Reset()
{
   Destroy();
}

defaultproperties
{
   MusicSound(0)=Sound'ClubEndMusic'
   MusicSound(1)=Sound'TechnoEndMusic'
   MusicSound(2)=Sound'GhettoEndMusic'
   MusicSound(3)=Sound'SaxyFrench'
   MusicSound(4)=Sound'sexyhouse'
   MusicSound(5)=Sound'GreaseMonkey'
   bStatic=False
   bAlwaysRelevant=True
   SoundRadius=16
   SoundVolume=255
}
