
class RelicDefenseInventory expands RelicInventory;

#exec TEXTURE IMPORT NAME=1upA FILE=Textures\1upA.bmp

function bool HandlePickupQuery( inventory Item )
{
   local Inventory I;

   if (item.IsA('UT_Shieldbelt') )
      return true; //don't allow shieldbelt if have defense relic
   return Super.HandlePickupQuery(Item);
}

function PickupFunction(Pawn Other)
{
   local Inventory I;

   Super.PickupFunction(Other);

   for ( I=Owner.Inventory; I!=None; I=I.Inventory )
   if ( I.IsA('UT_Shieldbelt') )
      I.Destroy();
}

function ArmorImpactEffect(vector HitLocation)
{ 
   if ( Owner.IsA('PlayerPawn') )
   {
      PlayerPawn(Owner).ClientFlash(-0.05,vect(400,400,400));
   }
   Owner.PlaySound(DeActivateSound, SLOT_None, 2.7*Pawn(Owner).SoundDampening);
   FlashShell(0.4);
}

function int ArmorAbsorbDamage(int Damage, name DamageType, vector HitLocation)
{
   ArmorImpactEffect(HitLocation);
   return 0.5 * Damage;
}

function int ArmorPriority(name DamageType)
{
   return 1;
}

defaultproperties
{
   ShellSkin=None
   bRotatingPickup=True
   PickupMessage="Defense Relic: 50% less damage!"
   PickupViewMesh=Mesh'oneupA'
   PickupViewScale=0.70
   bIsAnArmor=True
   PickupSound=Sound'GoBooster'
   Icon=Texture'DefenseTile'
   MultiSkins(0)=FireTexture'Belt_fx.ShieldBelt.BlueShield'
   MultiSkins(1)=Texture'1upA'
   CollisionHeight=40.00
   LightBrightness=200
   LightHue=185
   LightSaturation=0
   RotationRate=(Pitch=12250,Yaw=12000,Roll=12500),
}
