
class RelicInvulnerableInventory expands RelicInventory;

#exec obj load file=..\Textures\Belt_fx.utx package=Belt_fx
#exec TEXTURE IMPORT NAME=kevlar FILE=Textures\kevlar.bmp

#exec mesh import mesh=oneupA anivfile=Models\oneupA_a.3d datafile=Models\oneupA_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=oneupA x=0 y=0 z=0
#exec mesh sequence mesh=oneupA seq=All startframe=0 numframes=1

#exec meshmap new meshmap=oneupA mesh=oneupA
#exec meshmap scale meshmap=oneupA x=0.06250 y=0.06250 z=0.12500

var int PHealth, PArmor;
var int ShowCharge;
var config int bRespawnTime;
var config int Charge;

state Activated
{
   function endstate()
   {
      local Inventory S;
      local PlayerPawn P;

      P = PlayerPawn(Owner);
      P.ReducedDamageType = '';
      bActive = false;
      PlaySound(DeActivateSound);
      Owner.SetDefaultDisplayProperties();
      S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
      if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
      {
         UT_Shieldbelt(S).MyEffect.bHidden = false;
      }
      PHealth = 0;
      PArmor = 0;
   }
   function Activate()
   {
      bActive = true;
      SetOwnerDisplay();
   }
   function SetOwnerDisplay()
   {
      if ( !bActive )
      {
         return;
      }
      Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield',true,true);
   }
   function ChangedWeapon()
   {
      if ( !bActive )
      {
         return;
      }
      if( Inventory != None )
      {
	 Inventory.ChangedWeapon();
      }
      if ( Pawn(Owner).Weapon != None )
      {
         Pawn(Owner).Weapon.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield',true,true);
      }
   }
   function Timer()
   {
      Charge -= 1;
      Pawn(Owner).Visibility = 10;
      Owner.AmbientGlow = 250;
      Owner.LightEffect=LE_Rotor;//NonIncidence
      Owner.LightBrightness=64;
      Owner.LightHue=255;
      Owner.LightRadius=32;
      Owner.LightSaturation=127;
      Owner.LightType=LT_Steady;
      Pawn(Owner).DamageScaling = 3.0;
      ShowCharge = Charge;
      if (Charge<-0)
      {
         Owner.AmbientGlow = Owner.Default.AmbientGlow;
         Owner.LightType = LT_None;
         Pawn(Owner).DamageScaling = 1.0;
	 UsedUp();	
      }
      if ( Charge < 12 && Charge > 0 )
      {
	 Owner.PlaySound(Sound'BotPack.ChatSound.NewBeep');
      }
   }
   function BeginState()
   {
      local Inventory S;

      bActive = true;
      PlaySound(ActivateSound,,4.0);
      Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield',false,true);
      SetTimer(0.5,True);
      S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
      if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
      {
         UT_Shieldbelt(S).MyEffect.bHidden = true;
      }
   }
   simulated function Tick(float DT)
   {
      local PlayerPawn P;

      P = PlayerPawn(Owner);
      Super.Tick(DT);
      P.ReducedDamageType = 'All';
   }
}

state DeActivated
{
   Begin:
}

State Sleeping
{
   ignores Touch;

   function BeginState()
   {
      BecomePickup();
      bHidden = true;
   }
   function EndState()
   {
      local int i;

      bSleepTouch = false;
      for ( i=0; i<4; i++ )
      if ( (Touching[i] != None) && Touching[i].IsA('Pawn') )
         bSleepTouch = true;
   }
   Begin:
      Sleep( bReSpawnTime );
      PlaySound( RespawnSound );
      Sleep( Level.Game.PlaySpawnEffect(self) );
      GoToState( 'Pickup' );
}

defaultproperties
{
   bRespawnTime=1
   ShellSkin=None
   ExpireMessage="You are no longer invincible."
   bRotatingPickup=True
   PickupMessage="You are now invincible!"
   ItemName="Invincibility"
   PickupViewMesh=Mesh'oneupA'
   PickupViewScale=0.70
   Charge=120
   PickupSound=Sound'GoInvulnerable'
   ActivateSound=Sound'Botpack.Pickups.UTSuperHeal'
   DeActivateSound=Sound'UnrealI.Generic.Teleport1'
   Icon=Texture'InvulnerableTile'
   Mesh=Mesh'oneupA'
   bCollideWhenPlacing=True
   MultiSkins(0)=FireTexture'Belt_fx.ShieldBelt.BlueShield'
   MultiSkins(1)=Texture'kevlar'
   CollisionRadius=32.00
   CollisionHeight=40.00
   LightHue=185
   LightSaturation=0
   RotationRate=(Pitch=12250,Yaw=12000,Roll=12500),
}
