
class RelicStrengthInventory expands RelicInventory;

#exec TEXTURE IMPORT NAME=bicep FILE=Textures\bicep.bmp
#exec AUDIO IMPORT FILE="Sounds\StrengthUse.WAV" NAME="StrengthUse"

var float FireTime;
var TournamentWeapon StrengthWeapon;

function bool HandlePickupQuery( inventory Item )
{
   if (Item.IsA('UDamage'))
      return true;
   else
      return Super.HandlePickupQuery( Item );
}

function PickupFunction(Pawn Other)
{
   local Inventory I;

   Super.PickupFunction(Other);
   for ( I=Owner.Inventory; I!=None; I=I.Inventory )
   if ( I.IsA('UDamage') )
   {
      I.SetTimer(0.2, false);
      UDamage(I).FinalCount = 0;
   }
}

state Activated
{
   function BeginState()
   {
      Pawn(Owner).DamageScaling = 2.0;
      SetStrengthWeapon();
      Super.BeginState();
   }
   function EndState()
   {
      Pawn(Owner).DamageScaling = 1.0;
      if (  StrengthWeapon != None )
         StrengthWeapon.Affector = None;
      Super.EndState();
   }
}

function SetStrengthWeapon()
{
   if ( StrengthWeapon != None )
      StrengthWeapon.Affector = None;

   StrengthWeapon = TournamentWeapon(Pawn(Owner).Weapon);
   if ( StrengthWeapon != None )
      StrengthWeapon.Affector = self;
}

function ChangedWeapon()
{
   if( Inventory != None )
      Inventory.ChangedWeapon();
   SetStrengthWeapon();
}

simulated function FireEffect()
{
   SetLocation(Owner.Location);
   SetBase(Owner);
   PlaySound(sound'StrengthUse', SLOT_Interact, 6);
   PlaySound(sound'StrengthUse', SLOT_Interact, 6);
   FlashShell(0.15);
}

defaultproperties
{
   ShellSkin=None
   bRotatingPickup=True
   PickupMessage="Strength Relic: You do double damage!"
   PickupViewMesh=Mesh'oneupA'
   PickupViewScale=0.70
   PickupSound=Sound'GoRage'
   Icon=Texture'StrengthTile'
   MultiSkins(0)=FireTexture'Belt_fx.ShieldBelt.BlueShield'
   MultiSkins(1)=Texture'bicep'
   CollisionHeight=40.00
   LightHue=185
   LightSaturation=0
   RotationRate=(Pitch=12250,Yaw=12000,Roll=12500),
}
