
class ServerAdds expands Mutator config;

var bool bInitialized;

var globalconfig float fDelay; // delay between an message
var globalconfig string sLines[25]; // the lines
var globalconfig int iRepeat; // repeat messages X times
var globalconfig int iGroupSize; //size of the message groups
var globalconfig int iAddType; //type of advertisement
var globalconfig bool bDontWrapList; //when in grouped mode don't wrap to the top of the list
var globalconfig bool bEnabled;
var globalconfig color cAdminMessageColor; // (R=255,G=255,B=255,A=0)

// 0 = old skool
// 1 = cycle list (1 line at the time)
// 2 = cycle list with groups of messsage
// 3 = random message
// 4 = multiple random messages (iGroupSize number of message)
// 5 = random multiple messages (iGroupSize number of message)

var int iCurrentPos;
var int iGroupIndex;

const VERSION = "104";
const nLines = 25;

function PostBeginPlay()
{
   local int i,j;
   if (!bInitialized)
   {
      j = 0;
      bInitialized = true;
      log("[~] starting Server Advertisements version "$VERSION);
      for (i = 0; i < nLines; i++)
      {
         if (sLines[i] != "") j++;
      }
      log("[~] there are "$j$" lines in the list");
      iCurrentPos = 0;
      SetTimer(fDelay,true);
   }
}

function UpdateTimer()
{
   SetTimer(fDelay,true);
}

event BroadcastAdd( coerce string Msg, optional bool bBeep, optional name Type )
{
   local Pawn P;

   if (Type == '')
   Type = 'Event';

   if ( Level.Game.AllowsBroadcast(self, Len(Msg)) )
   {   
      for( P=Level.PawnList; P!=None; P=P.nextPawn )
      {   
         if (P.IsA('PlayerPawn'))
         {
            if (left(Msg,1) == "#")
            {
               if (iGroupIndex < 8)
               {
                  if (iGroupIndex == 0) PlayerPawn(P).ClearProgressMessages();
       		     PlayerPawn(P).SetProgressMessage(Mid(Msg,1),iGroupIndex);
                  PlayerPawn(P).SetProgressColor(cAdminMessageColor,iGroupIndex);
                  PlayerPawn(P).SetProgressTime(6);
               }
            }
            else
            {
               P.ClientMessage( Msg, Type, bBeep );
            }
         }
      }
   }
}

event Timer()
{
   local int i;
   local int j;

   if (!bEnabled) return;

   if (iAddType == 0) // old skool
   {
      for (i=0; i<iRepeat; i++)
      {
         for (j=0; j<nLines; j++)
         {
            if (sLines[j] != "") BroadcastAdd(sLines[j]);
         }
      }
   }
   else if (iAddType == 1) //plain cycle
   {
      for (i=0; i<iRepeat; i++)
      {
         while (sLines[iCurrentPos] == "")
         {
            iCurrentPos = iCurrentPos+1;
            if (iCurrentPos >= nLines)
            {
               iCurrentPos = 0;
            }
         }
         BroadcastAdd(sLines[iCurrentPos]);
         iCurrentPos = iCurrentPos+1;
      }
   }
   else if (iAddType == 2) //plain cycle w/ groups
   {
      for (i=0; i<iRepeat; i++)
      {
         for (j=0; j<iGroupSize; j++)
         {
            while (sLines[iCurrentPos] == "")
            {
               iCurrentPos = iCurrentPos+1;
               if (iCurrentPos >= nLines)
               {
                  iCurrentPos = 0;
                  if (bDontWrapList) return;
               }
            }
            iGroupIndex = j;
            BroadcastAdd(sLines[iCurrentPos]);
            iCurrentPos = iCurrentPos+1;
         }
      }
   }
   else if (iAddType == 3) //random msg
   {
      for (i=0; i<iRepeat; i++)
      {
         iCurrentPos = rand(nLines);
         while (sLines[iCurrentPos] == "") iCurrentPos = rand(nLines);
       	    BroadcastAdd(sLines[iCurrentPos]);
      }
   }
   else if (iAddType == 4) //mutiple random msgs (iGroupSize) number of message
   {
      for (i=0; i<iRepeat; i++)
      {
         for (j=0; j<iGroupSize; j++)
         {
            iCurrentPos = rand(nLines);
            while (sLines[iCurrentPos] == "") iCurrentPos = rand(nLines);
               iGroupIndex = j;
            BroadcastAdd(sLines[iCurrentPos]);
         }
      }
   }
   else if (iAddType == 5) //random multiple msgs (iGroupSize) number of message
   {
      for (i=0; i<iRepeat; i++)
      {
         iCurrentPos = rand(nLines);
         while (sLines[iCurrentPos] == "") iCurrentPos = rand(nLines);
            for (j=0; j<iGroupSize; j++)
            {
               while (sLines[iCurrentPos] == "")
               {
                  iCurrentPos = iCurrentPos+1;
                  if (iCurrentPos >= nLines)
                  {
                     iCurrentPos = 0;
                     if (bDontWrapList) return;
                  }
               }
               iGroupIndex = j;
               BroadcastAdd(sLines[iCurrentPos]);
               iCurrentPos = iCurrentPos+1;
            }
      }
   }
}


defaultproperties
{
   fDelay=300.00
   sLines(0)="Server Advertisement script is not setup correctly"
   sLines(1)="Please contact the server admin to correct this"
   iRepeat=1
   iGroupSize=1
   bEnabled=True
   cAdminMessageColor=(R=255,G=255,B=255,A=0),
}
