
class ShutUp extends UTServerAdminSpectator config(MonsterHunt2Gold);

var int NumMsg[63]; // Contains the amount of voice messages sent by each player in the game (corresponding to their PlayerID) -- NOTE: max limit is 63, otherwise compiler quits with error: "Variable is too large (256 bytes, 255 max)" when trying to access this array from S2
var string BlockIP[63]; // Contains the IP addresses of players that are blocked from sending voice messages (if bReinforce=True)
var config int MaxMsg; // After how many messages should the player be blocked from sending messages?
var config bool bReinforce; // Whether we should reinforce the voice block if the offending player rejoins the current match
var config bool bPlayerMsg; // Wheter we should inform the player when the voice block takes effect
var config string MsgToPlayer; // Message to send if bPlayerMsg=True
var config bool bBroadcast; // Whether we should tell other players this player is now muted (NOT if bDisableTaunts is active -it would defy the purpose- AND NOT on rejoins)
var config string MsgToBroadcast; // Message to broadcast to other players if bBroadcast=True
var config bool bTeamGames; // True if we should also count team messages
var config bool bDisableTaunts; // True to disable taunts altogether (we should set the VoiceType to none for every player in the game)

function PostBeginPlay()
{
   local pawn p;
   local UTServerAdminSpectator2 S2;

   Self.PlayerReplicationInfo.bIsSpectator=true;
   Self.bIsPlayer=false;
   if(bBroadcast) if(InStr(MsgToBroadcast,"%Player%") == -1) MsgToBroadcast="The voice message capabilities of %Player% have been revoked.";
   if(bReinforce || bDisableTaunts) SetTimer(2.0,true);
   if(Level.Game.bTeamGame && bTeamGames && !bDisableTaunts)
   {
      S2 = Spawn(class 'UTServerAdminSpectator2');
      Self.PlayerReplicationInfo.Team=0;
   }
}

function Timer()
{
   local int i;
   local pawn p;

   for (p=Level.PawnList; p!=None; p=p.NextPawn)
   if(p.IsA('PlayerPawn') && !p.IsA('Spectator'))
   if(bDisableTaunts)
   {
      if(p.PlayerReplicationInfo.VoiceType!=none)
      {
         p.PlayerReplicationInfo.VoiceType=none; // Taunts are disabled in whole
         if(bPlayerMsg) DoMsg(p);
      }
   }
   else
   {
      for(i=0; i<64 && BlockIP[i]!=""; i++)
      if(p.PlayerReplicationInfo.VoiceType!=none && BlockIP[i]==IP(PlayerPawn(p)))
      {
         p.PlayerReplicationInfo.VoiceType=none;
         if(bPlayerMsg) DoMsg(p);
      }
   }
}

function ClientVoiceMessage(PlayerReplicationInfo Sender, PlayerReplicationInfo Recipient, name messagetype, byte messageID)
{
   local pawn p;
   local int i;

   if(string(messagetype)~="AUTOTAUNT") return;

   for (p=Level.PawnList; p!=None; p=p.NextPawn)
   if((p.IsA('PlayerPawn') && !p.IsA('Spectator') || p.IsA('Bot')) && p.PlayerReplicationInfo.PlayerID==Sender.PlayerID) break;
   if(p.IsA('Bot')) return;
   NumMsg[Sender.PlayerID]++;
   if(NumMsg[Sender.PlayerID]==MaxMsg)
   {
      p.PlayerReplicationInfo.VoiceType=none;
      if(bPlayerMsg) DoMsg(p);
      if(bBroadcast) DoMsg(p,true);
      if(!bReinforce) return;
      for(i=0; i<64; i++)
      if(BlockIP[i]=="")
      {
         BlockIP[i]=IP(PlayerPawn(p));
         break;
      }
   }
}

function DoMsg(pawn badPlayer, optional bool bB)
{
   local pawn p;
   local string tmpMsg;

   if(bB)
   {
      tmpMsg=MsgToBroadcast;
      ReplaceText(tmpMsg, "%Player%", badPlayer.PlayerReplicationInfo.Playername);
      for (p=Level.PawnList; p!=None; p=p.NextPawn)
      if(p.IsA('PlayerPawn') && p!=badPlayer)
      p.ClientMessage(tmpMsg);
   }
   else
   {
      badPlayer.ClientMessage(MsgToPlayer);
   }
}

function string IP(PlayerPawn p)
{
   local int i;
   local string IP;

   IP = p.GetPlayerNetworkAddress();
   i = InStr(IP, ":");
   if (i != -1)
      IP = Left(IP, i);
   return IP;
}

defaultproperties
{
   MaxMsg=20
   bReinforce=True
   bPlayerMsg=True
   MsgToPlayer="You have reached the maximum amount of taunts allowed for this match."
   bBroadcast=True
   MsgToBroadcast="The voice message capabilities of %Player% have been revoked."
   bTeamGames=True
   bDisableTaunts=False
}