
class WebAdmin expands WebApplication config;

var globalconfig string AdminRealm;
var globalconfig string AdminUsername;
var globalconfig string AdminPassword;

var ServerAdds ServerAddsA;
var int iEmptyIndex;

event Init()
{
   Super.Init();
   GetServerAddsA();
}

function GetServerAddsA()
{
   local ServerAdds A;
   foreach Level.AllActors( class'ServerAdds', A )
   {
      if (String(A.Class) == "MonsterHunt2GoldCE.ServerAdds")
      {
         ServerAddsA = A;
         Log("[~] ServerAdds actor found");
      }
   }
   if (ServerAddsA == none) Log("[E] ServerAdds actor NOT found !");
}

function FillMessageList(WebResponse Response)
{
   local int i;
   for (i = 0; i < ServerAddsA.nLines; i++)
   {
      if (ServerAddsA.sLines[i] != "")
      {
         Response.SendText("<option value=\""$string(i)$"\">["$string(i)$"] = "$ServerAddsA.sLines[i]$"</option>");
      }
      else if (iEmptyIndex == 255) iEmptyIndex = i;
   }
}

function configUpdate(WebRequest Request, WebResponse Response)
{
   if (ServerAddsA.fDelay != float(Request.GetVariable("fDelay")))
   {
      ServerAddsA.fDelay = float(Request.GetVariable("fDelay"));
      ServerAddsA.UpdateTimer();
   }
   ServerAddsA.iRepeat = int(Request.GetVariable("iRepeat"));
   ServerAddsA.iGroupSize = int(Request.GetVariable("iGroupSize"));
   ServerAddsA.bDontWrapList = (caps(Request.GetVariable("bDontWrapList")) == "TRUE");
   ServerAddsA.iAddType = int(Request.GetVariable("iAddType"));
   ServerAddsA.bEnabled = (caps(Request.GetVariable("bEnabled")) == "TRUE");
   ServerAddsA.StaticSaveConfig();
   ServerAddsA.SaveConfig();
}

function configDelete(WebRequest Request, WebResponse Response)
{
   local string tmp;
   local int index,i;

   tmp = Request.GetVariable("sLines");
   if (tmp == "") return;
   index = int(tmp);

   for (i = index; i < (ServerAddsA.nLines-1); i++)
   {
      ServerAddsA.sLines[i] = ServerAddsA.sLines[i+1];
   }
   ServerAddsA.StaticSaveConfig();
   ServerAddsA.SaveConfig();
}

function configAdd(WebRequest Request, WebResponse Response)
{
   local string tmp;
   local int index,i;

   tmp = Request.GetVariable("iInsertIndex");
   if (tmp == "") return;
   index = int(tmp);
   if ((index >= 25) || (index < 0)) return;

   for (i = (ServerAddsA.nLines-2); i > (index-1); i--)
   {
      ServerAddsA.sLines[i+1] = ServerAddsA.sLines[i];
   }
   ServerAddsA.sLines[index] = Request.GetVariable("sNewLine");
   ServerAddsA.StaticSaveConfig();
   ServerAddsA.SaveConfig();
}

event Query(WebRequest Request, WebResponse Response)
{
   local string sUpdate, sDelete, sAdd;

   if ((AdminUsername != "" && Caps(Request.Username) != Caps(AdminUsername)) || (AdminPassword != "" && Caps(Request.Password) != Caps(AdminPassword))) 
   {
      Response.FailAuthentication(AdminRealm);
      return;
   }
   if (ServerAddsA != none)
   {
      iEmptyIndex = 255;
      sUpdate = Request.GetVariable("Update");
      sDelete = Request.GetVariable("Delete");
      sAdd = Request.GetVariable("Add");
      if (caps(sUpdate) == "UPDATE") configUpdate( Request,  Response);
      if (caps(sDelete) == "DELETE") configDelete( Request,  Response);
      if (caps(sAdd) == "ADD") configAdd( Request,  Response);
      Response.SendText("<HTML><head><title>ServerAdds WebAdmin</title><META http-equiv=\"Cache-Control\" content=\"no-cache, must-revalidate\"><META http-equiv=\"Pragma\" content=\"no-cache\"></head>");
      Response.SendText("<body bgcolor=\"Black\" text=\"Silver\" link=\"33cc66\" vlink=\"33cc66\"><form method=\"post\">");
      Response.SendText("<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" align=\"center\" bgcolor=\"#408080\"><tr><td>");
      Response.SendText("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" bgcolor=\"#000000\">");
      Response.SendText("<tr><td colspan=\"2\" align=\"center\" bgcolor=\"#306060\"><b><i><font face=\"Arial\" size=\"+2\">Server Adds WebAdmin</font></i></b></td></tr>");
      Response.SendText("<tr><td align=\"right\"><font face=\"Arial\">&nbsp;&nbsp;fDelay&nbsp;:&nbsp;</font></td>");
      Response.SendText("<td><font face=\"Arial\"><input type=\"text\" name=\"fDelay\" value=\""$string(ServerAddsA.fDelay)$"\">&nbsp;&nbsp;</font></td>");
      Response.SendText("</tr><tr><td align=\"right\"><font face=\"Arial\">&nbsp;&nbsp;iRepeat&nbsp;:&nbsp;</font></td>");
      Response.SendText("<td><font face=\"Arial\"><input type=\"text\" name=\"iRepeat\" value=\""$string(ServerAddsA.iRepeat)$"\">&nbsp;&nbsp;</font></td>");
      Response.SendText("</tr><tr><td align=\"right\"><font face=\"Arial\">&nbsp;&nbsp;iGroupSize&nbsp;:&nbsp;</font></td>");
      Response.SendText("<td><font face=\"Arial\"><input type=\"text\" name=\"iGroupSize\" value=\""$string(ServerAddsA.iGroupSize)$"\">&nbsp;&nbsp;</font></td>");
      Response.SendText("</tr><tr><td align=\"right\"><font face=\"Arial\">&nbsp;&nbsp;bDontWrapList&nbsp;:&nbsp;</font></td>");
      Response.SendText("<td><font face=\"Arial\"><input type=\"checkbox\" name=\"bDontWrapList\" value=\"True\" ");
      if (ServerAddsA.bDontWrapList) Response.SendText("CHECKED");
      Response.SendText(">&nbsp;&nbsp;</font></td>");
      Response.SendText("</tr><tr><td align=\"right\"><font face=\"Arial\">&nbsp;&nbsp;iAddType&nbsp;:&nbsp;</font></td>");
      Response.SendText("<td><font face=\"Arial\"><select name=\"iAddType\">");
      Response.SendText("<option value=\"0\" ");
      if (ServerAddsA.iAddType == 0) Response.SendText("SELECTED");
      Response.SendText(">Old Skool</option>");
      Response.SendText("<option value=\"1\" ");
      if (ServerAddsA.iAddType == 1) Response.SendText("SELECTED");
      Response.SendText(">Cycle list</option>");
      Response.SendText("<option value=\"2\" ");
      if (ServerAddsA.iAddType == 2) Response.SendText("SELECTED");
      Response.SendText(">Cycle list with groups</option>");
      Response.SendText("<option value=\"3\" ");
      if (ServerAddsA.iAddType == 3) Response.SendText("SELECTED");
      Response.SendText(">Random message</option>");
      Response.SendText("<option value=\"4\" ");
      if (ServerAddsA.iAddType == 4) Response.SendText("SELECTED");
      Response.SendText(">Multiple random messages</option>");
      Response.SendText("<option value=\"5\" ");
      if (ServerAddsA.iAddType == 5) Response.SendText("SELECTED");
      Response.SendText(">Random multiple messages</option>");
      Response.SendText("</select>&nbsp;&nbsp;</font></td>");
      Response.SendText("</tr><tr><td align=\"right\"><font face=\"Arial\">&nbsp;&nbsp;bEnabled&nbsp;:&nbsp;</font></td>");
      Response.SendText("<td><font face=\"Arial\"><input type=\"checkbox\" name=\"bEnabled\" value=\"True\" ");
      if (ServerAddsA.bEnabled) Response.SendText("CHECKED");
      Response.SendText(">&nbsp;&nbsp;</font></td>");
      Response.SendText("</tr><tr><td colspan=\"2\" align=\"center\"><font face=\"Arial\" size=\"-2\">&nbsp;</font></td>");
      Response.SendText("</tr><tr><td colspan=\"2\" align=\"center\" bgcolor=\"#003030\"><font face=\"Arial\"><input type=\"submit\" name=\"Update\" value=\"Update\"></font></td>");
      Response.SendText("</tr><tr><td colspan=\"2\" align=\"center\"><font face=\"Arial\" size=\"-2\">&nbsp;</font></td>");
      Response.SendText("</tr><tr><td colspan=\"2\" align=\"center\" bgcolor=\"#306060\"><b><i><font face=\"Arial\" size=\"+1\">sLines[]</font></i></b></td>");
      Response.SendText("</tr><tr><td colspan=\"2\" align=\"center\"><font face=\"Arial\">&nbsp;&nbsp;<select name=\"sLines\" size=\"10\">");
      FillMessageList(Response);
      Response.SendText("</select>&nbsp;&nbsp;</font></td>");
      Response.SendText("</tr><tr><td colspan=\"2\" align=\"center\"><font face=\"Arial\">&nbsp;&nbsp;[<input type=\"text\" name=\"iInsertIndex\" size=\"1\" value=\""$string(iEmptyIndex)$"\">] = <input type=\"text\" name=\"sNewLine\" size=\"40\">&nbsp;&nbsp;</font></td>");
      Response.SendText("</tr><tr><td colspan=\"2\" align=\"center\"><font face=\"Arial\" size=\"-2\">&nbsp;</font></td>");
      Response.SendText("</tr><tr><td colspan=\"2\" align=\"center\" bgcolor=\"#003030\"><font face=\"Arial\"><input type=\"submit\" name=\"Delete\" value=\"Delete\"><font face=\"Arial\"><input type=\"submit\" name=\"Add\" value=\"Add\"></font></td>");
      Response.SendText("</tr><tr><td colspan=\"2\" align=\"center\"><font face=\"Arial\" size=\"-2\">&nbsp;</font></td>");
      Response.SendText("</tr><tr><td colspan=\"2\" align=\"center\" bgcolor=\"#306060\"><b><i><font face=\"Arial\">Version ");
      Response.SendText(ServerAddsA.VERSION);
      Response.SendText("- Build by <a href=\"mailto:thekiller@cyberjunie.com\">El Muerte [TDS]</a></font></i></b></td>");
      Response.SendText("</tr></table></td></tr></table></form>");
      Response.SendText("</body></HTML>");
   }
   else
   {
      Response.SendText("<html><body><B>ERROR : ServerAdds actor not found, did you install it correctly ?</B></html></body>");
   }
}

defaultproperties
{
   AdminRealm="ServerAdds admin"
}