
class WickedProj expands Projectile;

var Actor Seeking;
var float MagnitudeVel, Count, SmokeRate;
var vector InitialDir;
var bool bRing, bHitWater, bWaterStart;
var int NumExtraRockets;

simulated function PostBeginPlay()
{
   Count = -0.1;
   if (Level.bHighDetailMode) SmokeRate = 0.035;
   else SmokeRate = 0.15;
}

simulated function Tick(float DeltaTime)
{
   local SpriteBallExplosion b;

   if (bHitWater)
   {
      Disable('Tick');
      Return;
   }
   Count += DeltaTime;
   if ( (Count>(SmokeRate+FRand()*(SmokeRate+NumExtraRockets*0.035))) && (Level.NetMode!=NM_DedicatedServer) )
   {
      b = Spawn(class'SpriteBallExplosion');
      b.RemoteRole = ROLE_None;
      Count=0.0;
   }
}

auto state Flying
{
   simulated function ZoneChange( Zoneinfo NewZone )
   {
      local MysticExplo4 w;

      if (!NewZone.bWaterZone || bHitWater) Return;

      bHitWater = True;
      Disable('Tick');
      if ( Level.NetMode != NM_DedicatedServer )
      {
         w = Spawn(class'MysticExplo4',,,,rot(16384,0,0));
	 w.DrawScale = 0.2;
	 w.RemoteRole = ROLE_None;
	 PlayAnim( 'All', 3.0 );
      }
      Velocity=0.6*Velocity;
   }

   simulated function ProcessTouch (Actor Other, Vector HitLocation)
   {
      if ((Other != instigator) && (Rocket(Other) == none))
         Explode(HitLocation,Normal(HitLocation-Other.Location));
   }
   function BlowUp(vector HitLocation, RingExplosion r)
   {
      if ( Level.Game.IsA('DeathMatchGame') ) //bigger damage radius
	  HurtRadius(0.9 * Damage,300.0, 'exploded', MomentumTransfer, HitLocation );
      else HurtRadius(Damage,300.0, 'exploded', MomentumTransfer, HitLocation );
      MakeNoise(1.0);

      if ( r != None )
         r.PlaySound(r.ExploSound,,6);
   }
   simulated function Explode(vector HitLocation, vector HitNormal)
   {
      local RingExplosion3 s;
      local RingExplosion3 r;

      s = spawn(class'RingExplosion3',,,HitLocation + HitNormal*16);
      s.RemoteRole = ROLE_None;

      if (bRing)
      {
         r = Spawn(class'RingExplosion3',,,HitLocation + HitNormal*16,rotator(HitNormal));
         r.RemoteRole = ROLE_None;
      }
      BlowUp(HitLocation, r);
      Destroy();
   }
   function BeginState()
   {
      initialDir = vector(Rotation);
      if ( Role == ROLE_Authority )
	  Velocity = speed*initialDir;
      Acceleration = initialDir*50;
      PlaySound(SpawnSound, SLOT_None, 2.3);
      PlayAnim( 'All', 0.2 );
      if (Region.Zone.bWaterZone)
      {
         bHitWater = True;
	 Velocity=0.6*Velocity;
      }
   }
}

defaultproperties
{
   speed=1100.000000
   MaxSpeed=1700.000000
   Damage=499.000000
   MomentumTransfer=80000
   RemoteRole=ROLE_SimulatedProxy
   Style=STY_Translucent
   Texture=FireTexture'UnrealShare.SEffect1.Smoke1'
   Mesh=LodMesh'UnrealI.FlakSh'
   bMeshEnviroMap=True
}
