class ExDeadBodySwarm extends Pawn;

var()	byte	swarmsize; //number of horseflies in swarm
var		byte	totalflies;
var()   bool	bOnlyIfEnemy;
var()	float	swarmradius;

function PreBeginPlay()
{
	totalflies = swarmsize;
	Super.PreBeginPlay();
}

singular function ZoneChange( ZoneInfo NewZone )
{
	if (NewZone.bWaterZone /* || NewZone.bPainZone */)
	{
		SetLocation(OldLocation);
		Velocity = vect(0,0,0);
		Acceleration = vect(0,0,0);
		MoveTimer = -1.0;
		Enemy = None;
	}
}

function SpawnFlies()
{
	while (swarmsize > 0)
	{
		swarmsize--;
		spawn(class 'horsefly',self,'', Location + VRand() * CollisionRadius);
	}
}


function bool EncroachingOn( actor Other )
{
	if ( (Other.Brush != None) || (Brush(Other) != None) )
		return true;

	return false;
}

event FootZoneChange(ZoneInfo newFootZone)
{
}

function EncroachedBy( actor Other )
{
}

function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
}

function BaseChange()
{
}

auto state buzzing
{
ignores EnemyNotVisible;

	function SpawnFly()
	{
		if ( swarmsize > 0 )
		{
			swarmsize--;
			spawn(class 'horsefly',self,'', Location + VRand() * CollisionRadius);
		}
		if ( swarmsize > 0 )
			SetTimer(5.0 * FRand(), false);
	}

	function Timer()
	{
		SpawnFly();
	}

	function SeePlayer(Actor SeenPlayer)
	{
		SpawnFly();
		Disable('SeePlayer');
	}
}

auto state stasis
{
ignores EncroachedBy;
	
	function SeePlayer(Actor SeenPlayer)
	{
		enemy = Pawn(SeenPlayer);
		SpawnFlies();
		Gotostate('wandering');
	}

Begin:
	SetPhysics(PHYS_None);
}		

state wandering
{
ignores EncroachedBy;

	function SeePlayer(Actor SeenPlayer)
	{
		local actor newfly;
		Enemy = Pawn(SeenPlayer);
		SpawnFlies();
		Disable('SeePlayer');
		Enable('EnemyNotVisible');
	}

	function EnemyNotVisible()
	{
		Enemy = None;
		Disable('EnemyNotVisible');
	}
	
Begin:
	SetPhysics(PHYS_Flying);

Wander:
	if (Enemy == None)
		Enable('SeePlayer');
		
	if ( (Enemy != None) && !Enemy.Region.Zone.bWaterZone  && !Enemy.Region.Zone.bPainZone )
	{
		MoveToward(Enemy);
		sleep(2 * FRand());
	}	
	else
	{
		Destination = Location + VRand() * 1000;
		Destination.Z = 0.5 * (Destination.Z + Location.Z);
		MoveTo(Destination);
	}
	Goto('Wander');
}

defaultproperties
{
   bOnlyIfEnemy=False
   bForceStasis=True
   bCollideActors=False
   bBlockActors=False
   bBlockPlayers=False
   bProjTarget=False
   Mass=5.000000
   Buoyancy=5.000000
   swarmsize=20
   swarmradius=120.000000
   GroundSpeed=200.000000
   AirSpeed=200.000000
   JumpZ=-1.000000
   SightRadius=2000.000000
   PeripheralVision=-5.000000
   bHidden=True
}