
class MH2Base expands Mutator config(MonsterHunt2Lite);

#exec AUDIO IMPORT FILE="Sounds\HitsoundEnemy.wav" NAME="HitsoundEnemy" GROUP="QFeedback"
#exec AUDIO IMPORT FILE="Sounds\QFeedbackArmourWav.wav" NAME="QFeedbackArmourWav" GROUP="QFeedback"
#exec AUDIO IMPORT FILE="Sounds\HitsoundTeam.wav" NAME="HitsoundTeam" GROUP="QFeedback"

//Setup
var bool Initialized;
var int AmpCount;
var int kakuCount;
var int HealthCount;
var bool bFirstBlood;
var config String bServerInfo;
var config bool AdjustFactories;
var config int bCapacity;
var DeathMatchPlus MyGame;

//Awards
var config int AmpSpawnTime;
var config int DeemerSpawnTime;
var config int HealthAwardTime;
var config bool bGiveArmor;

//Weapons and Ammo
var config bool bUseRandomWeapon;
var config bool bUseRegenAmmo;
var config int AmmoInterval;
var config bool GiveAllWeapons;

//Health regen
var config int DefaultHealth;
var config int HealthRegenPerSec;
var config int MaxHealth;
var config bool bUseRegenHealth;
var config int MaxRegenHealth;
var config int HealthRegenPerKill;

//Admin options and various settings
var config bool bUseAntiBoost;
var config bool bHitsounds;
var config bool bAltScoring;
var config bool stopPlayerCollision;
var config bool ReplaceInvis;
var config float HitVolume;
var config bool VisibleMonsterEnds;
var config float retainScoreOnDeathPercent;
var config bool UseMHTranslocator;
var config bool UseLimeLight;
var config bool UseMH2JumpBoots;
var config int MaxDamage;

//Mutate commands
var config string CommandOpen;
var config string CommandClose;

var String MH2NaliFruit;
var String MH2MedBox;
var String MH2HealthPack;
var String MH2UnrealHealth;
var String MH2HealthVial;
var String MH2ShieldBelt;
var String MH2UDamage;
var String MH2JumpBoots;

//Double Jump
var config bool DoubleJump;
var config int maxJumps;
var config int jumpType;
var config float jumpHeight;

//Spawn protection
var() globalconfig bool bUseSpawnProt;
var() globalconfig int SpawnProtDuration;

//Mover fix
var config bool bFixCrushingMover;

function PreBeginPlay()
{
   local ThingFactory Thfa;
   local CreatureFactory CF;
   local CTFFlag Flag;
   local ScriptedPawn S;
   local LevelInfo LI;
   local TranslatorEvent TE;
   local GoTranslatorMark ex;

   if ( Initialized )
      return;

   Super.PreBeginPlay();

   foreach AllActors (class 'ScriptedPawn', S)
   {
      if ( S != None )
      {
   	 	if (S.Orders == 'Roaming')
   	 	{
   	    	S.Orders = '';
   	    	S.GoToState('Waiting');
   	 	}
   	}
   }

   foreach AllActors (class 'ThingFactory', Thfa)
   {
   	if (Thfa != None)
      {
   	  	Thfa.bCovert = False; //:P No bullshit check
      	if (Thfa.interval < 0.3)
   	  		{
   	   		Thfa.interval = 0.3;
   	  		}
      }
      if (Thfa.prototype == class 'BiterFishSchool')
      {
   	  	Thfa.prototype = class 'UnrealI.Pupae';
      }
      if (Thfa.prototype == class 'Bird1')
      {
   	  	Thfa.prototype = class 'MonsterHunt2Lite.Bird2';
      }
   }

   foreach AllActors (class 'CreatureFactory', CF)
   {
   	if ( CF != None )
   	{
   		if (CF.Orders == 'Roaming')
   		{
   			CF.Orders = 'Attacking';
   		}
   		CF.AddedCoopCapacity = 0;
   	}
	}
		
	foreach AllActors(class 'CTFFlag', Flag)
	{
		if (flag != none)
		{
			Flag.Destroy();
		}
	}
		
	foreach AllActors(class 'ScriptedPawn', S)
	{
		if (S != None)
		{
			if (S.DrawScale > 4)
				S.DrawScale = 4;
			if (S.DrawScale < 0.3)
				S.DrawScale = 0.3;
		}
	}
	
	foreach AllActors(class'TranslatorEvent', TE)
   {
      if(TE !=none)
      {
         TE.bHidden=False;
         TE.DrawType=DT_Mesh;
         TE.Mesh=Mesh'MonsterHunt2Lite.SV_Invincible';
         TE.bFixedRotationDir=True;
         TE.SetPhysics(PHYS_Rotating);
         TE.RotationRate.Yaw=6000;
         TE.Velocity.Z=6000;
      }   
   }

   if ( NextMutator != None )
      NextMutator.PreBeginPlay();
}

function PostBeginPlay()
{
   local string newhud;
   local class newclass;
   local NavigationPoint NP;
   local MonsterEnd ME;
   local ScriptedPawn S;
   local MonsterWaypoint MW;

   if (Initialized)
      return;
      
   SaveConfig();

   Log("*** MonsterHunt2Lite Gametype and Mutator is loaded ");

   Initialized = True;
   kakuCount = 0;
   HealthCount = 0;

   if(DefaultHealth < 1)
      DefaultHealth = 100;

   SetTimer(1, True);

   if(Level.Game.HUDType !=none)
      Level.Game.HUDType = class'MH2HUD';

   if(Level.Game.ScoreBoardType !=none)
   	Level.Game.ScoreBoardType=Class'MH2ScoreBoard';


   Level.Game.RegisterDamageMutator(Spawn(class'SpawnProt'));
   Level.Game.RegisterDamageMutator(Self);

   TournamentGameInfo(Level.Game).GameName = bServerInfo;

   fixmover();
   
   SetUpCurrent();

   if(VisibleMonsterEnds) fixmymonsterend();

   if(AdjustFactories) CheckFactories();

   foreach AllActors(class'MonsterWaypoint', MW)
      MW.Destroy();

   if ( NextMutator != None )
      NextMutator.PostBeginPlay();
      
   MyGame = DeathMatchPlus(Level.Game);
		Super.PostBeginPlay();
}

function SetUpCurrent()
{
	spawn(class'PawnNotify');
}


function CheckFactories()
{
   local CreatureFactory C;
   local ThingFactory T;

   foreach AllActors( class 'CreatureFactory', C)
   {
      if(C !=none)
      {
         if(C.Capacity < 0)
            C.Capacity=bCapacity;
         else if (C.Capacity > bCapacity)
            C.Capacity=bCapacity;
         if(C.bCovert==True)
            C.bCovert=False;
      }
   }
   foreach AllActors( class 'ThingFactory', T)
   {
      if(T !=none)
      {
         if(T.Capacity < 0)
            T.Capacity=bCapacity;
         else if (T.Capacity > bCapacity)
            T.Capacity=bCapacity;
         if(T.bCovert==True)
            T.bCovert=False;
      }
   }
}

function fixmover()
{
   local mover M;
   foreach AllActors( class 'Mover', M)
   {
      if(bFixCrushingMover)
      {
         if(M.bTriggerOnceOnly && M.MoverEncroachType == ME_ReturnWhenEncroach)
	    		M.MoverEncroachType = ME_IgnoreWhenEncroach;
      }
      if(M.bUseTriggered == True)
	 		M.bUseTriggered = False;
   }
}

function fixmymonsterend()
{
   local MonsterEnd T;

   foreach AllActors( class 'MonsterEnd', T)
   {
      if(T.bHidden == True)
         T.bHidden = False;
   }
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local Inventory Inv;
	local Weapon W;

   if (Other.isA('Weapon') && Other.Instigator != None && Other.Instigator.IsA('ScriptedPawn'))
   {
      return true;
   }
   if(Other.IsA('Pickup'))
   {
      Pickup(Other).bAutoActivate=True;
   }
   if (Other.Class == Class 'Bird1')
   {
   	ReplaceWithOther(Other,"MonsterHunt2Lite.Bird2");
   	return False;
   }
   if(Other.Class==Class'NaliFruit')
   {
      ReplaceWith(Other,MH2NaliFruit);
      return false;
   }
   if(Other.Class==Class'Bandages')
   {
      ReplaceWith(Other,"MonsterHunt2Lite.MH2Bandages");
      return false;
   }
   if(Other.Class==Class'Health')
   {
      ReplaceWith(Other,"MonsterHunt2Lite.MH2U1Health");
      return false;
   }
   if(Other.Class==Class'SuperHealth')
   {
      ReplaceWith(Other,"MonsterHunt2Lite.MH2SuperHealth");
      return false;
   }
   if(Other.Class==Class'MedBox')
   {
      ReplaceWith(Other,MH2MedBox);
      return false;
   }
   if(Other.Class==Class'HealthPack')
   {
      ReplaceWith(Other,MH2HealthPack);
      return false;
   }
   if(Other.Class==Class'HealthVial')
   {
      ReplaceWith(Other,MH2HealthVial);
      return false;
   }
   if(Other.Class==Class'ShieldBelt')
   {
      ReplaceWith(Other,"MonsterHunt2Lite.MH2U1ShieldBelt");
      return false;
   }
   if(Other.Class==Class'PowerShield')
   {
      ReplaceWith(Other,"MonsterHunt2Lite.MH2U1ShieldBelt");
      return false;
   }
   if(Other.Class==Class'UT_ShieldBelt')
   {
      ReplaceWith(Other,"MonsterHunt2Lite.MH2ShieldBelt");
      return false;
   }
   if(Other.Class==Class'ThighPads')
   {
      ReplaceWith(Other,"MonsterHunt2Lite.MH2ThighPads");
      return false;
   }
   if(Other.Class==Class'Armor2')
   {
      ReplaceWith(Other,"MonsterHunt2Lite.MH2Armor2");
      return false;
   }
   if(UseLimeLight)
   {
      if(Other.IsA('Flashlight') && !Other.IsA('LimeLight'))
      {
         ReplaceWith(Other,"MonsterHunt2Lite.LimeLight");
	 		return false;
      }
   }
   if(UseMH2JumpBoots)
   {
      if(Other.IsA('JumpBoots') && !Other.IsA('MH2JumpBoots'))
      {
      	 ReplaceWith(Other,"MonsterHunt2Lite.MH2JumpBoots");
         return false;
      }
   }
   if(Other.IsA('UT_JumpBoots') && !Other.IsA('MH2JumpBoots'))
   {
      if(InStr ( Level.Title, "Andromeda" ) == -1)  //Stupid hack to let the people play with the everlasting jump boots
      {
         ReplaceWith(Other,"MonsterHunt2Lite.MH2JumpBoots");
         return false;
      }
   }
   if(ReplaceInvis)
   {
      if(Other.Class==Class'Invisibility')
      {
         ReplaceWith(Other,MH2MedBox);
         return false;
      }
   }
   if(Other.Class==Class'SCUBAgear')
   {
      ReplaceWith(Other,"MonsterHunt2Lite.MH2Scuba");
      return false;
   }
   if (Other.Class==Class'BiterFishSchool')
   {
      ReplaceWith(Other,"MonsterHunt2Lite.MH2BiterFishSchool");
      return False;
   }
   if(Other.Class==Class'QuadShot') //Quad has buggy graphics
   {
      ReplaceWith(Other,"Botpack.UT_FlakCannon");
      return false;
   }

   if ( Other.IsA('Weapon') )
   {
      if ( Other.IsA('TournamentWeapon') )
      	return true;
      if ( Other.IsA('UIWeapon') )
      	return true;
      if(Other.Class==Class'Stinger')
      {
         ReplaceWith(Other, "MonsterHunt.OLStinger");
         return false;
      }
      if(Other.Class==Class'Rifle')
      {
         ReplaceWith( Other, "MonsterHunt.OLRifle" );
         Return false;
      }
      if(Other.Class==Class'Razorjack')
      {
         ReplaceWith(Other, "MonsterHunt.OLRazorjack");
         Return false;
      }
      if(Other.Class==Class'Minigun')
      {
         ReplaceWith( Other, "MonsterHunt.OLMinigun" );
         return false;
      }
      if(Other.Class==Class'AutoMag')
      {
         ReplaceWith( Other, "MonsterHunt.OLAutoMag" );
         return false;
      }
      if(Other.Class==Class'Eightball')
      {
         ReplaceWith( Other, "MonsterHunt.OLEightball" );
         return false;
      }
      if(Other.Class==Class'FlakCannon')
      {
         ReplaceWith( Other, "MonsterHunt.OLFlakCannon" );
         return false;
      }
      if(Other.Class==Class'ASMD')
      {
         ReplaceWith( Other, "MonsterHunt.OLASMD" );
         return false;
      }
      if(Other.Class==Class'GesBioRifle')
      {
         ReplaceWith( Other, "MonsterHunt.OLGESBioRifle" );
         return false;
      }
   }

   bSuperRelevant = 0;
   return true;
}

function GiveAmp(Pawn PlayerPawn)
{
   local UDamage damage;

   if( (PlayerPawn.FindInventoryType(class'UDamage') != None) || (PlayerPawn.Health <= 0) )
      return;
   damage = spawn(class'UDamage',PlayerPawn,,PlayerPawn.Location);
   if( damage != None )
   {
      damage.RespawnTime = 0.0;
      damage.GiveTo(PlayerPawn);
      damage.Activate();
   }
}

function MutatorTakeDamage (out int ActualDamage,Pawn Victim,Pawn InstigatedBy,out Vector HitLocation,out Vector Momentum,name DamageType)
{
   local Pawn P;
   
   if(DamageType == 'Impact') // hammer x5 ii !
	{
	   ActualDamage *= 5;
	}

   if(bUseAntiBoost)
   {
      if(Victim != None && InstigatedBy != None)
      {
         if (InstigatedBy.IsA('PlayerPawn') && Victim.IsA('PlayerPawn'))
         {
	    		Momentum = Vect(0,0,0);
            ActualDamage = 0;
            if (string(DamageType)=="RedeemerDeath")
            {
	       		Velocity = Vect(0,0,0);
	       		Victim.Velocity = (Victim.Velocity * 0);
            }
         }
      }
   }
   if(bHitsounds)
   {
      if(Victim != None && InstigatedBy != None)
      {
         if ( InstigatedBy.IsA('PlayerPawn') && (Victim != InstigatedBy) )
         {
            if( Victim.IsA('PlayerPawn') || Victim.IsA('Bot') )  // When player shoot other player
            {
	       		PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_None, HitVolume, false);
	       		PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interface, HitVolume, false);
	       		PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interact, HitVolume, false);
            }
            if( Victim.IsA('ScriptedPawn') )  // When player shoots a monster
            {   	// Cows and rabbits are friends
	       		if(Victim.IsA('Cow')|| Victim.IsA('BabyCow')|| Victim.IsA('NaliRabbit'))
               {
                  PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_None, HitVolume, false);
	          		PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interface, HitVolume, false);
	          		PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interact, HitVolume, false);
	       		}
               else // ScriptedPawn is an enemy
	       		{
		  				PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_None, HitVolume, false);
		  				PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_Interface, HitVolume, false);
		  				PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_Interact, HitVolume, false);
	       		}
            }
         }
      }
   }
   if(bAltScoring) // Scoring by damage
   {
      if (Victim != None && InstigatedBy != None)
      {
         if ( Victim.IsA('ScriptedPawn') && instigatedBy.IsA('ScriptedPawn') || Victim == instigatedBy && Victim.IsA('ScriptedPawn'))
            actualDamage=0;
         if ( actualDamage < 0 )
            return;
         else if ( actualDamage > 1000 )
            actualDamage=MaxDamage;
         if (ActualDamage > Victim.Health)
            ActualDamage = Victim.Health;
         if (Victim != None && InstigatedBy != None && Victim != InstigatedBy)
         {
	    		if (Victim.IsA('ScriptedPawn') && InstigatedBy.bIsPlayer)
            {
               InstigatedBy.PlayerReplicationInfo.Score += ActualDamage;
            }
         }
      }
   }
   if ( NextDamageMutator != None )
      NextDamageMutator.MutatorTakeDamage(ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

function ModifyPlayer(Pawn Other)
{
   local int randm;
   local inventory inv;
   local class<DJ_InventoryItem> InventoryClass;
   local DJ_InventoryItem DJ_Inv;

	Other.Health = DefaultHealth;

   if (stopPlayerCollision == true)
      Other.bBlockPlayers = false;

   if(UseMHTranslocator)
      DeathMatchPlus(Level.Game).GiveWeapon(Other,"MonsterHunt2Lite.MHTranslocator");
      
   inv = Spawn(class'Translator');
   if( inv != None )
   {
      inv.GiveTo(Other);
      inv.Activate();
   }

   InventoryClass = class<DJ_InventoryItem>(DynamicLoadObject("MonsterHunt2Lite.DJ_InventoryItem", class'Class'));

   if(DoubleJump)
   {
      DJ_Inv = Spawn(class'DJ_InventoryItem', Other,, Other.Location);
      if( DJ_Inv != None )
      {
         DJ_Inv.RespawnTime = 0.0;
         DJ_Inv.GiveTo(Other);
         DJ_Inv.maxJumps = maxJumps;
         DJ_Inv.jumpType = jumpType;
         DJ_Inv.jumpHeight = jumpHeight;
      }
   }
   if (bUseSpawnProt)
   {
      Inv = Other.FindInventoryType(class'SpawnProtEffect');
      if ( Inv != None )
         SpawnProtEffect(Inv).Duration = SpawnProtDuration;
      else
      {
         inv = Spawn(class'SpawnProtEffect');
         if( inv != None )
         {
            SpawnProtEffect(Inv).Duration = SpawnProtDuration;
            inv.GiveTo(Other);
            inv.Activate();
         }
      }
   }
   if(bGiveArmor)
   {
      inv = Spawn(class'MH2Armor2');
      if( inv != None )
	 	{
	    	inv.bHeldItem = true;
	    	inv.RespawnTime = 0.0;
	    	inv.GiveTo(Other);
	    	inv.Charge = Inv.Default.Charge;
     	}
   }
   if(GiveAllWeapons)
   {
      GiveWeapon(Other,class'PulseGun');
      GiveWeapon(Other,class'ShockRifle');
      GiveWeapon(Other,class'UT_FlakCannon');
      GiveWeapon(Other,class'Botpack.UT_BioRifle');
      GiveWeapon(Other,class'Botpack.Minigun2');
      GiveWeapon(Other,class'Botpack.Ripper');
      GiveWeapon(Other,class'Botpack.UT_Eightball');
      GiveWeapon(Other,class'Botpack.SniperRifle');
   }
   if (bUseRandomWeapon && Other.IsA('TournamentPlayer'))
   {
      randm = Rand(10);
      switch(randm)
      {
         case 0:
            GiveWeapon(Other,class'UT_Biorifle');
            break;
         case 1:
            GiveWeapon(Other,class'Shockrifle');
            break;
         case 2:
            GiveWeapon(Other,class'Pulsegun');
            break;
         case 3:
            GiveWeapon(Other,class'ripper');
            break;
         case 4:
            GiveWeapon(Other,class'minigun2');
            break;
         case 5:
            GiveWeapon(Other,class'UT_Flakcannon');
	   	 	break;
         case 6:
            GiveWeapon(Other,class'UT_EightBall');
           break;
	 		case 7:
            GiveWeapon(Other,class'SniperRifle');
            break;
         case 8:
            GiveWeapon(Other,class'WarHeadLauncher');
	       	Other.Health += 200;
            break;
         case 9:
	       	GiveWeapon(Other,class'ImpactHammer');
	       	Other.Health += 200;
            break;
      }
   	Other.ReceiveLocalizedMessage( class'MH2GetWeaponMessage', randm, Other.PlayerReplicationInfo, Other.PlayerReplicationInfo );
   }

   if ( NextMutator != None )
      NextMutator.ModifyPlayer(Other);
}

function GiveWeapon(Pawn PlayerPawn, class<TournamentWeapon> WeaponClass )
{
   local Weapon NewWeapon;

   if( PlayerPawn.FindInventoryType(WeaponClass) != None )
      return;
   newWeapon = Spawn(WeaponClass);
   if( newWeapon != None )
   {
      newWeapon.RespawnTime = 0.0;
      newWeapon.GiveTo(PlayerPawn);
      newWeapon.bHeldItem = true;
      newWeapon.SetSwitchPriority(PlayerPawn);
      newWeapon.WeaponSet(PlayerPawn);
      newWeapon.AmbientGlow = 0;
      PlayerPawn.PendingWeapon = None;
      if ( !newWeapon.IsA('ImpactHammer') && !newWeapon.IsA('Translocator') )
      {
	 		newWeapon.GiveAmmo(PlayerPawn);
	 		newWeapon.AmmoType.AmmoAmount = newWeapon.AmmoType.MaxAmmo;
      }
   }
}

function ScoreKill(Pawn Killer, Pawn Other)
{
   if(Killer == None)return;
   if(!Killer.bIsHuman)return;
   if(Killer.PlayerReplicationInfo.bIsABot) return;
   if(Killer.IsA('ScreptedPawn'))return;
   if(Killer.IsA('ScreptedPawn') && Other.IsA('ScreptedPawn'))return;
   if ( (Killer == None) && (Other == None) )return;
   if ( Killer.bIsPlayer && Other.bIsPlayer )return;

   if ( Other.Spree > 1 && Other.bIsPlayer)
     EndSpree(Killer, Other);
   if(Other.bIsPlayer)Other.Spree = 0;
   if ( (Killer != None) && Killer.bIsPlayer && (Killer != Other) )
   {
      if(Killer.Health <= MaxHealth)
      {
         Killer.Health += HealthRegenPerKill;
      }
      if(Killer.Health > MaxHealth)
      {
         Killer.Health = MaxHealth;
      }
      Killer.Spree+=1;
      if ( Killer.Spree > 14 )
         NotifySpree(Killer, Killer.Spree);
      if ( (TournamentPlayer(Killer).Level.TimeSeconds - TournamentPlayer(Killer).LastKillTime < 3))
      {
	 		TournamentPlayer(Killer).MultiLevel++;
	 		if(TournamentPlayer(Killer).MultiLevel >= 41)TournamentPlayer(Killer).MultiLevel = 40;
	 		TournamentPlayer(Killer).ReceiveLocalizedMessage( class'MH2MultiKillMessage', TournamentPlayer(Killer).MultiLevel );
	 		CheckBroadCast(Killer,TournamentPlayer(Killer).MultiLevel);
      }
      else TournamentPlayer(Killer).MultiLevel = 0;
      TournamentPlayer(Killer).LastKillTime = TournamentPlayer(Killer).Level.TimeSeconds;
   }
}

function CheckBroadCast(Pawn Killer,int num)
{
   if(Killer.bIsPlayer && !Killer.PlayerReplicationInfo.bIsABot)
      BroadCastMessage(Killer.PlayerReplicationInfo.PlayerName@GetText(num));
}

function string GetText(int Switch)
{
   switch (Switch)
   {
      case 1:
	 		return " has Double Kill!";
	 		break;
      case 2:
	 		return " has Multi Kill!";
	 		break;
      case 3:
	 		return " has Mega Kill!";
	 		break;
      case 4:
	 		return " has ULTRA KILL!!";
	 		break;
      case 5:
	 		return " has M O N S T E R  K I L L !!!";
	 		break;
      case 6:
	 		return " has L U D I C R O U S  K I L L !!!!";
	 		break;
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 37:
      case 38:
      case 39:
         return " has H  O  L  Y   S  H  I  T !!!!!!!";
	 		break;
      case 40:
	 		return " is still going.... !!!!!!!!!!!";
	 		break;
   }
   return "";
}

function NotifySpree(Pawn Other, int num)
{
   local Pawn P;

   if ( num == 30 )
      num = 0;
   else if ( num == 45 )
      num = 1;
   else if ( num == 60 )
      num = 2;
   else if ( num == 90 )
      num = 3;
   else if ( num == 125 )
      num = 4;
   else if ( num == 250 )
      num = 5;
   else if ( num == 500 )
      num = 6;
   else if ( num == 1000 )
      num = 7;
   else
      return;

   for ( P=Level.PawnList; P!=None; P=P.NextPawn )
   if ( P.IsA('TournamentPlayer') )
      P.ReceiveLocalizedMessage( class'MH2KillingSpreeMessage', Num, Other.PlayerReplicationInfo );
}

function EndSpree(Pawn Killer, Pawn Other)
{
   local Pawn P;

   if ( !Other.bIsPlayer || Killer.PlayerReplicationInfo.bIsABot)
      return;
   for ( P=Level.PawnList; P!=None; P=P.NextPawn )
   if ( P.IsA('TournamentPlayer') )
   {
      P.ReceiveLocalizedMessage( class'MH2KillingSpreeMessage', Other.Spree, Killer.PlayerReplicationInfo, Other.PlayerReplicationInfo );
   }
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name DamageType, Vector HitLocation)
{
   local bool pd;

   pd=Super.PreventDeath(Killed,Killer,DamageType,HitLocation);

   if (Killed != none && !pd)
   {
      if (!Killed.IsA('ScriptedPawn'))
      {
         if (Killer != none && Killer.IsA('ScriptedPawn'))
    	      DiscardInventory(Killed);
         if (Killed.bIsPlayer)
            Killed.PlayerReplicationInfo.Score *= retainScoreOnDeathPercent;
      }
   }
   return pd;
}

function DiscardInventory (Pawn Other)
{
   local Actor dropped;
   local Inventory Inv;
   local class<Weapon> Initial1;
   local class<Weapon> Initial2;

   if (Other != none)
   {
      if ( Other.DropWhenKilled != None )
      {
         dropped=Spawn(Other.DropWhenKilled,,,Other.Location);
         Inv=Inventory(dropped);
         if ( Inv != None )
         {
            Inv.RespawnTime=0.00;
            Inv.BecomePickup();
    	 	}
         if ( dropped != None )
         {
            dropped.RemoteRole=ROLE_SimulatedProxy;
            dropped.SetPhysics(PHYS_Falling);
            dropped.bCollideWorld=True;
            dropped.Velocity=Other.Velocity + VRand() * 280;
    	 	}
         if ( Inv != None )
         {
            Inv.GotoState('Pickup','dropped');
    	 	}
      }
      Inv=Other.Inventory;
      JL0111:
         if ( Inv != None )
    	 	{
            if ( Inv.IsA('Weapon') )
    	    	{
    	       	if ( (Inv.Class != Level.Game.BaseMutator.MutatedDefaultWeapon()) && ((Weapon(Inv).AmmoType == None) || (Weapon(Inv).AmmoType.AmmoAmount > 0)) && Weapon(Inv).bCanThrow)
               {
                  if (Inv.class != class'Enforcer' && Inv.Class != class'DoubleEnforcer')
                     DropWeapon(Other,Inv);
    	       	}
            }
    	    	Inv.Destroy();
            Inv=Inv.Inventory;
            goto JL0111;
         }
   }
}

function DropWeapon (Pawn Other, Inventory Inv)
{
   local Inventory DropInv;
   local int DropPitch;
   local int DropYaw;
   local Rotator DropRot;

   DropInv=Spawn(Inv.Class,,,Other.Location);
   if ( DropInv == None )
   {
      return;
   }
   DropRot=Other.ViewRotation;
   DropPitch=Rand(32768);
   DropYaw=Rand(65536);
   DropRot.Pitch=DropPitch;
   DropRot.Yaw=DropYaw;
   Weapon(DropInv).bWeaponStay = false;
   DropInv.Velocity=vector(DropRot) * (Rand(250) + 250);
   DropInv.RespawnTime=0.00;
   DropInv.BecomePickup();
   DropInv.NetPriority=2.50;
   DropInv.RemoteRole=ROLE_SimulatedProxy;
   DropInv.SetPhysics(PHYS_Falling);
   DropInv.bCollideWorld=True;
   DropInv.GotoState('Pickup','dropped');
}

function Timer()
{
   local Pawn P, PRand;
   local Inventory Inv;
   local SkaarjTrooper ST;
   local Weapon Wp;
   local Fragment F;
   local CreatureCarcass C;
   local ScriptedPawn S;
   local Queen Q;
   
   foreach AllActors (class 'Fragment' ,F)
   {
   	if ( F != None )
   		F.Destroy();
   }
   foreach AllActors (class 'CreatureCarcass' ,C)
   {
   	if (C != None)
   	{
   		if (C != None && !C.bstatic && !C.bNoDelete)
   			C.GotoState('Corroding');
   	}		
   }

   if (Level.Game.bGameEnded) return;

   for (P = Level.PawnList; P != None; P = P.NextPawn)
   {
 		ST = SkaarjTrooper(P);
		S = ScriptedPawn(P);
		Q = Queen(P);
		
		if (Q != None)
      {
			if (Q.IsInState('Teleporting'))
				Q.GotoState('Roaming','');
		}

		if (S != None && S.Health >= 1)
			S.TeamTag='Monst';

		if (S != None && S.Health < -1) //Wtf ? They are spirits, ghosts ? No shit me.
			S.GotoState('Dying');		
 
		if (ST != None && ST.myWeapon == None)
		{
			ST.bIsPlayer = True;
			Wp = spawn (class 'MonsterHunt.OLASMD',,,ST.Location + vect(0,0,1));
			Wp.RespawnTime=0;
			Wp.GiveTo(ST);
			Wp.bHeldItem = True;
			Wp.SetSwitchPriority(ST);
			Wp.WeaponSet(ST);
			Wp.AmbientGlow = 0;
			ST.PendingWeapon = None;
			Wp.GiveAmmo(ST);
			Wp.AmmoType.AmmoAmount = Wp.AmmoType.MaxAmmo * 20;
			ST.myWeapon = Wp;
			ST.bIsPlayer = False;
		}

		if (ST != None && ST.myWeapon != None )
		{
			SetWeapon(ST);
			ST.bIsPlayer = False;
		}

		if (S != None && S.ReducedDamagePct > 0)
		{
			S.ReducedDamageType = '';
			S.ReducedDamagePct = 0;
		}
   }

   if (AmpCount < AmpSpawnTime) AmpCount++;

   else if (AmpCount == AmpSpawnTime)
   {
      BroadcastLocalizedMessage(class 'MH2AmpMessage', , , None, None);
      for (P = Level.PawnList; P != None; P = P.NextPawn)
      {
         if (P.IsA('Bot') || P.IsA('TournamentPlayer')) GiveAmp(P);
      }
      AmpCount = 0;
   }

   for (P = Level.PawnList; P != None; P = P.NextPawn)
   {
      if (P.IsA('Bot') || P.IsA('TournamentPlayer'))
      {
         if (P.Health > 0)
         {
            if (bUseRegenAmmo)
            {
               for (Inv = P.Inventory; Inv != None; Inv = Inv.Inventory)
               {
                  if ((Ammo(Inv) != None) && (P.bFire == 0) && (P.bAltFire == 0))
                  {
                     if (Ammo(Inv).AmmoAmount < Ammo(Inv).MaxAmmo * 10)
                     {
                        Ammo(Inv).AmmoAmount += (Ammo(Inv).Default.AmmoAmount / AmmoInterval);
                        if (Ammo(Inv).AmmoAmount > Ammo(Inv).MaxAmmo * 10)
                           Ammo(Inv).AmmoAmount = Ammo(Inv).MaxAmmo * 10;
                     }
                  }
               }
            }
            if (bUseRegenHealth)
            {
               if (P.Health < MaxRegenHealth && P.Region.Zone != None && !P.Region.Zone.bWaterZone) // waterzone stoppage of health regen
               {
                  if (P.IsInState('FeigningDeath'))
                     P.Health = FMin(MaxRegenHealth, P.Health + (3 * HealthRegenPerSec));
                  else
                     P.Health = FMin(MaxRegenHealth, P.Health + HealthRegenPerSec);
               }
            }
         }

         PRand = GetRandomPlayer();
         if (PRand != None)
         {
            if (kakuCount < DeemerSpawnTime) kakuCount++;
            if (HealthCount < HealthAwardTime) HealthCount++;
            if (DeemerSpawnTime - kakuCount < 5 && DeemerSpawnTime - kakuCount > 0)
            {
               BroadcastLocalizedMessage(class 'MH2RandomDeemerMsg', DeemerSpawnTime - kakuCount, PRand.PlayerReplicationInfo);
            }
            if (HealthAwardTime - HealthCount < 5 && HealthAwardTime - HealthCount > 0)
            {
               BroadcastLocalizedMessage(class 'MH2RandomHealthMsg', HealthAwardTime - HealthCount, PRand.PlayerReplicationInfo);
            }
            if (kakuCount >= DeemerSpawnTime)
            {
               kakuCount = 0;
               PRand = GetRandomPlayer();
               if (PRand != None && PRand.bIsPlayer)
               {
                  BroadcastLocalizedMessage(class 'MH2RandomDeemerMsg', kakuCount, PRand.PlayerReplicationInfo);
                  GiveOldRedeemer(PRand);
               }
            }
            if (HealthCount >= HealthAwardTime)
            {
               HealthCount = 0;
               PRand = GetRandomPlayer();
               if (PRand != None && PRand.bIsPlayer)
               {
                  BroadcastLocalizedMessage(class 'MH2RandomHealthMsg', HealthCount, PRand.PlayerReplicationInfo);
                  GiveHealth(PRand);
               }
            }
         }
      }
   }
}

function GiveOldRedeemer(Pawn PlayerPawn)
{
   local Warheadlauncher  redeA;
   local bool NoNeed;

   redeA= spawn(class'Warheadlauncher');
   if( redeA!= None )
   {
      if (PlayerPawn.FindInventoryType(class'Warheadlauncher') != None)
         NoNeed = true;

      redeA.RespawnTime = 0.0;
      redeA.GiveTo(PlayerPawn);
      redeA.SetSwitchPriority(PlayerPawn);
      PlayerPawn.AddInventory(redeA);
      redeA.PickupAmmoCount = 1;
      redeA.GiveAmmo(PlayerPawn);
      if (NoNeed)
         redeA.Destroy();
   }
}

function SetWeapon(SkaarjTrooper ST) 
{
	local Weapon W;

	W = ST.myWeapon;

	if (W != None && !W.IsA('UIweapons') && !W.IsA('UIweapon') && !W.IsA('TournamentWeapon'))
	{
		if (W.IsA('Rifle'))
		{
			W.Destroy();
			W = spawn (class 'MonsterHunt.OLRifle');
		}
		else if (W.IsA('Eightball'))
		{
			W.Destroy();
			W = spawn (class 'MonsterHunt.OLEightball');
		}
		else if (W.IsA('FlakCannon'))
		{
			W.Destroy();
			W = spawn (class 'MonsterHunt.OLFlakCannon');
		}
		else if (W.IsA('Minigun'))
		{
			W.Destroy();
			W = spawn (class 'MonsterHunt.OLMinigun');
		}
		else if (W.IsA('RazorJack'))
		{
			W.Destroy();
			W = spawn (class 'MonsterHunt.OLRazorJack');
		}
		else if (W.IsA('Stinger'))
		{
			W.Destroy();
			W = spawn (class 'MonsterHunt.OLStinger');
		}
		else if (W.IsA('ASMD'))
		{
			W.Destroy();
			W = spawn (class 'MonsterHunt.OLASMD');
		}
		else if (W.IsA('GESBioRifle'))
		{
			W.Destroy();
			W = spawn (class 'MonsterHunt.OLGESBioRifle');
		}
		else if (W.IsA('DispersionPistol'))
		{
			W.Destroy();
			W = spawn (class 'MonsterHunt.OLDPistol');
		}

		W.RespawnTime=0;
		W.GiveTo(ST);
		W.bHeldItem = True;
		W.SetSwitchPriority(ST);
		W.WeaponSet(ST); 		//Engine will deliver something less funny, but I don't give a shit on that LogPickup crap.
		W.AmbientGlow = 0;
		ST.PendingWeapon = None;
		ST.myWeapon = W;
		if ( !W.IsA('ImpactHammer') && !W.IsA('Translocator') )
		{
			W.GiveAmmo(ST);
			W.AmmoType.AmmoAmount = W.AmmoType.MaxAmmo*50;
		}
	}
}

function GiveHealth(Pawn PlayerPawn)
{
   PlayerPawn.Health+=500;
}

function Pawn GetRandomPlayer()
{
   local Pawn N;
   local PlayerPawn Dest;
   local Pawn Candidate[32];
   local int num;

   for (N=Level.PawnList; N!=None; N=N.NextPawn)
   {
      Dest=PlayerPawn(N);
      if (Dest!=None && Dest.bIsPlayer && !Dest.PlayerReplicationInfo.bIsSpectator)
      {
         if (num<32) Candidate[num] = Dest;
         else if (Rand(num) < 32) Candidate[Rand(32)] = Dest;
         num++;
      }
   }
   if(num==0) return None;
   return Candidate[Rand(Min(32,num))];
}

function Mutate(string MutateString, PlayerPawn Sender)
{
   local mover M;

   if(!Sender.PlayerReplicationInfo.bIsSpectator || !Sender.PlayerReplicationInfo.bWaitingPlayer)
   {
      if(MutateString~="light")
      {
         Sender.ClientMessage("Toggling personal light on");
         Sender.AmbientGlow = 254;
         Sender.LightEffect=LE_NonIncidence;
         Sender.LightBrightness=255;
         Sender.LightHue=210;
         Sender.LightRadius=30;
         Sender.LightSaturation=200;
         Sender.LightType=LT_Steady;
      }
      if(MutateString~="dark")
      {
         Sender.ClientMessage("Toggling personal light off");
         Sender.AmbientGlow = Owner.Default.AmbientGlow;
         Sender.LightType = LT_None;
      }
      if(MutateString ~= CommandOpen)
      {
         Sender.ClientMessage("Movers in range opened (Action was logged to the server admin)...");
         foreach RadiusActors(class'Mover', M, 250, Sender.Location)
         {
            log("## ADMIN- Mover opened:"@M@" by player:"@Sender.PlayerReplicationInfo.PlayerName);
            M.DoOpen();
         }
      }
      else if(MutateString ~= CommandClose)
      {
         Sender.ClientMessage("Movers in range closed (Action was logged to the server admin)...");
         foreach RadiusActors(class'Mover', M, 250, Sender.Location)
         {
            log("## ADMIN- Mover closed:"@M@" by player:"@Sender.PlayerReplicationInfo.PlayerName);
            M.DoClose();
         }
      }
   }
   if ( NextMutator != None )
      NextMutator.Mutate(MutateString, Sender);
}

simulated function bool AlwaysKeep(Actor Other)
{
   local bool bTemp;
   
   	if ( Other.IsA('ScriptedPawn') )
   	{
   		ScriptedPawn(Other).NetPriority = 3.000000;
   		return True;
		}
		
	if ( Other.IsA('ThingFactory') )
		return True;
	
   if (Other.IsA('ScriptedPawn'))
      ScriptedPawn(Other).bIsPlayer = False;

   if ( NextMutator != None )
      return ( NextMutator.AlwaysKeep(Other) );
   return false;
}

function bool ReplaceWithOther(actor Other, string aClassName)
{
	local Actor A;
	local class<Actor> aClass;

	if ( Other.IsA('Inventory') && (Other.Location == vect(0,0,0)) )
		return false;
	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if ( aClass != None )
	{
		Other.SetCollision(False,False,False);
		aClass.default.bCollideWhenPlacing = False;
		aClass.Default.bCollideWorld = True;
		A = Spawn(aClass,Other.Owner,Other.tag,Other.Location, Other.Rotation);
	}
	if ( Other.IsA('Inventory') )
	{
		if ( Inventory(Other).MyMarker != None )
		{
			Inventory(Other).MyMarker.markedItem = Inventory(A);
			if ( Inventory(A) != None )
			{
				Inventory(A).MyMarker = Inventory(Other).MyMarker;
				A.SetLocation(A.Location + (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1));
			}
			Inventory(Other).MyMarker = None;
		}
		else if ( A.IsA('Inventory') )
		{
			Inventory(A).bHeldItem = true;
			Inventory(A).Respawntime = 0.0;
		}
	}
	if ( A != None )
	{
		A.event = Other.event;
		A.tag = Other.tag;
		return true;
	}
	return false;
}

defaultproperties
{
   AmpSpawnTime=400
   DeemerSpawnTime=120
   HealthAwardTime=500
   bUseRandomWeapon=True
   HealthRegenPerSec=10
   MaxHealth=500
   bUseRegenAmmo=True
   bUseRegenHealth=True
   bGiveArmor=True
   MaxRegenHealth=500
   HealthRegenPerKill=10
   DefaultHealth=100
   bUseAntiBoost=False
   AmmoInterval=3
   bHitsounds=True
   bAltScoring=True
   stopPlayerCollision=True
   ReplaceInvis=True
   VisibleMonsterEnds=True
   GiveAllWeapons=True
   DoubleJump=True
   maxJumps=3
   jumpType=2
   jumpHeight=2.00
   retainScoreOnDeathPercent=0.75
   bUseSpawnProt=True
   SpawnProtDuration=10
   UseMHTranslocator=True
   HitVolume=16.00
   bFixCrushingMover=False
   UseLimeLight=False
   UseMH2JumpBoots=False
   MaxDamage=1000
   bServerInfo="Default message"
   MH2NaliFruit="MonsterHunt2Lite.MH2NaliFruit"
   MH2MedBox="MonsterHunt2Lite.MH2MedBox"
   MH2HealthPack="MonsterHunt2Lite.MH2HealthPack"
   MH2UnrealHealth="MonsterHunt2Lite.MH2UnrealHealth"
   MH2HealthVial="MonsterHunt2Lite.MH2HealthVial"
   AdjustFactories=False
   bCapacity=500
}
