
class MH2KillingSpreeMessage expands CriticalEventLowPlus;

#exec AUDIO IMPORT FILE="Sounds\femspree.wav" NAME=femspree
#exec AUDIO IMPORT FILE="Sounds\femrampage.wav" NAME=femrampage
#exec AUDIO IMPORT FILE="Sounds\femdominating.wav" NAME=femdominating
#exec AUDIO IMPORT FILE="Sounds\femunstop.wav" NAME=femunstop
#exec AUDIO IMPORT FILE="Sounds\femwicked.wav" NAME=femwicked
#exec AUDIO IMPORT FILE="Sounds\femgodlike.wav" NAME=femgodlike
#exec AUDIO IMPORT FILE="Sounds\Excellent.wav" NAME="Excellent"
#exec AUDIO IMPORT FILE="Sounds\Impressive.wav" NAME="Impressive"

var(Messages)	localized string EndSpreeNote, EndSelfSpree, EndFemaleSpree,EndSpreeNoteTrailer;
var(Messages)	localized string Spreenote[10];
var(Messages)	sound SpreeSound[10];

static function string GetString(optional int Switch,optional PlayerReplicationInfo RelatedPRI_1,optional PlayerReplicationInfo RelatedPRI_2,optional Object OptionalObject)
{
   if (RelatedPRI_2 == None)
   {
      if (RelatedPRI_1 == None)
         return "";
      if (RelatedPRI_1.PlayerName != "")
	 		return RelatedPRI_1.PlayerName@Default.SpreeNote[Switch];
   }
   else
   {
      return RelatedPRI_2.PlayerName$Default.EndSpreeNote@Switch;
   }
   return "";
}

static simulated function ClientReceive(PlayerPawn P,optional int Switch,optional PlayerReplicationInfo RelatedPRI_1,optional PlayerReplicationInfo RelatedPRI_2,optional Object OptionalObject)
{
   Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
	
   if (RelatedPRI_2 != None)
      return;
   if (RelatedPRI_1 != P.PlayerReplicationInfo)
   {
      P.PlaySound(sound'SpreeSound',, 4.0);
	 		return;
   }
   P.ClientPlaySound(Default.SpreeSound[Switch],, true);
}

defaultproperties
{
   EndSpreeNote=" was killed. Total kill: "
   EndSelfSpree="was looking good till he killed himself!"
   EndFemaleSpree="was looking good till she killed herself!"
   spreenote(0)="is on a killing spree with 30 kills!"
   spreenote(1)="is on a rampage with 45 kills!"
   spreenote(2)="is dominating with 60 kills!"
   spreenote(3)="is unstoppable with 90 kills!"
   spreenote(4)="is WickedSick with 125 kills!"
   spreenote(5)="**is GODLIKE with 250 KILLS!!**"
   spreenote(6)="just got 500 KILLS!!"
   spreenote(7)="topped 1000 kills!!"
   SpreeSound(0)=Sound'femspree'
   SpreeSound(1)=Sound'femrampage'
   SpreeSound(2)=Sound'femdominating'
   SpreeSound(3)=Sound'femunstop'
   SpreeSound(4)=Sound'femwicked'
   SpreeSound(5)=Sound'femgodlike'
   SpreeSound(6)=Sound'Impressive'
   SpreeSound(7)=Sound'Excellent'
   bBeep=False
}
