
class MH2MonsterEnd expands Trigger config(MonsterHunt2Lite);

#exec obj load file=..\Music\null48.umx

function Touch( actor Other )
{
   local actor A;
   local pawn P, Best;

   if( IsRelevant( Other ) )
   {
      if ( ReTriggerDelay > 0 )
      {
	 		if ( Level.TimeSeconds - TriggerTime < ReTriggerDelay )
            return;
	 		TriggerTime = Level.TimeSeconds;
      }
      if( Event != '' )
         foreach AllActors( class 'Actor', A, Event )
         A.Trigger( Other, Other.Instigator );

      if ( Other.IsA('Pawn') && (Pawn(Other).SpecialGoal == self) )
	 		Pawn(Other).SpecialGoal = None;

      if( Message != "" )
	 		Other.Instigator.ClientMessage( Message );

      TriggerObjective();

      for ( P=Level.PawnList; P!=None; P=P.nextPawn )
      if ( P.bIsPlayer && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
         Best = P;

      if( bTriggerOnceOnly )
         SetCollision(False);
      else if ( RepeatTriggerTime > 0 )
 	 SetTimer(RepeatTriggerTime, false);
   }
}

function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation,	Vector momentum, name damageType)
{
   local actor A;

   if ( bInitiallyActive && (TriggerType == TT_Shoot) && (Damage >= DamageThreshold) && (instigatedBy != None) )
   {
      if ( ReTriggerDelay > 0 )
      {
      	 if ( Level.TimeSeconds - TriggerTime < ReTriggerDelay )
            return;
         TriggerTime = Level.TimeSeconds;
      }
      if( Event != '' )
         foreach AllActors( class 'Actor', A, Event )
         A.Trigger( instigatedBy, instigatedBy );

      if( Message != "" )
	 		instigatedBy.Instigator.ClientMessage( Message );

      if( bTriggerOnceOnly )
	 		SetCollision(False);

      TriggerObjective();
   }
}

function TriggerObjective()
{
   if (Level.Game.IsA('MonsterHunt'))
      Level.Game.EndGame("Hunt Successfull!");
   else
      log("MonsterEnd - TriggerObjective - MH == None. This map needs to be fixed for normal MH.");
}

defaultproperties
{
   InitialState=OtherTriggerTurnsOn
   bInitiallyActive=True
   Texture=Texture'MonsterHunt.MHEnd'
}