
class MH2NaliFruit extends NaliFruit config(MonsterHunt2Lite);

var config int MaxHealth;

event float BotDesireability(Pawn Bot)
{
   if ( HealingAmount < 3 ) return 0;
   return Super.BotDesireability(Bot);
}

auto state Pickup
{
   function Timer()
   {
      HealingAmount += 1;
      SetTimer(0.5,True);
   }
   function Touch( actor Other )
   {
      if ( !ValidTouch(Other) || (HealingAmount<2) )
         Return;
      if (Level.Game.LocalLog != None)
	 		Level.Game.LocalLog.LogPickup(Self, Pawn(Other));
      if (Level.Game.WorldLog != None)
	 		Level.Game.WorldLog.LogPickup(Self, Pawn(Other));
      if (Pawn(Other).Health < MaxHealth)
      {
         Pawn(Other).Health += HealingAmount;
	 		if (Pawn(Other).Health > MaxHealth) Pawn(Other).Health = MaxHealth;
	 		Pawn(Other).ClientMessage(PickupMessage$HealingAmount, 'Pickup');
	 		PlaySound (PickupSound);
	 		SetRespawn();
	 		if ( Level.Game.Difficulty > 1 )
            Other.MakeNoise(0.1 * Level.Game.Difficulty);
      }
   }
   Begin:
      PlayAnim('Root');
      FinishAnim();
      HealingAmount = 0;
      Sleep(FRand()*3);
      SetTimer(8.5,False);
      PlayAnim('Grow',0.036);
      FinishAnim();
      SetTimer(0.0,False);
      LoopAnim('Waver',0.1);
}

defaultproperties
{
   MaxHealth=500
}
