
#exec OBJ LOAD File="..\System\MonsterHunt.u"

class MonsterHunt expands TeamGamePlus config(MonsterHunt2Lite);

var config bool bUseTeamSkins, bUseLives;
var config int MonsterSkill, Lives;

var string TimeOutMessage;

var int LivePpl;
var int PlainPpl;

var int LastPoint;
var int NumPoints;
var int MonstersTotal;
var int HuntersTotal;

var config string StartUpMessage;
var config int MaxMonsterHealth;

var float LastMonsterAttackTime;
var float LastMadTime;

function PostBeginPlay()
{
	local int i;
	local ScriptedPawn S;
	local pawn pawnlink;
	local MonsterWaypoint WP;
	local MonsterEnd ME;
	local MH2MonsterEnd ex;

	LastPoint = 0;

	foreach AllActors(class'MonsterWaypoint', WP)
		NumPoints ++;

	foreach AllActors(class'ScriptedPawn', S)
	{
		MonstersTotal ++;
		if ( !S.IsA('Nali') && !S.IsA('Cow'))
			S.AttitudeToPlayer=ATTITUDE_Hate;
	}

   foreach AllActors(class'MonsterEnd', ME)
	{
		if(ME !=none)
	   {
			ex=Spawn(class'MH2MonsterEnd',,,ME.location+vect(-1,-1,-1)); // right next to it
			if(ME.Tag !='')
            ex.tag=ME.Tag;
         if(ME.Event !='')
				ex.event=ME.Event;
			if(ME.AttachTag !='')
				ex.AttachTag=ME.AttachTag;
			ex.SetCollisionSize(ME.CollisionRadius, ME.CollisionHeight);
			if (ME.bInitiallyActive)
				ex.bInitiallyActive=True;
			else
				ex.bInitiallyActive=False;
	    }
	}

	MonsterReplicationInfo2(GameReplicationInfo).Monsters = MonstersTotal;
	MonsterReplicationInfo2(GameReplicationInfo).Lives = Lives;
	MonsterReplicationInfo2(GameReplicationInfo).bUseTeamSkins = bUseTeamSkins;
	if ( MonsterReplicationInfo2(GameReplicationInfo).Lives <= 0 )
		MonsterReplicationInfo2(GameReplicationInfo).bUseLives = False;
	else
		MonsterReplicationInfo2(GameReplicationInfo).bUseLives = True;

	Super.PostBeginPlay();
}

function PreCacheReferences()
{
	Spawn(class'MonsterHunt2Lite.ExCreatureCarcass');
	Spawn(class'MonsterHunt2Lite.ExCreatureChunks');
	Spawn(class'MonsterHunt.OLASMD');
	Spawn(class'MonsterHunt.OLDPistol');
	Spawn(class'MonsterHunt.OLEightball');
	Spawn(class'MonsterHunt.OLFlakCannon');
	Spawn(class'MonsterHunt.OLGESBioRifle');
	Spawn(class'MonsterHunt.OLMinigun');
	Spawn(class'MonsterHunt.OLRazorJack');
	Spawn(class'MonsterHunt.OLRifle');
	Spawn(class'MonsterHunt.OLStinger');
}

function SetPawnDifficulty( int Diff, ScriptedPawn S )
{
	local int DiffScale;
/*
	switch (Diff)
	{
		case 0:
			DiffScale = 80;
			break;
		case 1:
			DiffScale = 90;
			break;
		case 2:
			DiffScale = 100;
			break;
		case 3:
			DiffScale = 110;
			break;
		case 4:
			DiffScale = 120;
			break;
		case 5:
			DiffScale = 130;
			break;
		case 6:
			DiffScale = 140;
			break;
		case 7:
*/
			DiffScale = 150;
//			break;
//	}
	
	if (S.PeripheralVision < -4) S.PeripheralVision = -4;
	if (S.PeripheralVision > 0.2) S.PeripheralVision = 0.2;
	if (S.HearingThreshold < 0.5) S.HearingThreshold = 0.5;
	if (S.Aggressiveness < 0.8) S.Aggressiveness = 0.8;
//	if (S.Skill < DiffScale / 100)
//		S.Skill = (DiffScale /100);
	if (S.Skill < 1.5)
		S.Skill = 1.5;

//	S.Health = (S.Health * DiffScale) / 100;

	if (S.Health > MaxMonsterHealth) S.Health = MaxMonsterHealth;
	S.SightRadius = (S.SightRadius * DiffScale) / 100;
	S.Aggressiveness = (S.Aggressiveness * DiffScale) / 100;
	S.ReFireRate = (S.ReFireRate * DiffScale) / 100;
	S.CombatStyle = (S.CombatStyle * DiffScale) / 100;
	S.ProjectileSpeed = (S.ProjectileSpeed * DiffScale) / 100;
	S.GroundSpeed = (S.GroundSpeed * DiffScale) / 100;
	S.AirSpeed = (S.AirSpeed * DiffScale) / 100;
	S.WaterSpeed = (S.WaterSpeed * DiffScale) / 100;

	if (S.GroundSpeed > 500)
		S.GroundSpeed = 500;
	S.Intelligence = BRAINS_HUMAN; 
	if (S.HearingThreshold < 0.5)
		S.HearingThreshold = 0.5;
	if (S.SightRadius < 5000)
		S.SightRadius = 5000;
	if (S.AccelRate > 700)
		S.AccelRate = 700;
	if (S.AirSpeed > 500)
		S.AirSpeed = 500;
	if (S.WaterSpeed > 400)
		S.WaterSpeed = 400;
	if (S.IsA('Brute'))
		Brute(S).WhipDamage = (Brute(S).WhipDamage * DiffScale) / 100;
	if (S.IsA('Gasbag'))
		Gasbag(S).PunchDamage = (Gasbag(S).PunchDamage * DiffScale) / 100;
	if (S.IsA('Titan'))
		Titan(S).PunchDamage = (Titan(S).PunchDamage * DiffScale) / 100;
	if (S.IsA('Krall'))
		Krall(S).StrikeDamage = (Krall(S).StrikeDamage * DiffScale) / 100;
	if (S.IsA('Manta'))
	{
		Manta(S).StingDamage = (Manta(S).StingDamage * DiffScale) / 100;
		if (S.RangedProjectile == None) S.bHasRangedAttack = False;
	}
	if (S.IsA('Mercenary'))
	{
		Mercenary(S).PunchDamage = (Mercenary(S).PunchDamage * DiffScale) / 100;
		Mercenary(S).bHasInvulnerableShield = False;
		Mercenary(S).invulnerableCharge = 0.2;
	}
	if (S.IsA('Skaarj'))
		Skaarj(S).ClawDamage = (Skaarj(S).ClawDamage * DiffScale) / 100;
	if (S.IsA('Pupae'))
	{
		Pupae(S).BiteDamage = (Pupae(S).BiteDamage * DiffScale) / 100;
		if (S.RangedProjectile == None) S.bHasRangedAttack = False;
	}
	if (S.IsA('Queen'))
		Queen(S).ClawDamage = (Queen(S).ClawDamage * DiffScale) / 100;
	if (S.IsA('Slith'))
		Slith(S).ClawDamage = (Slith(S).ClawDamage * DiffScale) / 100;
	if (S.IsA('Warlord'))
		Warlord(S).StrikeDamage = (Warlord(S).StrikeDamage * DiffScale) / 100;
		
	S.bInitialFear=False;
	S.bMoraleBoosted = True;
	
	// Just to be sure
	if(S.health > MaxMonsterHealth)
		S.Health= MaxMonsterHealth;
	
	if (S.CarcassType != None)
	{
		S.CarcassType = class'MonsterHunt2Lite.ExCreatureCarcass';
	}
	S.TeamTag = 'Mns';
}

function AddDefaultInventory( pawn PlayerPawn )
{
	bUseTranslocator = false;
	Super.AddDefaultInventory(PlayerPawn);
}

event InitGame( string Options, out string Error )
{
	local string InOpt;
	local Mutator M, last;
	local class<Mutator> MutatorClass;
	local int i;

	MaxTeams = Min(MaxTeams,MaxAllowedTeams);

	for (M = BaseMutator; M != None; M = M.NextMutator)
	{
		if (M.class == class'Botpack.LowGrav')
		{
			last.NextMutator = M.NextMutator;
			M.Destroy();
			M = last;
		}
		if (M.class == class'Botpack.InstaGibDM')
		{
			last.NextMutator = M.NextMutator;
			M.Destroy();
			M = last;
		}
	}

	Super(TournamentGameInfo).InitGame(Options, Error);

	RemainingTime = 60 * TimeLimit;
	SetGameSpeed(GameSpeed);
	FragLimit = GetIntOption( Options, "FragLimit", FragLimit );
	TimeLimit = GetIntOption( Options, "TimeLimit", TimeLimit );
	MaxCommanders = GetIntOption( Options, "MaxCommanders", MaxCommanders );
	InOpt = ParseOption( Options, "CoopWeaponMode");
	if ( InOpt != "" ) bCoopWeaponMode = bool(InOpt);
	IDnum = -1;
	IDnum = GetIntOption( Options, "Tournament", IDnum );
	if ( IDnum > 0 )
	{
		bRatedGame = true;
		TimeLimit = 0;
		RemainingTime = 0;
	}
	if ( Level.NetMode == NM_StandAlone )
	{
		bRequireReady = true;
		CheckReady();
	}
	if ( Level.NetMode == NM_StandAlone )
	{
		bRequireReady = true;
		CountDown = 1;
	}
	if ( !bRequireReady && (Level.NetMode != NM_Standalone) )
	{
		bRequireReady = true;
		bNetReady = true;
	}

	bJumpMatch = False;
	bNoMonsters = False;
	bCanChangeSkin = True;
}

function bool SetEndCams(string Reason)
{
	local TeamInfo BestTeam;
	local int i;
	local pawn P, Best;
	local PlayerPawn player;
	local bool bGood;
   local ScriptedPawn S;
	local Carcass C;
	local ThingFactory T;
	local SpawnPoint SP;

	bGood = True;

	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
			Best = P;

	if ( Reason == "No Hunters" )
	{
		bGood = False;
		GameEndedMessage = "All players are lost, game over!";
	}

	if ( (RemainingTime == 0) && (TimeLimit >= 1) )
	{
		bGood = False;
		GameReplicationInfo.GameEndedComments = TimeOutMessage;
	}
	else
		GameReplicationInfo.GameEndedComments = GameEndedMessage;

	EndTime = Level.TimeSeconds + 3.0;
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		player = PlayerPawn(P);
		if ( Player != None )
		{
         //Attempt to stop the sliding player at map end
         player.SetLocation(player.Location);
         player.Velocity.X = 0;
         player.Velocity.Y = 0;
      	player.Velocity.Z = 0;
			if (!bTutorialGame)
				PlayWinMessage(Player, bGood);
			player.bBehindView = true;
			if ( Player == Best )
				Player.ViewTarget = None;
			else
				Player.ViewTarget = Best;
			player.ClientGameEnded();
		}
		P.GotoState('GameEnded');
	}
   foreach AllActors (class 'Carcass', C)
	{
		if (C != None)
			C.GoToState('Corroding','');
	}
	foreach AllActors ( class 'SpawnPoint', SP )
	{
		if (SP != None)
			SP.tag = ''; //Better give me a break before I slap you so bad :D...
	}
	foreach AllActors (class 'ThingFactory', T)
	{
		if (T != None)
			T.capacity = 0;
	}
	foreach AllActors (class 'ScriptedPawn', S)
	{
		if (S != None)
			S.Destroy();
	}
	CalcEndStats();
	return true;
}

function PlayStartUpMessage(PlayerPawn NewPlayer)
{
	local int i;
	local color Green, DarkGreen;

	NewPlayer.ClearProgressMessages();

	Green.G = 255;
	Green.B = 128;
	DarkGreen.G = 200;
	DarkGreen.B = 64;

	NewPlayer.SetProgressColor(Green, i);

	NewPlayer.SetProgressMessage(GameName, i++);
	if ( bRequireReady && (Level.NetMode != NM_Standalone) )
	{
		NewPlayer.SetProgressColor(Green, i);
		NewPlayer.SetProgressMessage(TourneyMessage, i++);
	}
	else
	{
		NewPlayer.SetProgressColor(Green, i);
		NewPlayer.SetProgressMessage(StartUpMessage, i++);
	}

	if ( Level.NetMode == NM_Standalone )
		NewPlayer.SetProgressMessage(SingleWaitingMessage, i++);
}

function playerpawn Login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local PlayerPawn newPlayer;
	local NavigationPoint StartSpot;
	local int i;

	newPlayer = Super.Login(Portal, Options, Error, SpawnClass);
	if ( newPlayer == None)
		return None;

	PlayerTeamNum = NewPlayer.PlayerReplicationInfo.Team;

	if (bUseLives)
		if ( (NewPlayer != None) && !NewPlayer.IsA('Spectator') )
			NewPlayer.PlayerReplicationInfo.Deaths = MonsterReplicationInfo2(GameReplicationInfo).Lives;

	CountHunters();

	return newPlayer;
}

function bool RestartPlayer( pawn aPlayer )	
{
	local NavigationPoint startSpot;
	local bool foundStart;
	local Pawn P;

	if (MonsterReplicationInfo2(GameReplicationInfo).bUseLives)
	{
		if( bRestartLevel && Level.NetMode!=NM_DedicatedServer && Level.NetMode!=NM_ListenServer )
			return true;

		if ( aPlayer.PlayerReplicationInfo.Deaths < 1 )
		{
			BroadcastMessage(aPlayer.PlayerReplicationInfo.PlayerName$" has been lost!", true, 'MonsterCriticalEvent');
			For ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.bIsPlayer && (P.PlayerReplicationInfo.Deaths >= 1) )
					P.PlayerReplicationInfo.Deaths += 0.00001;
			if ( aPlayer.IsA('Bot') )
			{
				aPlayer.PlayerReplicationInfo.bIsSpectator = true;
				aPlayer.PlayerReplicationInfo.bWaitingPlayer = true;
				aPlayer.GotoState('GameEnded');
				return false;
			}
		}

		startSpot = FindPlayerStart(None, 255);
		if( startSpot == None )
			return false;
			
		foundStart = aPlayer.SetLocation(startSpot.Location);
		if( foundStart )
		{
			startSpot.PlayTeleportEffect(aPlayer, true);
			aPlayer.SetRotation(startSpot.Rotation);
			aPlayer.ViewRotation = aPlayer.Rotation;
			aPlayer.Acceleration = vect(0,0,0);
			aPlayer.Velocity = vect(0,0,0);
			aPlayer.Health = aPlayer.Default.Health;
			aPlayer.ClientSetRotation( startSpot.Rotation );
			aPlayer.bHidden = false;
			aPlayer.SoundDampening = aPlayer.Default.SoundDampening;
			if ( aPlayer.PlayerReplicationInfo.Deaths < 1 )
			{
				aPlayer.bHidden = true;
				aPlayer.PlayerRestartState = 'PlayerSpectating';
			} 
			else
			{
				aPlayer.SetCollision( true, true, true );
				AddDefaultInventory(aPlayer);
			}
		}
		return foundStart;
	}
	else 
		return Super.RestartPlayer(aPlayer);
}

function CheckEndGame()
{
	local Pawn PawnLink;
	local int StillPlaying;
	local bool bStillHuman;
	local bot B, D;

	if ( bGameEnded )
		return;

	LivePpl = 0;
	PlainPpl = 0;
	for ( PawnLink=Level.PawnList; PawnLink!=None; PawnLink=PawnLink.nextPawn )
		if ( PawnLink.bIsPlayer )
		{
			if ( ( PawnLink.PlayerReplicationInfo.Deaths >= 1 ) && 
				!PawnLink.PlayerReplicationInfo.bIsSpectator )
				LivePpl ++;
			if ( PawnLink.IsA('PlayerPawn') &&
				(PawnLink.PlayerReplicationInfo.Deaths >= 1) )
				PlainPpl ++;
		}

	if ( LivePpl < 1 )
		EndGame("No Hunters");
	else if ( PlainPpl < 1 )
	{
		for ( PawnLink=Level.PawnList; PawnLink!=None; PawnLink=PawnLink.NextPawn )
		{
			B = Bot(PawnLink);
			if ( (B != None) && (B.Health > 0) )
				B.SetOrders('Attack', None,true);
		}
	}		
}

function Killed( pawn killer, pawn Other, name damageType )
{
	Super(GameInfo).Killed(Killer, Other, DamageType);

   if ((Killer != None) && (Other !=None))    //added check for access nones showing on server logs
   {
      if ((Killer != Other) && (DamageType == 'Decapitated'))
      {
         if ( FRand() < 0.2 )
         	Killer.ReceiveLocalizedMessage(class'MH2HeadShotMessage');
	   }

   	if (!bFirstBlood)
   	{
      	if (Killer.bIsPlayer && (Killer != Other))
      	{
	      	bFirstBlood = True;
         	BroadcastLocalizedMessage(class'MH2FirstBloodMessage', 0, Killer.PlayerReplicationInfo);
      	}
   	}

   	if ( Killer == Other )
      	Other.PlayerReplicationInfo.Score -= 4;

   	if ( Killer.IsA('ScriptedPawn') && Other.bIsPlayer && !MonsterReplicationInfo2(GameReplicationInfo).bUseLives)
      	Other.PlayerReplicationInfo.Score -= 5;

   	if (MonsterReplicationInfo2(GameReplicationInfo).bUseLives && Other.bIsPlayer)
   	{
			Other.PlayerReplicationInfo.Deaths -= 1;
	   	CheckEndGame();
   	}
	}
}

function ScoreKill(pawn Killer, pawn Other)
{
   local ScriptedPawn S;
   local Pawn P;

   if ((Killer != none) && (Other != none))
   {
	   if ( (Killer == None) || (Killer == Other) || !Other.bIsPlayer || (Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team) )
		  	Super.ScoreKill(Killer, Other);

		if (Other.bIsPlayer && MonsterReplicationInfo2(GameReplicationInfo).bUseLives)
			Other.PlayerReplicationInfo.Deaths -= 1;

 		if(!Other.IsA('ScriptedPawn')) return;

		if(Killer!=None)
 		{
    		BroadcastMessage(Killer.GetHumanName()@"killed"$Other.GetHumanName());
    		countmonsters();
 		}

		if ( (Killer.bIsPlayer) && ( (Other.IsA('Titan')) || (Other.IsA('Queen')) || (Other.IsA('WarLord')) ) )
			Killer.PlayerReplicationInfo.Score += 4;
		if ( (Killer.bIsPlayer) && ( (Other.IsA('GiantGasBag')) || (Other.IsA('GiantManta')) ) )
			Killer.PlayerReplicationInfo.Score += 3;
		if ( (Killer.bIsPlayer) && ( (Other.IsA('SkaarjWarrior')) || (Other.IsA('MercenaryElite')) || (Other.IsA('Brute')) ) )
			Killer.PlayerReplicationInfo.Score += 2;
		if ( (Killer.bIsPlayer) && ( (Other.IsA('SkaarjTrooper')) || ( (Other.IsA('Mercenary')) && (!Other.IsA('MercenaryElite')) ) || (Other.IsA('Krall')) || (Other.IsA('Slith')) || ( (Other.IsA('GasBag')) && (!Other.IsA('GiantGasBag')) ) ) )
			Killer.PlayerReplicationInfo.Score += 1;

		if ( (Killer.bIsPlayer) && ( (Other.IsA('Nali')) || (Other.IsA('Cow')) || (Other.IsA('NaliRabbit')) ) )
			Killer.PlayerReplicationInfo.Score -= 6;
		else if (Killer == None && Other.IsA('ScriptedPawn'))		//La, la, la, losers, killing yourselves is a bit nasty
		{
			countmonsters();
			return;
		}							
  	}
}

function AddToTeam( int num, Pawn Other )
{
	local teaminfo aTeam;
	local Pawn P;
	local bool bSuccess;
	local string SkinName, FaceName;
	local int i;
	
	num = 0;
	
	if (MaxTeams == 1 || MaxAllowedTeams == 1)

   if ( Other != None )
	{
		aTeam = Teams[num];
		aTeam.Size++;
		Other.PlayerReplicationInfo.Team = num;
		Other.PlayerReplicationInfo.TeamName = aTeam.TeamName;
		bSuccess = false;
		if ( Other.IsA('PlayerPawn') && !Other.IsA('ScriptedPawn'))
		{
			Other.PlayerReplicationInfo.TeamID = 0;
		}

		while ( !bSuccess )
		{
			bSuccess = true;
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.bIsPlayer && (P != Other) && (!P.IsA('SkaarjTrooper')
					&& (P.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team)
					&& (P.PlayerReplicationInfo.TeamId == Other.PlayerReplicationInfo.TeamId) )  )
			{	
				Other.PlayerReplicationInfo.TeamID++;
				bSuccess = False;
			}
		}

		if (MonsterReplicationInfo2(GameReplicationInfo).bUseLives)
			Other.PlayerReplicationInfo.Deaths = MonsterReplicationInfo2(GameReplicationInfo).Lives;

		if (MonsterReplicationInfo2(GameReplicationInfo).bUseTeamSkins)
		{
			Other.static.GetMultiSkin(Other, SkinName, FaceName);
			Other.static.SetMultiSkin(Other, SkinName, FaceName, 0);
		}
	}
}

function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
    Damage = Super.ReduceDamage(Damage, DamageType, injured, instigatedBy);
    
    if ( instigatedBy == None )
        return Damage;

    if (injured.IsA('SkaarjTrooper'))
        return Damage;

    if ( (instigatedBy != injured) && injured.bIsPlayer && instigatedBy.bIsPlayer 
        && (injured.PlayerReplicationInfo.Team == instigatedBy.PlayerReplicationInfo.Team))
    {
        if ( injured.IsA('Bot') )
            Bot(Injured).YellAt(instigatedBy);
        return (Damage * FriendlyFireScale);
    }
    else
        return Damage;
}

function StartMatch()
{
	local Pawn P;
	local ScriptedPawn S;

	CountHunters();
	for (P=Level.PawnList; P!=None; P=P.NextPawn)
	{
	S=ScriptedPawn(P);
		if(S != None)	//Game has started - We turn back the Hate for humanity, 
		{
			if (S.Health >= 1 && !S.IsA('Nali') && !S.IsA('Cow') /*&& !S.IsA('NaliRabbit')*/)
			{
				S.AttitudeToPlayer=ATTITUDE_Hate;
			}
		}
	}
	super.StartMatch();
}

function Timer()
{
	CountHunters();
	Super.Timer();
}
function CountHunters()
{
	local Bot B;
	local TournamentPlayer TP;
	local Pawn P;

	HuntersTotal = 0;

	for (P=Level.PawnList; P!=None; P=P.NextPawn)
	{
	   B=Bot(P);
	   TP=TournamentPlayer(P);
	   
	   if ((B!=None) && (TP!=None))
		if (!TP.PlayerReplicationInfo.bIsSpectator || !B.PlayerReplicationInfo.bIsSpectator)
			HuntersTotal ++;
	}
	MonsterReplicationInfo2(GameReplicationInfo).Hunters = HuntersTotal;
}

function bool FindSpecialAttractionFor(Bot aBot)
{
	local MonsterWaypoint W;
	local MonsterEnd E;
	local MonsterWaypoint NextPoint;
	local bool bFound;
	local ScriptedPawn S;

	if ((aBot != None) && (aBot.Health < 1))
	{
		aBot.GotoState('GameEnded');
		return false;
	}

	if ( aBot.LastAttractCheck == Level.TimeSeconds )
		return false;

	if(aBot==None)
		return false;

	foreach AllActors( class'ScriptedPawn', S )
	{
		if ( S.CanSee(aBot) )
		{
			if ( ((S.Enemy == None) || ((S.Enemy.IsA('PlayerPawn')) || ((!S.Enemy.IsA('Spectator'))) && (FRand() >= 0.5))) && (S.Health >= 1) )
			{
				S.Hated = aBot;
				S.Enemy = aBot;
				aBot.Enemy = S;
				S.GotoState('Attacking');
				If (FRand() >= 0.35)
				{
					aBot.GotoState('Attacking');
					return false;
				}
			}
		}
		else
		if (aBot.CanSee(S) && (FRand() >= 0.35) && (S.Health >= 1))
		{
			aBot.Enemy = S;
			aBot.GotoState('Attacking');
			S.Enemy = aBot;
			S.GotoState('Attacking');
			return false;
		}
	}

	aBot.LastAttractCheck = Level.TimeSeconds;

	if ( (aBot.Orders == 'Attack') || ((aBot.Orders == 'Freelance') && (FRand() > 0.2)) )
	{
		foreach AllActors( class'MonsterWaypoint', W )
		{
			if (!W.bVisited && (W.Position == LastPoint + 1))
			{
				NextPoint = W;
				if ( aBot.ActorReachable(NextPoint) )
					aBot.MoveTarget = NextPoint;
				else
					aBot.MoveTarget = aBot.FindPathToward(NextPoint);
				NumPoints --;
				SetAttractionStateFor(aBot);
				return True;
			}
		}

		if (NumPoints <= 0)
		{
			foreach AllActors( class'MonsterEnd', E )
			{
				if ( aBot.ActorReachable(E) )
					aBot.MoveTarget = E;
				else
					aBot.MoveTarget = aBot.FindPathToward(E);
				SetAttractionStateFor(aBot);
				return True;
			}
		}
	}

	return false;
}

function ClearOrders(Pawn Leaving) //reservation, no problem next time will treat it as needed
{
	local Pawn P;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('Bot') && (Bot(P).OrderObject == Leaving) )
			Bot(P).SetOrders('Freelance', None);
}

function PickAmbushSpotFor(Bot aBot)
{
	local NavigationPoint N;

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
		if ( N.IsA('Ambushpoint') && !N.taken )
		{
			if ( aBot.Orders == 'Defend' )
			{
				if ( N.IsA('DefensePoint') && (DefensePoint(N).team == aBot.PlayerReplicationInfo.team) )
				{
					if ( (DefensePoint(aBot.Ambushspot) == None)
						|| (DefensePoint(N).priority > DefensePoint(aBot.Ambushspot).priority) )
						aBot.Ambushspot = Ambushpoint(N);
					else if ( (DefensePoint(N).priority == DefensePoint(aBot.Ambushspot).priority)
						&& (FRand() < 0.4) ) 
						aBot.Ambushspot = Ambushpoint(N);
				}		
				else if ( (DefensePoint(aBot.AmbushSpot) == None)
						&& (VSize(N.Location - aBot.OrderObject.Location) < 1500)
						&& FastTrace(aBot.OrderObject.Location, N.Location)
						&& ((aBot.Ambushspot == None) || (FRand() < 0.5)) )
							aBot.Ambushspot = Ambushpoint(N);
			}
			else if ( (aBot.AmbushSpot == None)
				|| (VSize(aBot.Location - aBot.Ambushspot.Location)
					 > VSize(aBot.Location - N.Location)) )
				aBot.Ambushspot = Ambushpoint(N);
		}
}       

simulated function Tick (float DT)
{
	Super.Tick(DT);
	if ( Level.Game.bGameEnded ) return;

	if ( (LastMonsterAttackTime + 0.3) < Level.TimeSeconds )
		MonsterAttackCheck();
	if ( LastMadTime < Level.TimeSeconds )
		MadStop();
}

function bool NeverStakeOut(Bot Other)
{
	if ( Other.Region.Zone.bWaterZone || Other.Region.Zone.IsA('KillingField') )
		return True;
	return False;
}

function bool CanStakeOut(ScriptedPawn Other)
{
	if ( Other.Region.Zone.bWaterZone || Other.Region.Zone.IsA('KillingField') )
		return False;
	return True;
}

function MadStop()
{
	local Pawn P;
	local ScriptedPawn S;

	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
	S = ScriptedPawn(P);
		if ( S != None && S.Enemy != None && S.Enemy.Health <= 0 )
		{
		S.Hated = None;
		S.Enemy = None;
		S.bHunting = False;
		S.Target = None;
		S.bReadyToAttack = False;
		if (S.OldEnemy != None && S.OldEnemy.Health <= 0)
		{
			S.OldEnemy = None;
		}
		S.GoToState('Waiting','');
		}
	}
	LastMadTime = Level.TimeSeconds;
}

function MonsterAttackCheck()
{
	local Pawn P;
	local ScriptedPawn S;
	local Queen Q;

	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		S = ScriptedPawn(P);
		if ( S != None && S.Enemy != None && S.Enemy.IsA('ScriptedPawn') && !S.IsA('Nali') && !S.IsA('Cow') && !S.Enemy.IsA('Nali') && !S.Enemy.IsA('Cow'))
		{
			S.Hated = None;
			S.Enemy = None;
			S.Target = None;
			S.bHunting = False;
			S.bReadyToAttack = False;
			if (S.OldEnemy != None && S.OldEnemy.IsA('ScriptedPawn'))
			{
				S.OldEnemy = None;
			}
			S.GoToState('Waiting','');
		}
		if ( S != None && !S.IsA('Nali') && !S.IsA('Cow'))
		{
			if (S.TeamTag != 'Mns')
			SetPawnDifficulty(MonsterSkill, S);
		}
	}
	LastMonsterAttackTime = Level.TimeSeconds;
}

function countmonsters()
{
	local Pawn P;
	local ScriptedPawn S;

	MonstersTotal = 0;

	for (P=Level.PawnList; P!=None; P=P.NextPawn)
	{
		S=ScriptedPawn(P);
		if (S != None)
		{   
			if (S.Health >= 1)
			MonstersTotal ++;
		}
	}
	MonsterReplicationInfo2(GameReplicationInfo).Monsters = MonstersTotal;
}


defaultproperties
{
	bCanChangeSkin=True
	MonsterSkill=7
   Lives=30
   TimeOutMessage="Times up, you failed!"
   bSpawnInTeamArea=True
   bBalanceTeams=False
   bPlayersBalanceTeams=False
   MaxTeams=1
   MaxAllowedTeams=1
   MaxTeamSize=24
   StartUpTeamMessage="Welcome to the server!"
   FragLimit=0
   NetWait=2
   RestartWait=5
   bUseTranslocator=False
   StartUpMessage="Use your skills to defeat the monsters and solve the puzzles!"
   StartMessage="The game has been started!"
   GameEndedMessage="You have won!!!"
   SingleWaitingMessage="Press Fire to start the game."
   ExplodeMessage=" was blown up"
   BurnedMessage=" was incinerated"
   CorrodedMessage=" was slimed"
   HackedMessage=" was hacked"
   bNoMonsters=False
   bCoopWeaponMode=True
   DefaultWeapon=Class'Botpack.SniperRifle'
   ScoreBoardType=Class'MonsterHunt2Lite.MH2ScoreBoard'
   BotMenuType="MonsterHunt2Lite.Monster2BotConfig"
   RulesMenuType="MonsterHunt2Lite.MonsterHuntRules"
   SettingsMenuType="MonsterHunt2Lite.Monster2Settings"
   HUDType=Class'MonsterHunt2Lite.MH2HUD'
   MapListType=Class'MonsterHunt.MonsterMapList'
   MapPrefix="MH"
   BeaconName="MH"
   LeftMessage=" left the game (Quitter!)."
   EnteredMessage=" has joined the game!"
   GameName="MonsterHunt"
   DMMessageClass=Class'MonsterHunt2Lite.HuntMessage'
   MutatorClass=Class'MonsterHunt2Lite.MH2Base'
   GameReplicationInfoClass=Class'MonsterHunt.MonsterReplicationInfo2'
   MaxMonsterHealth=5000.00
}
