
class Dog expands ScriptedPawn;

#exec TEXTURE IMPORT NAME=Dog FILE=Textures\Dog.bmp GROUP=Skins FLAGS=2

#exec MESH MODELIMPORT MESH=Dog MODELFILE=Models\Dog.psk
//add
#Exec MESH LODPARAMS MESH=Dog STRENGTH=1
#exec MESH ORIGIN MESH=Dog X=0 Y=0 Z=50 YAW=-64 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=Dog X=1.0 Y=1.0 Z=1.0
//#exec ANIM IMPORT ANIM=animDog ANIMFILE=Models\animDog.psa COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec ANIM IMPORT ANIM=animDog ANIMFILE=Models\animDog.psa IMPORTSEQS=0

#exec ANIM SEQUENCE ANIM=animDog  SEQ=All 			STARTFRAME=0 	NUMFRAMES=700
#exec ANIM SEQUENCE ANIM=animDog  SEQ=lay_in 		STARTFRAME=0 	NUMFRAMES=61
#exec ANIM SEQUENCE ANIM=animDog  SEQ=lay_on 		STARTFRAME=61 	NUMFRAMES=61
#exec ANIM SEQUENCE ANIM=animDog  SEQ=Lay_out 		STARTFRAME=122 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=animDog  SEQ=run_scared 	STARTFRAME=153 NUMFRAMES=20
#exec ANIM SEQUENCE ANIM=animDog  SEQ=pounce 		STARTFRAME=173 NUMFRAMES=39
#exec ANIM SEQUENCE ANIM=animDog  SEQ=Die 			STARTFRAME=212 NUMFRAMES=24
#exec ANIM SEQUENCE ANIM=animDog  SEQ=Walk 			STARTFRAME=236 NUMFRAMES=33
#exec ANIM SEQUENCE ANIM=animDog  SEQ=Run 			STARTFRAME=269 NUMFRAMES=20
#exec ANIM SEQUENCE ANIM=animDog  SEQ=stand 			STARTFRAME=289 NUMFRAMES=143
#exec ANIM SEQUENCE ANIM=animDog  SEQ=bark 			STARTFRAME=432 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=animDog  SEQ=piss 			STARTFRAME=463 NUMFRAMES=101
#exec ANIM SEQUENCE ANIM=animDog  SEQ=attack 		STARTFRAME=564 NUMFRAMES=35
#exec ANIM SEQUENCE ANIM=animDog  SEQ=limp 			STARTFRAME=599 NUMFRAMES=101

#exec ANIM DIGEST ANIM=animDog
#exec MESH DEFAULTANIM MESH=Dog ANIM=animDog
#Exec MESHMAP NEW MESHMAP=Dog MESH=Dog

#Exec MESHMAP SCALE MESHMAP=Dog X=1.0 Y=1.0 Z=1.0
#EXEC MESHMAP SETTEXTURE MESHMAP=Dog NUM=0 TEXTURE=Dog



#exec AUDIO IMPORT FILE="Sounds\dog_bark1.WAV"      	NAME="dog_bark1"
#exec AUDIO IMPORT FILE="Sounds\dog_bark2.WAV"      	NAME="dog_bark2"
#exec AUDIO IMPORT FILE="Sounds\dog_bark3.WAV"      	NAME="dog_bark3"
#exec AUDIO IMPORT FILE="Sounds\dog_biting2.WAV"    	NAME="dog_biting2"
#exec AUDIO IMPORT FILE="Sounds\dog_biting3.WAV"    	NAME="dog_biting3"
#exec AUDIO IMPORT FILE="Sounds\dog_die.WAV"      		NAME="dog_die"
#exec AUDIO IMPORT FILE="Sounds\dog_growl2.WAV"       NAME="dog_growl2"
#exec AUDIO IMPORT FILE="Sounds\dog_growl3.WAV"       NAME="dog_growl3"
#exec AUDIO IMPORT FILE="Sounds\dog_hit1.WAV"       	NAME="dog_hit1"
#exec AUDIO IMPORT FILE="Sounds\dog_hit2.WAV"       	NAME="dog_hit2"
#exec AUDIO IMPORT FILE="Sounds\dog_meanbark2.WAV"    NAME="dog_meanbark2"
#exec AUDIO IMPORT FILE="Sounds\dog_pant.WAV"       	NAME="dog_pant"
#exec AUDIO IMPORT FILE="Sounds\dog_sniffing.WAV"     NAME="dog_sniffing"
#exec AUDIO IMPORT FILE="Sounds\dog_whimper2.WAV"     NAME="dog_whimper2"
#exec AUDIO IMPORT FILE="Sounds\dog_yell.WAV"       	NAME="dog_yell"


var(Sounds) sound bite;
var(Sounds) sound stab;
var(Sounds) sound lunge;
var(Sounds) sound chew;
var(Sounds) sound tear;
var(Sounds) sound MeleeSound;


function PostBeginPlay()
{
	Super.PostBeginPlay();
	MaxDesiredSpeed = 0.7 + 0.1 * skill;
}

function JumpOffPawn()
{
	Super.JumpOffPawn();
	PlayAnim('attack', 1.0, 0.2);
}

function SetMovementPhysics()
{
	SetPhysics(PHYS_Falling);
}

function eAttitude AttitudeToCreature(Pawn Other)
{
	if ( Other.IsA('Dog') )
		return ATTITUDE_Friendly;
	else if ( Other.IsA('HellHound') )
		return ATTITUDE_Friendly;
//	else if ( Other.IsA('ScriptedPawn') )
//		return ATTITUDE_Hate;
}

function PlayMeleeAttack()
{
	MeleeDamageTarget(55,vect(0,0,0) );
    PlaySound(MeleeSound, SLOT_Interact);
    PlayAnim('attack');
}

function PlayWaiting()
{
	local float decision;
	local float animspeed;
	animspeed = 0.4 + 0.6 * FRand();
	decision = FRand();
	if ( !bool(NextAnim) || (decision < 0.4) ) //pick first waiting animation
	{
		if ( !bQuiet )
			PlaySound(Chew, SLOT_Talk, 0.7,,800);
		NextAnim = 'lay_in';
	}
	else if (decision < 0.55)
		NextAnim = 'lay_on';
	else if (decision < 0.7)
	{
		if ( !bQuiet )
			PlaySound(Stab, SLOT_Talk, 0.7,,800);
		NextAnim = 'lay_out';
	}
	else if (decision < 0.7)
		NextAnim = 'Piss';
	else
		NextAnim = 'Bark';

	LoopAnim(NextAnim, animspeed);
}

function PlayPatrolStop()
{
	PlayWaiting();
}

function PlayWaitingAmbush()
{
	PlayWaiting();
}

function PlayChallenge()
{
		PlayAnim('Bark');
}

function TweenToFighter(float tweentime)
{
	TweenAnim('Bark', tweentime);
}

function TweenToRunning(float tweentime)
{
	if (AnimSequence != 'Run' || !bAnimLoop)
		TweenAnim('Run', tweentime);
}

function TweenToWalking(float tweentime)
{
	TweenAnim('Walk', tweentime);
}

function TweenToWaiting(float tweentime)
{
	TweenAnim('Limp', tweentime);
}

function TweenToPatrolStop(float tweentime)
{
	TweenAnim('Stand', tweentime);
}

function PlayRunning()
{
	PlaySound(sound'WalkC', SLOT_Interact);
	LoopAnim('Run', -4.0/GroundSpeed,,0.4);
}

function PlayWalking()
{
	PlaySound(sound'walkc', SLOT_Interact);
	LoopAnim('Walk', -4.0/GroundSpeed,,0.4);
}

function PlayThreatening()
{
	PlayWaiting();
}

function PlayTurning()
{
	TweenAnim('pounce', 0.3);
}

function PlayDying(name DamageType, vector HitLocation)
{

	PlaySound(Die, SLOT_Talk, 3.5);
   PlayAnim('Die', 0.7, 0.1);
}

function PlayTakeHit(float tweentime, vector HitLoc, int damage)
{
	PlayAnim('Bark');
}

function PlayVictoryDance()
{
	PlayAnim('Piss', 1.0, 0.1);
}

auto state StartUp
{
	function SetMovementPhysics()
	{
		SetPhysics(PHYS_None); // don't fall at start
	}
}

state Waiting
{
TurnFromWall:
	WaitForLanding();
	if ( NearWall(70) )
	{
		PlayTurning();
		TurnTo(Focus);
	}
	Disable('Bump');
	Timer();
Begin:
	WaitForLanding();
	TweenToWaiting(0.4);
	bReadyToAttack = false;
	if (Physics != PHYS_Falling)
		SetPhysics(PHYS_None);
KeepWaiting:
	NextAnim = '';
}

defaultproperties
{
    Bite=Sound'P2Animals.dog_meanbark2'
    Stab=Sound'P2Animals.dog_sniffing'
    Chew=Sound'P2Animals.dog_whimper2'
    Tear=Sound'P2Animals.dog_yell'
    MeleeSound=Sound'P2Animals.dog_biting3'
    Aggressiveness=3.40
    Acquire=Sound'P2Animals.dog_biting2'
    Fear=Sound'P2Animals.dog_pant'
    Roam=Sound'P2Animals.dog_bark1'
    Threaten=Sound'P2Animals.dog_growl3'
    bCanStrafe=True
    MeleeRange=43.00
    GroundSpeed=600.00
    JumpZ=431.00
    SightRadius=4300.00
    BaseEyeHeight=18.00
    Health=240
    ReducedDamageType=All
    ReducedDamagePct=0.30
    Intelligence=BRAINS_MAMMAL
    HitSound1=Sound'P2Animals.dog_hit1'
    HitSound2=Sound'P2Animals.dog_hit2'
    Die=Sound'P2Animals.dog_die'
    CombatStyle=1.00
    MenuName="Dog"
    DrawType=DT_Mesh
    Texture=None
    Mesh=SkeletalMesh'Dog'
    DrawScale=1.60
    CollisionRadius=28.00
    CollisionHeight=69.00
    Mass=110.00
}
