//==============================================================================
//  Done by gopostal      agutgopostal@hotmail.com
//  BIG shout to Iniquitous for help and guidance
//
//	20110315 Helen - added RadarRange as a config option
//	20110906 Helen - Did some overrides so that translocator is still shown for
//					 a player who plays with weapon hand hidden, and radar is on.
//				   - Also SetHand() now calls the correct Super class.
//	20120512 Helen - RadarOn and RadarRange are now obtained and replicated via an
//					 instance of medWarReplicationInfo.
//==============================================================================

class DTranslocator extends Translocator;

//Needed text for radar
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontSmall"  Height=8  USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontMedium" Height=10 USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontLarge"  Height=12 USize=256 VSize=256 CharactersPerPage=256
#exec Texture Import Name=TeamBeacon2 File="Textures\TeamBeacon2.bmp" Flags=2

var string mPackage;
var cmmReplicationY mWarInfo;

var DTranslocatorTarget TTarget;
var float TossForce, FireDelay;
var Weapon PreviousWeapon;
var Actor DesiredTarget;
var float MaxTossForce;
var bool bBotMoveFire, bTTargetOut;

var bool RadarOn;
var float RadarRange;

var color GreenColor, BeaconColor;
var Texture TeamBeaconIcon;
var int d;

replication
{
	reliable if ( bNetOwner && (Role == ROLE_Authority) )
		bTTargetOut;
}

simulated function PreBeginPlay()
{
	mPackage = class'cmmCommon'.static.GetPackageName(string(self.class));
}

simulated function PostBeginPlay()
{
	foreach AllActors(class'cmmReplicationY', mWarInfo)
	{
		if(mPackage ~= class'cmmCommon'.static.GetPackageName(string(mWarInfo.class)))
			break;
		mWarInfo = None;
	}

	if(mWarInfo != None)
	{
		RadarOn = mWarInfo.tRadarOn;
		RadarRange = class'cmmCommon'.static.ValidateFloat(mWarInfo.tRadarRange, Default.RadarRange, 100, 50000);
	}
}

simulated function PostRender( canvas Canvas )
{
   local Pawn thisPawn;
   local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
   local rotator CamRot;
   local Actor Camera;
   local float BaseBeaconScale, BeaconScale, Dist, DistScale;
   local float TanFOVx, TanFOVy;
   local float TanX, TanY;
   local float dx, dy, FontY;
   local string BeaconText;
   
   Canvas.Style = ERenderStyle.STY_Masked;

   if (Canvas.ClipX > 1024)
      Canvas.Font = Font'BeaconNameFontLarge';
   else if (Canvas.ClipX > 640)
      Canvas.Font = Font'BeaconNameFontMedium';
   else
      Canvas.Font = Font'BeaconNameFontSmall';
	
   Canvas.SetPos(0, 0);
   Canvas.TextSize("X", dx, FontY);
   BaseBeaconScale = 1.5 * FontY / Texture'TeamBeacon2'.VSize;

   Canvas.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

   TanFOVx = Tan(Canvas.ViewPort.Actor.FOVAngle / 114.591559);
   TanFOVy = (Canvas.ClipY / Canvas.ClipX) * TanFOVx;
   GetAxes(CamRot, X, Y, Z);

   Canvas.bNoSmooth = False;
   Canvas.Style = ERenderStyle.STY_Masked;

   foreach RadiusActors(class 'Pawn', thisPawn, RadarRange)
   {
      if ( thisPawn != none && thisPawn != Camera && thisPawn.Health > 0 && !thisPawn.bHidden)
      {
         TargetDir = thisPawn.Location - CamLoc;
	 		Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);
	 		TargetDir = Normal(TargetDir + vect(0,0,1) * thisPawn.CollisionHeight);
	 		DistScale = FMin(100.0 * thisPawn.CollisionRadius / Dist, 1.0);
	 		d = Dist;

	 		if (DistScale > 0.0 && TargetDir dot X > 0) 
			// These checks removed to allow wall hack
			// && (FastTrace(thisPawn.Location, CamLoc) || FastTrace(thisPawn.Location + vect(0,0,0.8) * thisPawn.CollisionHeight, CamLoc)))
         {
	    		BeaconScale = BaseBeaconScale * DistScale;
	   	 	Dir = X * (X dot TargetDir);
	    		XY = TargetDir - Dir;

	    		dx = Canvas.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
	    		dy = Canvas.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));

	    		Canvas.SetPos(dx - 0.5 * BeaconScale * TeamBeaconIcon.USize, dy - 2 * FontY * DistScale);

	    		if (DistScale <= 1.0)
            {
	       		if (Canvas.ClipX > 600)
		  				BeaconText = "" $ d $ "";
               Canvas.DrawIcon(texture'CrossHair6', 1.0);
	       		Canvas.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize + 1, dy - 1.75 * FontY + 1);
	       		Canvas.DrawTextClipped(BeaconText, False);
            }
         }
      }
   }
}

function setHand(float Hand)
{
	Hand = AdjustHand(Hand);

	if ( Hand != 2 )
	{
		if ( Hand == 0 )
			Hand = 1;
		else
			Hand *= -1;

		if ( Hand == -1 )
			Mesh = mesh(DynamicLoadObject("Botpack.TranslocR", class'Mesh'));
		else
			Mesh = mesh'Botpack.Transloc';
	}

	// Make sure to call the correct class.
	Super(Weapon).SetHand(Hand);
}

// Problem: If a player plays with weapon hand hidden, they don't see the radar
// drawn for them because the render won't be called. Since the radar is a huge
// advantage (when turned on), the player will have to live with the fact that
// we need to draw the translocator in order to give them the radar.
simulated function float AdjustHand(float Hand)
{
	/* Values for Hand
	 0 = center
	 1 = Left
	-1 = right
	 2 = hidden
	*/
	if(RadarOn && (Hand == 2))
		Hand = 1;

	return Hand;
}

// I brought in this entire method so I could change the value of Handedness if necessary.
simulated event RenderOverlays( canvas Canvas )
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	if ( bHideWeapon || (Owner == None) )
		return;

	PlayerOwner = PlayerPawn(Owner);

	if ( PlayerOwner != None )
	{
		if ( PlayerOwner.DesiredFOV != PlayerOwner.DefaultFOV )
			return;
		bPlayerOwner = true;
		Hand = AdjustHand(PlayerOwner.Handedness);

		if ( (Level.NetMode == NM_Client) && (Hand == 2) )
		{
			bHideWeapon = true;
			return;
		}
	}

	if ( !bPlayerOwner || (PlayerOwner.Player == None) )
		Pawn(Owner).WalkBob = vect(0,0,0);

	if ( (bMuzzleFlash > 0) && bDrawMuzzleFlash && Level.bHighDetailMode && (MFTexture != None) )
	{
		MuzzleScale = Default.MuzzleScale * Canvas.ClipX/640.0;
		if ( !bSetFlashTime )
		{
			bSetFlashTime = true;
			FlashTime = Level.TimeSeconds + FlashLength;
		}
		else if ( FlashTime < Level.TimeSeconds )
			bMuzzleFlash = 0;
		if ( bMuzzleFlash > 0 )
		{
			if ( Hand == 0 )
				Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
			else
				Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * FlashY);

			Canvas.Style = 3;
			Canvas.DrawIcon(MFTexture, MuzzleScale);
			Canvas.Style = 1;
		}
	}
	else
		bSetFlashTime = false;

	SetLocation( Owner.Location + CalcDrawOffset() );
	NewRot = Pawn(Owner).ViewRotation;

	if ( Hand == 0 )
		newRot.Roll = -2 * Default.Rotation.Roll;
	else
		newRot.Roll = Default.Rotation.Roll * Hand;

	setRotation(newRot);
	Canvas.DrawActor(self, false);
}

function float RateSelf( out int bUseAltMode )
{
	return -2;
}

function BringUp()
{
	PreviousWeapon = None;
	Super.BringUp();
}

function RaiseUp(Weapon OldWeapon)
{
	if ( OldWeapon == self )
		PreviousWeapon = None;
	else
		PreviousWeapon = OldWeapon;
	Super.BringUp();
}

// return delta to combat style
function float SuggestAttackStyle()
{
	local float EnemyDist;

	if ( bTTargetOut )
		return -0.6;

	EnemyDist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
	if ( EnemyDist < 700 )
		return 1.0;
	else
		return -0.2;
}

function float SuggestDefenseStyle()
{
	if ( bTTargetOut )
		return 0;

	return -0.6;
}

function bool HandlePickupQuery( inventory Item )
{
	if ( Item.IsA('DTranslocatorTarget') && (item == TTarget) )
	{
		TTarget.Destroy();
		TTarget = None;
		bTTargetOut = false;
		return true;
	}

	return Super.HandlePickupQuery(Item);
}

function Destroyed()
{
	Super.Destroyed();
	if ( TTarget != None )
		TTarget.Destroy();
}

function SetSwitchPriority(pawn Other)
{
	AutoSwitchPriority = 0;
}

simulated function ClientWeaponEvent(name EventType)
{
	if ( EventType == 'TouchTarget' )
		PlayIdleAnim();
}

function Fire( float Value )
{
	if ( bBotMoveFire )
		return;
	if (  TTarget == None )
	{
		if ( Level.TimeSeconds - 0.5 > FireDelay )
		{
			bPointing=True;
			bCanClientFire = true;
			ClientFire(value);
			Pawn(Owner).PlayRecoil(FiringSpeed);
			ThrowTarget();
			FireDelay = Level.TimeSeconds + 0.1;
		}
	}
	else if ( TTarget.SpawnTime < Level.TimeSeconds - 0.8 )
	{
		if ( TTarget.Disrupted() )
		{
			if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogSpecialEvent("translocate_gib", Pawn(Owner).PlayerReplicationInfo.PlayerID);
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogSpecialEvent("translocate_gib", Pawn(Owner).PlayerReplicationInfo.PlayerID);

			Pawn(Owner).PlaySound(sound'TDisrupt', SLOT_None, 4.0);
			Pawn(Owner).PlaySound(sound'TDisrupt', SLOT_Misc, 4.0);
			Pawn(Owner).PlaySound(sound'TDisrupt', SLOT_Interact, 4.0);
			Pawn(Owner).gibbedBy(TTarget.disruptor);
			return;
		}
		Owner.PlaySound(AltFireSound, SLOT_Misc, 4 * Pawn(Owner).SoundDampening);
		bTTargetOut = false;
		TTarget.Destroy();
		TTarget = None;
		FireDelay = Level.TimeSeconds;
	}

	GotoState('NormalFire');
}

simulated function bool ClientFire(float Value)
{
	if ( !bTTargetOut && bCanClientFire && (Level.TimeSeconds - 0.5 > FireDelay) )
	{
		PlayFiring();
		FireDelay = Level.TimeSeconds + 0.1;
		return true;
	}
	return false;
}

simulated function bool ClientAltFire( float Value )
{
	return true;
}

function SpawnEffect(vector Start, vector Dest)
{
	local actor e;

	e = Spawn(class'TranslocOutEffect',,,start, Owner.Rotation);
	e.Mesh = Owner.Mesh;
	e.Animframe = Owner.Animframe;
	e.Animsequence = Owner.Animsequence;
	e.Velocity = 900 * Normal(Dest - Start);
}

function Translocate()
{
	local vector Dest, Start;
	local Bot B;
	local Pawn P;
	//local Pawn SP;

	bBotMoveFire = false;
	PlayAnim('Thrown', 1.2,0.1);
	Dest = TTarget.Location;
	if ( TTarget.Physics == PHYS_None )
		Dest += vect(0,0,40);

	if ( Level.Game.IsA('DeathMatchPlus')
		&& !DeathMatchPlus(Level.Game).AllowTranslocation(Pawn(Owner), Dest) )
		return;

	Start = Pawn(Owner).Location;
	TTarget.SetCollision(false,false,false);

//trace can return HitLocation and HitNormal if I need those, Location.Z+200 is where to end ...
///the trace(code might be wrong might be like Location + 200 * Z)...
//...Location is the start of the trace, true means it will check for actors, vect(20,20,20) is specifying ...
//a size of the trace (like a box. these are the dimensions of the box)...
//imagine a long square tube.

	foreach RadiusActors(class'Pawn', P, 100, TTarget.location)
	{
		if((P != None) && (Pawn(Owner) !=P))
		{
			BroadcastLocalizedMessage( class'NoTransMessage',,, None, None );
			return;
		}
	}


	if ( Pawn(Owner).SetLocation(Dest) )
	{
		if ( !Owner.Region.Zone.bWaterZone )
			Owner.SetPhysics(PHYS_Falling);
		if ( TTarget.Disrupted() )
		{
			if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogSpecialEvent("translocate_gib", Pawn(Owner).PlayerReplicationInfo.PlayerID);
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogSpecialEvent("translocate_gib", Pawn(Owner).PlayerReplicationInfo.PlayerID);

			SpawnEffect(Start, Dest);
			Pawn(Owner).gibbedBy(TTarget.disruptor);
			return;
		}

		if ( !FastTrace(Pawn(Owner).Location, TTarget.Location) )
		{
			if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogSpecialEvent("translocate_fail", Pawn(Owner).PlayerReplicationInfo.PlayerID);
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogSpecialEvent("translocate_fail", Pawn(Owner).PlayerReplicationInfo.PlayerID);

			Pawn(Owner).SetLocation(Start);
			Owner.PlaySound(AltFireSound, SLOT_Misc, 4 * Pawn(Owner).SoundDampening);
		}
		else
		{
			if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogSpecialEvent("translocate", Pawn(Owner).PlayerReplicationInfo.PlayerID);
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogSpecialEvent("translocate", Pawn(Owner).PlayerReplicationInfo.PlayerID);

			Owner.Velocity.X = 0;
			Owner.Velocity.Y = 0;
			B = Bot(Owner);
			if ( B != None )
			{
				if ( TTarget.DesiredTarget.IsA('NavigationPoint') )
					B.MoveTarget = TTarget.DesiredTarget;
				B.bJumpOffPawn = true;
				if ( !Owner.Region.Zone.bWaterZone )
					B.SetFall();
			}
			else
			{
				// bots must re-acquire this player
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
					if ( (P.Enemy == Owner) && P.IsA('Bot') )
						Bot(P).LastAcquireTime = Level.TimeSeconds;
			}

			Level.Game.PlayTeleportEffect(Owner, true, true);
			SpawnEffect(Start, Dest);
		}
	}
	else
	{
		Owner.PlaySound(AltFireSound, SLOT_Misc, 4 * Pawn(Owner).SoundDampening);
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogSpecialEvent("translocate_fail", Pawn(Owner).PlayerReplicationInfo.PlayerID);
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogSpecialEvent("translocate_fail", Pawn(Owner).PlayerReplicationInfo.PlayerID);
	}

	if ( TTarget != None )
	{
		bTTargetOut = false;
		TTarget.Destroy();
		TTarget = None;
	}
	bPointing=True;
}

function AltFire( float Value )
{
	if ( bBotMoveFire )
		return;

	GotoState('NormalFire');

	if ( TTarget != None )
		Translocate();
}

function ReturnToPreviousWeapon()
{
	if ( (PreviousWeapon == None) || ((PreviousWeapon.AmmoType != None) && (PreviousWeapon.AmmoType.AmmoAmount <=0)) )
		Pawn(Owner).SwitchToBestWeapon();
	else
	{
		Pawn(Owner).PendingWeapon = PreviousWeapon;
		PutDown();
	}
}

simulated function PlayFiring()
{
	PlayOwnedSound(FireSound, SLOT_Misc, 4 * Pawn(Owner).SoundDampening);
	PlayAnim('Throw',1.0,0.1);
}

function ThrowTarget()
{
	local Vector Start, X,Y,Z;

	if (Level.Game.LocalLog != None)
		Level.Game.LocalLog.LogSpecialEvent("throw_translocator", Pawn(Owner).PlayerReplicationInfo.PlayerID);
	if (Level.Game.WorldLog != None)
		Level.Game.WorldLog.LogSpecialEvent("throw_translocator", Pawn(Owner).PlayerReplicationInfo.PlayerID);

	if ( Owner.IsA('Bot') )
		bBotMoveFire = true;
	Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
	Pawn(Owner).ViewRotation = Pawn(Owner).AdjustToss(TossForce, Start, 0, true, true);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	TTarget = Spawn(class'DTranslocatorTarget',,, Start);
	if (TTarget!=None)
	{
		bTTargetOut = true;
		TTarget.Master = self;
		if ( Owner.IsA('Bot') )
			TTarget.SetCollisionSize(0,0);
		TTarget.Throw(Pawn(Owner), MaxTossForce, Start);
	}
	else
	{
		GotoState('Idle');
	}
}

state NormalFire
{
	ignores fire, altfire, AnimEnd;

	function bool PutDown()
	{
		GotoState('DownWeapon');
		return True;
	}

Begin:
	if ( Owner.IsA('Bot') )
		Bot(Owner).SwitchToBestWeapon();
	Sleep(0.1);
	if ( (Pawn(Owner).bFire != 0) && (Pawn(Owner).bAltFire != 0) )
		ReturnToPreviousWeapon();
	GotoState('Idle');
}

state Idle
{
	function AnimEnd()
	{
		PlayIdleAnim();
	}

	function bool PutDown()
	{
		GotoState('DownWeapon');
		return True;
	}

Begin:
	bPointing=False;
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	if ( Pawn(Owner).bAltFire!=0 ) AltFire(0.0);
	Disable('AnimEnd');
	FinishAnim();
	PlayIdleAnim();
}

///////////////////////////////////////////////////////////
simulated function PlayIdleAnim()
{
	if ( Mesh == PickupViewMesh )
		return;
	if ( bTTargetOut )
		LoopAnim('Idle', 0.4);
	else
		LoopAnim('Idle2',0.2,0.1);
	Enable('AnimEnd');
}

simulated function PlaySelect()
{
	bForceFire = false;
	bForceAltFire = false;
	if ( bTTargetOut )
		TweenAnim('ThrownFrame', 0.27);
	else
		PlayAnim('Select',1.1, 0.0);
	PlaySound(SelectSound, SLOT_Misc,Pawn(Owner).SoundDampening);
}

simulated function TweenDown()
{
	if ( IsAnimating() && (AnimSequence != '') && (GetAnimGroup(AnimSequence) == 'Select') )
		TweenAnim( AnimSequence, AnimFrame * 0.36 );
	else
	{
		if ( bTTargetOut )
			PlayAnim('Down2', 1.1, 0.05);
		else
			PlayAnim('Down', 1.1, 0.05);
	}
}

simulated function PlayPostSelect()
{
	local actor RealTarget;

	if ( Level.NetMode == NM_Client )
	{
		Super.PlayPostSelect();
		return;
	}

	// If Bot is wanting a specific target fired at, do it
	if ( DesiredTarget != None )
	{
		TossForce = MaxTossForce;
		RealTarget = Owner.Target;
		Owner.Target = DesiredTarget;
		ThrowTarget();
		PlayFiring();
		Owner.Target = RealTarget;
		TTarget.DesiredTarget = DesiredTarget;
		DesiredTarget = None;
	}
}

defaultproperties
{
	MaxTossForce=1000.00
	RadarOn=True
	PickupMessage="You got the Pirate Trans Source Module."
	ItemName="Pirate Trans"
	RadarRange=7000
	BeaconColor=(R=0,G=150,B=0,A=0),
	GreenColor=(R=0,G=255,B=0,A=0),
	TeamBeaconIcon=Texture'TeamBeacon2'
}
