class MDeemerSkin extends TournamentPickup;

var Weapon MDeemerWeapon;
var sound ExtraFireSound;
var sound EndFireSound;
var int FinalCount;

singular function UsedUp()
{
	if ( MDeemerWeapon != None )
	{
		MDeemerWeapon.SetDefaultDisplayProperties();
		if ( MDeemerWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(MDeemerWeapon).Affector = None;
	}
	if ( Owner != None )
	{
		if ( Owner.bIsPawn )
		{
			if ( !Pawn(Owner).bIsPlayer || (Pawn(Owner).PlayerReplicationInfo.HasFlag == None) )
			{
				Owner.AmbientGlow = Owner.Default.AmbientGlow;
				Owner.LightType = LT_None;
			}
			Pawn(Owner).DamageScaling = 1.0;
		}
		bActive = false;
		if ( Owner.Inventory != None )
		{
			Owner.Inventory.SetOwnerDisplay();
			Owner.Inventory.ChangedWeapon();
		}
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogItemDeactivate(Self, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogItemDeactivate(Self, Pawn(Owner));
	}
	Destroy();
}

function SetMDeemerWeapon()
{
	if ( !bActive )
		return;

//    SetOwnerLighting();

	// Make old weapon normal again.
	if ( MDeemerWeapon != None )
	{
		MDeemerWeapon.SetDefaultDisplayProperties();
		if ( MDeemerWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(MDeemerWeapon).Affector = None;
	}

	MDeemerWeapon = Pawn(Owner).Weapon;
	// Make new weapon cool.
	if ( MDeemerWeapon != None )
	{
		if ( MDeemerWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(MDeemerWeapon).Affector = self;
		if ( Level.bHighDetailMode )
			MDeemerWeapon.SetDisplayProperties(ERenderStyle.STY_Normal,
									 Texture'UnrealShare.Belt_fx.ShieldBelt.newblue',
									 true,
									 true);
		else
			MDeemerWeapon.SetDisplayProperties(ERenderStyle.STY_Normal,
							 Texture'UnrealShare.Belt_fx.ShieldBelt.newblue',
							 true,
							 true);
	}
}

state Activated
{
	function Timer()
	{
		if ( FinalCount > 0 )
		{
			SetTimer(1.0, true);
			Owner.PlaySound(DeActivateSound,, 8);
			FinalCount--;
			return;
		}
		UsedUp();
	}

	function SetOwnerDisplay()
	{
		if( Inventory != None )
			Inventory.SetOwnerDisplay();

		SetMDeemerWeapon();
	}

	function ChangedWeapon()
	{
		if( Inventory != None )
			Inventory.ChangedWeapon();

		SetMDeemerWeapon();
	}

	function EndState()
	{
		UsedUp();
	}

	function BeginState()
	{
		bActive = true;
		FinalCount = Min(FinalCount, 0.1 * Charge - 1);
		SetTimer(0.1 * Charge - FinalCount,false);
		//Owner.PlaySound(ActivateSound);
		//SetOwnerLighting();
		//Pawn(Owner).DamageScaling = 3.0;
		SetMDeemerWeapon();
	}
}

defaultproperties
{
	EndFireSound=Sound'Botpack.Pickups.AmpFire2b'
	FinalCount=5
	bAutoActivate=True
	bActivatable=True
	bDisplayableInv=True
	PickupMessage="You got the Damage Amplifier!"
	ItemName="Damage Amplifier"
	RespawnTime=120.00
	PickupViewMesh=LodMesh'Botpack.UDamage'
	Charge=999999999
	MaxDesireability=2.50
	PickupSound=Sound'Botpack.Pickups.AmpPickup'
	DeActivateSound=Sound'Botpack.Pickups.AmpOut'
	Icon=Texture'Botpack.Icons.I_UDamage'
	Physics=PHYS_Rotating
	RemoteRole=ROLE_DumbProxy
	Texture=Texture'Botpack.GoldSkin2'
	Mesh=LodMesh'Botpack.UDamage'
	bMeshEnviroMap=True
}
