class PirateDeemerMod expands Mutator config(PirateDeemerCMM);

#exec AUDIO IMPORT FILE="Sounds\HitsoundEnemy.wav" NAME="HitsoundEnemy"

enum ELogType
{
	LOG_info,   // 0
	LOG_error,   // 1
	LOG_debug
};

var string	mPackage;

var() class<cmmWarheadLauncher> LauncherType;
var() class<DTranslocator> TranslocatorType;
var() class<cmmJumpBoots> JumpBootsType;

var() config bool bArena;
var() config int AmmoPer;
var() config int MaxAmmo;
var() config string AmmoKind;

var config bool Removehealth;
var config bool NoInvisibility;
var config bool GhostDeemer;
var config bool MyJumpBoots;

var() config bool TransRadarOn;
var() config float TransRadarRange;

var() config bool GuidedRadarOn;
var() config float GuidedRadarRange;

var UDeemerSkin dskin;
var Weapon UDeemerWeapon;
var config bool Hitsounds;
var config float HitVolume;

var bool bInitialized;

var cmmReplicationX mReplicationInfo;
var cmmReplicationY mWarInfo;

var() config bool bLogInfo;
var() config bool bDebug;

// cmmWarShell
var() config float WarShellSpeed;
var() config float WarShellDamageScale;
var() config float WarShellDamageRadiusScale;
var() config float WarShellSoundRadiusScale;
var() config bool WarShellSmokeTrail;
var() config bool WarShellWarnCannons;

// cmmShockWave
var() config float	ShockWaveRadius;
var() config float	ShockWaveAccelerateScale;
//var() config float	ShockWaveEdgeGraceScale;
var() config float	ShockWaveSoundLevel;
var() config int	ShockWaveSoundCount;
var() config bool	ShockWaveShakeView;
var() config float	ShockWaveShakeViewScale;
var() config float	ShockWaveLifeSpan;
var() config string	ShockWaveColor;
var() config bool	ShockWaveSecondary;
var() config float	ShockWaveLifeSpanSecondary;
var() config string	ShockWaveColorSecondary;

// warheadlauncher
var() config string AltFireMode;
var() config string zoomDrawStyle;
var() config string zoomPic;
var() config float zoomBarRate;
var() config int zoomBarPause;
var() config int zoomBarPadding;
var() config bool zoomBars;
var() config string guidePic;
var() config float GuideSpeed;
var() config float rezRespawnTime;
var() config int MaxLob;

// warExplosion
var() config float WarExplosionDrawScale;
var() config float WarExplosionSoundVolume;
var() config float WarExplosionSoundRadius;
var() config string WarExplosionSound;

// ammo
var() config float amRespawnTime;

// lobbed shockwave config
var() config float 	lwRadius;
var() config float 	lwLifeSpan;
var() config float 	lwLifeSpanSecondary;

// lobbed explosion config
var() config float leDrawScale;
var() config float leSoundVolume;
var() config float leSoundRadius;

// lobbed shell config
var() config float lsDamageRadiusScale;
var() config float lsSoundRadiusScale;
var() config float lsDamageScale;
var() config float lsSpeed;
var() config float lsExplodeDelay;
var() config float lsExplodeDelaySpread;

// rezzer ring
var() config bool RezzerRing;
var() config float RezzerRingDrawScale;
var() config float RezzerRingLifeSpan;
var() config string RezzerRingPic;

var float ShockWaveLobRadius;
var float ShockWaveLobLifeSpan;
var float ShockWaveLobLifeSpanSecondary;
var float MaxGuideSpeed;

// boots
var() config string bootPic;

//Spawn protection
var() globalconfig bool bUseSpawnProt;
var() globalconfig int SpawnProtDuration;

function AddMutator(Mutator M)
{
	if ( M.IsA('Arena') )
	{
		log(M$" not allowed (already have an Arena mutator)");
		return; //only allow one arena mutator
	}
	Super.AddMutator(M);
}

/* overriding this purely for log messages */
function Class<Weapon> MutatedDefaultWeapon()
{
	local Class<Weapon> W;

	if ( NextMutator != None )
	{
		W = NextMutator.MutatedDefaultWeapon();
		if ( W == Level.Game.DefaultWeapon )
			W = MyDefaultWeapon();
	}
	else
		W = MyDefaultWeapon();

	doLog(LOG_debug, "MutatedDefaultWeapon() - is returning a "$string(W));
	return W;
}

event PreBeginPlay()
{
	local cmmWarheadLauncher wl;
	local DTranslocator t;
	local Mutator m;
	local bool bDefaultWeaponSet;
	local cmmJumpBoots jb;

	mPackage = class'cmmCommon'.static.GetPackageName(string(self.class));

	LauncherType = class<cmmWarheadLauncher>(DynamicLoadObject(mPackage$".cmmWarheadLauncher", class'Class'));
	if(LauncherType == None)
	{
		wl = Spawn(class'cmmWarheadLauncher');
		LauncherType = wl.Class;
		wl.Destroy();
	}
	doLog(LOG_info, "PreBeginPlay() - LauncherType = "$string(LauncherType));

	TranslocatorType = class<DTranslocator>(DynamicLoadObject(mPackage$".DTranslocator", class'Class'));
	if(TranslocatorType == None)
	{
		t = Spawn(class'DTranslocator');
		TranslocatorType = t.Class;
		t.Destroy();
	}
	doLog(LOG_info, "PreBeginPlay() - TranslocatorType = "$string(TranslocatorType));

	JumpBootsType = class<cmmJumpBoots>(DynamicLoadObject(mPackage$".cmmJumpBoots", class'Class'));
	if(JumpBootsType == None)
	{
		jb = Spawn(class'cmmJumpBoots');
		JumpBootsType = jb.Class;
		jb.Destroy();
	}
	doLog(LOG_info, "PreBeginPlay() - JumpBootsType = "$string(JumpBootsType));

	DefaultWeapon = LauncherType;

	// This single instance will be used to replicate options to our various classes.
	mReplicationInfo = Spawn(class'cmmReplicationX', self);

	doLog(LOG_info, "PreBeginPlay() - mReplicationInfo.class = "$string(mReplicationInfo.class));

	if(mReplicationInfo == None)
	{
		doLog(LOG_info, "PreBeginPlay() - Failed to spawn a cmmReplicationX class for unknown reasons :(  This mute cannot continue.");
		return;
	}

	ShockWaveRadius = class'cmmCommon'.static.ValidateFloat(ShockWaveRadius, Default.ShockWaveRadius, 30, 22000);
	ShockWaveAccelerateScale = class'cmmCommon'.static.ValidateFloat(ShockWaveAccelerateScale, Default.ShockWaveAccelerateScale, 0.1, 1);
	//ShockWaveEdgeGraceScale = class'cmmCommon'.static.ValidateFloat(ShockWaveEdgeGraceScale, Default.ShockWaveEdgeGraceScale, 0.1, 10);
	ShockWaveSoundCount = class'cmmCommon'.static.ValidateInt(ShockWaveSoundCount, Default.ShockWaveSoundCount, 0, 4);
	ShockWaveSoundLevel = class'cmmCommon'.static.ValidateFloat(ShockWaveSoundLevel, Default.ShockWaveSoundLevel, 1, 16);
	ShockWaveShakeViewScale = class'cmmCommon'.static.ValidateFloat(ShockWaveShakeViewScale, Default.ShockWaveShakeViewScale, 0.05, 2);
	ShockWaveLifeSpan = class'cmmCommon'.static.ValidateFloat(ShockWaveLifeSpan, Default.ShockWaveLifeSpan, 0.5, 10);
	ShockWaveLifeSpanSecondary = class'cmmCommon'.static.ValidateFloat(ShockWaveLifeSpanSecondary, Default.ShockWaveLifeSpanSecondary, 0.5, 10);

	// Only allow one decimal place for life span.
	ShockWaveLifeSpan = class'cmmCommon'.static.RoundFloat(ShockWaveLifeSpan, 1);
	ShockWaveLifeSpanSecondary = class'cmmCommon'.static.RoundFloat(ShockWaveLifeSpanSecondary, 1);

	//SecondaryLifeSpan must be less than PrimaryLifeSpan
	if(ShockWaveLifeSpanSecondary > ShockWaveLifeSpan)
		ShockWaveLifeSpanSecondary = ShockWaveLifeSpan;

	lwRadius = class'cmmCommon'.static.ValidateFloat(lwRadius, Default.ShockWaveLobRadius, 30, 22000);
	lwLifeSpan = class'cmmCommon'.static.ValidateFloat(lwLifeSpan, Default.ShockWaveLobLifeSpan, 0.5, 10);
	lwLifeSpanSecondary = class'cmmCommon'.static.ValidateFloat(lwLifeSpanSecondary, Default.ShockWaveLobLifeSpanSecondary, 0.5, 10);

	// Only allow one decimal place for life span.
	lwLifeSpan = class'cmmCommon'.static.RoundFloat(lwLifeSpan, 1);
	lwLifeSpanSecondary = class'cmmCommon'.static.RoundFloat(lwLifeSpanSecondary, 1);

	//LifeSpanSecondary must be less than LifeSpan
	if(lwLifeSpanSecondary > lwLifeSpan)
		lwLifeSpanSecondary = lwLifeSpan;

	RezzerRingDrawScale = class'cmmCommon'.static.ValidateFloat(RezzerRingDrawScale, Default.RezzerRingDrawScale, 0.1, 30);
	RezzerRingLifeSpan = class'cmmCommon'.static.ValidateFloat(RezzerRingLifeSpan, Default.RezzerRingLifeSpan, 0.5, 10);

	mReplicationInfo.wsSpeed = WarShellSpeed;
	mReplicationInfo.wsDamageScale = WarShellDamageScale;
	mReplicationInfo.wsDamageRadiusScale = WarShellDamageRadiusScale;
	mReplicationInfo.wsSoundRadiusScale = WarShellSoundRadiusScale;
	mReplicationInfo.wsSmokeTrail = WarShellSmokeTrail;
	mReplicationInfo.wsWarnCannons = WarShellWarnCannons;

	mReplicationInfo.swRadius = ShockWaveRadius;
	//mReplicationInfo.swEdgeGraceScale = ShockWaveEdgeGraceScale;
	mReplicationInfo.swAccelerateScale = ShockWaveAccelerateScale;
	mReplicationInfo.swSoundLevel = ShockWaveSoundLevel;
	mReplicationInfo.swSoundCount = ShockWaveSoundCount;
	mReplicationInfo.swShakeView = ShockWaveShakeView;
	mReplicationInfo.swShakeViewScale = ShockWaveShakeViewScale;
	mReplicationInfo.swLifeSpan = ShockWaveLifeSpan;
	mReplicationInfo.swColor = ShockWaveColor;

	mReplicationInfo.swSecondary = ShockWaveSecondary;
	mReplicationInfo.swColorSecondary = ShockWaveColorSecondary;
	mReplicationInfo.swLifeSpanSecondary = ShockWaveLifeSpanSecondary;

	mReplicationInfo.AltFireMode = AltFireMode;
	mReplicationInfo.zDrawStyle = zoomDrawStyle;
	mReplicationInfo.zPic = zoomPic;
	mReplicationInfo.zBarRate = zoomBarRate;
	mReplicationInfo.zBarPause = zoomBarPause;
	mReplicationInfo.zBarPadding = zoomBarPadding;
	mReplicationInfo.zBar = zoomBars;

	mReplicationInfo.lwRadius = lwRadius;
	mReplicationInfo.lwLifeSpan = lwLifeSpan;
	mReplicationInfo.lwLifeSpanSecondary = lwLifeSpanSecondary;

	mReplicationInfo.rr = RezzerRing;

	mReplicationInfo.GuideSpeed = class'cmmCommon'.static.ValidateFloat(GuideSpeed, Default.GuideSpeed, 10, Default.MaxGuideSpeed);

	mReplicationInfo.bInitialized = true;

	AmmoPer = class'cmmCommon'.static.ValidateInt(AmmoPer, Default.AmmoPer, 1, 999);
	MaxAmmo = class'cmmCommon'.static.ValidateInt(MaxAmmo, Default.MaxAmmo, 1, 999);
	if(AmmoPer > MaxAmmo)
		AmmoPer = MaxAmmo;

	// The above replication info is nearing its capacity, so starting another info.
	mWarInfo = Spawn(class'cmmReplicationY', self);
	if(mWarInfo != None)
	{
		mWarInfo.AmmoKind = AmmoKind;
		mWarInfo.AmmoPer = AmmoPer;
		mWarInfo.bArena = bArena;
		mWarInfo.weSound = WarExplosionSound;
		mWarInfo.amRespawnTime = amRespawnTime;
		mWarInfo.amMaxAmmo = MaxAmmo;
		mWarInfo.MaxLob = class'cmmCommon'.static.ValidateInt(MaxLob, Default.MaxLob, 2, 10);

		mWarInfo.guidePic = guidePic;
		mWarInfo.rezRespawnTime = rezRespawnTime;

		mWarInfo.lsSpeed = lsSpeed;
		mWarInfo.lsDamageRadiusScale = lsDamageRadiusScale;
		mWarInfo.lsSoundRadiusScale = lsSoundRadiusScale;
		mWarInfo.lsDamageScale = lsDamageScale;
		mWarInfo.lsExplodeDelay = lsExplodeDelay;
		mWarInfo.lsExplodeDelaySpread = lsExplodeDelaySpread;
		mWarInfo.leDrawScale = leDrawScale;
		mWarInfo.leSoundVolume = leSoundVolume;
		mWarInfo.leSoundRadius = leSoundRadius;
		mWarInfo.weDrawScale = WarExplosionDrawScale;
		mWarInfo.weSoundVolume = WarExplosionSoundVolume;
		mWarInfo.weSoundRadius = WarExplosionSoundRadius;

		mWarInfo.rrDrawScale = RezzerRingDrawScale;
		mWarInfo.rrLifeSpan = RezzerRingLifeSpan;
		mWarInfo.rrPic = RezzerRingPic;

		mWarInfo.tRadarOn = TransRadarOn;
		mWarInfo.tRadarRange = TransRadarRange;

		mWarInfo.gRadarOn = GuidedRadarOn;
		mWarInfo.gRadarRange = GuidedRadarRange;

		mWarInfo.bootPic = bootPic;
	}
}

function PostBeginPlay()
{
	doLog(LOG_debug, "PostBeginPlay() - self.class = "$string(self.class));
	if (bInitialized)
		return;
	bInitialized = True;

   Level.Game.RegisterDamageMutator(Spawn(class'SpawnProt'));
   Level.Game.RegisterDamageMutator(Self);
}

function bool AlwaysKeep(Actor Other)
{
	local string s;

	if(bArena)
	{
		// Well, for whatever reason, AlwaysKeep is not getting called for our cmmWarheadLauncher.
		// So we need to set PickupAmount thru our replication object(s).
		if("cmmWarheadLauncher" ~= class'cmmCommon'.static.GetClassName(string(Other.class)))
		{
			Weapon(Other).PickupAmmoCount = AmmoPer;
			return true;
		}

		if(AmmoKind ~= class'cmmCommon'.static.GetClassName(string(Other.class)))
		{
			/* I TOOK THESE OUT, THE REPLICATION CLASS TAKES CARE OF IT NOW
			cmmAmmo(Other).AmmoAmount = AmmoPer;
			cmmAmmo(Other).MaxAmmo = MaxAmmo;
			*/
			// besides, they should be...
			//Ammo(Other).AmmoAmount = AmmoPer;
			//Ammo(Other).MaxAmmo = MaxAmmo;
			return true;
		}
	}
	else
	{
		// ALLOW FOR GENERIC CHECK TO ALLOW ANY KIND OF THIS TYPE OF CLASS (TO ALLOW DOUBLE LOADING)
		if("cmmWarheadLauncher" ~= class'cmmCommon'.static.GetClassName(string(Other.class)))
			return true;

		// ALLOW FOR GENERIC CHECK TO ALLOW ANY KIND OF THIS TYPE OF CLASS (TO ALLOW DOUBLE LOADING)
		if("cmmAmmo" ~= class'cmmCommon'.static.GetClassName(string(Other.class)))
			return true;
	}

	if(NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));

	return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if(Other.IsA('Health') || Other.IsA('TournamentHealth'))
	{
		if (Removehealth)
		  	return false;

		return true;
	}

	if(Other.IsA('Invisibility') || Other.IsA('UT_Invisibility'))
	{
		if (NoInvisibility)
			return false;

		return true;
	}

	if(bArena)
	{
		if(Other.IsA('Weapon'))
		{
			// KEEP THIS GENERIC TO ALLOW for DOUBLE LOADING OF THIS SAME MUTATOR
			if(("DTranslocator" ~= class'cmmCommon'.static.GetClassName(string(Other.class))))
				return true;

			if (Other.IsA('Translocator'))
				return !TransRadarOn;

			if(!("cmmWarheadLauncher" ~= class'cmmCommon'.static.GetClassName(string(Other.class))))
			{
				//Level.Game.bCoopWeaponMode = false;
				ReplaceWith(Other, mPackage$".cmmWarheadLauncher");
				return false;
			}
		}

		if(Other.IsA('Ammo'))
		{
			if(!(AmmoKind ~= class'cmmCommon'.static.GetClassName(string(Other.class))))
			{
				ReplaceWith(Other, mPackage$"."$AmmoKind);
				return false;
			}
		}
	}
	else
	{
		if(Other.IsA('Weapon'))
		{
			doLog(LOG_debug, "CheckReplacement() - other is a "$string(other.Class)$", static class is "$class'cmmCommon'.static.GetClassName(string(Other.class)));

			// KEEP THIS GENERIC TO ALLOW for DOUBLE LOADING OF THIS SAME MUTATOR
			if(("DTranslocator" ~= class'cmmCommon'.static.GetClassName(string(Other.class))))
				return true;

			if (Other.IsA('Translocator'))
				return !TransRadarOn;

			// KEEP THIS GENERIC TO ALLOW for DOUBLE LOADING OF THIS SAME MUTATOR
			if("cmmWarheadLauncher" ~= class'cmmCommon'.static.GetClassName(string(Other.class)))
			{
				doLog(LOG_debug, "CheckReplacement() - keeping this launcher");
				return true;
			}

			return false;
		}

		if(Other.IsA('Ammo'))
		{
			// KEEP THIS GENERIC TO ALLOW for DOUBLE LOADING OF THIS SAME MUTATOR
			if("cmmAmmo" ~= class'cmmCommon'.static.GetClassName(string(Other.class)))
				return true;

			return false;
		}
	}

	if(Other.IsA('UT_JumpBoots'))
	{
		if(!MyJumpBoots)
			return true;

		// KEEP THIS GENERIC TO ALLOW FOR DOUBLE LOADING OF THIS SAME MUTATOR
		if("cmmJumpBoots" ~= class'cmmCommon'.static.GetClassName(string(Other.class)))
			return true;

		ReplaceWith(Other, string(JumpBootsType));
		return false;
	}

	bSuperRelevant = 0;
	return true;
}

function ModifyPlayer(Pawn Other)
{
	local Inventory inv;
	local ammo a;
	local Pawn P;
	local Weapon w;

	if(!bArena)
	{
		//inv = Other.FindInventoryType(LauncherType);
		inv = myFindInventoryType(Other, LauncherType);

		// -- inv as a Redeemer --
		if (inv == None)
		{
			// original way
			inv = Spawn(LauncherType);
			if(inv != None)
			{
				doLog(LOG_info, "ModifyPlayer() - spawned the launchertype of "$string(LauncherType)$", giving to player.");
				inv.GiveTo(Other);
			}
		}

		if(inv != None)
		{
			doLog(LOG_debug, "ModifyPlayer() - "$string(LauncherType)$".PickupAmmoCount before assigning = "$string(Weapon(inv).PickupAmmoCount));
			Weapon(inv).PickupAmmoCount = 999; //Weapon(inv).AmmoName.Default.MaxAmmo;
			doLog(LOG_debug, "ModifyPlayer() - "$string(LauncherType)$".PickupAmmoCount  after assigning = "$string(Weapon(inv).PickupAmmoCount));

			Weapon(inv).GiveAmmo(Other);

			// This might seem redundant to what is inside GiveAmmo, but we are doing
			// this in case it wasn't us that initially gave the ammo to the weapon.
			a = Ammo(Other.FindInventoryType(Weapon(inv).AmmoName));
			if(a != None)
			{
				doLog(LOG_debug, "ModifyPlayer() - "$string(LauncherType)$" - weapon ammo count before = "$string(a.AmmoAmount));
				a.MaxAmmo = 999;
				a.AmmoAmount = 999; //Weapon(inv).AmmoName.Default.MaxAmmo;
				doLog(LOG_debug, "ModifyPlayer() - "$string(LauncherType)$" - weapon ammo count  after = "$string(a.AmmoAmount));
			}
		}
		// -- end of inv as a Redeemer --
	}

	if(GhostDeemer)
	{
		// TODO - in the case of multiple loading, the ghost skin is applied to all
		// the weapons. A goal would be to just get it applied to one in particular.
		inv = Spawn(class'UDeemerSkin');
		if( inv != None )
		{
			inv.GiveTo(Other);
			inv.Activate();

			// todo, note that when inv is activated, you can just call activate again to deactivate it.
		}
	}

	if (TransRadarOn)
	{
		// Check for ANY kind of DTranslocator.
		inv = myFindInventoryTypeByClass(Other, "DTranslocator");
		if (inv == None)
		{
			inv = Spawn(class'DTranslocator');
			if( inv != None )
				inv.GiveTo(Other);
		}
	}
   if (bUseSpawnProt)
   {
      Inv = Other.FindInventoryType(class'SpawnProtEffect');
      if ( Inv != None )
         SpawnProtEffect(Inv).Duration = SpawnProtDuration;
      else
      {
         inv = Spawn(class'SpawnProtEffect');
         if( inv != None )
         {
            SpawnProtEffect(Inv).Duration = SpawnProtDuration;
            inv.GiveTo(Other);
            inv.Activate();
         }
      }
   }

	if(NextMutator != None)
		NextMutator.ModifyPlayer(Other);
}

// This is basically a copy of the Pawn's version, but with logging.
function Inventory myFindInventoryType(Pawn Other, class DesiredClass)
{
	local Inventory Inv;

	doLog(LOG_debug, "myFindInventoryType() - About to check for inventory: "$string(DesiredClass));
	for(Inv=Other.Inventory; Inv!=None; Inv=Inv.Inventory)
	{
		doLog(LOG_debug, "myFindInventoryType() - checking: "$string(Inv.class));
		if (Inv.class == DesiredClass)
		{
			doLog(LOG_debug, "myFindInventoryType() - already here: "$string(Inv.class));
			return Inv;
		}
	}
	return None;
}

function Inventory myFindInventoryTypeByClass(Pawn Other, String AClassName)
{
	local Inventory inv;

	doLog(LOG_debug, "myFindInventoryTypeByClass() - About to check for inventory: "$AClassName);
	for(inv=Other.Inventory; inv!=None; inv=inv.Inventory)
	{
		doLog(LOG_debug, "myFindInventoryTypeByClass() - checking: "$string(Inv.class));
		if((AClassName ~= class'cmmCommon'.static.GetClassName(string(inv.class))))
		{
			doLog(LOG_debug, "myFindInventoryTypeByClass() - already here: "$string(inv.class));
			return inv;
		}
	}
	return None;
}

// This is basically a copy of the Pawn's version, but with logging.
function bool myAddInventory(Pawn Other, inventory NewItem)
{
	// Skip if already in the inventory.
	local inventory Inv;

	// The item should not have been destroyed if we get here.
	if (NewItem ==None )
		log("tried to add none inventory to "$self);

	doLog(LOG_debug, "myAddInventoryType() - About to check for inventory: "$string(NewItem));
	for( Inv=Other.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		doLog(LOG_debug, "myAddInventory() - checking: "$string(Inv));
		if( Inv == NewItem )
		{
			doLog(LOG_debug, "myAddInventory() - already here: "$string(Inv));
			return false;
		}
	}

	// Add to front of inventory chain.
	NewItem.SetOwner(Other);
	NewItem.Inventory = Other.Inventory;
	Other.Inventory = NewItem;

	return true;
}

function MutatorTakeDamage (out int ActualDamage,Pawn Victim,Pawn InstigatedBy,out Vector HitLocation,out Vector Momentum,name DamageType)
{
	if(HitSounds && (Victim != none) && (InstigatedBy != none) && InstigatedBy.IsA('PlayerPawn') && (Victim != InstigatedBy) && (Victim.IsA('PlayerPawn') || Victim.IsA('Bot')) )
	{
		PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_None, HitVolume, false);
		PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_Interface, HitVolume, false);
		PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_Interact, HitVolume, false);
	}

	if (NextDamageMutator != None)
		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
}

function doLog(ELogType ALogType, string AMessage)
{
	if( ((ALogType == LOG_info) && bLogInfo) || ((ALogType == LOG_debug) && bDebug) )
		Log(mPackage$": "$AMessage, 'PirateDeemerMod');
}

defaultproperties
{
	TransRadarOn=True
	MyJumpBoots=True
	HitSounds=True
	HitVolume=16.00
	bLogInfo=false;
	WarShellSpeed=600.0
	WarShellDamageScale=1.0
	WarShellDamageRadiusScale=1.0
	WarShellSoundRadiusScale=1.0
	WarShellSmokeTrail=True
	ShockWaveRadius=1100
	ShockWaveAccelerateScale=0.1
	//ShockWaveEdgeGraceScale=1.0
	ShockWaveSoundCount=4
	ShockWaveSoundLevel=16.0
	ShockWaveShakeView=true
	ShockWaveShakeViewScale=1.0
	ShockWaveLifeSpan=1.5
	ShockWaveLifeSpanSecondary=0.7
	ShockWaveColor="DarkYellow"
	ShockWaveSecondary=True
	ShockWaveColorSecondary="DarkRed"
	AltFireMode="zoom"
	zoomPic="monzaBar"
	zoomBarRate=0.25
	zoomBarPause=3
	zoomBarPadding=0
	WarExplosionDrawScale=12.000000
	WarExplosionSoundVolume=13.000000
	WarExplosionSoundRadius=6000.000000
	ShockWaveLobRadius=150
	ShockWaveLobLifeSpan=1.0
	ShockWaveLobLifeSpanSecondary=0.5
	AmmoPer=1
	MaxAmmo=5
	AmmoKind="cmmAmmo"
	MaxLob=3
	RezzerRingDrawScale=8
	RezzerRingLifeSpan=0.8
	RezzerRingPic="blueInsta"
	GuideSpeed=550
	MaxGuideSpeed=2000
	bUseSpawnProt=True
   SpawnProtDuration=10
}
