class SpawnProtEffect extends Inventory;

var() float Duration;
var() bool bSpawnProtActive;
var int TeamNum;
var UT_ShieldBeltEffect MyEffect;

replication
{
   reliable if( Role==ROLE_Authority && bNetOwner)
      bSpawnProtActive;
}

function PostBeginPlay()
{
   M_Activated = "";
   M_DeActivated = "";
   M_Selected = "";
}

singular function UsedUp()
{
   if (MyEffect != None)
      MyEffect.Destroy();
   if ((Owner != None) )
      Owner.SetDefaultDisplayProperties();
      Pawn(Owner).ReceiveLocalizedMessage( class'cmmProtectionMessage');
   Destroy();
}

function Destroyed()
{
   if (MyEffect != None)
      MyEffect.Destroy();
   if ((Owner != None) )
      Owner.SetDefaultDisplayProperties();
   Super.Destroyed();
}

state Activated
{
   function Timer()
   {
      if ( (Pawn(Owner) != None) && (M_Deactivated != "") )
         Pawn(Owner).ClientMessage(ItemName$M_Deactivated);
      bSpawnProtActive = False;
      UsedUp();
   }
   Begin:
      bSpawnProtActive = True;
      MyEffect = Spawn(class'UT_ShieldBeltEffect', Owner,,Owner.Location, Owner.Rotation);
      MyEffect.Mesh = Owner.Mesh;
      MyEffect.DrawScale = Owner.Drawscale;
      MyEffect.Texture = FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield';
      MyEffect.LowDetailTexture = FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield';
      MyEffect.ScaleGlow = 0.75;

   SetTimer(Duration, False);
}

defaultproperties
{
   bActivatable=True
   DrawType=DT_None
}