class UDeemerSkin extends TournamentPickup;

var Weapon UDeemerWeapon;
var sound ExtraFireSound;
var sound EndFireSound;
var int FinalCount;

singular function UsedUp()
{
	if ( UDeemerWeapon != None )
	{
		UDeemerWeapon.SetDefaultDisplayProperties();
		if ( UDeemerWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(UDeemerWeapon).Affector = None;
	}
	if ( Owner != None )
	{
		if ( Owner.bIsPawn )
		{
			if ( !Pawn(Owner).bIsPlayer || (Pawn(Owner).PlayerReplicationInfo.HasFlag == None) )
			{
				Owner.AmbientGlow = Owner.Default.AmbientGlow;
				Owner.LightType = LT_None;
			}
			Pawn(Owner).DamageScaling = 1.0;
		}
		bActive = false;
		if ( Owner.Inventory != None )
		{
			Owner.Inventory.SetOwnerDisplay();
			Owner.Inventory.ChangedWeapon();
		}
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogItemDeactivate(Self, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogItemDeactivate(Self, Pawn(Owner));
	}
	Destroy();
}
/*
simulated function FireEffect()
{
	if ( (TimerRate - TimerCounter < 5) && (Level.NetMode != NM_Client) )
		Pawn(Owner).Weapon.PlayOwnedSound(EndFireSound, SLOT_Interact, 8);
	else
		Pawn(Owner).Weapon.PlayOwnedSound(ExtraFireSound, SLOT_Interact, 8);
}

function SetOwnerLighting()
{
	if ( Owner.bIsPawn && Pawn(Owner).bIsPlayer
		&& (Pawn(Owner).PlayerReplicationInfo.HasFlag != None) )
		return;
	Owner.AmbientGlow = 254;
	Owner.LightEffect=LE_NonIncidence;
	Owner.LightBrightness=255;
	Owner.LightHue=210;
	Owner.LightRadius=10;
	Owner.LightSaturation=0;
	Owner.LightType=LT_Steady;
}
*/
function SetUDeemerWeapon()
{
	if ( !bActive )
		return;

//    SetOwnerLighting();

	// Make old weapon normal again.
	if ( UDeemerWeapon != None )
	{
		UDeemerWeapon.SetDefaultDisplayProperties();
		if ( UDeemerWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(UDeemerWeapon).Affector = None;
	}

	UDeemerWeapon = Pawn(Owner).Weapon;
	// Make new weapon cool.
	if ( UDeemerWeapon != None )
	{
		if ( UDeemerWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(UDeemerWeapon).Affector = self;
		if ( Level.bHighDetailMode )
			UDeemerWeapon.SetDisplayProperties(ERenderStyle.STY_Translucent,
									 Texture'UnrealShare.Belt_fx.ShieldBelt.newblue',
									 true,
									 true);
		else
			UDeemerWeapon.SetDisplayProperties(ERenderStyle.STY_Translucent,
							 Texture'UnrealShare.Belt_fx.ShieldBelt.newblue',
							 true,
							 true);
	}
}

state Activated
{
	function Timer()
	{
		if ( FinalCount > 0 )
		{
			SetTimer(1.0, true);
			Owner.PlaySound(DeActivateSound,, 8);
			FinalCount--;
			return;
		}
		UsedUp();
	}

	function SetOwnerDisplay()
	{
		if( Inventory != None )
			Inventory.SetOwnerDisplay();

		SetUDeemerWeapon();
	}

	function ChangedWeapon()
	{
		if( Inventory != None )
			Inventory.ChangedWeapon();

		SetUDeemerWeapon();
	}

	function EndState()
	{
		UsedUp();
	}

	function BeginState()
	{
		bActive = true;
		FinalCount = Min(FinalCount, 0.1 * Charge - 1);
		SetTimer(0.1 * Charge - FinalCount,false);
		//Owner.PlaySound(ActivateSound);
		//SetOwnerLighting();
		//Pawn(Owner).DamageScaling = 3.0;
		SetUDeemerWeapon();
	}
}

defaultproperties
{
	EndFireSound=Sound'Botpack.Pickups.AmpFire2b'
	FinalCount=5
	bAutoActivate=True
	bActivatable=True
	bDisplayableInv=True
	PickupMessage="You got the Damage Amplifier!"
	ItemName="Damage Amplifier"
	RespawnTime=120.000000
	PickupViewMesh=LodMesh'Botpack.UDamage'
	Charge=999999999
	MaxDesireability=2.500000
	PickupSound=Sound'Botpack.Pickups.AmpPickup'
	DeActivateSound=Sound'Botpack.Pickups.AmpOut'
	Icon=Texture'Botpack.Icons.I_UDamage'
	Physics=PHYS_Rotating
	RemoteRole=ROLE_DumbProxy
	Texture=Texture'Botpack.GoldSkin2'
	Mesh=LodMesh'Botpack.UDamage'
	bMeshEnviroMap=True
}
