
class cmmAmmo extends TournamentAmmo;

#exec MESH IMPORT MESH=shellM ANIVFILE=MODELS\shell_a.3D DATAFILE=MODELS\shell_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=shellM X=0 Y=0 Z=0 PITCH=0
#exec MESH SEQUENCE MESH=shellM SEQ=All    STARTFRAME=0   NUMFRAMES=1
#exec mesh SEQUENCE MESH=shellM SEQ=Still  STARTFRAME=0   NUMFRAMES=1
#exec texture IMPORT NAME=jshell FILE=MODELS\shell.pcx GROUP=Skins  LODSET=2
#exec MESHMAP scale MESHMAP=shellM X=0.3 Y=0.3 Z=0.6
#exec MESHMAP SETTEXTURE MESHMAP=shellM NUM=1 TEXTURE=jshell

var string	mPackage;
var cmmReplicationY mWRI;

simulated function PostBeginPlay()
{
	mPackage = class'cmmCommon'.static.GetPackageName(string(self.class));

	foreach AllActors(class'cmmReplicationY', mWRI)
	{
		if(mPackage ~= class'cmmCommon'.static.GetPackageName(string(mWRI.class)))
			break;
		mWRI = None;
	}

	if(mWRI == None)
		return;

	RespawnTime = class'cmmCommon'.static.ValidateFloat(mWRI.amRespawnTime, Default.RespawnTime, 2, 999);
	if(mWRI.bArena)
	{
		AmmoAmount = mWRI.AmmoPer;
		MaxAmmo = class'cmmCommon'.static.ValidateInt(mWRI.amMaxAmmo, Default.MaxAmmo, 1, 999);
	}
	else
	{
		AmmoAmount = 999;
		MaxAmmo = 999;
	}
}

defaultproperties
{
	DrawScale=0.3
	PickupViewScale=0.3
	PlayerViewScale=0.3
	ThirdPersonScale=0.3
	AmmoAmount=1
	MaxAmmo=5
	UsedInWeaponSlot(5)=1
	PickupMessage="You picked up some CMM ammo"
	PickupViewMesh=LodMesh'Botpack.shellM'
	MaxDesireability=0.450000
	Physics=PHYS_Falling
	Mesh=LodMesh'Botpack.shellM'
	Texture=Texture'jshell'
	CollisionRadius=13.000000
	CollisionHeight=33.000000
	bCollideActors=True
	DrawType=DT_Mesh
}
