//====================================================================================
//	cmmCommon | by Helen! | www.birdieman.com/forum
//====================================================================================
//  A class to hold static methods that are used multiple times.
//====================================================================================

class cmmCommon expands object;

var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor;

static simulated function float ValidateFloat(float AValue, float ADefault, float AMin, float AMax)
{
	if((AValue >= AMin) && (AValue <= AMax))
		return AValue;

	return ADefault;
}

static simulated function int ValidateInt(int AValue, int ADefault, int AMin, int AMax)
{
	if((AValue >= AMin) && (AValue <= AMax))
		return AValue;

	return ADefault;
}

static simulated function byte ValidateByte(byte AValue, byte ADefault, byte AMin, byte AMax)
{
	if((AValue >= AMin) && (AValue <= AMax))
		return AValue;

	return ADefault;
}

simulated static function float RoundFloat(float f, int ANumberOfDecimals)
{
	local int i;
	local int factor;

	if(ANumberOfDecimals <= 0)
		return float(int(f));

	i = 0;
	factor = 1;
	while(i < ANumberOfDecimals)
	{
		factor = factor * 10;
		i++;
	}

	return (float(int(f * factor)))/factor;
}

simulated static function string GetPackageName(string AClass)
{
	local int index;

	index = InStr(AClass, ".");
	if(index == -1)
	{
		// It is best to let this fail if there is
		// no dot, because this is unexpected.
		return "";
	}

	return Left(AClass, index);
}

simulated static function string GetClassName(string AClass)
{
	local int index;

	index = InStr(AClass, ".");
	if(index == -1)
		return AClass;

	return Mid(AClass, index+1);
}

// Validate the string contains a value from 0 to 255.
static simulated function bool ValidInt(string s, out int i)
{
	if(s == "")
		return false;

	if (s == "0")
	{
		i = 0;
		return true;
	}

	i = int(s);
	if((i <= 0) || (i >= 256))
		return false;

	return true;
}

static simulated function Color GetColor(string AColor, Color ADefault)
{
	local string s;
	local int i;
	local Color cc;
	local bool bKeepGoing;
	local int customR;
	local int customG;
	local int customB;

	if(AColor ~= "white")
		return default.WhiteColor;
	if(AColor ~= "green")
		return default.GreenColor;
	if(AColor ~= "gold")
		return default.GoldColor;
	if(AColor ~= "blue")
		return default.BlueColor;
	if(AColor ~= "lightCyan")
		return default.LightCyanColor;
	if(AColor ~= "silver")
		return default.SilverColor;
	if(AColor ~= "bronze")
		return default.BronzeColor;
	if(AColor ~= "cyan")
		return default.CyanColor;
	if(AColor ~= "red")
		return default.RedColor;

	if(AColor ~= "orange")
	{
		cc.R = 255;
		cc.G = 102;
		cc.B = 0;
		return cc;
	}
	if(AColor ~= "pink")
	{
		cc.R = 255;
		cc.G = 0;
		cc.B = 255;
		return cc;
	}

	if(Left(AColor, 2) ~= "R=")
	{
		s = GetSetting(AColor, "R");
		if(ValidInt(s, customR))
		{
			s = GetSetting(AColor, "G");
			if(ValidInt(s, customG))
			{
				s = GetSetting(AColor, "B");
				if(ValidInt(s, customB))
				{
					cc.R = customR;
					cc.G = customG;
					cc.B = customB;
					return cc;
				}
			}
		}
	}

	return ADefault;
}

static simulated function string GetSetting(string ASource, string ASetting)
{
	local int i;
	local string s;
	local bool bFound;

	if (ASource == "")
		return "";

	ASource = myReplace(ASource, " ", "");
	ASource = Caps(ASource);
	ASetting = Caps(ASetting);

	bFound = false;
	do
	{
		i = InStr(ASource, ",");
		if(i == (-1))
		{
			s = ASource;
			ASource = "";
		}
		else
		{
			s = Left(ASource, i);
			ASource = Mid(ASource, i+1);
		}

		i = InStr(s, ASetting$"=");
		if(i != -1)
		{
			// Note we have to skip over entire length of setting
			s = Mid(s, i+Len(ASetting$"="));
			bFound = (s != "");
		}

	} until ((bFound) || (ASource == ""));

	if(bFound)
		return s;
	else
		return "";
}

static simulated function string myReplace(string ASource, string AReplace, string AWith)
{
	local int i;
	local string aResult;

	i = InStr(ASource, AReplace);

	if(i==-1)
	   return ASource;

	aResult = "";

	do
	{
		aResult = aResult $ Left(ASource, i) $ AWith;
		ASource = Mid(ASource, i + Len(AReplace));
		i = InStr(ASource, AReplace);
	} until (i==-1);

	if(ASource != "")
		aResult = aResult $ ASource;

	return aResult;
}

defaultproperties
{
	GreenColor=(G=255)
	WhiteColor=(R=255,G=255,B=255)
	GoldColor=(R=255,G=255)
	BlueColor=(B=255)
	LightCyanColor=(R=128,G=255,B=255)
	SilverColor=(R=138,G=164,B=166)
	BronzeColor=(R=203,G=147,B=52)
	CyanColor=(G=128,B=255)
	RedColor=(R=255)
}
