//=============================================================================
// cmmJumpBoots
//=============================================================================
class cmmJumpBoots extends UT_JumpBoots;

#exec AUDIO IMPORT FILE="Sounds\MyJumpSnd.WAV" NAME="MyJumpSnd"
#exec AUDIO IMPORT FILE="Sounds\MyJumpJmp.WAV" NAME="MyJumpJmp"

var string mPackage;
var cmmReplicationY mWarInfo;

var string BootTex;

replication
{
	// Things the server should send to the client.
	reliable if(Role == ROLE_Authority)
		BootTex;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	mPackage = class'cmmCommon'.static.GetPackageName(string(self.class));

	foreach AllActors(class'cmmReplicationY', mWarInfo)
	{
		if(mPackage ~= class'cmmCommon'.static.GetPackageName(string(mWarInfo.class)))
			break;
		mWarInfo = None;
	}

	if(mWarInfo != None)
	{
		BootTex = mWarInfo.bootPic;
	}
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	MultiSkins[1] = Texture(DynamicLoadObject(BootTex, class'Texture'));
}

function OwnerJumped()
{
	TimeCharge=0;
	if ( Charge <= 0 )
	{
		if ( Owner != None )
		{
			Pawn(Owner).JumpZ = Pawn(Owner).Default.JumpZ * Level.Game.PlayerJumpZScaling();
		}
		UsedUp();
	}
	else
	{
		Owner.PlaySound(sound'MyJumpJmp');
	}
	Charge -= 1;
}

defaultproperties
{
	ExpireMessage="pirate JumpBoots have drained."
	PickupMessage="You picked up pirate JumpBoots."
	PickupSound=None
	ActivateSound=Sound'MyJumpSnd'
}
