//====================================================================================
// cmmShockWave | by Helen! | www.birdieman.com/forum
//====================================================================================
class cmmShockWave expands ShockWave;

// We import this texture for two reasons:
//	A. Because it does not work when loaded dynamically.
//	B. Might as well have at least one default custom texture.
#exec texture IMPORT NAME=swFire FILE=TEXTURES\swFire.PCX

var cmmReplicationX mReplicationInfo;
var string	mPackage;
var bool	bIsPrimaryWave;
var bool	bLobbed;
var bool	bDoSecondaryWave;
var float	mSecondaryLifeSpan;
var Vector	mOriginalLocation;
var float	mStartingLifeSpan;
var bool	bSecondarySpawned;
var() class<ShockWave> mShockWaveSecondaryType;
var() class<WarExplosion> mWarExplosionType;
var float	TIMER_GAP;
var int		TimerCount;
var int		StrideCount;
var int		OldStrideCount;
var float	DistanceTravelled;
var float	minStartRadius;
var bool	bFirstTime;
var bool	bPreDone;

var float	AvgStrideLength;
var float	FirstStrideLength;
var float	LastStrideLength;
var float	StrideIncrement;
var float	AccelerateScale;
var int		NumberOfStrides;

var float 	ShockWaveEdgeGraceScale;
var float	ShockWaveRadius;
var float 	SoundLevel;
var int   	SoundCount;
var bool  	bShakeView;
var float 	ShakeViewScale;

simulated function PreBeginPlay()
{
	if(bPreDone)
		return;

	bPreDone = true;

	// We do not want the base class behaviour for Tick.
	Disable('Tick');

	Super(Actor).PreBeginPlay();

	mPackage = class'cmmCommon'.static.GetPackageName(string(self.class));

	if(bLobbed)
	{
		mShockWaveSecondaryType = class<ShockWave>(DynamicLoadObject(mPackage$".cmmShockWaveSecondaryLob", class'Class'));
		mWarExplosionType = class<WarExplosion>(DynamicLoadObject(mPackage$".cmmWarExplosionLob", class'Class'));
	}
	else
	{
		mShockWaveSecondaryType = class<ShockWave>(DynamicLoadObject(mPackage$".cmmShockWaveSecondary", class'Class'));
		mWarExplosionType = class<WarExplosion>(DynamicLoadObject(mPackage$".cmmWarExplosion", class'Class'));
	}

	mOriginalLocation = self.Location;

	foreach AllActors(class'cmmReplicationX', mReplicationInfo)
	{
		if(mPackage ~= class'cmmCommon'.static.GetPackageName(string(mReplicationInfo.class)))
			break;
		mReplicationInfo = None;
	}

	if(mReplicationInfo == None)
		return;

	// Explicit initialization
	TimerCount = 0;
	StrideCount = 0;
	OldStrideCount = 0;
	DistanceTravelled = 0;
	bFirstTime = true;

	// Possible items to make adjustable in the future
	minStartRadius = 25;
	ShockWaveEdgeGraceScale = 1.0;

	AccelerateScale = mReplicationInfo.swAccelerateScale;

	if(bLobbed)
		ShockWaveRadius = mReplicationInfo.lwRadius;
	else
		ShockWaveRadius = mReplicationInfo.swRadius;

	if(bIsPrimaryWave)
	{
		//ShockWaveEdgeGraceScale = mReplicationInfo.swEdgeGraceScale;
		SoundLevel = mReplicationInfo.swSoundLevel;
		SoundCount = mReplicationInfo.swSoundCount;
		SetWaveColor(mReplicationInfo.swColor);
		bDoSecondaryWave = mReplicationInfo.swSecondary;

		if(bLobbed)
		{
			bShakeView = false;
			LifeSpan = mReplicationInfo.lwLifeSpan;
		}
		else
		{
			bShakeView = mReplicationInfo.swShakeView;
			ShakeViewScale = mReplicationInfo.swShakeViewScale;
			LifeSpan = mReplicationInfo.swLifeSpan;
		}

		if(bDoSecondaryWave)
		{
			if(bLobbed)
				mSecondaryLifeSpan = mReplicationInfo.lwLifeSpanSecondary;
			else
				mSecondaryLifeSpan = mReplicationInfo.swLifeSpanSecondary;
		}
	}
	else
	{
		if(bLobbed)
			LifeSpan = mReplicationInfo.lwLifeSpanSecondary;
		else
			LifeSpan = mReplicationInfo.swLifeSpanSecondary;

		SetWaveColor(mReplicationInfo.swColorSecondary);
	}

	mStartingLifeSpan = LifeSpan;

	SetupStride();
}

simulated function PostBeginPlay()
{
	local Pawn P;

	if(bIsPrimaryWave && (Role == ROLE_Authority))
	{
		if(bShakeView)
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if ( P.IsA('PlayerPawn') && (VSize(P.Location - Location) < 3000) )
					PlayerPawn(P).ShakeView(0.5, ShakeViewScale*600000.0/VSize(P.Location - Location), 10);
			}
		}

		if ( Instigator != None )
			MakeNoise(10.0);
	}

	SetTimer(TIMER_GAP, True);

	if(bIsPrimaryWave && (Level.NetMode != NM_DedicatedServer))
		SpawnEffects();
}

simulated function Timer()
{
	local int i;
	local int StridesRequired;

	if(bFirstTime)
	{
		bFirstTime = false;
		DistanceTravelled = minStartRadius;
	}
	else if(StrideCount == 0)
	{
		DistanceTravelled += FirstStrideLength;
		StrideCount = 1;
	}
	else
	{
		StridesRequired = NumberOfStrides - (LifeSpan*100.0) - OldStrideCount;

		i = 0;
		while(i < StridesRequired)
		{
			DistanceTravelled += FirstStrideLength + (StrideCount*StrideIncrement);
			StrideCount++;

			i++;
		}
	}

	OldStrideCount = StrideCount;

	if(Level.NetMode != NM_DedicatedServer)
	{
		// Hmmm, so this diminishes. Want to keep it bright?
		ScaleGlow = Lifespan * 2;

		AmbientGlow = ScaleGlow * 255;
		DrawScale = DistanceTravelled/29;
	}

	if(TimerCount < 10)
	{
		TimerCount++;
		return;
	}

	TimerCount = 0;

	// If we need to start a second wave, we start it at a point in time such that it will
	// expand and catch up to primary wave when both of them reach their full size.
	if(bIsPrimaryWave && bDoSecondaryWave && (!bSecondarySpawned) && ((LifeSpan - mSecondaryLifeSpan) <= 0))
	{
		bSecondarySpawned = true;
		spawn(mShockWaveSecondaryType,,,mOriginalLocation);
	}

	if(bIsPrimaryWave)
	{
		if ( Level.NetMode != NM_DedicatedServer )
		{
			if (ICount==4)
			{
				spawn(class'WarExplosion2',,,Location);
			}
			ICount++;

			if ( Level.NetMode == NM_Client )
			{
				DoDamage(false);
				return;
			}
		}

		DoDamage(true);
	}

	OldShockDistance = DistanceTravelled;
}

simulated function DoDamage(bool bServer)
{
	local actor Victims;
	local float damageScale, dist, MoScale;
	local vector dir;

	foreach VisibleCollidingActors(class 'Actor', Victims, DistanceTravelled, Location)
	{
		if(bServer || (Victims.Role == ROLE_Authority))
		{
			dir = Victims.Location - Location;
			dist = FMax(1,VSize(dir));
			dir = dir/dist +vect(0,0,0.3);

			if ( (dist > OldShockDistance) || GetDirDotResult(bServer, dir, Victims.Velocity) )
			{
				MoScale = (ShockWaveRadius - (1.1 * Dist))/ShockWaveEdgeGraceScale;
				MoScale = FMax(0, MoScale);

				if (bServer && Victims.bIsPawn)
					Pawn(Victims).AddVelocity(dir * (MoScale + 20));
				else
					Victims.Velocity = Victims.Velocity + dir * (MoScale + 20);

				Victims.TakeDamage(MoScale, Instigator, Victims.Location - 0.5 * (Victims.CollisionHeight + Victims.CollisionRadius) * dir,	(1000 * dir), 'RedeemerDeath');
			}
		}
	}
}

simulated function bool GetDirDotResult(bool bServer, vector dir, vector velocity)
{
	if(bServer)
		return (dir dot velocity < 0);

	return (dir dot velocity <= 0);
}

simulated function SpawnEffects()
{
	local WarExplosion W;

	if(SoundCount > 0)
		PlaySound(Sound'Expl03', SLOT_None, SoundVolume);
	if(SoundCount > 1)
		PlaySound(Sound'Expl03', SLOT_Interface, SoundVolume);
	if(SoundCount > 2)
		PlaySound(Sound'Expl03', SLOT_Misc, SoundVolume);
	if(SoundCount > 3)
		PlaySound(Sound'Expl03', SLOT_Talk, SoundVolume);
	W = spawn(mWarExplosionType,,,Location);
	W.RemoteRole = ROLE_None;
}

simulated function float GetShockSize()
{
	return DistanceTravelled/29;
}

simulated function SetupStride()
{
	NumberOfStrides = mStartingLifeSpan/TIMER_GAP;

	AvgStrideLength = (ShockWaveRadius - minStartRadius)/NumberOfStrides;

	// Make the first stride some percentage less than the average stride.
	FirstStrideLength = AvgStrideLength*AccelerateScale;

	// Do the opposite for the last stride, make it longer by the same amount
	// that the first stride was reduced.
	LastStrideLength = AvgStrideLength + (AvgStrideLength - FirstStrideLength);

	// This is the amount I need to increase my stride by every
	// time if I am to get to my distance by the last stride.
	StrideIncrement = (LastStrideLength - FirstStrideLength)/(NumberOfStrides - 1);
}

simulated function SetWaveColor(string s)
{
	if((s ~= "fire") || (s == ""))
	{
		MultiSkins[1] = Texture'swFire';
		return;
	}

	MultiSkins[1] = Texture(DynamicLoadObject(s, class'Texture'));
}

defaultproperties
{
	bIsPrimaryWave=true
	bLobbed=false
	bDoSecondaryWave=false
	LifeSpan=1.500000
	bSecondarySpawned=false
	TIMER_GAP=0.01
}

