//====================================================================================
// cmmWarExplosion | by Helen! | www.birdieman.com/forum
//====================================================================================
class cmmWarExplosion extends WarExplosion;

#exec AUDIO IMPORT FILE="SOUNDS\cmmBlast.WAV" NAME="cmmBlast"

var float SoundVolume;
var float SoundRadius;

var cmmReplicationY mWarInfo;
var string mPackage;
var bool bPostDone;
var string mySound;
var bool bLobbed;

var float DrawScaleLob;
var float SoundRadiusLob;
var int SoundVolumeLob;

simulated function PostBeginPlay()
{
	if(bPostDone)
		return;
	bPostDone = true;

	Super.PostBeginPlay();

	mPackage = class'cmmCommon'.static.GetPackageName(string(self.class));

	foreach AllActors(class'cmmReplicationY', mWarInfo)
	{
		if(mPackage ~= class'cmmCommon'.static.GetPackageName(string(mWarInfo.class)))
			break;
		mWarInfo = None;
	}

	if(mWarInfo != None)
	{
		if(bLobbed)
		{
			DrawScale = class'cmmCommon'.static.ValidateFloat(mWarInfo.leDrawScale, Default.DrawScaleLob, 0.1, 30);
			SoundRadius = class'cmmCommon'.static.ValidateFloat(mWarInfo.leSoundRadius, Default.SoundRadiusLob, 5, 20000);
			SoundVolume = class'cmmCommon'.static.ValidateFloat(mWarInfo.leSoundVolume, Default.SoundVolumeLob, 1, 16);
		}
		else
		{
			DrawScale = class'cmmCommon'.static.ValidateFloat(mWarInfo.weDrawScale, Default.DrawScale, 0.5, 30);
			SoundRadius = class'cmmCommon'.static.ValidateFloat(mWarInfo.weSoundRadius, Default.SoundRadius, 5, 20000);
			SoundVolume = class'cmmCommon'.static.ValidateFloat(mWarInfo.weSoundVolume, Default.SoundVolume, 1, 16);
		}
		mySound = mWarInfo.weSound;
	}

	if (!Level.bHighDetailMode)
		Drawscale = GetLowDetailDrawScale();
	PlaySound(GetBlastSound(),,SoundVolume,,SoundRadius);
	Texture = Default.Texture;
}

simulated function float GetLowDetailDrawScale()
{
	return ((DrawScale * 2)/3);
}

simulated function sound GetBlastSound()
{
	if(mySound ~= "Blast")
		return sound'cmmBlast';

	return sound'Botpack.Redeemer.WarExplo';
}

defaultproperties
{
	SoundVolume=12.0
	SoundRadius=3000
	DrawScale=1.0
	SoundVolumeLob=6;
	SoundRadiusLob=600;
	DrawScaleLob=0.2
	bLobbed=false
}
