//=============================================================================
// cmmWarheadLauncher
//=============================================================================
//	20110108 Helen: In the case where a player has joined a game already in progress,
//		this class is not able to find an instance of the cmmReplicationX. So for
//		this class, a bunch of the necessary values are replicated locally.
//	20110127 Helen: class renamed as per original author's request.
//	20110906 Helen: Brought in the lobbing of grenades code from medRezzer010.
//=============================================================================

class cmmWarheadLauncher expands TournamentWeapon config(PirateDeemerCMM);

#exec MESH IMPORT  MESH=WarHead ANIVFILE=MODELS\war_a.3D DATAFILE=MODELS\war_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=WarHead X=0 Y=-210 Z=-50 YAW=64 PITCH=16  ROLL=-62
#exec MESH SEQUENCE MESH=WarHead SEQ=All         STARTFRAME=0   NUMFRAMES=35
#exec MESH SEQUENCE MESH=WarHead SEQ=Select      STARTFRAME=0   NUMFRAMES=15
#exec MESH SEQUENCE MESH=WarHead SEQ=Still       STARTFRAME=15  NUMFRAMES=1
#exec MESH SEQUENCE MESH=WarHead SEQ=Idle        STARTFRAME=15  NUMFRAMES=5
#exec MESH SEQUENCE MESH=WarHead SEQ=Down        STARTFRAME=20  NUMFRAMES=7
#exec MESH SEQUENCE MESH=WarHead SEQ=Fire        STARTFRAME=28  NUMFRAMES=7
#exec TEXTURE IMPORT NAME=Jwarhead1 FILE=MODELS\warh1.PCX GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=Jwarhead2 FILE=MODELS\warh2.PCX GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=Jwarhead3 FILE=MODELS\warh3.PCX GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=Jwarhead4 FILE=MODELS\warh4.PCX GROUP=Skins LODSET=2
#exec MESHMAP SCALE MESHMAP=WarHead X=0.006 Y=0.006 Z=0.012
#exec MESHMAP SETTEXTURE MESHMAP=WarHead NUM=0 TEXTURE=Jwarhead1
#exec MESHMAP SETTEXTURE MESHMAP=WarHead NUM=1 TEXTURE=Jwarhead2
#exec MESHMAP SETTEXTURE MESHMAP=WarHead NUM=2 TEXTURE=Jwarhead3
#exec MESHMAP SETTEXTURE MESHMAP=WarHead NUM=3 TEXTURE=Jwarhead4

#exec MESH IMPORT MESH=WHHand ANIVFILE=MODELS\WHpick_a.3D DATAFILE=MODELS\WHpick_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=WHHand X=-150 Y=-110 Z=0 YAW=0 ROLL=-64
#exec MESH SEQUENCE MESH=WHHand SEQ=All         STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=WHHand SEQ=Still       STARTFRAME=0   NUMFRAMES=1
#exec MESHMAP SCALE MESHMAP=WHHand X=0.05 Y=0.05 Z=0.1
#exec MESHMAP SETTEXTURE MESHMAP=WHHand NUM=1 TEXTURE=JWHPick1

#exec TEXTURE IMPORT NAME=IconWarH FILE=MODELS\IconWarH.PCX GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=UseWarH FILE=MODELS\UseWarH.PCX GROUP="Icons" MIPS=OFF

//Custom import from here
//#exec texture IMPORT NAME=Static_A00A FILE=TEXTURES\Static_A00A.pcx FLAGS=2 MIPS=OFF
#exec AUDIO IMPORT FILE="SOUNDS\cmmShotChoom.wav" NAME="cmmShotChoom" GROUP=Redeemer
#exec AUDIO IMPORT FILE="SOUNDS\cmmShotFireInHole.wav" NAME="cmmShotFireInHole" GROUP=Redeemer
#exec AUDIO IMPORT FILE="Sounds\WarheadPickupA.wav" NAME="WarheadPickupA" GROUP=Redeemer

// sniper zoom effects
#exec texture IMPORT NAME=zBarH FILE=TEXTURES\zBarH.PCX FLAGS=2 MIPS=OFF
#exec texture IMPORT NAME=zBarV FILE=TEXTURES\zBarV.PCX FLAGS=2 MIPS=OFF

// flat colors
#exec texture IMPORT NAME=MEDBLUE FILE=TEXTURES\MEDBLUE.PCX FLAGS=2 MIPS=OFF
#exec texture IMPORT NAME=WINE FILE=TEXTURES\WINE.PCX FLAGS=2 MIPS=OFF
#exec texture IMPORT NAME=DARKGREE FILE=TEXTURES\DARKGREE.PCX FLAGS=2 MIPS=OFF

enum ELogType
{
	LOG_info,   // 0
	LOG_error,   // 1
	LOG_debug
};
enum EAltFireType
{
	ALTFIRE_guide,
	ALTFIRE_zoom,
	ALTFIRE_lob
};

var string mPackage;

var() class<projectile> GrenadeClass;
// config vars
var() config int ScrollSpeed;
var() config float FireAnimationRate;
var() config string myFireSound;


var bool bLogInfo;
var() config bool bDebug;


var float GuideSpeed;
var float MaxGuideSpeed;

// class vars
var cmmReplicationX mReplicationInfo;
var cmmReplicationY mWarInfo;
var EAltFireType mAltFireMode;
var ERenderStyle mZoomDrawStyle;
var cmmGuidedWarShell GuidedShell;
var int Scroll;
var PlayerPawn GuidingPawn;
var bool    bGuiding, bCanFire, bShowStatic;
var rotator StartRotation;
var int ScrollCounter;    //slow the alt fire HUD side scroll down
var Texture mTexture;	// this is the zoom pic
var Texture mGuideTexture;
var float mBarRate;
var int mBarPause;
var int mBlinkIndex;
var Texture blinkSet[6];
var bool bPreDone;
var bool bPostDone;
var bool mBars;
var	Texture mBarH;
var	Texture mBarV;

var float mBarLeftX;
var float mBarRightX;
var float mBarBottomY;
var	int mBarTextureWidth;
var float mLastScale;
var float mLastClipX;
var float mLastClipY;
var bool bBarPaused;
var float mBarCountDown;
var int BAR_STEP;
var int mBarPadding;
var bool mDrawBars;

var bool mServerOwnsCrossHair;

//var string mAmmoKind;
var int mAmmoPer;
var int mMaxLob;
// == Advertising ==

var() config bool Advertise;
var() config string AdText;

// How far the ad should move from top to bottom - 20110709: no longer a config var
var float AdMoveDistance;
// scales how fast it fades in/out (and by default, how fast it moves)
var() config float AdFadeRate;
// starting point of ad text X. Valid choices are left, center, right
var() config string AdStartX;
// starting point of ad text Y. Valid choices are top, center, bottom
var() config string AdStartY;

// colors of text and background bars
var() config string AdTextColor;
var() config string AdBarColor;

// how may background bars to show. Valid choices are 0, 1, 2.
var() config int AdBarCount;

// Let's PostRender know if it should be advertising at the present moment.
var bool bAdvertising;

// Last draw position
var float AdX, AdY;

// % of translucence to use for the text at a given moment
var float mFadeFactor;

// This will be how many iterations of postRender it took to get fade factor to go from 0 to 1.
var int mFadeCount;

var color mAdTextColor;
var color mAdIconColor;
var float mAdTextWidth;
var float mAdTextHeight;
var float mAdWingWidth;
var float mAdBarHeight;
var float mAdBaseX;
var float mAdBaseY;
var Texture mAdBarTex;

// for help with slow replication
var bool bAdTextColorSet;
var bool bAdBarColorSet;

var bool bValidated;

var enum EFadeMode
{
	FADE_IN,
	FADE_PAUSE,
	FADE_OUT,

} FadeMode;

// == END of advertising ==

var string AmmoKind;

var FontInfo MyFonts;

var float lsSpeed;
var string mReplicationFlag;
var float RespawnTime;

// --------- lob -------------------
var int RocketsLoaded, ClientRocketsLoaded;
var bool bTightWad, bInstantRocket, bAlwaysInstant, bClientDone, bRotated;
// ---------------------------------

// Texture for the scrolling readout on the side.
var() config string Readout;
var texture mReadoutTex;

// debug
var config string myDebug[2];
//var int myDebugCount;

replication
{
	// Things the server should send to the client.
	reliable if(Role == ROLE_Authority)
	    mAltFireMode, mZoomDrawStyle, mTexture, mGuideTexture, blinkSet, mBarRate, mBarPause, mDrawBars, mBarH, mBarV, mBarPadding,
	    Advertise, AdText, bAdvertising, AdMoveDistance, AdFadeRate, AdStartX, AdStartY,
		AdBarColor, AdTextColor, AdBarCount,
	    InitAdvertising,
	    myFireSound,
	    FireAnimationRate,
	    ScrollSpeed,
	    RespawnTime,
	    mMaxLob,
	    mReplicationFlag,
	    mReadoutTex,
		bGuiding, bShowStatic;

	// The client packs up the parameter values in this call and gets it to run on server
	reliable if (Role < ROLE_Authority)
		UpdateServerOwnsCrossHair;
}

simulated function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

simulated function PreBeginPlay()
{
	local TournamentGameInfo aTGI;

	if(bPreDone)
		return;
	bPreDone = true;

	doLog(LOG_debug, "PreBeginPlay() from "$mPackage);

	mPackage = class'cmmCommon'.static.GetPackageName(string(self.class));
	ProjectileClass = class<projectile>(DynamicLoadObject(mPackage$".cmmWarShell", class'Class'));
	GrenadeClass = class<projectile>(DynamicLoadObject(mPackage$".medRezzerGrenade", class'Class'));
	AltProjectileClass = class<projectile>(DynamicLoadObject(mPackage$".cmmGuidedWarShell", class'Class'));

	// lob
	bInstantRocket = false;
	bAlwaysInstant = false;
	//bLockedOn = false;
	// end lob

	// We also need this task done just once. This will get the
	// deathmessage that is broadcast to have our ItemName.
	foreach AllActors(class'TournamentGameInfo', aTGI)
		break;

	if(aTGI != None)
		aTGI.RedeemerClass = class'cmmWarHeadLauncher';
}

simulated function PostBeginPlay()
{
	local color aDefaultTextColor;
	local color aDefaultBarColor;

	if(bPostDone)
		return;
	bPostDone = true;

	Super.PostBeginPlay();

	if(Role < ROLE_Authority)
	{
		MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));

		aDefaultTextColor.R = 255;
		aDefaultTextColor.G = 255;
		aDefaultTextColor.B = 255;

		return;
	}

	FireAnimationRate = class'cmmCommon'.static.ValidateFloat(FireAnimationRate, Default.FireAnimationRate, 0.1, 1.0);

	foreach AllActors(class'cmmReplicationX', mReplicationInfo)
	{
		if(mPackage ~= class'cmmCommon'.static.GetPackageName(string(mReplicationInfo.class)))
			break;
		mReplicationInfo = None;
	}

	if(mReplicationInfo != None)
	{
		if(mReplicationInfo.AltFireMode ~= "zoom")
			mAltFireMode = ALTFIRE_zoom;
		else if(mReplicationInfo.AltFireMode ~= "lob")
			mAltFireMode = ALTFIRE_lob;
		else
			mAltFireMode = ALTFIRE_guide;

		if(mAltFireMode  == ALTFIRE_lob)
			AltProjectileClass = class<projectile>(DynamicLoadObject(mPackage$".medRezzerGrenade", class'Class'));
		else
			AltProjectileClass = class<projectile>(DynamicLoadObject(mPackage$".cmmGuidedWarShell", class'Class'));

		if(mAltFireMode == ALTFIRE_zoom)
		{
			if(mReplicationInfo.zDrawStyle ~= "normal")
				mZoomDrawStyle = ERenderStyle.STY_NORMAL;
			else
				mZoomDrawStyle = ERenderStyle.STY_Translucent;

			mTexture = Texture(DynamicLoadObject(mReplicationInfo.zPic, class'Texture'));

			// This is the gliding "bars" on the zoom scope.
			if(mReplicationInfo.zBar)
			{
				mBarRate = class'cmmCommon'.static.ValidateFloat(mReplicationInfo.zBarRate, Default.mBarRate, 0.02, 5.0);
				mBarPause = class'cmmCommon'.static.ValidateFloat(mReplicationInfo.zBarPause, Default.mBarPause, 0, 50);
				mBarPadding = class'cmmCommon'.static.ValidateInt(mReplicationInfo.zBarPadding, Default.mBarPadding, 0, 20);
				mBarH = Texture'zBarH';
				mBarV = Texture'zBarV';
				mDrawBars = true;
			}
		}

		GuideSpeed = mReplicationInfo.GuideSpeed;

		if(mAltFireMode  == ALTFIRE_guide)
			AltProjectileSpeed = GuideSpeed;
		else if(mAltFireMode  == ALTFIRE_lob)
			AltProjectileSpeed = lsSpeed;
	}

	foreach AllActors(class'cmmReplicationY', mWarInfo)
	{
		if(mPackage ~= class'cmmCommon'.static.GetPackageName(string(mWarInfo.class)))
			break;
		mWarInfo = None;
	}

	if(mWarInfo != None)
	{
		AmmoKind = mWarInfo.AmmoKind;
		if(mWarInfo.bArena)
			PickupAmmoCount = mWarInfo.AmmoPer;

		mMaxLob = mWarInfo.MaxLob;

		if(mAltFireMode == ALTFIRE_guide)
		{
			mGuideTexture = Texture(DynamicLoadObject(mWarInfo.GuidePic, class'Texture'));
		}

		RespawnTime = class'cmmCommon'.static.ValidateFloat(mWarInfo.rezRespawnTime, Default.RespawnTime, 3, 600);
		lsSpeed = class'cmmCommon'.static.ValidateFloat(mWarInfo.lsSpeed, Default.lsSpeed, 200, 5000);
	}

	if(mAltFireMode == ALTFIRE_guide)
	{
		mReadoutTex = Texture(DynamicLoadObject(Readout, class'Texture'));
	}

	AmmoName = class<ammo>(DynamicLoadObject(mPackage$"."$AmmoKind, class'Class'));

	if(AdText != "")
	{
		PickupMessage = "You got the "$AdText;
		ItemName = AdText;
	}
}

simulated function Timer()
{
	if((mAltFireMode == ALTFIRE_zoom) && mDrawBars && bOwnsCrossHair && isScopeUp())
	{
		if(bBarPaused)
		{
			mBarCountDown -= mBarRate;
			bBarPaused = (mBarCountDown > 0);
		}
		else
		{
			if( (mBarRightX  < ((0.5 * mLastClipX) + (32 * mLastScale))) ||
				(mBarBottomY < ((0.5 * mLastClipY) + (32 * mLastScale))) ||
				(mBarLeftX > ((0.5 * mLastClipX) - (32 * mLastScale) - (mBarTextureWidth * mLastScale)) )
			)
			{
				bBarPaused = true;
				ResetBarStart();
				mBarCountDown = mBarRate * mBarPause;
			}
			else
			{
				mBarLeftX += BAR_STEP;
				mBarRightX -= BAR_STEP;
				mBarBottomY -= BAR_STEP;
			}
		}
		SetTimer(mBarRate, False);
		return;
	}
}

function SetWeaponStay()
{
	bWeaponStay = false;
}

simulated function color GetFadeColor(color ABaseColor, float AFadeFactor)
{
	local color aColor;

	// Don't process invalid values
	if((AFadeFactor < 0) || (AFadeFactor > 1))
		return ABaseColor;

	aColor.R = ABaseColor.R * AFadeFactor;
	aColor.G = ABaseColor.G * AFadeFactor;
	aColor.B = ABaseColor.B * AFadeFactor;

	return aColor;
}

simulated function PostRender(canvas Canvas)
{
	local int i, numReadouts, OldClipX, OldClipY;
	local float XScale;
	local PlayerPawn P;
	local float Scale;
	local int stretch;
	local float preX, preY;

	if(mAltFireMode == ALTFIRE_zoom)
	{
		Super.PostRender(Canvas);
		bOwnsCrossHair = ((Owner != None) && (Owner.IsA('PlayerPawn')) && (PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV));
		if(mServerOwnsCrossHair != bOwnsCrossHair)
		{
	        mServerOwnsCrossHair = bOwnsCrossHair;
			UpdateServerOwnsCrossHair(mServerOwnsCrossHair);
		}
	}
	else
	{
		bOwnsCrossHair = (bGuiding || bShowStatic);

		if((!bGuiding) && bShowStatic)
		{
			Canvas.SetPos(0, 0);
			Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.DrawIcon(Texture'Botpack.Static_A00', FMax(Canvas.ClipX, Canvas.ClipY)/256.0);
			if ( Owner.IsA('PlayerPawn') )
				PlayerPawn(Owner).ViewTarget = None;
			return;
		}
	}

	if(!bOwnsCrossHair)
	{
		if(Advertise && bAdvertising && (AdText != ""))
		{
			if((FadeMode == EFadeMode.FADE_OUT) && (mFadeFactor <= 0))
			{
				bAdvertising = false;
				return;
			}

			Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

			if(FadeMode == EFadeMode.FADE_IN)
			{
		        mFadeCount++;

				if (mFadeFactor == 0)
				{
					// This is the first call, so we need to do some initialization
					// that we can only do when we have the Canvas object.
					Canvas.StrLen(AdText, mAdTextWidth, mAdTextHeight);

					mAdBaseX = GetAdStartX(canvas) - (mAdTextWidth/2);
					mAdBaseY = GetAdStartY(canvas);

					AdX = mAdBaseX;
				}

				if (mFadeFactor > 1)
				{
					mFadeFactor = 1;
					FadeMode = EFadeMode.FADE_PAUSE;
					// Double how long it pauses in comparison to the fade time.
					mFadeCount = mFadeCount*2;
				}
				else
				{
					mFadeFactor = mFadeFactor + (0.005 * AdFadeRate);
				}
			}
			else if(FadeMode == EFadeMode.FADE_PAUSE)
			{
		        mFadeCount--;
		        if(mFadeCount <= 0)
		        	FadeMode = EFadeMode.FADE_OUT;
			}
			else
			{
				mFadeFactor = mFadeFactor - (0.005 * AdFadeRate);
				if(mFadeFactor < 0)
					mFadeFactor = 0;
			}

			AdY = mAdBaseY - (AdMoveDistance * mFadeFactor);

			// Draw Bar
			if(AdBarCount > 0)
			{
				if(!bAdBarColorSet && (self.AdBarColor != ""))
				{
					// If we try to do this during PostBeginPlay, the value has
					// not been replicated yet, so we do it here at a later time.
					bAdBarColorSet = true;
					mAdBarTex = GetTexColor(AdBarColor);
				}

				// Don't ever draw the bars 'normal', because it overpowers the text, making it illegible.
				Canvas.Style = ERenderStyle.STY_Translucent;

				Canvas.DrawColor = GetFadeColor(mAdIconColor, mFadeFactor);

				preX = AdX;
				preY = AdY;

				// AdX is currently set to be the left of where the text is drawn. So move it to the left.
				AdX = AdX - mAdWingWidth;

				if(AdBarCount == 1)
				{
					AdY = AdY + 7;
					Canvas.SetPos(AdX, AdY);
					Canvas.DrawTileClipped(mAdBarTex, mAdTextWidth + (mAdWingWidth*2), 7, 0, 0, 4, 4);
				}
				else
				{
					// AdY is currently set to the top of where the text is drawn. We start our bar a little lower.
					AdY = AdY + 6;

					Canvas.SetPos(AdX, AdY);
					Canvas.DrawTileClipped(mAdBarTex, mAdTextWidth + (mAdWingWidth*2), mAdBarHeight, 0, 0, 4, 4);

					// Move down a bit
					AdY = AdY + 6;

					Canvas.SetPos(AdX, AdY);
					Canvas.DrawTileClipped(mAdBarTex, mAdTextWidth + (mAdWingWidth*2), mAdBarHeight, 0, 0, 4, 4);
				}

				// Restore pos to where the text needs to be drawn
				AdX = preX;
				AdY = preY;
			}

			if(FadeMode == EFadeMode.FADE_PAUSE)
				Canvas.Style = ERenderStyle.STY_Normal;
			else
				Canvas.Style = ERenderStyle.STY_Translucent;

			if(!bAdTextColorSet && (AdTextColor != ""))
			{
				// If we try to do this during PostBeginPlay, the value has
				// not been replicated yet, so we do it here at a later time.
				bAdTextColorSet = true;
				mAdTextColor = class'cmmCommon'.static.GetColor(AdTextColor, mAdIconColor);
			}

			// Finally the weapon name
			Canvas.SetPos(AdX, AdY);
			Canvas.DrawColor = GetFadeColor(mAdTextColor, mFadeFactor);
			Canvas.DrawText(AdText);
		}

		return;
	}
	// Note, at this point it should not be possible that the mode is ALTFIRE_lob.

	if(mAltFireMode == ALTFIRE_zoom)
	{
		// This basically comes from SniperRifle.uc
		P = PlayerPawn(Owner);

		// The crosshair
		Scale = Canvas.ClipX/640;
		Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
		Canvas.Style = mZoomDrawStyle;
		Canvas.DrawIcon(mTexture, Scale);

		// Bar effects
		if(mDrawBars)
		{
			mLastScale = Scale;
			mLastClipX = Canvas.ClipX;
			mLastClipY = Canvas.ClipY;

			if(!bBarPaused)
			{
				if(mBarLeftX == -666)
					ResetBarStart();

				stretch = Rounder(mLastScale) + mBarPadding;

				// left bar
				Canvas.SetPos(mBarLeftX, (0.5 * Canvas.ClipY) - (mLastScale/2));
				Canvas.DrawRect(mBarH, (mBarTextureWidth * mLastScale), stretch);

				// right bar
				Canvas.SetPos(mBarRightX, (0.5 * Canvas.ClipY) - (mLastScale/2));
				Canvas.DrawRect(mBarH, (mBarTextureWidth * mLastScale), stretch);

				// bottom bar
				Canvas.SetPos((0.5 * Canvas.ClipX) - (mLastScale/2), mBarBottomY);
				Canvas.DrawRect(mBarV, stretch, (mBarTextureWidth * mLastScale));
			}
		}

		Canvas.SetPos(0.5 * Canvas.ClipX + 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale);
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
		Scale = P.DefaultFOV/P.DesiredFOV;
		Canvas.DrawText("X"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));

		return;
	}

	GuidedShell.PostRender(Canvas);
	OldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	XScale = FMax(0.5, int(Canvas.ClipX/640.0));
	Canvas.SetPos( 0.5 * OldClipX - 128 * XScale, 0.5 * OldClipY - 128 * XScale );

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawIcon(mGuideTexture, XScale);

	numReadouts = OldClipY/128 + 2;
	for ( i = 0; i < numReadouts; i++ )
	{
		Canvas.SetPos(1,Scroll + i * 128);
		ScrollCounter++;

		if(ScrollCounter == ScrollSpeed)
		{
			Scroll--;
			ScrollCounter = 0;
		}

		if ( Scroll < -128 )
		{
			Scroll = 0;
		}

		Canvas.DrawIcon(mReadoutTex, 1.0);  // Custom texture for the side scroll
	}
}

function float RateSelf( out int bUseAltMode )
{
	local Pawn P, E;
	local Bot O;

	O = Bot(Owner);
	if ( (O == None) || (AmmoType.AmmoAmount <=0) || (O.Enemy == None) )
		return -2;

	bUseAltMode = 0;
	E = O.Enemy;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.bIsPlayer && (P != O) && (P != E)
			&& (!Level.Game.bTeamGame || (O.PlayerReplicationInfo.Team != P.PlayerReplicationInfo.Team))
			&& (VSize(E.Location - P.Location) < 650)
			&& (!Level.Game.IsA('TeamGamePlus') || TeamGamePlus(Level.Game).PriorityObjective(O) < 2)
			&& FastTrace(P.Location, E.Location) )
		{
			if ( VSize(E.Location - O.Location) > 500 )
				return 2.0;
			else
				return 1.0;
		}

	return 0.35;
}

// return delta to combat style
function float SuggestAttackStyle()
{
	return -1.0;
}

simulated function PlayFiring()
{
	PlayAnim('Fire', FireAnimationRate);
	PlayOwnedSound(GetFireSound(), SLOT_None,4.0*Pawn(Owner).SoundDampening);
}

function setHand(float Hand)
{
	if ( Hand == 2 )
	{
		bHideWeapon = true;
		return;
	}
	else
		bHideWeapon = false;

	PlayerViewOffset.Y = Default.PlayerViewOffset.Y;
	PlayerViewOffset.X = Default.PlayerViewOffset.X;
	PlayerViewOffset.Z = Default.PlayerViewOffset.Z;

	PlayerViewOffset *= 100; //scale since network passes vector components as ints
}

function AltFire(float Value)
{
	if(mAltFireMode == ALTFIRE_zoom)
	{
		ClientAltFire(Value);
		return;
	}

	if(mAltFireMode == ALTFIRE_lob)
	{
		bPointing = true;
		bCanClientFire = true;
		if ( AmmoType == None )
		{
			// ammocheck
			GiveAmmo(Pawn(Owner));
		}
		if ( AmmoType.UseAmmo(1) )
		{
			GoToState('AltFiring');
		}
		return;
	}
	if(!Owner.IsA('PlayerPawn'))
	{
		Fire(Value);
		return;
	}

	if (AmmoType.UseAmmo(1))
	{
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		Pawn(Owner).PlayRecoil(FiringSpeed);
		PlayFiring();
		GuidedShell = cmmGuidedWarShell(ProjectileFire(AltProjectileClass, GuideSpeed, bWarnTarget));
		GuidedShell.SetOwner(Owner);
		PlayerPawn(Owner).ViewTarget = GuidedShell;
		GuidedShell.Guider = PlayerPawn(Owner);
		ClientAltFire(0);
		GotoState('Guiding');
	}
}

simulated function bool ClientAltFire( float Value )
{
	if(mAltFireMode == ALTFIRE_zoom)
	{
		if(mDrawBars && (!isScopeUp()) && (Role < ROLE_Authority))
			SetTimer(mBarRate, False);

		GotoState('Zooming');
		return true;
	}

	if(mAltFireMode == ALTFIRE_lob)
	{
		if ( bCanClientFire && ((Role == ROLE_Authority) || (AmmoType == None) || (AmmoType.AmmoAmount > 0)) )
		{
			GotoState('ClientAltFiring');
			return true;
		}
		return false;
	}

	if(bCanClientFire && ((Role == ROLE_Authority) || (AmmoType == None) || (AmmoType.AmmoAmount > 0)))
	{
		if ( Affector != None )
			Affector.FireEffect();
		PlayOwnedSound(GetFireSound(), SLOT_None,4.0*Pawn(Owner).SoundDampening);

		return true;
	}

	return false;
}

simulated function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Vector Start, X,Y,Z;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);
	Owner.MakeNoise(PawnOwner.SoundDampening);

	if(mServerOwnsCrossHair) // zoomed
	{
		// This is our attempt to get it drawn as close to the center as we can.
		Start = Owner.Location + CalcDrawOffset();
	}
	else
	{
		GetAxes(PawnOwner.ViewRotation,X,Y,Z);
		Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
	}
	AdjustedAim = PawnOwner.AdjustAim(ProjSpeed, Start, AimError, True, bWarn);
	return Spawn(ProjClass,,, Start,AdjustedAim);
}

simulated function UpdateServerOwnsCrossHair(bool AOwnsCrossHair)
{
	// This check shouldn't be necessary, but it helps with the story as to when I am expecting this method to run.
	if(Role == ROLE_SimulatedProxy)
		return;

	// We are on the server, updating this value.
	mServerOwnsCrossHair = AOwnsCrossHair;
}

simulated function bool isScopeUp()
{
	if(mAltFireMode != ALTFIRE_zoom)
		return false;

	if(Owner == None)
		return false;

	if(!Owner.IsA('PlayerPawn'))
		return false;

	return (PlayerPawn(Owner).DefaultFOV != PlayerPawn(Owner).DesiredFOV);
}

State Guiding
{
	function Fire ( float Value )
	{
		if ( !bCanFire )
			return;
		if ( GuidedShell != None )
			GuidedShell.Explode(GuidedShell.Location,Vect(0,0,1));
		bCanClientFire = true;

		GotoState('Finishing');
	}

	function AltFire ( float Value )
	{
		Fire(Value);
	}

	function BeginState()
	{
		Scroll = 0;
		bGuiding = true;
		bCanFire = false;
		if ( Owner.IsA('PlayerPawn') )
		{
			GuidingPawn = PlayerPawn(Owner);
			StartRotation = PlayerPawn(Owner).ViewRotation;
			PlayerPawn(Owner).ClientAdjustGlow(-0.2,vect(200,0,0));
		}
	}

	function EndState()
	{
		bGuiding = false;
		if ( GuidingPawn != None )
		{
			GuidingPawn.ClientAdjustGlow(0.2,vect(-200,0,0));
			GuidingPawn.ClientSetRotation(StartRotation);
			GuidingPawn = None;
		}
	}


Begin:
	Sleep(1.0);
	bCanFire = true;
}

state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if(Owner == None)
			return;

		if ( Pawn(Owner).bAltFire == 0 )
		{
			PlayerPawn(Owner).StopZoom();
			GoToState('Idle');
		}
	}

	simulated function BeginState()
	{
		if ( Owner.IsA('PlayerPawn') )
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).ToggleZoom();
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}

State Finishing
{
	ignores Fire, AltFire;

	function BeginState()
	{
		bShowStatic = true;
	}

Begin:
	Sleep(0.2);
	bShowStatic = false;
	Sleep(1.0);
	GotoState('Idle');
}

function BringUp()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		SetHand(PlayerPawn(Owner).Handedness);
		PlayerPawn(Owner).EndZoom();
	}
	bWeaponUp = false;
	PlaySelect();

	// == start of cmm code ==
	InitAdvertising();
	// == end of cmm code ==

	GotoState('Active');
}

simulated function ClientPutDown(Weapon NextWeapon)
{
	bAdvertising = false;
}

simulated function InitAdvertising()
{
	FadeMode = EFadeMode.FADE_IN;
	mFadeCount = 0;
	mAdTextWidth = 0;
	mFadeFactor = 0;

	if(!bValidated)
	{
		bValidated = true;
		AdFadeRate = class'cmmCommon'.static.ValidateFloat(AdFadeRate, Default.AdFadeRate, 1, 20);
		AdBarCount = class'cmmCommon'.static.ValidateInt(AdBarCount, Default.AdBarCount, 0, 2);
	}

	// Ready
	bAdvertising = true;
}

simulated function float GetAdStartX(canvas c)
{
	if(AdStartX ~= "left")
		return c.ClipX/4;

	if(AdStartX ~= "center")
		return c.ClipX/2;

	if(AdStartX ~= "right")
		return (c.ClipX*3)/4;

	// for unknown value, use center
	return c.ClipX/2;
}

simulated function float GetAdStartY(canvas c)
{
	if(AdStartY ~= "top")
		return c.ClipY/4;

	if(AdStartY ~= "center")
		return c.ClipY/2;

	if(AdStartY ~= "bottom")
		return (c.ClipY*3)/4;

	// for unknown value, use center
	return c.ClipY/2;
}

simulated function ResetBarStart()
{
	mBarLeftX = GetLeftStartingPoint();
	mBarRightX = GetRightStartingPoint();
	mBarBottomY = GetBottomStartingPoint();
}

simulated function float GetLeftStartingPoint()
{
	return ( (0.5 * mLastClipX) - (96 * mLastScale) );
}

simulated function float GetRightStartingPoint()
{
	return ( (0.5 * mLastClipX) + (96 * mLastScale) - (mBarTextureWidth * mLastScale) );
}

simulated function float GetBottomStartingPoint()
{
	return ( (0.5 * mLastClipY) + (96 * mLastScale) - (mBarTextureWidth * mLastScale) );
}

simulated function DrawClip(Canvas c, Texture aTexture, int AWidth, int AHeight, int xClipStart, int yClipStart, int xClipWidth, int yClipWidth)
{
	c.DrawTileClipped(aTexture, AWidth, AHeight, xClipStart, yClipStart, xClipWidth, yClipWidth);
}

// Round to the closest integer.
simulated function int Rounder(float f)
{
	local float high, low;
	local float highDif, lowDif;

	low = int(f);
	high = low + 1;
	lowDif = f - low;
	highDif = high - f;

	if(highDif <= lowDif)
		return int(high);

	return int(low);
}

simulated function texture GetTexColor(string AColor)
{
	if(AColor ~= "blue")
		return texture'MEDBLUE';
	if(AColor ~= "green")
		return texture'DARKGREE';
	if(AColor ~= "red")
		return texture'WINE';

	return texture'MEDBLUE';
}

simulated function sound GetFireSound()
{
	if(myFireSound ~= "Choom")
		return sound'cmmShotChoom';
	if(myFireSound ~= "FireInHole")
		return sound'cmmShotFireInHole';

	return sound'Botpack.Redeemer.WarheadShot';
}

// --------- lob ---------------

simulated function PlayLoading(float rate, int num)
{
	if ( Owner == None )
		return;
	Owner.PlayOwnedSound(CockingSound, SLOT_None, Pawn(Owner).SoundDampening);
	PlayAnim('Idle', 1, 0.25);
}

simulated function PlayRotating(int num)
{
	Owner.PlayOwnedSound(Misc3Sound, SLOT_None, 0.1*Pawn(Owner).SoundDampening);
	PlayAnim('Idle', 1, 0.25);
}

simulated function FiringRockets()
{
	PlayRFiring(ClientRocketsLoaded - 1);
	bClientDone = true;
	Disable('Tick');
}

simulated function PlayRFiring(int num)
{
	if ( Affector != None )
		Affector.FireEffect();

	PlayOwnedSound(AltFireSound, SLOT_None, 4.0*Pawn(Owner).SoundDampening);

	PlayAnim('Idle', 1, 0.05);
}

//////////////////////////////////////////////////////
state AltFiring
{
	function Tick( float DeltaTime )
	{
		if( (pawn(Owner).bAltFire==0) || (RocketsLoaded > (mMaxLob-1)) )  // If if Fire button down, load up another
 			GoToState('FireRockets');
	}

	function AnimEnd()
	{
		if ( bRotated )
		{
			bRotated = false;
			PlayLoading(1.1, RocketsLoaded);
		}
		else
		{
			if ( RocketsLoaded == mMaxLob )
			{
				GotoState('FireRockets');
				return;
			}
			RocketsLoaded++;
			AmmoType.UseAmmo(1);
			if ( (PlayerPawn(Owner) == None) && ((FRand() > 0.5) || (Pawn(Owner).Enemy == None)) )
				Pawn(Owner).bAltFire = 0;
			bPointing = true;
			Owner.MakeNoise(0.6 * Pawn(Owner).SoundDampening);
			RotateRocket();
		}
	}

	function RotateRocket()
	{
		if (AmmoType.AmmoAmount<=0)
		{
			GotoState('FireRockets');
			return;
		}
		PlayRotating(RocketsLoaded-1);
		bRotated = true;
	}

	function BeginState()
	{
		Super.BeginState();
		RocketsLoaded = 1;
		RotateRocket();
	}

Begin:
	//bLockedOn = False;
}

//////////////////////////////////////////////////////
state ClientReload
{
	simulated function bool ClientFire(float Value)
	{
		// lob, guessing to return true for deemer normal fire needs
		return true;
		//bForceFire = bForceFire || ( bCanClientFire && (Pawn(Owner) != None) && (AmmoType.AmmoAmount > 0) );
		//return bForceFire;
	}

	simulated function bool ClientAltFire(float Value)
	{
		bForceAltFire = bForceAltFire || ( bCanClientFire && (Pawn(Owner) != None) && (AmmoType.AmmoAmount > 0) );
		return bForceAltFire;
	}

	simulated function AnimEnd()
	{
		if ( bCanClientFire && (PlayerPawn(Owner) != None) && (AmmoType.AmmoAmount > 0) )
		{
			// lob, not sure if i need this if statement...
			if ( bForceFire || (Pawn(Owner).bFire != 0) )
			{
				Global.ClientFire(0);
				return;
			}

			else if ( bForceAltFire || (Pawn(Owner).bAltFire != 0) )
			{
				Global.ClientAltFire(0);
				return;
			}
		}
		GotoState('');
		Global.AnimEnd();
	}

	simulated function EndState()
	{
		bForceFire = false;
		bForceAltFire = false;
	}

	simulated function BeginState()
	{
		bForceFire = false;
		bForceAltFire = false;
	}
}

//////////////////////////////////////////////////////
state ClientAltFiring
{
	simulated function Tick(float DeltaTime)
	{
		if ( (Pawn(Owner).bAltFire == 0) || (Ammotype.AmmoAmount <= 0) )
			FiringRockets();
	}

	simulated function AnimEnd()
	{
		if ( !bCanClientFire || (Pawn(Owner) == None) )
			GotoState('');
		else if ( bClientDone )
		{
			PlayLoading(1.5,0);
			GotoState('ClientReload');
		}
		else if ( bRotated )
		{
			PlayLoading(1.1, ClientRocketsLoaded);
			bRotated = false;
			ClientRocketsLoaded++;
		}
		else
		{
			if ( ClientRocketsLoaded == mMaxLob )
			{
				FiringRockets();
				return;
			}
			Enable('Tick');
			PlayRotating(ClientRocketsLoaded - 1);
			bRotated = true;
		}
	}

	simulated function BeginState()
	{
		ClientRocketsLoaded = 1;
		PlayRotating(ClientRocketsLoaded - 1);
		bRotated = true;
	}

	simulated function EndState()
	{
		ClientRocketsLoaded = 0;
		bClientDone = false;
		bRotated = false;
	}
}

///////////////////////////////////////////////////////
state FireRockets
{
	function Fire(float F) {}
	function AltFire(float F) {}

	function ForceFire()
	{
		bForceFire = true;
	}

	function ForceAltFire()
	{
		bForceAltFire = true;
	}

	function bool SplashJump()
	{
		return false;
	}

	function BeginState()
	{
		local vector FireLocation, StartLoc, X,Y,Z;
		local rotator FireRot, RandRot;
		local projectile g;
		local float Angle, RocketRad;
		local pawn BestTarget, PawnOwner;
		local PlayerPawn PlayerOwner;
		local int DupRockets;
		local bool bMultiRockets;

		PawnOwner = Pawn(Owner);
		if ( PawnOwner == None )
			return;

		PlayerOwner = PlayerPawn(Owner);
		Angle = 0;
		DupRockets = RocketsLoaded - 1;
		if (DupRockets < 0) DupRockets = 0;
		if ( PlayerOwner == None )
			bTightWad = ( FRand() * 4 < PawnOwner.skill );

		GetAxes(PawnOwner.ViewRotation,X,Y,Z);
		StartLoc = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;

		AdjustedAim = PawnOwner.AdjustToss(AltProjectileSpeed, StartLoc, AimError, True, bAltWarnTarget);

		if ( PlayerOwner != None )
			AdjustedAim = PawnOwner.ViewRotation;

		PlayRFiring(RocketsLoaded-1);
		Owner.MakeNoise(PawnOwner.SoundDampening);

		BestTarget = None;

		bPointing = true;
		FireRot = AdjustedAim;
		RocketRad = 4;
		if (bTightWad)
			RocketRad=7;

		bMultiRockets = ( RocketsLoaded > 1 );

		While ( RocketsLoaded > 0 )
		{
			if ( bMultiRockets )
				Firelocation = StartLoc - (Sin(Angle)*RocketRad - 7.5)*Y + (Cos(Angle)*RocketRad - 7)*Z - X * 4 * FRand();
			else
				FireLocation = StartLoc;

			g = Spawn(GrenadeClass,, '', FireLocation, AdjustedAim);
			if ( DupRockets > 0 )
			{
				RandRot.Pitch = FRand() * 1500 - 750;
				RandRot.Yaw = FRand() * 1500 - 750;
				RandRot.Roll = FRand() * 1500 - 750;
				g.Velocity = g.Velocity >> RandRot;
			}

			Angle += 1.0484; //2*3.1415/6;
			RocketsLoaded--;
		}
		bTightWad=False;
		bRotated = false;
	}

	function AnimEnd()
	{
		if ( !bRotated && (AmmoType.AmmoAmount > 0) )
		{
			PlayLoading(1.5,0);
			RocketsLoaded = 1;
			bRotated = true;
			return;
		}
		Finish();
	}
Begin:
}

///////////////////////////////////////////////////////
state Idle
{
Begin:
	if(mAltFireMode == ALTFIRE_lob)
	{
		if (Pawn(Owner).bFire!=0)
			Fire(0.0);
		if (Pawn(Owner).bAltFire!=0)
			AltFire(0.0);
		bPointing = False;
		if (AmmoType.AmmoAmount<=0)
			Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
		PlayIdleAnim();
	}
	else
	{
		// This is base Weapon code
		bPointing=False;
		if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) )
			Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
		if ( Pawn(Owner).bFire!=0 )
			Fire(0.0);
		if ( Pawn(Owner).bAltFire!=0 )
			AltFire(0.0);
		Disable('AnimEnd');
		PlayIdleAnim();
	}
}

// -----------------------------
function doLog(ELogType ALogType, string AMessage)
{
	if( ((ALogType == LOG_info) && bLogInfo) || ((ALogType == LOG_debug) && bDebug) )
		Log(mPackage$": "$AMessage, 'cmmWarheadLauncher');
}

defaultproperties
{
	ScrollSpeed=3
	WeaponDescription="Classification: Thermonuclear Device\n\nPrimary Fire: Launches a huge missile that, upon striking a solid surface, will explode and send out a gigantic shock wave, instantly pulverizing anyone or anything within its colossal radius, including yourself.\n\nSecondary Fire: Take control of the missile and fly it anywhere.  You can press the primary fire button to explode the missile early.\n\nTechniques: Remember that while this rocket is being piloted you are a sitting duck.  If an opponent manages to hit your incoming Redeemer missile while it's in the air, the missile will explode harmlessly."
	bNetTemporary=False  // Set to false if you need to replicate data to the clients more than once per level
	InstFlash=-0.40
	InstFog=(X=950.00,Y=650.00,Z=290.00)
	ReloadCount=1
	PickupAmmoCount=1
	bWarnTarget=True
	bAltWarnTarget=True
	bSplashDamage=True
	bSpecialIcon=True
	FiringSpeed=1.00
	FireOffset=(X=18.00,Y=12.00,Z=-10.00)
	shakemag=350.00
	shaketime=0.20
	shakevert=7.50
	AIRating=1.00
	RefireRate=0.25
	AltRefireRate=0.25
	FireSound=Sound'Botpack.Redeemer.WarheadShot'
	SelectSound=Sound'Redeemer.WarheadPickupA'
	DeathMessage="%o was vaporized by %k's %w!!"
	NameColor=(R=255,G=128,B=128)
	AutoSwitchPriority=10
	InventoryGroup=10
	PickupMessage="You got the Pirate Deemer"
	ItemName="Pirate Deemer"
	RespawnTime=50.00
	PlayerViewOffset=(X=1.80,Y=2.00,Z=-2.89),
	PlayerViewMesh=LodMesh'Botpack.WarHead'
	BobDamping=0.98
	PickupViewMesh=LodMesh'Botpack.WHPick'
	ThirdPersonMesh=LodMesh'Botpack.WHHand'
	StatusIcon=Texture'Botpack.Icons.UseWarH'
	PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	Icon=Texture'Botpack.Icons.UseWarH'
	Mesh=LodMesh'Botpack.WHPick'
	bNoSmooth=False
	CollisionRadius=45.00
	CollisionHeight=23.00
	mAltFireMode=ALTFIRE_guide
	mZoomDrawStyle=STY_Normal
	mTexture=Texture'zRed'
	mGuideTexture=Texture'zRed'
	mDrawBars=false
	mBarRate=0.25
	mBlinkIndex=0
	mBarPause=3
	mBarTextureWidth=16
	mLastScale=1
	mBarLeftX=-666
	mBarRightX=-666
	mBarBottomY=-666
	BAR_STEP=5
	mBarPadding=0
	FireAnimationRate=0.3
	Advertise=true
	AdMoveDistance=80
	AdStartX="center"
	AdStartY="bottom"
	AdTextColor="white"
	AdFadeRate=5
	AdBarCount=1
	mAdWingWidth=10
	mAdBarHeight=2
	mAdIconColor=(R=255,G=255,B=255)
	mMaxLob=3
	AmmoKind="cmmAmmo"
	GuideSpeed=550
	MaxGuideSpeed=2000
	AltFireSound=Sound'UnrealShare.Eightball.EightAltFire'
	CockingSound=Sound'UnrealShare.Eightball.Loading'
	Misc3Sound=Sound'UnrealShare.Eightball.BarrelMove'
	lsSpeed=600.0
}
