//====================================================================================
// medRezzerGrenade | by Helen! | www.birdieman.com/forum
//====================================================================================
class medRezzerGrenade extends Projectile;

#exec mesh IMPORT MESH=shellM ANIVFILE=MODELS\shell_a.3D DATAFILE=MODELS\shell_d.3D X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=shellM X=0 Y=0 Z=0 PITCH=292
#exec MESH SEQUENCE MESH=shellM SEQ=All    STARTFRAME=0   NUMFRAMES=1
#exec mesh SEQUENCE MESH=shellM SEQ=Still  STARTFRAME=0   NUMFRAMES=1
#exec MESHMAP scale MESHMAP=shellM X=0.3 Y=0.3 Z=0.6
#exec texture IMPORT NAME=jshell FILE=MODELS\shell.pcx GROUP=Skins  LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=shellM NUM=1 TEXTURE=jshell

var string mPackage;
var cmmReplicationY mRI;
var bool bPreDone;
var bool bPostDone;
var() class<ShockWave> mShockWaveType;
var() class<WarExplosion> mWarExplosionType;
var float DamageScale;
var float DamageRadiusScale;
var float SoundRadiusScale;
var float ExplodeDelay;
var float ExplodeDelaySpread;

var bool bCanHitOwner, bHitWater;

simulated function PreBeginPlay()
{
	if(bPreDone)
		return;
	bPreDone = true;

	Super.PreBeginPlay();

	mPackage = class'cmmCommon'.static.GetPackageName(string(self.class));
	mShockWaveType = class<ShockWave>(DynamicLoadObject(mPackage$".cmmShockWaveLob", class'Class'));
	mWarExplosionType = class<WarExplosion>(DynamicLoadObject(mPackage$".cmmWarExplosionLob", class'Class'));
	texture = Texture'jshell';
}

simulated function PostBeginPlay()
{
	local vector X,Y,Z;
	local rotator RandRot;

	if(bPostDone)
		return;
	bPostDone = true;

	Super.PostBeginPlay();

	Disable('Tick');

	foreach AllActors(class'cmmReplicationY', mRI)
	{
		if(mPackage ~= class'cmmCommon'.static.GetPackageName(string(mRI.class)))
			break;
		mRI = None;
	}

	if(mRI != None)
	{
		Speed = class'cmmCommon'.static.ValidateFloat(mRI.lsSpeed, Default.Speed, 200, Default.MaxSpeed);
		DamageScale = class'cmmCommon'.static.ValidateFloat(mRI.lsDamageScale, Default.DamageScale, 0.05, 5);
		DamageRadiusScale = class'cmmCommon'.static.ValidateFloat(mRI.lsDamageRadiusScale, Default.DamageRadiusScale, 0.05, 20);
		SoundRadiusScale = class'cmmCommon'.static.ValidateFloat(mRI.lsSoundRadiusScale, Default.SoundRadiusScale, 0.1, 10);
		ExplodeDelay = class'cmmCommon'.static.ValidateFloat(mRI.lsExplodeDelay, 2.5, 1, 60);
		ExplodeDelaySpread = class'cmmCommon'.static.ValidateFloat(mRI.lsExplodeDelaySpread, 0.5, 0.1, 5);
	}

	SetTimer(ExplodeDelay + (FRand()*ExplodeDelaySpread), false);                  //Grenade begins unarmed

	if ( Role == ROLE_Authority )
	{
		GetAxes(Instigator.ViewRotation,X,Y,Z);
		Velocity = X * (Instigator.Velocity Dot X)*0.4 + Vector(Rotation) * (Speed + FRand() * 100);
		Velocity.z += 210;
		//MaxSpeed = 1000;
		RandSpin(50000);
		bCanHitOwner = False;
		if (Instigator.HeadRegion.Zone.bWaterZone)
		{
			bHitWater = True;
			Velocity=0.6*Velocity;
		}
	}
}

simulated function ZoneChange( Zoneinfo NewZone )
{
	local waterring w;

	if (!NewZone.bWaterZone || bHitWater)
		return;

	bHitWater = True;
	w = Spawn(class'WaterRing',,,,rot(16384,0,0));
	w.DrawScale = 0.2;
	w.RemoteRole = ROLE_None;
	Velocity=0.6*Velocity;
}

simulated function Timer()
{
	//Explosion(Location+Vect(0,0,1)*16);
	Explode(Location, Vect(0,0,1));
}

simulated function Landed( vector HitNormal )
{
	HitWall( HitNormal, None );
}

simulated function ProcessTouch( actor Other, vector HitLocation )
{
	if ( (Other!=instigator) || bCanHitOwner )
		Explode(Location, Vect(0,0,1));
		//Explosion(HitLocation);
}

function Explode(vector HitLocation, vector HitNormal)
{
	if ( Role < ROLE_Authority )
		return;

	HurtRadius(GetDamage(), GetDamageRadius(), MyDamageType, MomentumTransfer, HitLocation );
	spawn(mShockWaveType,,,HitLocation + HitNormal*16);
	RemoteRole = ROLE_SimulatedProxy;
	Destroy();
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	bCanHitOwner = True;
	Velocity = 0.75*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	RandSpin(100000);
	speed = VSize(Velocity);
	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(ImpactSound, SLOT_Misc, 1.5 );
	if ( Velocity.Z > 400 )
		Velocity.Z = 0.5 * (400 + Velocity.Z);
	else if ( speed < 20 )
	{
		bBounce = False;
		SetPhysics(PHYS_None);
	}
}

///////////////////////////////////////////////////////
function BlowUp(vector HitLocation)
{
	HurtRadius(GetDamage(), GetDamageRadius(), MyDamageType, MomentumTransfer, HitLocation );
}

simulated function Explosion(vector HitLocation)
{
	Explode(HitLocation, Vect(0,0,1));
}

simulated function float GetDamage()
{
	return DamageScale*Default.Damage;
}

simulated function float GetDamageRadius()
{
	return DamageRadiusScale*300;
}

simulated function float GetSoundRadius()
{
	return SoundRadiusScale*Default.SoundRadius;
}

defaultproperties
{
	speed=600.000000
	MaxSpeed=5000.000000
	Damage=200
	MomentumTransfer=100000
	MyDamageType=RedeemerDeath
	ImpactSound=Sound'UnrealShare.Eightball.GrenadeFloor'
	ExplosionDecal=Class'Botpack.NuclearMark'
	Physics=PHYS_Falling
	RemoteRole=ROLE_SimulatedProxy
	Mesh=LodMesh'shellM'
	DrawScale=0.3
	AmbientGlow=78
	bUnlit=True
	bBounce=True
	bFixedRotationDir=True
	DesiredRotation=(Pitch=12000,Yaw=5666,Roll=2334)
	bNetTemporary=False
	SoundRadius=100
	SoundVolume=255
	CollisionRadius=10.00
	CollisionHeight=15.00
	DamageScale=1.0
	DamageRadiusScale=1.0
	SoundRadiusScale=1.0
}
