//====================================================================================
// medRezzerRing | by Helen! | www.birdieman.com/forum
//====================================================================================
class medRezzerRing extends UT_RingExplosion;

var cmmReplicationY mWarInfo;
var string mPackage;
var float mDrawScale;
var float mLifeSpan;
var float mHalfLifeSpan;

simulated function PostBeginPlay()
{
	local string s;

	mPackage = class'cmmCommon'.static.GetPackageName(string(self.class));

	foreach AllActors(class'cmmReplicationY', mWarInfo)
	{
		if(mPackage ~= class'cmmCommon'.static.GetPackageName(string(mWarInfo.class)))
			break;
		mWarInfo = None;
	}

	if(mWarInfo != None)
	{
		mDrawScale = mWarInfo.rrDrawScale;
		mLifeSpan = mWarInfo.rrLifeSpan;

		LifeSpan = mLifeSpan;
		mHalfLifeSpan = mLifeSpan/2;

		s = mWarInfo.rrPic;
		MultiSkins[0] = Texture(DynamicLoadObject(s, class'Texture'));
	}

	// Start off 'hidden'.
	ScaleGlow = 0;

	// Start off small in case it is drawn before tick is called.
	DrawScale = 0.1;

	if ( Level.NetMode != NM_DedicatedServer )
	{
		PlayAnim( 'Explo', 0.35, 0.0 );
	}
}

simulated function Tick( float DeltaTime )
{
	if ( Level.NetMode == NM_DedicatedServer )
		return;

	if((LifeSpan - mLifeSpan) > 0)
		ScaleGlow = 1.0 - ((LifeSpan - mHalfLifeSpan)/mHalfLifeSpan);
	else
		ScaleGlow = 1.0 - ((mHalfLifeSpan - LifeSpan)/mHalfLifeSpan);

	AmbientGlow = ScaleGlow * 255;

	if((mLifeSpan - LifeSpan) == 0.0)
		DrawScale = 0.1;
	else
		DrawScale = mDrawScale * ((mLifeSpan - LifeSpan)/mLifeSpan);
}

simulated function SpawnEffects()
{
	// Overridden so that base class functionality does not fire.
}

defaultproperties
{
	mDrawScale=8
	mLifeSpan=0.8
}
