//=============================================================================
// PlasmaSphere.
//=============================================================================
class slowp extends pickup;

#exec MESH IMPORT MESH=portal ANIVFILE=MODELS\portal_a.3d DATAFILE=MODELS\portal_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=portal X=-30 Y=0 Z=0

#exec MESH SEQUENCE MESH=portal SEQ=All    STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=portal SEQ=portal STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=portal MESH=portal
#exec MESHMAP SCALE MESHMAP=portal X=0.1 Y=0.1 Z=0.2


#exec texture import file=models\gray.bmp 
#exec texture import file=models\black.bmp group=plas
#exec texture import file=models\eff.bmp

#exec obj load file=..\textures\portal.utx package=portalgunftw

var() slowp brother;
var bool btouched;
var rotator rot,comerot,enterrot;
var vector locate;
var() playerpawn lastplayer;

replication
{
	unreliable if ( Role == ROLE_Authority )
		brother, btouched,rot,locate,enterrot,comerot,lastplayer;
}

function postbeginplay()
{
	
drawscale=0;

playsound(sound'there',slot_interact,16.0);
}




auto state pickup
{


function tick(float delta)
{

rot=rotation;
rot.roll=0;


if(drawscale<default.drawscale)
drawscale+=0.3;

if(instigator.health<=0)
destroy();

locate=location;
}
	
simulated function Timer()
{


if(btouched==true)
  btouched=false;
if(lastplayer!=none)
   {lastplayer.desiredfov=lastplayer.defaultfov;lastplayer=none;}
}

function bump( actor other )
{
if(brother!=none&&Other!=none&&!Other.isa('slowp')&&btouched==false&&!other.isa('pawn')&&!other.isa('brush')){
brother.btouched=true;
brother.settimer(0.7,false);
Other.setlocation(brother.locate+Vector(brother.rot)*20+vect(0,0,0)+Velocity*0.01);
Other.setrotation(brother.rot);
Other.velocity=vsize(other.velocity) * vector(brother.rotation);

}
}
simulated function Touch (Actor Other)
{local rotator s;
 local vector v;
local int yaw;
local int pitch;

if ( ValidTouch(Other) ) 

		{	
work(other);

settimer(0.3,false);

}




if(brother!=none&&Other!=none&&!Other.isa('slowp')&&btouched==false&&!other.isa('pawn')){
brother.btouched=true;
brother.settimer(0.7,false);
Other.setlocation(brother.locate+Vector(brother.rot)*20+vect(0,0,0)+Velocity*0.01);
Other.setrotation(brother.rot);
Other.velocity=vsize(other.velocity) * vector(brother.rotation);

}


}



simulated function work(actor other)
{local rotator s;
 local vector v;
local int yaw;
local int pitch;

v=other.velocity;

if(btouched==false&&brother!=none&&!other.isa('slowp')&&!Other.isa('projectile')&&!other.isa('carcass')){

btouched=true;


Yaw=rotation.yaw - pawn(other).viewrotation.yaw;
pitch=rotation.pitch - pawn(other).viewrotation.pitch;

other.setphysics(phys_none);
other.setlocation(brother.locate);
other.setphysics(phys_falling);
other.velocity=(vsize(v) * 1.1) * vector(brother.rot);

enterrot=brother.rotation;
enterrot.yaw-=yaw;
enterrot.pitch=pawn(other).viewrotation.pitch;
enterrot.roll=0;
enterrot=rotator(-vector(enterrot));
pawn(other).viewrotation=(enterrot);
pawn(other).setrotation(enterrot);
PlayerTurn(pawn(other),enterrot);

}
}

simulated function playerturn(pawn p, rotator rot)
{
p.setrotation(rot);
p.viewrotation=rot;
}
}
function BecomePickup()
{
}
function Becomeitem()
{

}
defaultproperties
{
    Physics=4
    LifeSpan=300.00
    LODBias=10.00
    Style=3
    Texture=WetTexture'blue3'
    Mesh=LodMesh'Portal'
    DrawScale=3.00
    ScaleGlow=10.00
    AmbientGlow=187
    bUnlit=True
    SoundRadius=50
    SoundVolume=255
    AmbientSound=Sound'hum'
    CollisionRadius=39.00
    CollisionHeight=39.00
    LightType=1
    LightEffect=10
    LightBrightness=255
    LightHue=153
    LightRadius=30
    bFixedRotationDir=False
    RotationRate=(Pitch=0,Yaw=0,Roll=900000),
    DesiredRotation=(Pitch=0,Yaw=0,Roll=70000),
    NetPriority=3.00
}
