//=====================================================================
// RX6T4.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//          Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================
class AntiSlv expands DumbRocket config (RX6T4);

#exec MESH IMPORT MESH=harpoon ANIVFILE=Models\harpoon_a.3d DATAFILE=Models\harpoon_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=harpoon X=0 Y=0 Z=0 YAW=-448 
#exec MESH LODPARAMS MESH=harpoon STRENGTH=0
#exec MESH SEQUENCE MESH=harpoon SEQ=All     STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=harpoon SEQ=harpoon STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=harpoon MESH=harpoon
#exec MESHMAP SCALE MESHMAP=harpoon X=0.1 Y=0.1 Z=0.2

#exec TEXTURE IMPORT NAME=HarpoonR FILE=Textures\HarpoonR.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=HarpoonR FILE=Textures\HarpoonR.pcx GROUP=Skins PALETTE=HarpoonR
#exec MESHMAP SETTEXTURE MESHMAP=harpoon NUM=1 TEXTURE=HarpoonR

#exec TEXTURE IMPORT NAME=HarpoonR2 FILE=Textures\HarpoonR2.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=HarpoonR2 FILE=Textures\HarpoonR2.pcx GROUP=Skins PALETTE=HarpoonR2
#exec MESHMAP SETTEXTURE MESHMAP=harpoon NUM=2 TEXTURE=HarpoonR2

#exec TEXTURE IMPORT NAME=HarpoonR3 FILE=Textures\HarpoonR3.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=HarpoonR3 FILE=Textures\HarpoonR3.pcx GROUP=Skins PALETTE=HarpoonR3
#exec MESHMAP SETTEXTURE MESHMAP=harpoon NUM=3 TEXTURE=HarpoonR3

#exec TEXTURE IMPORT NAME=HarpoonR4 FILE=Textures\HarpoonR4.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=HarpoonR4 FILE=Textures\HarpoonR4.pcx GROUP=Skins PALETTE=HarpoonR4
#exec MESHMAP SETTEXTURE MESHMAP=harpoon NUM=4 TEXTURE=HarpoonR4

#exec TEXTURE IMPORT NAME=HarpoonR5 FILE=Textures\HarpoonR3.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=HarpoonR5 FILE=Textures\HarpoonR3.pcx GROUP=Skins PALETTE=HarpoonR5
#exec MESHMAP SETTEXTURE MESHMAP=harpoon NUM=5 TEXTURE=HarpoonR5

#exec TEXTURE IMPORT NAME=HarpoonR6 FILE=Textures\HarpoonR6.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=HarpoonR6 FILE=Textures\HarpoonR6.pcx GROUP=Skins PALETTE=HarpoonR6
#exec MESHMAP SETTEXTURE MESHMAP=harpoon NUM=6 TEXTURE=HarpoonR6

#exec TEXTURE IMPORT NAME=HarpoonR7 FILE=Textures\HarpoonR7.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=HarpoonR7 FILE=Textures\HarpoonR7.pcx GROUP=Skins PALETTE=HarpoonR7
#exec MESHMAP SETTEXTURE MESHMAP=harpoon NUM=7 TEXTURE=HarpoonR7






var Actor Seeking;
var() config int CheckRadius;
var bool bInCheck;
var() int MyTeam;
var Strangeshell sl;
var bool bOnce;

replication
{
  unreliable if (role == ROLE_Authority)

		Seeking, MyTeam, sl;
}

simulated function timer()
{
     local vector x,y,z;
     local float bestDist, bestAim;
     local vector SeekingDir;
     local float MagnitudeVel;
     local LightSmokeTrail b;    //ut_SpriteSmokePuff
     local Pawn pilot;     // pawn(owner) Pilot;
     local actor other;
     local Pawn p;
  
          
If (Seeking==None)
     {     
          if(sl!=None) // Reset the values. This shouldn't happen after initial launch unless Seeking was destroyed.
		{
			sl.bSeeking=False;
			sl=None;
		}
          bestAim = 0.85;//0.93
          seeking = instigator.PickTarget(bestAim, bestDist, Normal(Velocity), Location);
          bOnce=True;
  }
     If (Seeking != None  && Seeking != Instigator) 
     { 
          SeekingDir = Normal(Seeking.Location - Location);
               MagnitudeVel = VSize(Velocity);
               Velocity =  MagnitudeVel * Normal(SeekingDir * 2.0 * MagnitudeVel + Velocity);               SetRotation(rotator(Velocity));
    		
               if(bOnce)
		{ 
			ForEach AllActors(Class'Strangeshell', sl)
			{
				if(Seeking==sl.Pilot || Seeking==sl.Gunner)
				{
					sl.bSeeking=True;
					break;
				}
			}
			if(sl!=None && sl.bSeeking==False)
			{     
				sl=None;
                                sl.bSeeking=False;
			}
			bOnce=False;
		}
		else if(sl!=None && (Pawn(Seeking).Health<=0 ||  (sl.Gunner==None && Seeking!=sl.Pilot)))
		{     
			sl.bSeeking=False;
		}
 }
     Velocity = Speed * vector(Rotation);
            
     if ( Trail == None )
          Trail = Spawn(class'Rtrail',self); 
                  

     CannonTimer += SmokeRate;
     if ( CannonTimer > 0.6 )
     {
          WarnCannons();
          CannonTimer -= 0.6;
     }

     if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
     {
          SetTimer(SmokeRate, false);
          Return;
     }

     if ( Level.bHighDetailMode )
     {
          if ( Level.bDropDetail )
               Spawn(Class'LightSmokeTrail');
          else
               Spawn(Class'LightSmokeTrail');
          SmokeRate = 152/Speed; 
          
     }
     else 
     {
          SmokeRate = 0.15;

          b = Spawn(Class'LightSmokeTrail');
          b.RemoteRole = ROLE_None;
     }

     SetTimer(SmokeRate, false);
}

simulated function Destroyed()
{
     if ( Trail != None )
          Trail.Destroy();
     if(sl!=None)
	{
		sl.bSeeking=False;
		sl=None;
	}
     Super.Destroyed();
}

function WarnCannons()
{
     local Pawn P;

     for ( P=Level.Pawnlist; P!=None; P=P.NextPawn )
          if ( P.IsA('TeamCannon') && !P.IsInState('TrackWarhead') && P.LineOfSightTo(self) )
          {
               P.target = self;
               P.GotoState('TrackWarhead');
          }
}

singular function TakeDamage( int Damage, Pawn InstigatedBy, Vector hitlocation, 
                        vector momentum, name damageType )
{
	if (TeamGamePlus(Level.Game) != None)
	{

	if ( Damage > 5 && !TeamGamePlus(Level.Game).IsOnTeam(InstigatedBy,
	Instigator.PlayerReplicationInfo.Team))
	{
		PlaySound(Sound'Expl03',,6.0);
          spawn(class'WarExplosion',,,Location);
		HurtRadius(Damage,350.0, MyDamageType, MomentumTransfer, HitLocation );
		RemoteRole = ROLE_SimulatedProxy;                   
		Destroy();
	}

	}
	else
	{

	if ( Damage > 5)
	{
		PlaySound(Sound'Expl03',,6.0);
          spawn(class'WarExplosion',,,Location);
		HurtRadius(Damage,350.0, MyDamageType, MomentumTransfer, HitLocation );
		RemoteRole = ROLE_SimulatedProxy;                   
		Destroy();
	}

	}
}
auto state Flying
{

     simulated function ZoneChange( Zoneinfo NewZone )
     {
          local waterring w;
          
          if ( NewZone.bWaterZone != Region.Zone.bWaterZone )

          {
               w = Spawn(class'WaterRing',,,,rot(16384,0,0));
               w.DrawScale = 0.2;
               w.RemoteRole = ROLE_None; 
          }     

     }
     
     function ProcessTouch (Actor Other, Vector HitLocation)
     {
          if ( Other != instigator ) 
               Explode(HitLocation,Normal(HitLocation-Other.Location));
     }

     function Explode(vector HitLocation, vector HitNormal)
     {
          if ( Role < ROLE_Authority )
               return;

        HurtRadius(Damage,300.0, MyDamageType, MomentumTransfer, HitLocation );    
        
        spawn(class'RX6T4.BlackCloud',,, location);
        spawn(class'RX6T4.Strangewave',,, location);
	Spawn(Class'RX6T4.FlameExplosion');

           RemoteRole = ROLE_SimulatedProxy;                           
           Destroy();
     }

     function BeginState()
     {
          local vector InitialDir;

          initialDir = vector(Rotation);
          if ( Role == ROLE_Authority )     
               Velocity = speed*initialDir;
          Acceleration = initialDir*50;
     }
}

defaultproperties
{
    CheckRadius=128
    bOnce=True
    speed=1750.00
    MaxSpeed=1750.00
    MyDamageType=RedeemerDeath
    ImpactSound=Sound'SLV2Sounds.Rocket.detonate'
    MiscSound=Sound'SLV2Sounds.Rocket.Warning'
    LifeSpan=0.00
    AmbientSound=Sound'NemesisWS.Sounds.missile'
    Mesh=LodMesh'harpoon'
    AmbientGlow=78
    SoundRadius=208
    SoundPitch=104
    TransientSoundVolume=255.00
    CollisionRadius=15.00
    CollisionHeight=8.00
    bProjTarget=True
    LightBrightness=131
    LightHue=255
    LightRadius=6
    bBounce=True
}
