//=====================================================================
// RX6T4.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//          Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================
class DumbRocket expands Projectile config (RX6T4);


var() int BlastRadius;
var RTrail Trail;
var class<SpriteGreenE> SpriteGreenEClass;
var class<StrangeExpl> StrangeExplClass;
var class<GreenSmokePuff> GreenSmokePuffClass;
var float CannonTimer, SmokeRate;
var bool bRing,bHitWater,bWaterStart;


simulated function Timer()
{
	local GreenSmokePuff b;

	if ( Trail == None )
		Trail = Spawn(class'RTrail ',self);

	CannonTimer += SmokeRate;
	if ( CannonTimer > 0.6 )
	{
		//WarnCannons();
		CannonTimer -= 0.6;
	}

	if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
	{
		SetTimer(SmokeRate, false);
		Return;
	}

	if ( Level.bHighDetailMode )
	{
		if ( Level.bDropDetail )
			Spawn(class'GreenSmokePuff');
		else
			Spawn(class'GreenSmokePuff');
		SmokeRate = 152/Speed;
	}
	else
	{
		SmokeRate = 0.15;
		b = Spawn(class'GreenSmokePuff');
		b.RemoteRole = ROLE_None;
	}
	SetTimer(SmokeRate, false);
}

simulated function PostBeginPlay()
{
	SmokeRate = 0.3;
	SetTimer(0.3,false);
}

simulated function Destroyed()
{
	if ( Trail != None )
		Trail.Destroy();
	Super.Destroyed();
}

auto state Flying
{

	simulated function ZoneChange( Zoneinfo NewZone )
	{
		local waterring w;

		if ( NewZone.bWaterZone != Region.Zone.bWaterZone )
		{
			w = Spawn(class'WaterRing',,,,rot(16384,0,0));
			w.DrawScale = 0.2;
			w.RemoteRole = ROLE_None;
		}
	}

	function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ( Other != instigator )
			Explode(HitLocation,Normal(HitLocation-Other.Location));
	}

	function Explode(vector HitLocation, vector HitNormal)
	{
	local SpriteGreenE F;
	//local WaveStrange r;
	local vector start;


		if ( Role < ROLE_Authority )
			return;



	HurtRadius(damage, BlastRadius, 'StrangeDeath', MomentumTransfer, HitLocation);
	start = Location + 10 * HitNormal;
	F = Spawn( class'SpriteGreenE',,,Start);
	//r = Spawn(class'RX6T4.WaveStrange',,,HitLocation + HitNormal*16);

	RemoteRole = ROLE_SimulatedProxy;
		Destroy();

	//F.RemoteRole = ROLE_None;
	//F.DrawScale *= 1.75;

	}

	function BeginState()
	{
		local vector InitialDir;

		initialDir = vector(Rotation);
		if ( Role == ROLE_Authority )
			Velocity = speed*initialDir;
		Acceleration = initialDir*50;
	}
}

defaultproperties
{
    BlastRadius=20
    speed=800.00
    Damage=1000.00
    MomentumTransfer=100000
    SpawnSound=Sound'UnrealShare.Eightball.Ignite'
    ImpactSound=Sound'UnrealShare.Eightball.GrenadeFloor'
    bCanTeleport=True
    bNetTemporary=False
    RemoteRole=2
    LifeSpan=14.00
    AmbientSound=Sound'Botpack.Redeemer.WarFly'
    AmbientGlow=51
    bUnlit=True
    SoundRadius=255
    SoundVolume=255
    SoundPitch=166
    CollisionRadius=2.00
    CollisionHeight=2.00
    LightType=1
    LightEffect=13
    VolumeBrightness=3
}
