//=====================================================================
// RX6T4.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//			Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================

/** Provides dynamically loaded fonts for various HUDs. Not fully used
	yet.
*/
class Fontlib extends FontInfo;


enum FStyle {
	FS_Normal,
	FS_Slick,
	FS_Title
};

var() name fnames[6];
var() FStyle fstyles[6];

var int currindex;
var FStyle currstyle;


// Overridden Botpack.FontInfo functions. We can get rid of these
// eventually.

static function Font getStaticHugeFont(float width) {
	return Font(dynamicLoadObject("SLV2Fonts.title18", class'Font'));
}

static function Font getStaticBigFont(float width) {
	return Font(dynamicLoadObject("SLV2Fonts.leg16", class'Font'));
}

static function Font getStaticMediumFont(float width) {
	return Font(dynamicLoadObject("SLV2Fonts.leg16", class'Font'));
}

static function Font getStaticSmallFont(float width) {
	return Font(dynamicLoadObject("SLV2Fonts.leg8", class'Font'));
}

static function Font getStaticSmallestFont(float width) {
	return Font(dynamicLoadObject("SLV2Fonts.leg8", class'Font'));
}

static function font GetStaticAReallySmallFont(float Width) {
	return Font(dynamicLoadObject("SLV2Fonts.leg8", class'Font'));
}

static function font GetStaticACompletelyUnreadableFont(float Width) {
	return Font(dynamicLoadObject("SLV2Fonts.leg8", class'Font'));
}


// Mine.
static function Font getFont(optional FStyle style, optional bool big) {
	local String name;

	switch (style) {
	case FS_Slick:
		if (big)
			name = "techno16";
		else
			name = "techno8";
		break;
	
	case FS_Title:
		if (big)
			name = "title18";
		else
			name = "title9";
		break;
	
	// case FS_Normal:
	default:
		if (big)
			name = "leg16";
		else 
			name = "leg8";
	}

	return Font(dynamicLoadObject("SLV2Fonts." $ name, class'Font'));
}


function Font getNextFont(FStyle style, optional bool reset) {
	local int i;

	if (reset || style != currstyle) {
		currindex = 0;
		currstyle = style;
	}

	while (currindex < arrayCount(fnames)) {
		if (fstyles[i] == currstyle) {
			return Font(dynamicLoadObject("SLV2Fonts." $ fnames[i], class'Font'));
		}
		currindex++;
	}

	// At the end.
	currindex = 0;
	return none;
}


/** Find a font with the specified style that will fit in the
	specified space.
*/
function Font fitFont(Canvas c, string s, out float w, out float h, FStyle style) {
	local Font font, last;
	local float xl, yl;

	font = getNextFont(style);
	while (font != none) {
		c.font = font;
		c.textSize(s, xl, yl);
		if (xl <= w && yl <= h) {
			w = xl;
			h = yl;
			return font;
		}

		last = font;
		font = getNextFont(style);
	}

	// No font fit.
	return last;
}



// end

defaultproperties
{
    fnames(0)=leg16
    fnames(1)=leg8
    fnames(2)=techno16
    fnames(3)=techno8
    fnames(4)=title18
    fnames(5)=title9
    fstyles(2)=1
    fstyles(3)=1
    fstyles(4)=2
    fstyles(5)=2
}
