//=====================================================================
// RX6T4.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//          Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================
class Konglauncher extends SLWeapon config (RX6T4);




#exec MESH IMPORT  MESH=WarHeadEd ANIVFILE=Models\WarHeadEd_a.3D DATAFILE=Models\WarHeadEd_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=WarHeadEd X=0 Y=300 Z=-80 YAW=-195 PITCH=6  //ROLL=-62
#exec MESH LODPARAMS MESH=WarHeadEd STRENGTH=0
#exec MESH SEQUENCE MESH=WarHeadEd SEQ=All STARTFRAME=0 NUMFRAMES=9
#exec MESH SEQUENCE MESH=WarHeadEd SEQ=still STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=WarHeadEd SEQ=Fire STARTFRAME=0 NUMFRAMES=5
#exec MESH SEQUENCE MESH=WarHeadEd SEQ=Select STARTFRAME=5 NUMFRAMES=4 RATE=5 GROUP=Select
#exec TEXTURE IMPORT NAME=Jtex1 FILE=Textures\Jtex1.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=Jtex1 FILE=Textures\Jtex1.pcx GROUP=Skins PALETTE=Jtex1
#exec MESHMAP SCALE MESHMAP=WarHeadEd X=0.05 Y=0.05 Z=0.1
#exec MESHMAP SETTEXTURE MESHMAP=WarHeadEd NUM=0 TEXTURE=Jtex1

#exec texture IMPORT NAME=RX6icon FILE=Textures\RX6icon.pcx GROUP=icons MIPS=OFF



#exec OBJ LOAD FILE=..\Textures\RXHOFXHAIR.utx PACKAGE=RXHOFXHAIR
#exec AUDIO IMPORT FILE="Sounds\KFire.wav" NAME="Kfire" GROUP="NXSounds"


#exec AUDIO IMPORT FILE="Sounds\Gpickup.wav" NAME="Gpickup" GROUP="RX6T4Sounds"
// DATA
//

var Fuelcore fc;                              // Keeps track of fuel cores for the ret HUD.
var vector launchv;                              // Owner velocity at launch.
var float lastFired;                         // Bots should only fire every so often...
var SkyNet skynet;
var SkyNode launchsn;                         // Our onramp onto the network.
var() config bool bNeverStay;
var bool bClear;
var float clearanceStamp;
var() config string teamSLClass[4];
var UT_ShieldBeltEffect MyEffect;
var config bool bForceLaunchPuff;
var bool bPendingLock;
var Actor LockedTarget, NewTarget, OldTarget;
var byte Teams;

replication {
	 reliable if (role == ROLE_Authority && bNetOwner)
		  bClear;
}

//=============
// METHODS
//==============

/** Set the projectile classes based on team.
*/
function bringUp() {
	 
     local PlayerReplicationInfo pri;
     // Teams alternate rocket types.
     if (Pawn(owner) != none) {
       pri = Pawn(owner).playerReplicationInfo;
       projectileClass = (Class'RX6T4.AntiSLV');
       
       
       altProjectileClass = Class<Projectile>(dynamicLoadObject(teamSLClass[pri.team], Class'Class'));
     }
     super.bringup();
}

state Idle {

	  simulated function timer() {
	  super.timer();
	  NewTarget = CheckTarget();
          if ( NewTarget == OldTarget )
	  {
	        LockedTarget = NewTarget;
	        If (LockedTarget != None)
	        {
	             bLockedOn=True;
		     Owner.MakeNoise(Pawn(Owner).SoundDampening);
		     Owner.PlaySound(Misc1Sound, SLOT_None,Pawn(Owner).SoundDampening);
		     if ( (Pawn(LockedTarget) != None) && (FRand() < 0.7) )
			  Pawn(LockedTarget).WarnTarget(Pawn(Owner), ProjectileSpeed, vector(Pawn(Owner).ViewRotation));
		     if ( bPendingLock )
		     {
			 oldTarget = NewTarget;
		         Pawn(Owner).bFire = 0;
		         GotoState('Fire', 'Begin');
		         return;
                     }
		}
	  }

	  else if( (OldTarget != None) && (NewTarget == None) )
	  {
	       Owner.PlaySound(Misc2Sound, SLOT_None,Pawn(Owner).SoundDampening);
	       bLockedOn = False;
          }
          else
          {
	       LockedTarget = None;
	       bLockedOn = False;
          }
          OldTarget = NewTarget;
          bPendingLock = false;
     }

Begin:
     if (Pawn(Owner).bFire!=0) Fire(0.0);
     if (Pawn(Owner).bAltFire!=0) AltFire(0.0);
     bPointing=False;
     if (AmmoType.AmmoAmount<=0)
	  Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
     OldTarget = CheckTarget();
     SetTimer(0.75,True);  //1.25
     LockedTarget = None;
     bLockedOn = False;
PendingLock:
	 if ( bPendingLock )
	      bPointing = true;
	 if ( TimerRate <= 0 )
	      SetTimer(0.5, true); //1.0
}

simulated function PlayFiring()

{
	PlayAnim( 'Fire', 0.5 );		
	playsound(Sound'RX6T4.NXSounds.Kfire');

}



simulated function PostRender(canvas Canvas)
{
     local float XScale;
     Super.PostRender(Canvas);
     bOwnsCrossHair = bLockedOn;
     if ( bOwnsCrossHair )
     {
          // if locked on, draw special crosshair
          XScale = FMax(1.25, Canvas.ClipX/640.0);
          Canvas.SetPos(0.525 * (Canvas.ClipX - Texture'RXHOFXHAIR.crosshair.TargetLocked'.USize * XScale), 0.525 * (Canvas.ClipY - Texture'RXHOFXHAIR.crosshair.TargetLocked'.VSize * XScale));
          Canvas.Style = ERenderStyle.STY_Translucent;
          Canvas.DrawIcon(Texture'RXHOFXHAIR.crosshair.TargetLocked', 1.25);
          Canvas.Style = 1.25;
     }
}

/** Function for bots. Returns true if they should ride a rocket. Not
	 simulated so we don't need the role check.             
*/
function bool useAltFire(Bot b) {
         local BotReplicationInfo bri;
	 local StrangeShell sl;

	 u.debug("useAltFire(): ammo: " $ ammoLeft() $ " enemy: " $ b.enemy $ " orders: " $ b.orders);

	 bri = BotReplicationInfo(b.playerReplicationInfo);

	 // Only used in CTF and assault gametypes. And for assault, only if they're attacking.
	 if (!(level.game.isA('CTFGame') || (level.game.isA('Assault') && bri.team == Assault(level.game).attacker.teamIndex)))
		  return false;

	 if (!ammoLeft() || b.enemy != none)
		  return false;

	 // Which? FIX.
	 if (bri.realOrders == 'Defend' || bri.realOrders == 'Follow')
		  return false;

	 // Not if we're already riding one.
	 foreach b.radiusActors(Class'StrangeShell', sl, vsize(Class<StrangeShell>(projectileClass).default.pilotOffset) * 2.0) {
		  if (sl.getPilot() == b || sl.getGunner() == b)
			   return false;
	 }
	 
         return true;
}


function spawnSkyNet() {
	 foreach allActors(Class'SkyNet', skynet)
		  break;

	 // Spawn it!
	 if (skynet == none)
		  skynet = spawn(Class'SkyNet');
}

/** Needed to add fuel core count to the HUD.
*/
simulated function setRetMsgs() {
     super.setRetMsgs();

     if (!bClear && (level.timeseconds - clearanceStamp < 1.5)) {
		  retmsg = "no clearance!";
     }
     if (fc == none)
         fc = Fuelcore(Pawn(owner).findInventoryType(class'Fuelcore'));
     if (fc != none && fc.ammoAmount > 0)
          retmsg2 = "cores " $ fc.ammoAmount;
}

/** The Redeemer never stays.
*/
function setWeaponStay() {
	 if (bNeverStay)
	      bWeaponStay = false;
	 else
	      super.setWeaponStay();
}

/** Launch puffs spawned on the server.
*/
function spawnPuff() {
     local vector x, y, z;

         if (bForceLaunchPuff == true){
            getAxes(owner.rotation, x, y, z);
              spawn(class'LaunchPuff',,, owner.location + x * 80, rotation);
            } else if (level.bHighDetailMode && !level.bDropDetail && level.netmode != NM_DedicatedServer) 	 {
          // Place it in view.

          getAxes(owner.rotation, x, y, z);
          spawn(class'LaunchPuff',,, owner.location + x * 80, rotation);
     }
}

/** If we had a successful launch, spawn the puff.
*/


function fire(float v) {

     local Vector Start, X,Y,Z;
    lastFired = level.timeseconds;
 	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if (AmmoType.UseAmmo(1))
	{

        bPointing=true;
        bCanClientFire=true;
        GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
        Start = Owner.Location + CalcDrawOffset();
        Spawn(Class'WeaponLight',,'',Start+X*20,rot(0,0,0));
        Start = Start + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
        AdjustedAim = pawn(owner).AdjustToss(ProjectileSpeed, Start, AimError,true,bWarnTarget);


    if ( Pawn(Owner).PlayerReplicationInfo.Team == 0 ) {
     
        Spawn(class'AntiSlv',,, Start,AdjustedAim);
        Spawn(class'KongFlashR',,,start,AdjustedAim);
        PlayFiring();

    } if ( Pawn(Owner).PlayerReplicationInfo.Team == 1 ) {

        Spawn(class'AntiSlv2',,, Start,AdjustedAim);
        Spawn(class'KongFlashR',,,Start,AdjustedAim);
        PlayFiring();
    }
 

  
//super.fire(v);

	}


	if (lastProj != none)
       spawnPuff();
    if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) )
    {
    	 Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
    }
}

function altFire(float v)
{
     local bool bAmmo;
   //  local Inventory IP;
     bAmmo = ammoLeft();

    if (bAmmo)
	{
       spawnProjOffset = -(Class<StrangeShell>(altProjectileClass).default.pilotOffset);
       bSetProjOwner = true;
       Pawn(Owner).bHidden = true;
       lastProj = none;
    }
    // All just to get the click...
    super.altFire(v);

     if (bAmmo)
	 {
          if (lastProj != none)
		  {
          StrangeShell(lastProj).setPilot(Pawn(owner)); //, skynet, launchsn);
          } else {
               clearWarning();
               clearanceStamp = level.timeseconds;

          
          }
          bClear = (lastProj != none);
          // Unset these. Dumbs don't need them.
          spawnProjOffset = vect(0, 0, 0);
          bSetProjOwner = false;
          Pawn(Owner).bHidden = false;
          PlayAltFiring();
	  if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) {
		GotoState('DownWeapon');
                Pawn(Owner).SwitchToBestWeapon();
         }
     }
}

/** Plays the clearance warning on the client. Is there a way to quiet
     this? FIX.
*/
function clearWarning() {
     if (owner.isA('PlayerPawn'))
          PlayerPawn(owner).clientPlaySound(Class'StrangeShell'.default.warnSound, false, true);
          Pawn(Owner).SwitchToBestWeapon();
}
simulated function bool clientFire(float v) {
     // Reset it.
     launchv = vect(0, 0, 0);
     return super.clientFire(v);
}
simulated function bool clientAltFire(float v) {
     if (super.clientAltFire(v)) {
          clearanceStamp = level.timeseconds;
          launchv = owner.velocity;
          return true;
     } else {
     return false;
     }
}

function Actor CheckTarget() {

     local Actor ETarget;
     local Vector Start, X,Y,Z;
     local float bestDist, bestAim;
     local Pawn PawnOwner;
     local rotator AimRot;
     local int diff;

     PawnOwner = Pawn(Owner);
     bPointing = false;
     if ( Owner.IsA('PlayerPawn') )
     {
          GetAxes(PawnOwner.ViewRotation,X,Y,Z);
          Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
          bestAim = 0.93;
          ETarget = PawnOwner.PickTarget(bestAim, bestDist, X, Start);
     }
     else if ( PawnOwner.Enemy == None )
          return None;
     else if ( Owner.IsA('Bot') && Bot(Owner).bNovice )
          return None;
     else if ( VSize(PawnOwner.Enemy.Location - PawnOwner.Location) < 2000 )
     {
          Start = Owner.Location + CalcDrawOffset() + FireOffset.Z * vect(0,0,1);
          AimRot = rotator(PawnOwner.Enemy.Location - Start);
          diff = abs((AimRot.Yaw & 65535) - (PawnOwner.Rotation.Yaw & 65535));
          if ( (diff > 7200) && (diff < 58335) )
               return None;
          // check if can hold lock
          if ( !bPendingLock ) //not already locked
          {
               AimRot = rotator(PawnOwner.Enemy.Location + (3 - PawnOwner.Skill) * 0.3 * PawnOwner.Enemy.Velocity - Start);
               diff = abs((AimRot.Yaw & 65535) - (PawnOwner.Rotation.Yaw & 65535));
		if ( (diff > 16000) && (diff < 49535) )
        return None;
          }

          // check line of sight
          ETarget = Trace(X,Y, PawnOwner.Enemy.Location, Start, false);
          if ( ETarget != None )
               return None;

          return PawnOwner.Enemy;
     }
     bPointing = (ETarget != None);
     Return ETarget;
}

/** From Botpack.WarheadLauncher.
*/
function float rateSelf(out int bUseAltMode) {
	local Bot me;

	// Alt-fire handled separately in the idle loop.
	bUseAltMode = 1;

	me = Bot(owner);
	if (me == none || !ammoLeft() || (level.timeseconds - lastFired) < 2.0)
		return -2.0;

	// Keep the weapon out until we're under fire. We may alt-fire to
	// get on the sky network.
	if (useAltFire(me))
		return 1.0;

	if (me.enemy == none)
		return -2.0;
	
	if (vsize(me.enemy.location - me.location) > 800 && fastTrace(me.enemy.location, me.location)) {
		u.debug("rateSelf(): enemy past det range: " $ u.sname(me.enemy));
		return 2.0;
	}

	return -1.0;
}


function float suggestAttackStyle() {
	return -1.0;
}


//  The End

defaultproperties
{
    bNeverStay=True
    teamSLClass(0)="RX6T4.StrangeShell"
    teamSLClass(1)="RX6T4.rocket2X"
    wallhitClass=Class'SLWallhit'
    assFire=(aname=Fire,arate=10.20,tween=10.10,Sound=Sound'NXSounds.Kfire',Volume=4.00,Slot=0,bSkipOwner=True),
    assAltFire=(aname=AltFire,arate=0.00,tween=0.00,Sound=Sound'NXSounds.Kfire',Volume=4.00,Slot=0,bSkipOwner=True),
    assDown=(aname=Down,arate=0.40,tween=0.05,Sound=None,Volume=1.00,Slot=1,bSkipOwner=False),
    assReload=(aname=Reload,arate=0.50,tween=0.00,Sound=Sound'SLV2Sounds.Weapon.Reload',Volume=1.00,Slot=1,bSkipOwner=False),
    assIdle=(aname=Idle,arate=1.90,tween=0.00,Sound=None,Volume=1.00,Slot=1,bSkipOwner=True),
    paSlide=1.75
    mimicPriorityOf=WarheadLauncher
    WeaponDescription="Giant, yet portable anti-everything rocket."
    InstFlash=-0.40
    InstFog=(X=950.00,Y=650.00,Z=290.00),
    AmmoName=Class'StrangeAmmo'
    ReloadCount=1
    bWarnTarget=True
    bAltWarnTarget=True
    bSplashDamage=True
    bSpecialIcon=True
    FiringSpeed=1.00
    FireOffset=(X=18.00,Y=0.00,Z=-10.00),
    ProjectileClass=Class'AntiSlv'
    AltProjectileClass=Class'StrangeShell'
    MyDamageType=StrangeDeath
    shakemag=350.00
    shaketime=0.30
    shakevert=7.50
    AIRating=1.00
    RefireRate=0.25
    AltRefireRate=0.25
    DeathMessage="%o was reduced to a stain on the ground by %k's %w."
    NameColor=(R=10,G=0,B=0,A=0),
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="-=RocketX6 Armed=-"
    ItemName="Multi-Purpose Anti-Everything "
    PlayerViewOffset=(X=6.80,Y=-5.00,Z=-17.89),
    PlayerViewMesh=LodMesh'WarHeadEd'
    BobDamping=0.98
    PickupViewMesh=LodMesh'WarHeadEd'
    PickupViewScale=1.90
    ThirdPersonMesh=LodMesh'WarHeadEd'
    ThirdPersonScale=0.90
    StatusIcon=Texture'Icons.RX6icon'
    MaxDesireability=0.00
    PickupSound=Sound'RX6T4Sounds.Gpickup'
    Physics=0
    LODBias=4.00
    Rotation=(Pitch=0,Yaw=0,Roll=-500),
    Mesh=LodMesh'WarHeadEd'
    AmbientGlow=120
    bUnlit=True
    CollisionRadius=45.00
    CollisionHeight=23.00
}
