//=====================================================================
// RX6T4.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//			Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================
/** This gets spawned on the client when the Konglauncher is fired.
*/
class LaunchPuff extends SLSmoke;


// DATA
//

// The fade intro time in seconds.
var() float intro;

// Our own substitute for the builtin lifeSpan stuff. Used also in
// Contrail.uc. We do this so we can change the lifeSpan on the fly.
var() float life;
var float elapsed;

// This means our lifespan has been cut short.
var bool bShorted;


// METHODS
//

simulated function beginPlay() {
	velocity = vector(rotation) * 15.0;
	
	elapsed = life;
}


simulated function tick(float d) {
	if (level.bDropDetail && !bShorted) {
		life /= 4.0;
		elapsed /= 4.0;
		intro /= 2.0;
		bShorted = true;
	}

	if (elapsed > (life - intro)) {
		// For the intro time we are expanding and solidifying.
		scaleGlow = (life - elapsed) / intro;
		drawScale = default.drawScale * scaleGlow;
	} else {
		// The rest we are slowly expanding and fading out.
		scaleGlow = elapsed / (life - intro);
		drawScale = default.drawScale + 1.0 * (1.0 - scaleGlow);
	}

	lightBrightness = scaleGlow * default.lightBrightness;

	elapsed -= d;

	if (elapsed < 0)
		destroy();
}



// end

defaultproperties
{
    Intro=0.15
    life=2.00
    RemoteRole=2
    LifeSpan=0.00
    DrawType=1
    Texture=Texture'SLV2Textures.Smoke.LaunchPuff'
    DrawScale=0.20
    ScaleGlow=0.00
}
