//=====================================================================
// MineSLV.            555 ---===CrAzYBoNeS===--- 555
//                      
//                            ""()Frgd()""
//
// Thank you Al McElrath for SLV2.
//=====================================================================
class MineSLV expands Projectile;

var() config int BlastRadius;

simulated function PostBeginPlay()
{
     Super.PostBeginPlay();
     Velocity = Vector(Rotation) * Speed;     
     Velocity.z -= 10;
     if ( Level.bHighDetailMode  && !Level.bDropDetail ) 
          SetTimer(0.05,True);
     else 
          SetTimer(0.25,True);
}

function ProcessTouch (Actor Other, vector HitLocation)
{
     if ( Other != instigator )
     Explode(HitLocation,Normal(HitLocation-Other.Location));
}

function Landed( vector HitNormal )
{
     Explode(Location,HitNormal);
}

simulated function Timer()
{
     local ut_SpriteSmokePuff s;

     if (Level.NetMode!=NM_DedicatedServer) 
     {
          s = Spawn(class'ut_SpriteSmokePuff');
          s.RemoteRole = ROLE_None;
     }     
}

function Explode(vector HitLocation, vector HitNormal)
{
     local vector start;
     local FlameExplosion F;
//	 local NuclearMark G;     

     HurtRadius(damage, BlastRadius, 'mined', MomentumTransfer, HitLocation);     
     start = Location + 10 * HitNormal;
     F = Spawn( class'FlameExplosion',,,Start);
		 
		 Spawn( class 'UTChunk2',, '', Start);
         Spawn( class 'UTChunk3',, '', Start);
         Spawn( class 'UTChunk4',, '', Start);
         Spawn( class 'UTChunk1',, '', Start);
		 if ( Level.NetMode != NM_DedicatedServer )
		 Spawn(class'Botpack.NuclearMark',self,,Location, rotator(HitNormal));
		 //Spawn(class'Botpack.BlastMark',self,,Location, rotator(HitNormal));
		
		if ( F != None )
       		F.DrawScale *= 2.5;
// 		if ( G != None )
//	 		G.DrawScale *= 0.5;

      Destroy();
}

defaultproperties
{
    BlastRadius=300
    speed=2.00
    Damage=100.00
    MomentumTransfer=150000
    ImpactSound=Sound'UnrealShare.Eightball.GrenadeFloor'
    ExplosionDecal=Class'Botpack.BlastMark'
    bNetTemporary=False
    AnimSequence=WingIn
    AmbientSound=Sound'SLV2Sounds.Rocket.Warning'
    Mesh=LodMesh'UnrealShare.GrenadeM'
    DrawScale=1.25
    AmbientGlow=96
    bUnlit=True
    SoundRadius=13
    SoundVolume=255
    SoundPitch=255
    LightType=1
    LightBrightness=255
    LightHue=21
    LightSaturation=70
    LightRadius=2
    LightPhase=17
}
