//=====================================================================
// RX6T4.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//          Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================
/** Invisible weapon that makes is so the pilot can't shoot while
	 steering, and intercepts fire/altfire commands.
*/
class NullWeapon extends TournamentWeapon config (RX6T4);


#exec OBJ LOAD FILE=..\Textures\SLV2Textures.utx PACKAGE=SLV2Textures
#exec AUDIO IMPORT FILE="Sounds\BarretShot.wav" NAME="BarretShot" GROUP="NXSounds"


//================

var StrangeShell sl;                    // The controller.
var NullWeapon nw;

var Konglauncher kl;
var SLClip clip;                         // Current clip, if ammo().bClipped.
var bool bClipped;
var pawn pilot;
var bool bShowStatic;
var int Count;
var() config int RadiusDamage;
var byte Team;




replication {

	 unreliable if (role == ROLE_Authority)
		    Team;
		

}
simulated function postBeginPlay() {
	 // Use the Konglauncher defaults to tidy up the HUD. Is there a
	 // way to avoid this? FIX.
	 autoSwitchPriority = 3;
	 inventoryGroup = 3;
	 statusIcon = Class'Konglauncher'.default.statusIcon;
	 projectileClass = Class'Konglauncher'.default.projectileClass;
	 altProjectileClass = Class'Konglauncher'.default.altProjectileClass;
	 super.postBeginPlay();
}
function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{

  if ( RadiusDamage < 4096 ) RadiusDamage = 33;
  if (Other == Level)
  {
	Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	HurtRadius(RadiusDamage, 13, 'mortared', 2000, HitLocation);
  }
  else if ( (Other != self) && (Other != Owner) && (Other != None) )
  {
	if ( !Other.bIsPawn && !Other.IsA('Carcass') )
	  spawn(class'GreenSmokePuff',,,HitLocation+HitNormal*9);
    else
	  Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);

	if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight)
	  && (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
	  Other.TakeDamage(13, Pawn(Owner), HitLocation, 2000 * X, MyDamageType);//AltDamageType);
    else
	  Other.TakeDamage(13,  Pawn(Owner), HitLocation, 2000 * X, MyDamageType);
    if ( !Other.bIsPawn && !Other.IsA('Carcass') )
	  spawn(class'GreenSmokePuff',,,HitLocation+HitNormal*9);
  }
}


function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local vector SideOne, SideTwo;
	local actor Other;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (10000 * AimDir); 
	do
	{
		StartTrace += 50 * AimDir;
		Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	} until (Other == None || Other != sl)

	if ( VSize(HitLocation - StartTrace) > 125 )

if (pawn(owner).PlayerReplicationInfo.Team == 0 ) 
	{
		SideOne = StartTrace + (FireOffset.X - 5) * X + (FireOffset.Y - 40) * Y + (FireOffset.Z - 30) * Z;
                Spawn(class'CFlare',,,SideOne,AdjustedAim);
		SideTwo = StartTrace + (FireOffset.X - 5) * X + (FireOffset.Y + 40) * Y + (FireOffset.Z - 30) * Z;
                Spawn(class'CFlare',,,SideTwo,AdjustedAim);
		
              //  SideThree = StartTrace + (FireOffset.X - 5) * X + (FireOffset.Y - 60) * Y + (FireOffset.Z - 30) * Z;
              //  Spawn(class'CFlare',,,SideThree,AdjustedAim);
	      //  SideFour = StartTrace + (FireOffset.X - 5) * X + (FireOffset.Y + 60) * Y + (FireOffset.Z - 30) * Z;
              //  Spawn(class'CFlare',,,SideFour,AdjustedAim);
                
		
               // PlaySound(Sound'RX6T4.NXSounds.BarretShot', SLOT_None, 149.0, , , 3.3);
                PlaySound(Sound'RX6T4.NXSounds.Cfire', SLOT_None, 149.0, , , 3.3);
		SoundVolume = 250;
                SoundPitch = 50;
		if (Other == None || (HitLocation.X==0 && HitLocation.Y==0 && HitLocation.Z==0 ))
		

		
{
                     

			Spawn(class'SLVCannons',,, SideOne,rotator(EndTrace - SideOne));
                       
			Spawn(class'SLVCannons',,, SideTwo,rotator(EndTrace - SideTwo));

			//Spawn(class'SLVCannons',,, SideThree,rotator(EndTrace - SideThree));
                       
			//Spawn(class'SLVCannons',,, SideFour,rotator(EndTrace - SideFour));
                        
		}
		else
		{
			

			Spawn(class'SLVCannons',,, SideOne,rotator(EndTrace - SideOne));
                        
			Spawn(class'SLVCannons',,, SideTwo,rotator(EndTrace - SideTwo));

			//Spawn(class'SLVCannons',,, SideThree,rotator(EndTrace - SideThree));
                       
			//Spawn(class'SLVCannons',,, SideFour,rotator(EndTrace - SideFour));
                        
		}
ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
}

if (pawn(owner).PlayerReplicationInfo.Team == 1 ) 
	{
		SideOne = StartTrace + (FireOffset.X - 5) * X + (FireOffset.Y - 40) * Y + (FireOffset.Z - 30) * Z;
                Spawn(class'CFlare',,,SideOne,AdjustedAim);
		SideTwo = StartTrace + (FireOffset.X - 5) * X + (FireOffset.Y + 40) * Y + (FireOffset.Z - 30) * Z;
                Spawn(class'CFlare',,,SideTwo,AdjustedAim);
		
               // SideThree = StartTrace + (FireOffset.X - 5) * X + (FireOffset.Y - 60) * Y + (FireOffset.Z - 30) * Z;
               // Spawn(class'CFlare',,,SideThree,AdjustedAim);
		//SideFour = StartTrace + (FireOffset.X - 5) * X + (FireOffset.Y + 60) * Y + (FireOffset.Z - 30) * Z;
               // Spawn(class'CFlare',,,SideFour,AdjustedAim);
                
		
               // PlaySound(Sound'RX6T4.NXSounds.BarretShot', SLOT_None, 149.0, , , 3.3);
                PlaySound(Sound'RX6T4.NXSounds.Cfire', SLOT_None, 149.0, , , 3.3);
		SoundVolume = 250;
                SoundPitch = 50;
		if (Other == None || (HitLocation.X==0 && HitLocation.Y==0 && HitLocation.Z==0 ))
		

		
{
                     

			Spawn(class'SLVCannonsb',,, SideOne,rotator(EndTrace - SideOne));
                       
			Spawn(class'SLVCannonsb',,, SideTwo,rotator(EndTrace - SideTwo));

			//Spawn(class'SLVCannonsb',,, SideThree,rotator(EndTrace - SideThree));
                       
			//Spawn(class'SLVCannonsb',,, SideFour,rotator(EndTrace - SideFour));
                        
		}
		else
		{
			

			Spawn(class'SLVCannonsb',,, SideOne,rotator(EndTrace - SideOne));
                        
			Spawn(class'SLVCannonsb',,, SideTwo,rotator(EndTrace - SideTwo));

			//Spawn(class'SLVCannonsb',,, SideThree,rotator(EndTrace - SideThree));
                       
			//Spawn(class'SLVCannonsb',,, SideFour,rotator(EndTrace - SideFour));
                        
		}	
	

	}
	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
}


function Fire(float v)
{
		local Vector Start, X,Y,Z;
		local int NumPoints;
		local int diff;


		bPointing=true;
		bCanClientFire=true;
		GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
		Start = Owner.Location + CalcDrawOffset();
		Spawn(Class'WeaponLight',,'',Start+X*20,rot(0,0,0));
		Start = Start + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
		AdjustedAim = pawn(owner).AdjustToss(ProjectileSpeed, Start, AimError,true,bWarnTarget);

	
	

	

		GotoState('NormalFire');
		TraceFire(0.0);
		

	}



function altFire(float v) {
	 if (!owner.isA('Bot') && sl != none)
	   GoToState('AltFiring');
}

state AltFiring {
Begin:
	 sl.Afterburn();
		GoToState('');
}

state NormalFire {
Begin:
	 if (Pawn(Owner).Weapon != self) GotoState('');
	  Else sleep(0.175);
	  Finish();
}

simulated function bool clientFire(float v) {
	 return false;
}

simulated function renderOverlays(Canvas canvas) {
	 // Nothing.
}

state ClientActive {

	 simulated function beginState() {
		  // Nothing.
	 }
}
state Idle {

	 function bool putDown() {

		  return global.putDown();
	 }
}
auto state Active {
	 function bool putDown() {
		  return global.putDown();
	 }
	 function fire(float v) {

		  global.fire(v);
	 }
	 function altFire(float v) {
		  global.altfire(v);
	 }
	 function beginState() {
		  // Nothing.
	 }
	 function endState() {
		  // Nothing.
	 }
	 begin:
	 // Nothing.
}
state DownWeapon {

	 function bool putDown() {
		  return global.putDown();
	 }
}


simulated function setHand(float hand) {
	 // Nothing.
}



function bool putDown()
{
		  if (sl != None)
		 //  sl.switchwarhead();
			 bChangeWeapon = False;
			 Pawn(owner).pendingWeapon = None;
			 return True;
}

// These keep those accessed none warnings at bay.

simulated function playSelect() {
	 // Nothing. No mesh. No ammo.
}

simulated function tweenToStill() {

	 // No mesh. Nothing.
}

function bringUp() {
	 // Nothing.
}

defaultproperties
{
    RadiusDamage=150
    bCanThrow=False
    bOwnsCrosshair=True
    shakemag=0.00
    shaketime=0.00
    shakevert=0.00
    bAmbientGlow=False
    ItemName="'"
    bHidden=True
    DrawType=0
    AmbientGlow=0
    CollisionRadius=0.00
    CollisionHeight=0.00
    bCollideActors=False
}
