//=====================================================================
// RX6T4.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//			Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================
/** Projectiles launched from the back of a Strangelove get their
	velocities modified to be relative to the speed of the
	rocket. This SpawnNotify catches Projectile spawns and does so.
*/
class ProjectileSN extends SpawnNotify;


var() float limitMult;
var Util u;


function postBeginPlay() {
	u = spawn(Class'Util', self);
	u.setDebugLevel(DL_Verbose);
}


function Actor spawnNotification(Actor a) {
	local Pawn inst;
	local StrangeShell s;
	local float limit;
	local float da;

	inst = a.instigator;
	
	// No instigator? Don't bother.
	if (inst != none) {
		foreach allActors(Class'StrangeShell', s) {
			// From the rider or gunner?
			if (inst != none && (s.getPilot() == inst || s.gunner == inst)) {

				// We limit the final vel. with this.
				limit = vsize(a.velocity) * limitMult;

				// 1.0 is aligned. -1.0 is pointing directly away from each other.
				da = normal(a.velocity) dot normal(s.velocity);
				if (da > 0) {
					a.velocity += normal(a.velocity) * vsize(s.velocity) * da;
					if (vsize(a.velocity) > limit)
						a.velocity = normal(a.velocity) * limit;
				}

				u.debug("spawnNotification(): proj: " $ a $ " shellv: " $ u.sf(vsize(s.velocity)) $ " newv: " $ u.sf(vsize(a.velocity)) $ " limit: " $ u.sf(limit));

				break;
			}
		}
	}

	return a;
}



// end

defaultproperties
{
    limitMult=1.25
    ActorClass=Class'Engine.Projectile'
}
