//=============================================================================
// SLVCannons.
//=============================================================================
class SLVCannons extends Projectile config (RX6T4);

#exec AUDIO IMPORT FILE="Sounds\Cfire.wav" NAME="Cfire" GROUP="NXSounds"

var float SmokeRate;
var bool bRing,bHitWater,bWaterStart;
var int NumExtraRockets;
var	rockettrail trail;

simulated function Destroyed()
{
	if ( Trail != None )
		Trail.Destroy();
	Super.Destroyed();
}

simulated function PostBeginPlay()
{
	Trail = Spawn(class'CannonTrail',self);
	if ( Level.bHighDetailMode )
	{
		SmokeRate = (200 + (0.5 + 2 * FRand()) * NumExtraRockets * 24)/Speed; 
		if ( Level.bDropDetail )
		{
			SoundRadius = 6;
			LightRadius = 3;
		}
	}
	else 
	{
		SmokeRate = 0.15 + FRand()*(0.02+NumExtraRockets);
		LightRadius = 3;
	}
	SetTimer(SmokeRate, true);
}

simulated function Timer()
{
	local ut_SpriteSmokePuff b;

	if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
		Return;



}

auto state Flying
{

	simulated function ZoneChange( Zoneinfo NewZone )
	{
		local waterring w;
		
		if (!NewZone.bWaterZone || bHitWater) Return;

		bHitWater = True;
		if ( Level.NetMode != NM_DedicatedServer )
		{
			w = Spawn(class'WaterRing',,,,rot(16384,0,0));
			w.DrawScale = 0.2;
			w.RemoteRole = ROLE_None;
			PlayAnim( 'Still', 3.0 );
		}		
		Velocity=0.6*Velocity;
	}

	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ( (Other != instigator) && !Other.IsA('Projectile') ) 
			Explode(HitLocation,Normal(HitLocation-Other.Location));
	}

	function BlowUp(vector HitLocation)
	{
		HurtRadius(Damage,220.0, MyDamageType, MomentumTransfer, HitLocation );
		MakeNoise(1.0);
	}

	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local UT_HeavyWallHitEffect s;

		s = spawn(class'Botpack.UT_HeavyWallHitEffect',,,HitLocation + HitNormal*16);	
 		s.RemoteRole = ROLE_None;
                

		BlowUp(HitLocation);

 		Destroy();
	}

	function BeginState()
	{
		local vector Dir;

		Dir = vector(Rotation);
		Velocity = speed * Dir;
		Acceleration = Dir * 50;
		PlayAnim( 'Wing', 0.2 );
		if (Region.Zone.bWaterZone)
		{
			bHitWater = True;
			Velocity=0.6*Velocity;
		}
	}
}

defaultproperties
{
    speed=8000.00
    MaxSpeed=8000.00
    Damage=4.00
    MyDamageType=RocketDeath
    SpawnSound=Sound'UnrealShare.Eightball.Ignite'
    ImpactSound=Sound'UnrealShare.Eightball.GrenadeFloor'
    RemoteRole=2
    LifeSpan=6.00
    AmbientSound=Sound'Botpack.RocketLauncher.RocketFly1'
    Mesh=LodMesh'Botpack.UTRocket'
    DrawScale=0.01
    AmbientGlow=96
    bUnlit=True
    SoundRadius=14
    SoundVolume=255
    SoundPitch=100
    LightType=1
    LightEffect=13
    LightBrightness=255
    LightHue=255
    LightRadius=6
    bBounce=True
    bFixedRotationDir=True
    RotationRate=(Pitch=0,Yaw=0,Roll=50000),
    DesiredRotation=(Pitch=0,Yaw=0,Roll=30000),
}
