// SLV2. Copyright (C) Al McElrath 2001.
// http://www.planetunreal.com/0fus/

// $Id: Sidearm.uc,v 1.12 2001/07/13 18:00:29 yrns Exp $

/** Racing sidearm. AKA "yellow jacket".
*/
class Sidearm extends SLWeapon;


var() string deathStr[5];


/** Some of the sidearm anims don't return to zero. FIX this. Should
	be included in SLWeapon?
*/
simulated function tweenToStill() {
	tweenAnim('still', 0.3);
	if (slave != none)
		slave.tweenToStill();
}


/** We randomize the death messages here. This is a little
	overkill. FIX.
*/
function processTraceHit(Actor a, vector hl, vector hn, vector x, vector y, vector z) {
	// Leave in the %k. Goddamn needs the default.

	super.processTraceHit(a, hl, hn, x, y, z);
}

defaultproperties
{
    deathStr(0)="%o was taken out by %ks %w."
    deathStr(1)="%o got capped by %ks %w."
    deathStr(2)="%o had a big taste of %ks %w."
    deathStr(3)="%o was reduced to a stain on the ground by %ks %w."
    deathStr(4)="%o was splattered against the floor by %ks %w."
    bFirearm=True
    hitdam=30
    fireMode=2
    rpm=600
    bAkimbo=True
    slaveName="Dual Yellow Jackets"
    leftMesh="SLV2Models.sarmview"
    assFire=(aname=Fire,arate=3.00,tween=0.10,Sound=Sound'SLV2Sounds.Sidearm.Fire',Volume=1.00,Slot=0,bSkipOwner=True),
    assAltFire=(aname=AltFire,arate=4.00,tween=0.10,Sound=Sound'SLV2Sounds.Sidearm.Fire',Volume=1.00,Slot=0,bSkipOwner=True),
    assSelect=(aname=Select,arate=1.00,tween=0.00,Sound=Sound'SLV2Sounds.Weapon.Reload',Volume=1.00,Slot=1,bSkipOwner=False),
    assDown=(aname=Down,arate=2.50,tween=0.05,Sound=None,Volume=1.00,Slot=1,bSkipOwner=False),
    assReload=(aname=Reload,arate=1.00,tween=0.00,Sound=Sound'SLV2Sounds.Weapon.Reload',Volume=1.00,Slot=1,bSkipOwner=False),
    paSlide=1.75
    paFlashY=0.05
    paFlashO=0.01
    mimicPriorityOf=enforcer
    WeaponDescription="Hmm."
    bInstantHit=True
    bOwnsCrosshair=False
    FiringSpeed=2.00
    FireOffset=(X=4.00,Y=-5.00,Z=4.00),
    MyDamageType=shot
    RefireRate=0.60
    DeathMessage="%o was taken out by %ks %w."
    bDrawMuzzleFlash=True
    MuzzleScale=1.00
    FlashY=0.28
    FlashO=0.04
    FlashLength=0.04
    FlashS=256
    MFTexture=Texture'SLV2Textures.muzf.mf1'
    InventoryGroup=2
    PickupMessage="You picked up a Yellow Jacket."
    ItemName="Yellow Jacket"
    PlayerViewOffset=(X=9.00,Y=-8.00,Z=-6.50),
    StatusIcon=Texture'SLV2Textures.SLHud.sidearmicon'
    Icon=Texture'SLV2Textures.SLHud.sidearmicon'
    Rotation=(Pitch=0,Yaw=0,Roll=-4600),
    CollisionRadius=16.00
    CollisionHeight=4.00
    Mass=15.00
}
