//=====================================================================
// RX6T4.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//          Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================
class StrangeShell extends SLGuide config (RX6T4);


#exec AUDIO IMPORT FILE="Sounds\Warning.wav" NAME="Warning" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\ab_Fadesound.wav" NAME="ab_fadesound" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\ab_Kicksound.wav" NAME="ab_KickSound" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\ab_Loop.wav" NAME="ab_Loop" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\ambSound.wav" NAME="ambSound" GROUP="NXSounds"

#exec AUDIO IMPORT FILE="Sounds\impact.wav" NAME="impact" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\Detonate.wav" NAME="Detonate" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\March2.wav" NAME="March2" GROUP="NXSounds"

#exec AUDIO IMPORT FILE="Sounds\VehicleCollision01.wav" NAME="VehicleCollision01" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\VehicleCollision02.wav" NAME="VehicleCollision02" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\VehicleCollision03.wav" NAME="VehicleCollision03" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\VehicleCollision04.wav" NAME="VehicleCollision04" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\VehicleCollision05.wav" NAME="VehicleCollision05" GROUP="NXSounds"

#exec AUDIO IMPORT FILE="Sounds\HullHit.wav" NAME="HullHit" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\HullHit2.wav" NAME="HullHit2" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\HullHit3.wav" NAME="HullHit3" GROUP="NXSounds"
#exec AUDIO IMPORT FILE="Sounds\HullHit4.wav" NAME="HullHit4" GROUP="NXSounds"

//var() string AirBrakes_Info;       // 0=None 50=SLV2(Default) 255=Max
//var() string SlideFX_Info;         // 0=SLV2 Default 1=Max --->Less ---> 255=No Sliding FX
var() config byte SlideFX;      // Setting sliding effect on the rocket
var() config byte AirBrakes;    // Do i need to explain?
var float desired, speed;
var() config float MaxSpeed;        // Max speed with afterburner
var() config float AccelMax;        // Maximum Acceleration
var() config bool DamageFX;       // Damage FX on/off
var() config float baseFuelRate;  // Fuel consumption without afterburner
var() config float afterburnRate; // Extra fuel ratio you burn.
//var() config float startSpeed;


//========================================================================================================

var bool bRightSelected, bLeftSelected;
var StrangeShell sl;
var Controller slc;               // Our controller.
var bool dumb;
var() config float armor;               // Damage the hull can withstand.
var() config float MaxArmor;
var() config float fuel;            // Amount of fuel (in seconds).
var() config float teamDamage;      // Rocket friendly-fire.
var() vector pilotOffset;           // Relative offset from the rocket location.
var() config float minspeed;
var() config float fullspeed;       // Max speed without burners.
var bool bAfterburn;                // Is the afterburner on?cruising speed.
var bool bNoFuel;                   // Flag for setting stuff when the fuel runs out.
var() config float accel;                    // Current acceleration rate.
var()config float thrate;                 // Fastest you can move the throttle.
var bool bSeeking;

var() class<SLHud> HUDClass;
var() class<ExhaustPuff> ExhaustPuffClass;
var() class<DamagePuff> DamagePuffClass;
var() class<StrangeWave> detClass2;


var() float puffRand;                // Random x/y offset.
var() float puffOffset;              // Distance the puffs start behind.

/** The impact angle the hull can survive at max. velocity. This is
	 a percentage of 90, so 45 degrees would be 0.5. See reflect().
*/
var() float crushAngle;

// Sounds.
var() Sound gunnerSound;
var() sound crashSound;
var() Sound throtSound;
var() Sound warnSound;
var() Sound abFadeSound;
var() Sound abLoopSound;
var() Sound abKickSound;
var() Sound ambSound;
var() Sound refuelSound;
var() Sound hullHits[4];
var() Sound bounces[5];
var() Sound DriveThruSound[6];
var() Sound DrewSound;

var vector realAccel;                    // Just like GuidedWarshell's realLocation, etc.

// Warhead status. Goddamn enums.
var() config enum EWarStat {
	 WH_Auto,
	 WH_Armed,
	 WH_Disarmed
} warstat;

/*//JetWeapon Switch
var() config enum EJetWeapon {
     WH_Cannons,
     WH_Rockets,
     WH_Nuker,
     WH_Config
} jetweapon;
*/



var config bool bCanOverride;          // The pilot can toggle the warhead status manually.
var GameReplicationInfo GRI;          // Used to detect the end of the game.

var bool bDetonate;                  // Set just before calling explode().
var float errorSum;                  // Total client error on serverMove()'s.
var int start;                       // Seconds since level began at begin play.

var bool bClientNoFuel;              // We use this to run initial no fuel code once.
var bool bBlasted;                   // Placed blast decal?

/** This keeps track of the last two pawns to eject and when, so that
	 we don't pick them up again in touch().
*/
var Pawn ejected[2];
var float ejectTime[2];
var() float touchLapse;

var float tstamp;                    // When the last timer() Was called.
var float smokeTimer;                // Keep track of the old timer().

/** These are used to display our special death messages. Possible
	 dtypes: NoUpdate, Ram, HitWall, HitSL, Shot.
*/

var name dtype;
var() localized string normDamStr;
var() localized string normSelfDamStr;
var() localized string ramDamStr;
var() localized string ramSelfDamStr;
var() localized string ramSelf2DamStr;
var() localized string shotDamStr;
var() localized string shotSelfDamStr;
var() localized string hitWallDamStr;
var() localized string hitWall2DamStr;
var() localized string hitSLDamStr[5];
var() localized string hitSLDamStr2;

// See spawnPuffs(). These control sputtering when out of fuel, etc.
var bool bSputter;
var float sputtime;

var float launched;                     // The time we were spawned.

var() float shootCR;                    // Self damage diameter for the rocket around the player.

var() float lvlimit;                    // Limit on velocity we can maintain at launch. See setLaunchVel().

var StrangeShell rammed;               // The shell we just touched.

/** Used when handling teleportation. See touch().
*/
var Teleporter lastTP;
var rotator lastTPRot;
// CONTROLLER DATA
//

var Pawn pilot;
var Pawn gunner;
var bool bShootMode;
var bool addedHUD;
var SLHud HUD;

var float throttle;                         // Percent throttle value.
var float thrprev;                         // Throttle level before afterburner was set off.
var float thlvl;
var bool bThrotSent;
var int throtDir;                         // For the mutate throttle commands.

struct RiderInfo {
	 var Pawn pawn;
	 var bool bOldJumpStatus;
	 var bool bDelayedEject;
	 var SLBotBrain Brain;
	 var Actor trailers[5];
	 var vector lastLoc;
};

var RiderInfo pInfo, gInfo;

var() Sound sndPilotEj;
var() Sound sndGunnerEj;
var() Sound sndDrop;

var byte bDuck;
var vector fogReset;                    // Reset info to get rid of the fog.
var bool bFog;                              // Is the client fogged?

var nullweapon nw;                         // The glue gun.
var Weapon lastWeapon;                    // Weapon to switch back to in shoot mode or eject.

var float teleportDist;                    // Minimum distance to kick in teleport hack.
var FuelCore fc;                         // Our fuel core inventory object.

var config bool bBotsObeyOrders;     // Bots follow orders or stick as gunners?

var float marchWait;                    // Time to wait before playing total comm. sound.
var bool bMarchUnder;                    // Have we been under the march limit yet?
var bool bMarchPlaying;
var() Sound sndMarchLoop;
var() Sound sndTotalComm;

var float savedBob;                         // Preserve their bob and set it to zero.
var bool bTakeover;                         // In a takeover sequence.
var float toTime;                         // Time left until takeover by gunner.

var bool bWahooPlayed;                    // Once we achieve min speed, Major Kong plays.
var() Sound sndWahoo;

var() config bool bRevY;               // Reverse the mouse Y axis while flying?
var bool bFlipY;                         // Have we already flipped it?

var() localized string gunnerMountStr[3];
var() localized string gunnerMountStr2[3];

var float painTimer;

var Util u;


//=============================
//  Engine flames / flares
//=============================

var ABFlamesB BEF1;
var BEngineFlare1 BEF2;
var BEngineFlare2 BEF3;
var ABFlames REF1;
var REngineFlare1 REF2;
var REngineFlare2 REF3;
var XSFRed JetRed;
var XSFBlue JetBlue;
var() byte Team;

//======================================================

// REPLICATION

//======================================================

replication
{
        

	reliable if (role < ROLE_Authority && bNetOwner)
		clientSendThrot,goShootMode;
	unreliable if (role == ROLE_Authority)
		dumb,Armor,bAfterburn,bNoFuel,warstat;
	unreliable if (role == ROLE_Authority && bNetOwner)
		fuel;
	unreliable if (role == ROLE_Authority && !bNetOwner)
		realAccel;
	unreliable if (role == ROLE_Authority)
		pilot,gunner,bShootMode,throttle,FC,Team;
        reliable if (role < ROLE_Authority && bNetOwner)
	switchWarheadRight, switchWarheadLeft;
}


//======================================================



simulated function postBeginPlay() {

// METHODS

/** Called on auto proxy and clients.
*/

	 u = spawn(Class'Util', self);
	 u.setDebugLevel(DL_Normal);

   //  u.debug("postBeginPlay(): owner: " $ u.sname(owner));

	 launched = level.timeseconds;

	 // Find our GRI so we know when the match is over.
	 foreach allActors(Class'GameReplicationInfo', GRI)
		  break;
	if( default.armor != Armor )
		default.armor = Armor;
	if( Maxarmor < Default.Armor * 1.25 )
		Maxarmor = Default.Armor * 1.25;
	
        
               
	//startContrail();

	 setTimer(0.000000001, true);
	// setTimer(0.1, true);
	 start = level.timeseconds;
	 tstamp = level.timeseconds;

	 // Old controller init.
	 bShootMode = false;
	 thlvl = 0.0;
	 throttle = 0.0;
	 bThrotSent = false;
	 addedHUD = false;
	 bFog = false;
	 fogReset.x = 0;          //greenie.r * 0.0;
	 fogReset.y = 0;     //greenie.g * 0.5;
	 fogReset.z = 0;          //greenie.b * 0.0;
	 throtDir = 0;
}

function Mlock()
{     
	local AntiSLV R1;

	if(bSeeking == True)
		return;

	ForEach AllActors(Class'AntiSLV', R1)
	{
		if((R1.Seeking==Pilot || R1.Seeking==Gunner) && R1.Instigator!=Pilot && R1.Instigator!=Gunner)
		{
			R1.sl=Self;
			bSeeking=True;
			//break;	
		}else{

           bSeeking = False;
	 
      }
   }
}

function MlockB()
{     
	local AntiSLV2 B1;

	if (bSeeking == True)
		return;

	ForEach AllActors(Class'AntiSLV2', B1)
	{
		if((B1.Seeking==Pilot || B1.Seeking==Gunner) && B1.Instigator!=Pilot && B1.Instigator!=Gunner)
		{
			B1.sl=Self;
			bSeeking=True;
			//break;	
		}else{		



           bSeeking = False;
	 }
      }
   }


/** This is our new tick!
*/
simulated function timer() {
	 local float now;
	 local float delta;

	 now = level.timeseconds;
	if ( Armor > MaxArmor )
		Armor = MaxArmor;
	 if (tstamp != 0) {
		  delta = now - tstamp;
		  tstamp = now;
		  if (slc == none && !dumb)
			   ctick(delta);
			   smoketick(delta);
	 }
CheckSideInput();

	 tstamp = now;
}
/** Called on auto proxy clients. This is the old timer().
*/
simulated function smoketick(float delta) {
	 local float rate;
	 local vector x, y, z;

	 // Set the timer rate.
	 if (level.bHighDetailMode) {
		  rate = 0.01;
		  if (level.bDropDetail)
			   rate = 0.1;
	 } else {
		  rate = 0.15;
	 }

	 // This simulates the old timer code.
	 smokeTimer += delta;
	 if (smokeTimer > rate)
		  smokeTimer -= rate;
	 else
		  return;

	 // If we haven't received an update from the client in 4 seconds, explode.
	 if (!dumb && pilot != none && !gameOver() && !instigator.isA('Bot') && role == ROLE_Authority && (level.timeseconds - serverUpdate > 4.0)) {
		  dtype = 'NoUpdate';
		  explode(location, vect(0, 0, 1));
		  return;
	 }

	 // Warn cannons so they can shoot us down.
	cannonTimer += rate;
  if (cannonTimer > 0.6) {
	 warnCannons();
   cannonTimer -= 0.6;

		  // Just stuck this in here so I don't have to create another timer.
		  getTrailers();
  }

	 // This section just for f/x.
	 if (level.netmode != NM_DedicatedServer) {
		  spawnPuffs(rate);
	 }
}


/** Spawn exhaust puffs here. Rate is the timer rate.
*/
simulated function spawnPuffs(float rate) {

	 //local ExhaustPuff puff;
	//  local ExhaustPuff ExhaustPuffClass;
	 local vector x, y, z, loc;

	 // Handle sputtering.
	 if (region.zone.bWaterZone || bNoFuel) {
		  if (bSputter) {
			   sputtime += rate;
		  } else {
			   bSputter = true;
			   sputtime = 0;
		  }
	 } else {
		  bSputter = false;
	 }

	 // Do the puffs.
	 getAxes(rotation, x, y, z);

	 // If bSputter is on, sputter out slowly for 2 secs.
	 if (!bSputter || (bSputter && sputtime < 1.0 && (frand() * 1.0) > sputtime))

{
		  loc = location - (x * puffOffset); //collisionRadius);

		  if (puffRand > 0.0) {
			   loc += (y * ((frand() * puffRand * 2.0) - puffRand));
			   loc += (z * ((frand() * puffRand * 2.0) - puffRand));
		  }
//      ExhaustPuffClass = spawn(Class'ExhaustPuff',,, loc);

	   //   puff = spawn(ExhaustPuffClass,,, loc);
		  if (!bSputter)
		  //     ExhaustPuffClass.drawScale = ExhaustPuffClass.default.drawScale + 0.5 * ((vsize(velocity) -

//minspeed) / (maxspeed - minspeed));
	 }

	 if ((armor / default.armor) < 0.70)
		  spawnDamPuffs(location - (x * 20), y, z, 1.0 - armor / default.armor);
}


/** Spawn damage puffs here.
*/
simulated function spawnDamPuffs(vector loc, vector y, vector z, float damf) {
	 local DamagePuff DamagePuffClass;
	 local float rand;

	 // Hull puffs slightly more jumpy.
	 if (puffRand > 0.0) {
		  rand = puffRand * 2.0;
	 } else {
		  rand = 4.0;
	 }
	 loc += y * ((frand() * rand * 2.0) - rand);
	 loc += z * ((frand() * rand * 2.0) - rand);

	 // Size and scale rate depend on the damage factor.
	 DamagePuffClass = spawn(Class'DamagePuff',,, loc);
	 DamagePuffClass.drawScale = damf * 3.0;
}


function StrangeShell findSL(Pawn p) {
	 local StrangeShell s;

	 //u.debug("findSL()", DL_Verbose);
	 foreach allActors(class'StrangeShell', s) {
		  if ((s.pilot != none && s.pilot == p) || ((s.gunner != none) && s.gunner == p)) {
			   return s;
		  }
	 }
	 return none;
}

/** Cycles the warhead status.
*/
/*
function switchWarhead() {
     if (bCanOverride) {
          switch (warstat) {
          case WH_Auto: warstat = WH_Armed; break;
          case WH_Armed: warstat = WH_Disarmed; break;
          case WH_Disarmed: warstat = WH_Auto; break;
          }

     }
}

*/

//function that checks your input
simulated function CheckSideInput()
{
	if (PlayerPawn(pilot) != None)
	{
		if (PlayerPawn(pilot).bWasRight && !bRightSelected)
		{
			switchWarheadRight();
			bRightSelected = True;
		}
		else if (PlayerPawn(pilot).bWasLeft && !bLeftSelected)
		{
			switchWarheadLeft();
			bLeftSelected = True;
		}

		if (!PlayerPawn(pilot).bWasRight && bRightSelected)
			bRightSelected = False;
		if (!PlayerPawn(pilot).bWasLeft && bLeftSelected)
			bLeftSelected = False;
	}
}

//Switch warhead status >>>
function switchWarheadRight() {
     if (bCanOverride) {
          switch (warstat) {
          case WH_Auto: warstat = WH_Armed; break;
          case WH_Armed: warstat = WH_Disarmed; break;
          case WH_Disarmed: warstat = WH_Auto; break;
          }
     }
}

//Switch warhead status <<<
function switchWarheadLeft() {
     if (bCanOverride) {
          switch (warstat) {
          case WH_Auto: warstat = WH_Disarmed; break;
          case WH_Armed: warstat = WH_Auto; break;
          case WH_Disarmed: warstat = WH_Armed; break;
          }
     }
}



/** Disarm the warhead. For bots, mainly.
*/
function disarm() {
	 if (bCanOverride)
		  warstat = WH_Disarmed;
}
/** Arm the warhead. For bots.
*/
function arm() {
	 if (bCanOverride)
		  warstat = WH_Armed;
}
/** Returns true if we're armed.
*/
simulated function bool armed() {
	 return (warstat == WH_Armed);
}
/** If we are set to auto, arm us.
*/
function bool autoArm() {
	 if (warstat == WH_Auto) {
		  warstat = WH_Armed;
		  return true;
	 }

	 return false;
}


/** Called from the options screen.
*/
static function setDefaultWarhead(int stat) {
	 if (stat == 1)
		  default.warstat = WH_Armed;
	 else if (stat == 2)
		  default.warstat = WH_Disarmed;
	 else
		  default.warstat = WH_Auto;
}


function setRemoteRole(Actor a) {
	 if (level.netmode != NM_Standalone) {
		  if (role == ROLE_Authority && !dumb && a != none && !a.isA('Bot') && (level.netmode != NM_ListenServer || !u.hasViewPort(a)) && !bNoFuel) {
			   remoteRole = ROLE_AutonomousProxy;
		  } else {
			   remoteRole = ROLE_SimulatedProxy;
		  }

		  //u.debug("setRemoteRole(" $ u.sname(a) $ "): remoteRole set: " $ remoteRole);
	 }
}




auto state Flying {

simulated function ZoneChange( Zoneinfo NewZone )
	{
		local waterring w;
		
		if ( NewZone.bWaterZone != Region.Zone.bWaterZone )
		{
			w = Spawn(class'WaterRing',,,,rot(16384,0,0));
			w.DrawScale = 0.8;
			w.RemoteRole = ROLE_None; 
		}	
	}


	 simulated function beginState() {
		  local Pawn p;
		  local float lv;
                  


		  // Only the server has the owner set.
		  if (owner != none) {
			   serverUpdate = level.timeSeconds;
			   guidedRotation = rotation;

		  if (level.netmode == NM_Standalone || (level.netmode == NM_ListenServer && u.hasViewPort(owner)))
				slc = spawn(Class'Controller', self);
		if ( pawn(owner).PlayerReplicationInfo.Team == 0) {
			
			REF1 = Spawn(class'X6RP.ABFlames', self,,,rot(16384,0,0));
			REF2 = Spawn(class'REngineFlare1', self);
			REF3 = Spawn(class'REngineFlare2', self);
                        
			JetRed = Spawn(class'XSFRed',Self,, Location, Rotation);
		}



		else if ( pawn(owner).PlayerReplicationInfo.Team == 1) {
						
						BEF1 = Spawn(class'X6RP.ABFlamesB', self,,,rot(16384,0,0));
						BEF2 = Spawn(class'BEngineFlare1', self);
						BEF3 = Spawn(class'BEngineFlare2', self);
						
						JetBlue = Spawn(class'XSFBlue',Self,, Location, Rotation);
}




		
		  } else {
			   // The owner is always none on the client in a network
			   // game. (At least for another few ticks.)
			   if (role == ROLE_Authority) {
					dumb = true;
					warstat = WH_Armed;

					// Set acceleration. Catch this on the client with net initial...?
					acceleration = (AccelMax * 0.20) * vector(rotation);

					// Don't do the launch v.
					velocity = minspeed * vector(rotation);
					setRemoteRole(owner);
					return;
			   }
		 }

		  setLaunchVel(speed);
		  setRemoteRole(owner);
		 
}
	  
	 






	 /** We want to maintain the instigator's velocity when they
		  launch. On the server, we know it already. On the client the
		  vel. doesn't get updated for a few ticks (or more), so we guess it on
		  our end. The launcher sets the lv and we look for it here.
	 */
	 simulated function setLaunchVel(int startSpeed) {

		  local Pawn p;
		  local vector lv, zero;
		  local rotator lr;
		  local float z;

		  if (role == ROLE_Authority) {
			   if (instigator != none)
				  lv = instigator.velocity;
				  lr = rotation;


		  } else {
			   // This is on the client. dumb == unknown.
			   // Major kludge. This is all to save us from two or
			   // three ticks of the wrong velocity. Hopefully it will smooth launches
			   // out with maintained velocity. If there are two launches in the radius,
			   // set them all to 0. That's better than having the wrong velocity set.

			   foreach radiusActors(Class'Pawn', p, vsize(pilotOffset) * 2.0) {
					if (p.weapon != none && p.weapon.isA('Konglauncher') && konglauncher(p.weapon).launchv != zero) {
						 // Not set yet.
						 if (lv == zero) {
							  lv = konglauncher(p.weapon).launchv;
							  lr = p.rotation;
						 } else {
							  lv = zero;
						 }
					   //  u.debug("setLaunchVel(): found p: " $ u.sname(p) $ " lv: " $ u.sv(lv) $ " lr: " $ u.sr(lr) $ " delta loc: " $ u.sv(p.location - location), DL_Verbose);
						 // Clear it.
						 konglauncher(p.weapon).launchv = zero;
					}
			   }
		  }

		  // Now limit the velocity. Give a little on the z component, though.
		  if (vsize(lv) > lvlimit) {
			   z = lv.z;
			   lv = normal(lv) * lvlimit;
			   lv.z = fmin(z, lvlimit * 1.5);
			 //  u.debug("setLaunchVel(): lv scaled to: " $ u.sv(lv), DL_Verbose);
		  }

		  // Merge it with the shell v. Only if we have a launch rotation.
		  if (lr != rot(0, 0, 0))
			   velocity = vector(lr) * startSpeed + lv;
	 }
	 /** Someone has run into us! For shame! This handles detonations
		 as well as new gunners.
	 */
	 function processTouch(actor a, vector hl) {
		  local vector x, y, z;
		  local Strangeshell sl;

		  // 1. Ignore processTouch() on the auto proxy client.
		  // 2. Ignore fuel cores. (We have to pick them up.)
		  // 3. The touching actor is the pilot or gunner.
		  // 4. Ignore carcasses. Is this right?
		  // 5. Ignore those recently ejected.
		  // 6. Ignore the instigator if recently fired.

		  if (role < ROLE_Authority || a.isA('FuelCore') || a == pilot || a == gunner || a.isA('Carcass') || (a.isA('Pawn') && wasEjected(Pawn(a))) || (a == instigator && ((level.timeseconds - launched) < 2.0)))
			   return;

		 // u.debug("processTouch(): actor: " $ u.sname(a));

		  // See if we're a rider on another rocket.
		  if (a.isA('Pawn') && Pawn(a).bIsPlayer && findSL(Pawn(a)) == none) {
			   if (!dumb && sameTeam(Pawn(a), instigator) && gunner == none) {
				 
					setGunner(Pawn(a));
                                        
					return;
			   } else {
                           if (a.isA('Pawn') && sameTeam(Pawn(a), instigator)){
                             return;
			   } else {
			   if (a.isA('sl') && sameTeam(Pawn(a), instigator)){
                             return;
                           } 

				}
			}
				
			   // Nope? Run them over...
		  }

		  if (armed() && fromFront(a)) {
			 //  u.debug("processTouch(): detonating from front");
			   detonate(hl, normal(hl - a.location));
		  } else {
			   if (a.isA('StrangeShell')) {
					// Don't detonate our own freshly-launched rockets. Or the gunner's.
					if ((a.instigator == instigator || a.instigator == gunner) && ((level.timeseconds - StrangeShell(a).launched) < 2.0 || (level.timeseconds - launched) < 2.0))
						 return;

					// Remember who we rammed.
					rammed = StrangeShell(a);


					// This will give us an inverse normal 50% of the time.
					getAxes(a.rotation, x, y, z);
				   reflect(y, a); //, 0.75);
			   } else {
					// Print the correct death message.
					if (a == instigator)
						 u.setDamageString(ramSelf2DamStr, a, a);
					else
						 u.setDamageString(ramDamStr, instigator, a);
					a.takeDamage(vsize(velocity - a.velocity) * 0.15, instigator, hl, normal(velocity) * momentumTransfer, myDamageType);

					playSound(bounces[rand(ArrayCount(bounces))], SLOT_None, 4.0);

					// We take a fraction of the damage.
					takeDamage(vsize(velocity) * 0.05, instigator, hl, normal(velocity) * momentumTransfer, 'Ram');
			   }
		  }
	 }


	 /** Wrapper for detonation.
	 */
	 function detonate(vector hl, vector n) {
		  bDetonate = true;

		  explode(hl, n);
	 }


	 /** Either detonate, spawning a shock wave, or blow up due to damage.
	 */
	function explode(vector hl, vector n) {
              if (role < ROLE_Authority)
		   return;

		  if (bDetonate) {
		        
		          spawn(detClass2,,, hl + n * 16, rot(0, 0, 0));


		  } else {
			   // This looks silly dropped, but oh well.
			   if (!level.bDropDetail && level.netmode != NM_DedicatedServer) {
					spawn(class'StrangeExpl',,, location);
					spawn(class'blackcloud',,, location);

			   }

			   // Use our dtype, previously set in takeDamage().

			   specialHurtRadius(damage, 300.0, dtype, momentumTransfer, hl);
		  }

		  // Why do I need this?
		  remoteRole = ROLE_SimulatedProxy;

		
//==================
// Destroy function
//==================
	
	if (REF1 != none) REF1.Destroy();
	if (REF2 != none) REF2.Destroy();
	if (REF3 != none) REF3.Destroy();
	if (BEF1 != none) BEF1.Destroy();
	if (BEF2 != none) BEF2.Destroy();
	if (BEF3 != none) BEF3.Destroy();
	if (jetred != none) jetred.destroy();
        if (jetBlue != none) jetBlue.destroy();
	if (nw != none) nw.Destroy();
	
		  super.destroy();

	 }

}
 // End Flying.

function detonate(vector hl, vector n) {
	 // Nothing.


}


/** I had to redo this to get better control over the death messages.
*/
function specialHurtRadius(float dam, float rad, name dtype, float mom, vector hl) {
	 local Actor v;
	 local float dscale, dist;
	 local vector dir;
	 local string sds;

	 if (bHurtEntry)
		  return;
	   //bHurtEntry = true;
	  // u.debug("specialHurtRadius(): " $ dtype);
	   foreach visibleCollidingActors(Class'Actor', v, rad, hl) {
		  if (v != self) {
			   if (v.isA('Pawn')) {
					// Set our "special" damage string.
					sds = normDamStr;
					if (dtype == 'NoUpdate' && v == instigator) {
						 sds = normSelfDamStr;
					} else if (dtype == 'Ram' && v == instigator) {
						 sds = ramSelfDamStr;
					} else if (dtype == 'HitWall' && v == instigator) {
						 if (frand() < 0.5)
							  sds = hitWallDamStr;
						 else
							  sds = hitWall2DamStr;
					} else if (dtype == 'HitSL') {
						 // No rammed or ram pilot?
						 if (rammed == none || rammed.pilot == none) {

							  if (v == instigator)
								   sds = hitSLDamStr[rand(arrayCount(hitSLDamStr))];
						 } else {
							  if (v == rammed.pilot) {
								   sds = hitSLDamStr2;
							  } else if (v == instigator) {
								   // This will print a blank line. Oh well.
								   sds = " ";

							  }
						 }
					} else if (dtype == 'Shot') {
						 if (v == instigator) {
							  sds = shotSelfDamStr;
						 } else if (v == pilot || v == gunner) {

							  sds = shotDamStr;
						 }
					}
					  u.setDamageString(sds, instigator, v);
			   }
			   dir = v.location - hl;
			   dist = fmax(1, vsize(dir));
			   dir = dir / dist;
			   dscale = 1 - fmax(0, (dist - v.collisionRadius) / rad);
			   v.takeDamage(dscale * dam, instigator, v.location - 0.5 * (v.collisionHeight + v.collisionRadius) * dir, dscale * mom * dir, myDamageType);
		  }
		continue;
	}
	bHurtEntry = true;

}

/** Store this guy. He just ejected. If we have 3 ejects within
	 the eject lapse, then we lose whoever was in the first
	 slot. So be it.
*/
function storeEject(Pawn p) {
	 local float time;
	 time = level.timeseconds;
	 if (ejected[1] == none || (time - ejectTime[1]) > touchLapse) {
		  ejected[1] = p;
	 p.bHidden=False;
	 p.Visibility = p.Default.Visibility;
	 p.SetDefaultDisplayProperties();
		  ejectTime[1] = time;
	 } else {
		  ejected[0] = p;
	 p.bHidden=False;
	 p.Visibility = p.Default.Visibility;
	 P.SetDefaultDisplayProperties();
		  ejectTime[0] = time;
	 }
}

/** Was this guy recently ejected?
*/
function bool wasEjected(Pawn p) {
	 if (ejected[0] == p && (level.timeseconds - ejectTime[0]) <= touchLapse)
		   return true;
	  else if (ejected[1] == p && (level.timeseconds - ejectTime[1]) <= touchLapse)
		return true;

	 return false;
}


/** Returns true if they are in front of us. Roughly.
*/
function bool fromFront(Actor a) {
	 local vector dir, x, y, z;

	 if (a != none) {
			dir = normal(a.location - location);
			getAxes(rotator(velocity), x, y, z);
			// Is this like 45 degrees? Not sure...
		  return ((dir dot x) > 0.7);
	 } else {
		  return false;
	   }
}
/** Spit out some sparks.
*/
simulated function sparks(int dam) {
	 local int isparks;
	 if (level.netmode != NM_DedicatedServer) {
		  for (isparks = min(15, dam / 2); isparks > 0; isparks--)
			   spawn(Class'SLSparker');
	 }
}

/* if taking damage from the front, there should be a chance of
	 detonation - if armed.
	 Should this be singular? No. As an example, imagine our rocket
	 bumps into another rocket. We take a slight bit of damage, but the
	 other rocket explodes. Their explosion causes us massive damage. If
	 this function were singular, we'd be left unscathed. What we do is, if
	 our armor's already depleted, we return so we don't explode again.
*/

function takeDamage(int dam, Pawn i, vector hl, vector m, name dtype) {
     if (HUD != none) {
          HUD.shake(dam * 0.25);
     }

     if (armor < 0) {
          return;
     }

     sparks(dam);


     if (role < ROLE_Authority)
          return;

     // The instigator is what team we're on.
     if (i != instigator && sameTeam(i, instigator))
          dam *= teamDamage;

     armor -= dam;

     // Explode, either by shot damage or accidental (heh) detonation.
     if (armor <= 0 || (armed() && fromFront(i) && frand() < 0.40)) {

          // Reset the instigator so that whoever shot us gets credit.

          if (i != none && i != pilot)
               instigator = i;

          if (armed()) {
               detonate(hl, vect(0, 0, 1));
          } else {

               // If it's not one of these, we were shot down.
               if (dtype != 'HitWall' && dtype != 'HitSL' && dtype != 'Ram')
                    self.dtype = 'Shot';


               playSound(crashSound, SLOT_None, 8.0);

               explode(hl, vect(0, 0, 1));
          }

     } else {
          // Just a scratch. Play the dent sound.
          //if (type != 'HitWall')
               playSound(hullHits[rand(arrayCount(hullHits))], Slot_None, 6.0);
     }
}


/** This will get called on the client when we switch to sim proxy.
*/
simulated function hitWall(vector hn, Actor wall) {
     local float dam;
     local DirectionalBlast db;

     if (armed()) {
          // Blast decal.
          spawnBlast(true, location, hn);

          if (role == ROLE_Authority) {
               if ((Mover(wall) != none) && Mover(wall).bDamageTriggered)


                    // Bogus damage type.
                    wall.takeDamage(damage, instigator, location, normal(velocity) * momentumTransfer, 'RocketCrash');

               makeNoise(1.0);
               detonate(location + explowallout * hn, hn);
          }

          // Don't call hitwall again.
          setPhysics(PHYS_None);

          // warstat == 1 code adapted from Projectile.hitWall().
          //super.hitWall(hn, wall);

     } else {
          dam = reflect(hn, wall);


          if (level.netmode != NM_DedicatedServer) {
               db = spawn(Class'RX6T4.DScar', self);
               if (db != none) {
                    db.drawScale *= (dam * 0.03);
                    db.directionalAttach(velocity, hn);
               }
          }
     }




}


/** We have hit something. hn is the hit normal. Returns the amount of
	 damage inflicted.
	 In SL-SL collisions, this resets the velocity, which affects the
	 second rocket's reflect() call. FIX.
*/
simulated function float reflect(vector hn, Actor a, optional float soften) {

	 local float theta;
	 local vector nv, x, y, z;
	 local float relv;
	 local float dam;

	 if (soften == 0.0)
		  soften = 1.0;

	 // Default is hit wall.
	 if (a.isA('StrangeShell'))

		  dtype = 'HitSL';
	 else
		  dtype = 'HitWall';

	 // Angle of impact. 1 is head on. Near 0 is losing a coat of
	 // paint. Sometimes we're passed an inverse normal for simplicity, so
	 // take the abs().
	 theta = abs(normal(velocity) dot hn);
	 relv = vsize(velocity - a.velocity);

	 // Average the angle and speed components. 100.0 is usually the
	 // default armor (max. damage). 1000.0 is usually maxspeed. The
	 // angle counts twice as much.
	 dam = ((2.0 * (theta / crushAngle) + (relv / 1000.0)) / 3.0) * 100.0 * soften;

	 // Theta causes up to a 40% reduction in speed.

	 nv = mirrorVectorByNormal(velocity, hn) * (1.0 - 0.40 * theta);

	 if (soften < 1.0)
		  velocity = (velocity * (1.0 - soften) + nv * soften);
	 else
		  velocity = nv;

	 // Use the new velocity. Could we find a better hit location to use?
	 if (role == ROLE_Authority) {
		  takeDamage(dam + (rand(10) - 5), instigator, location, normal(velocity) * momentumTransfer, dtype);

		  // Don't piss off CSHP. Server only.
		  if (pilot != none) {
			   pilot.clientSetRotation(rotator(velocity));
		  }
	 }

	 guidedRotation = rotator(velocity);

	 // This'll never happen.
	 if (bNoFuel)
		  spin();

	 playSound(bounces[rand(ArrayCount(bounces))], SLOT_None, 4.0);

	 return dam;
}
simulated function float arccos(float x) {
	 return atan((sqrt(1 - x ^ 2)) / x);
}
/** Toggles the afterburners.
*/
Simulated function Afterburn()
{
	if (bNoFuel)
		return;
	if (pawn(owner)!=None && pawn(owner).PlayerReplicationInfo!=None && pawn(owner).PlayerReplicationInfo.Team == 0)
	{
	if (bAfterburn)
	{
			bAfterburn = false;
			throttle = thrprev;
if(REF1!=None)
			REF1.drawScale = 2.0;
if(REF2!=None)
			REF2.drawScale = 0.0;
if(REF3!=None)
			REF3.drawScale = 0.0;

			
		} else {
			bAfterburn = true;
			thrprev = throttle;
			throttle = 1.5;
if(REF1!=None)
			REF1.drawScale = 2.0;
if(REF2!=None)
			REF2.drawScale = 0.5;
if(REF3!=None)
			REF3.drawScale = 0.5;
			
                        
	}
		updateSound(0);
	}
	else  if (pawn(owner)!=None && pawn(owner).PlayerReplicationInfo!=None && pawn(owner).PlayerReplicationInfo.Team == 1)
	{
	if (bAfterburn)
	{
		bAfterburn = false;
		throttle = thrprev;
if(BEF1!=None)
		BEF1.drawScale = 2.0;
if(BEF2!=None)
		BEF2.drawScale = 0.0;
if(BEF3!=None)
		BEF3.drawScale = 0.0;
                
	} else {
		bAfterburn = true;
		thrprev = throttle;
		throttle = 1.5;
if(BEF1!=None)
		BEF1.drawScale = 2.0;
if(BEF2!=None)
		BEF2.drawScale = 0.5;
if(BEF3!=None)
		BEF3.drawScale = 0.5;
		
		

		
	}
		updateSound(0);
	}
	
}

function newOwner(Actor o) {
	// u.debug("newOwner(" $ u.sname(o) $ ")");
	 setOwner(o);
}

/** Returns true if the game's over.
*/
simulated function bool gameOver() {
	 return (GRI != none && GRI.gameEndedComments != "");
}
/** Handles fuel usage. Called from the controller's tick()
	 function. Midair (after no-fuel condition) refueling does not work
	 yet. FIX.
*/
simulated function burnFuel(float delta) {
	 local float fr;
	 local float dffx;
	 local bool DamageFX;
	 //local float RocketArmor;
	// u.debug("burnFuel(): current fuel: " $ fuel, DL_Verbose);

	 // Don't burn fuel after game's over.
	 if (gameOver())
		  return;

	 // Burn fuel. Only do this on the server and owner client. The
	 // owner client only does this to render the fuel gauge.
	 if (role == ROLE_Authority || (u != None && u.hasViewport(pilot))) {
		  if (fuel > 0.0)

			   {
			   if (DamageFX == true)
					dffx = (armor / default.armor);

			   if (DamageFX != true)
					dffx = 1;
					dffx = (armor / default.armor);
					fr = (baseFuelRate / dffx);
					if (bAfterburn)
					fr *= afterburnRate;
					fuel = fmax(0.0, fuel - fr * delta);
					return;

			   }


		  // Try to refuel. The client refuels, but doesn't ditch a pod.
		  if (fuel == 0.0) {
			   if (!refuel() && role == ROLE_Authority)
					bNoFuel = true;
			   else

		  }

	 }

	 // We don't really know we're out of fuel until the server sets
	 // bNoFuel to true. We only run this "out of fuel" code once.

	 if (bNoFuel) {
		  if (!bClientNoFuel) {
			  // u.debug("burnFuel(): Uh oh, no fuel.");
			   // Cut the engines yo.
			   updateSound(0);
			   // We should be falling down...
			   setRemoteRole(pilot);
			   setPhysics(PHYS_Falling);
			   
			if(pilot!=None)   {
			pilot.bHidden=false;
			}
			   noFuel();
			   spin();
			   bClientNoFuel = true;
		  }
	 }
}

/** This gets called when the shell runs out of fuel.
*/
function noFuel() {
	if (pilot != None)
	{
	     eject(pilot, 0, true);
	}
	if (gunner != None)
	{
	     eject(gunner, 0, true);
	}
	if (pilot != None)
	{
	     pilot.bHidden = false;
	}
	if (gunner != None)
	{
	     gunner.bHidden = false;
	}
}


simulated function spin() {
	 randspin(rand(10000) + 10000);
}


/** This handles refueling from carried fuel cores. It is called on
	 both (owner) client and server, but the "no fuel" condition is
	 passed to the client from bNoFuel on the rocket.
*/
simulated function bool refuel() {

	 if (pilot != none) {

		  if (fc != none && fc.ammoAmount > 0) {

			   if (role == ROLE_Authority)
					fc.useAmmo(1);

			   playSound(refuelSound, SLOT_None, 1.0);
			   fuel = default.fuel;
			   return true;
		  }
	 }
	 return false;
}


	 // If the game's over... freeze. Damnit this only works for players and guided rockets (fine).
simulated function tick(float delta) {

	 if  (bNoFuel)
		  return;
	 if (dumb) {
		  burnFuel(delta);
		  return;
	}

	 if (GRI != none && GRI.gameEndedComments != "") {
		 setPhysics(PHYS_None);
		  velocity = vect(0, 0, 0);
		 return;
	}

	 // The role is still auto on non-viewport clients. Duh. Took me

	 // this long to figure that out. Can't test for sim proxy on the client.
	 if (level.netmode == NM_Client && (instigator.isA('Bot') || !u.hasViewPort(instigator)))   {
		  updateSimProxy();
		  return;

	 // WTF is this? When does this happen? FIX.
	 } else if ((level.netmode != NM_Standalone) && (remoteRole == ROLE_AutonomousProxy)) {
		  return;
	 }

	 // if server updated client position, client needs to replay moves after the update
	 if (bUpdatePosition)
		  clientUpdatePosition();

	 // Keep goin straight if we're dead!
	 if (guided())
	 if (pInfo.brain != none && pInfo.brain.bGuiding)
			guidedRotation = pInfo.brain.getGuidedRotation();
		 else
			guidedRotation = pilot.viewRotation;
	 if (role == ROLE_AutonomousProxy)
		   autoMove(delta);
	 else
		  moveRocket(delta, velocity, guidedRotation);
}
simulated function updateSimProxy() {
	 if (updateReal(realLocation, location, 20.0)) {
		// u.debug("updateSimProxy: real loc: delta: " $ vsize(realLocation - location), DL_Verbose);
		  setLocation(realLocation);
		  realLocation = vect(0, 0, 0);
	 }
	 if (updateReal(realVelocity, velocity, 0.0)) {
	   // u.debug("updateSimProxy: real vel: delta: " $ vsize(realVelocity - velocity), DL_Verbose);
		  velocity = realVelocity;
		  // Aproximate the rotation on sim proxies (no roll).
		  setRotation(rotator(velocity));
		  realVelocity = vect(0, 0, 0);
	 }
	 if (updateReal(realAccel, acceleration, 0.0)) {
	   //  u.debug("updateSimProxy: real acc: delta: " $ vsize(realAccel - acceleration), DL_Verbose);
		  acceleration = realAccel;
		  realAccel = vect(0, 0, 0);
	}
}
simulated function bool updateReal(vector v1, vector v2, float mindelta) {
	 return (v1 != vect(0, 0, 0) && vsize(v1 - v2) > mindelta);
}
/** Auto proxy movement. Called from tick(). Calls serverMove().
*/
function autoMove(float delta) {
	 local SavedMove nm;

	 // Send the move to the server. Skip move if too soon.
	 if (clientBuffer < 0) {
		  clientBuffer += delta;
		  moveRocket(delta, velocity, guidedRotation);
		  return;
	 } else {
			clientBuffer = clientBuffer + delta - 80.0 / PlayerPawn(instigator).player.currentNetSpeed;
	 }
	  // I'm a client, so I'll save my moves in case I need to replay
	 // them. Get a SavedMove actor to store the movement in.
	 if (savedMoves == none) {
		  savedMoves = getFreeMove();
		  nm = savedMoves;
	 } else {
		  nm = savedMoves;
		  while (nm.NextMove != none)
		  nm = nm.nextMove;
		  nm.nextMove = getFreeMove();
		  nm = nm.nextMove;
	 }
	 nm.timestamp = level.timeseconds;
	 nm.delta = delta;
	 nm.velocity = velocity;
	 nm.setRotation(guidedRotation);
	 moveRocket(delta, velocity, guidedRotation);
	 serverMove(level.timeseconds, location, nm.rotation.pitch, nm.rotation.yaw);
}
/** Is there a pilot and is he conscious?
*/
simulated function bool guided() {
	 return (pilot != none && !bShootMode && pilot.health > 0);
}
/** Server replicates this to the client.
*/
simulated function clientAdjustPosition(float ts, float nlx, float nly, float nlz, float nvx, float nvy, float nvz) {
	 super.clientAdjustPosition(ts, nlx, nly, nlz, nvx, nvy, nvz);
	// u.debug("clientAdjustPosition(): new v: " $ vsize(velocity), DL_Verbose);
}
/** Had to modify this slightly.
*/
simulated function clientUpdatePosition() {
	 local SavedMove curm;
	 bUpdatePosition = false;
	 curm = savedMoves;
	 while (curm != none) {
		  if (curm.timestamp <= currentTimeStamp) {
			   savedMoves = curm.nextMove;
			   curm.nextMove = freeMoves;
			   freeMoves = curm;
			   freeMoves.clear();
			   curm = savedMoves;
		  } else {

			   // Use the current velocity, not the stored one!
			   moveRocket(curm.delta, velocity, curm.rotation);
			   curm = curm.nextMove;
		  }
	 }
	 //u.debug("clientUpdatePosition(): updated v: " $ vsize(velocity), DL_Verbose);
	 //super.clientUpdatePosition();
}
/** Client replicates this to the server. Called only from tick().
*/
function serverMove(float ts, vector clientloc, int pitch, int yaw) {
	 local float clientErr, delta;
	 local vector dloc;

	 if (currentTimeStamp >= ts)
		  return;

	 if (currentTimeStamp > 0)
		  delta = ts - currentTimeStamp;
	 currentTimeStamp = ts;
	 guidedRotation.pitch = pitch;
	 guidedRotation.yaw = yaw;

	 if (delta > 0)
		  moveRocket(delta, velocity, guidedRotation);


	 if (level.timeseconds - lastUpdateTime > 0.4) { //0.3) {
		//  u.debug("serverMove(): sec since last update: " $ (level.timeseconds - lastUpdateTime), DL_Verbose);
		  clientErr = 10000;
	 } else if (level.timeseconds - lastUpdateTime > 0.07) {
		  dloc = location - clientloc;

		  clientErr = dloc dot dloc;
		  errorSum += clientErr;
	 }

	 // If client has accumulated a noticeable positional error, correct him.
	 if (clientErr > 3) {
		  lastUpdateTime = level.timeseconds;
		//  u.debug("serverMove(): sending updated pos: clientErr: " $ clientErr, DL_Verbose);
		  clientAdjustPosition(ts, location.x, location.y, location.z, velocity.x, velocity.y, velocity.z);

	 }

	 //super.serverMove(ts, clientloc, pitch, yaw);
}

/** This clamps the guide rotation to 90 degree turns. We don't want
	 exact 180 turns else the rocket may shoot straight up or down.
	 Also clamp pitch to below 16384. The yaw goes wild past that.
*/
simulated function rotator adjustGuideRot(rotator gr, rotator rr) {
	 local float dyaw, pitch;
	 local rotator newr;

	 // This returns the last known guide rotation, i.e. straight. :)
	 if (!guided() || pilot.isA('Bot'))
		  return gr;
	 dyaw = (pilot.viewRotation.yaw & 65535) - (rr.yaw & 65535);
	 pitch = gr.pitch;
	 u.centerRotComp(dyaw);
	 u.centerRotComp(pitch);
	 newr = gr;
	 newr.yaw = rr.yaw + clamp(dyaw, -16384, 16384);
	 newr.pitch = clamp(pitch, -16384, 16384);

	 return newr;
}
/** Actually moves the rocket based on the passed criteria. Eventually
	 calls autonomousPhysics().
*/
simulated function moveRocket(float delta, vector cv, rotator gr) {
	 local vector deltav;
	 local int maxroll, oldroll, rollmag;
	 local float smoothRoll;
	 local vector oldv, x, y, z;

	// u.debug("moveRocket(): delta: " $ delta $ " cv: " $ vsize(cv) $ " gr: " $ u.sr(gr), DL_Verbose);


	 if (lastTP != none) {
		  if (lastTPRot != rotation) {
			 //  u.debug("moveRocket(): teleported! new rot: " $ u.sr(rotation), DL_Verbose);


			   cv = vsize(velocity) * vector(rotation);
			   velocity = cv;
			   gr = rotation;
		  }
		  lastTP = none;

		// startContrail();
	 }

	 serverUpdate = level.timeseconds;
	 oldroll = (rotation.roll & 65535);
	 oldv = cv;

	 // This is our steering component. Its strength is based on the
	 // current velocity. At higher speeds it's lower.
	 // Sliding effects adjustable or if 0 use delta
	 if (SlideFX !=0)
	 deltav = vector(adjustGuideRot(gr, rotator(cv))) * ((MaxSpeed + 700) - vsize(cv)) * (((SlideFX * 0.001568) + 0.05) * (armor / default.armor));
	 else
	 deltav = vector(adjustGuideRot(gr, rotator(cv))) * ((MaxSpeed + 700) - vsize(cv)) * delta;

	 // Here, we blend the current velocity (momentum) and the steering
	 // vector from above to get the sliding effect.
	 velocity = normal(cv + deltav) * vsize(cv);
	 // Handle the rolling.
	 maxroll = 65536 * 0.25;
	 getAxes(gr, x, y, z);
	 rollmag = int(10 * (y dot (velocity - oldv)) / delta);

	 if (rollmag > 0)
		  gr.roll = min(maxroll, rollmag);

	 else
		  gr.roll = max(65536 - maxroll, 65536 + rollmag);

	 // Smoothly change the rotation.
	 if (gr.roll > 32768) {
		  if (oldroll < 32768)
			   oldroll += 65536;

	 } else if (oldroll > 32768)
		  oldroll -= 65536;

	 smoothroll = fmin(1.0, 2.0 * delta);
	 gr.roll = gr.roll * smoothroll + oldroll * (1 - smoothroll);

	 setRotation(gr);

	 /** Normally an auto proxy does not move based on its physical
		  properties like acceleration and velocity unless you tell it to. We
		  only want to call autoPhysics() if it's a network game (where the
		  auto proxy role is used). And, on listen servers, only if it's not the
		  local viewport.

		  The auto proxy role shows up on all the clients, so we can't
		  specifically test for it. So we test netmodes, viewport (if a listen
		  server), and pilot (for dumb fires and ejected pilots).
	 */
	 // Do autonomous physics if:
	 // We're not playing standalone and...
	 if ((level.netmode != NM_Standalone) &&
		  // If we're a listen server, there's no viewport (remote player) and...
		  (level.netmode != NM_ListenServer || !u.hasViewPort(instigator)) &&
		  (!instigator.isA('Bot')) &&
		  // We have a pilot.
		  (pilot != none)) {

		 // u.debug("moveRocket(): auto physics", DL_Verbose);
		  autonomousPhysics(delta);
	 }

	 if (role == ROLE_Authority) {
		  realLocation = location;
		  realVelocity = velocity;
		  realAccel = acceleration;
	 }

}

function float damageadjust ( float hullarmor )
{
	local float armult;
	armult = 1;
	if ( hullarmor <= default.armor * 0.75 )
		armult = 1.25;
	if ( hullarmor <= default.armor * 0.5 )
		armult = 1.5;

	if ( hullarmor <= default.armor * 0.30 )
		armult = 1.9;
	if( hullarmor < default.armor )
		hullarmor = Fmin( ( hullarmor / default.armor )*armult , default.armor ) ;
	return hullarmor;
}



simulated function destroyed() {
	local Pawn p;
	local nullweapon nw;

	if (level.netmode != NM_DedicatedServer && !level.bDropDetail) 

			// Let the bot brain know how we died.
		clearRider(pilot, pInfo, dtype);
		clearRider(gunner, gInfo);
		if (p != None)
			p.bHidden=false;
	   
		if (gunner != None)
		 	gunner.bHidden=false;
	

	if (role == ROLE_Authority)
		if (level.netmode != NM_Standalone)


		// Let the bot brain know how we died.
		clearRider(pilot, pInfo, dtype);
		clearRider(gunner, gInfo);
		if (p != None)
			p.bHidden=false;
	   
		if (gunner != None)
		 	gunner.bHidden=false;

	}
    
   


/** Two cases: 1. We're calling this from hitwall() - use the supplied
	 hit location and normal. 2. On the client, destroyed() has been called

	 before a hitwall. In the off chance (likely on a LAN) that the destroy
	 notification arrives from the server before the hitwall is called on
	 the client, we need to spawn our own decal.
*/
simulated function spawnBlast(optional bool havev, optional vector hitl, optional vector hitn) {

	 local vector x, y, z, hl, hn;


	 local Actor wall;

   //  u.debug("spawnBlast()", DL_Verbose);

	 if (bBlasted || level.netmode == NM_DedicatedServer)
		  return;

	 if (havev) {
		  hl = hitl;
		  hn = hitn;

	 } else if (role < ROLE_Authority && level.netmode != NM_Standalone) {
		  getAxes(rotation, x, y, z);
		  wall = trace(hl, hn, location + x * 200, location, false);
		  if (wall == none)
			   return;
	 }

	 

	 bBlasted = true;
}


simulated function spawnWreckage() {
	 local int i;
	 local Wreckage w;
	 local int num;
	 num = 5 + rand(10);
	 for (i = 0; i < num; i++) {
		  w = spawn(class'Wreckage',,, location, rotator(vrand()));
			  w.eject(velocity * 1.0 + (vrand() * vsize(velocity) * 1.0));
	 }
}




/** Set the gunner.
*/
function setGunner(Pawn g) {

	 local string s;
	 local Inventory IG;

	 gunner = g;
	 g.SetDefaultDisplayProperties();
	 IG = g.FindInventoryType(class'UT_ShieldBelt');
	 if ( (IG != None) && (UT_Shieldbelt(IG).MyEffect != None) )
		 UT_Shieldbelt(IG).MyEffect.bHidden = True;
		  g.SetDisplayProperties(ERenderStyle.STY_Translucent, FireTexture'unrealshare.Belt_fx.Invis', true, true);
		  g.Visibility = 10;
		  g.bHidden=True;
		  g.playSound(gunnerSound, SLOT_None, 4.0 * g.soundDampening);
	 setupRider(g, gInfo);

	 if (pilot != none)
		  s = gunnerMountStr[rand(arrayCount(gunnerMountStr))];
	 else
		  s = gunnerMountStr2[rand(arrayCount(gunnerMountStr2))];;

	 broadcastMessage(u.parseKillString(s, g, pilot, true));

	Mlock();
        MlockB();

       
}



/** Sets up the controller for a new pilot. Usually called just after
	 the controller is spawned.
*/
function setPilot(Pawn p, optional Skynet Skynet, optional Skynode launchsn) {

	 local Inventory IP;
	 pilot = p;
                   
//=====================================================================
// Sets Pilots display to Invisable and if has shieldbelt it is also
// Invisable.
//
	 p.SetDefaultDisplayProperties();
	 IP = p.FindInventoryType(class'UT_ShieldBelt');
	 if ( (IP != None) && (UT_Shieldbelt(IP).MyEffect != None) )
		 UT_Shieldbelt(IP).MyEffect.bHidden = True;
	 p.SetDisplayProperties(ERenderStyle.STY_Translucent, FireTexture'unrealshare.Belt_fx.Invis', true, true);
	 p.bHidden=false;

//====================================================================
	 setupRider(p, pInfo, Skynet, launchsn);
	 if (p.isA('PlayerPawn')) {
		  savedBob = PlayerPawn(p).bob;
		  PlayerPawn(p).bob = 0;
		  // So we can fire while ducking and not go straight to shoot mode.
		  // Uh, okay. It's a "feature" now.
		  // bDuck = PlayerPawn(p).bDuck;
	 } else if (p.isA('Bot')) {
		  // Bot need to go slow.
		  throttle = 0.1;
	 }

	 // Save fc for the HUD.
	 fc = FuelCore(p.findInventoryType(class'FuelCore'));
	 // We do this just to init the shoot mode stuff.
	 bShootMode = true;
	 goShootMode();

	Mlock();
        MlockB();
        
	
}

function setupRider(Pawn p, out RiderInfo info, optional Skynet Skynet, optional Skynode launchsn) {
	 local StrangeShell sl;
	// u.debug("setupRider(" $ u.sname(p) $ ")");
	 info.pawn = p;
	 // Check if we were previously the pilot or gunner of another SL.
	 foreach radiusActors(class'StrangeShell', sl, 250) {
		  if (sl != self) {
			   if (sl.pilot == p)
					sl.clearRider(p, sl.pInfo);
			   if (sl.gunner == p)
					sl.clearRider(p, sl.gInfo);
		  }
	 }
	 if (p.isA('PlayerPawn'))
		  info.bOldJumpStatus = PlayerPawn(p).bJumpStatus;
	 info.bDelayedEject = false;
	 if (p.isA('Bot')) {
		info.brain = spawn(Class'SLBotBrain');
		  info.brain.setBot(Bot(p), self, Skynet, launchsn);
	 } else {
		  info.brain = none;
	 }
	 info.lastLoc = vect(0, 0, 0);
	 p.bWarping = true;
	 //p.bCollideWorld = false;
	 giveJD(p);
}

simulated function Pawn getPilot() {
	 return pilot;
}
/** Gunner accessor.
*/

simulated function Pawn getGunner() {
	 return gunner;
}
/** this should probably be called toggleShootMode(). */


function goShootMode() {

	 local Inventory IPSM;

	 if (role < ROLE_Authority)
			   return;


		 // u.debug("goShootMode()");

		  bShootMode = !bShootMode;

	 if (pilot.isA('PlayerPawn')) {
		//  adjustGlow();
		//  pilot.bHidden=true;
		  pilot.clientSetRotation(rotation);


	 }

	 if (bShootMode)
		  setCollisionSize(shootCR, default.collisionHeight);
	 else
		  setCollisionSize(default.collisionRadius, default.collisionHeight);
	 if (pilot != none)
		  handleInv(false);
//=====================================================================
// Sets Pilot display to Invisible and if has shieldbelt it is also
// Invisible if Pilot goes to shoot mode.
//
	 pilot.SetDefaultDisplayProperties();
	 IPSM = Pilot.FindInventoryType(class'UT_ShieldBelt');
	 if ( (IPSM != None) && (UT_Shieldbelt(IPSM).MyEffect != None) )
		   UT_Shieldbelt(IPSM).MyEffect.bHidden = True;
	 pilot.SetDisplayProperties(ERenderStyle.STY_Translucent, FireTexture'unrealshare.Belt_fx.Invis', true, true);
	 pilot.bHidden=False;
//====================================================================
}



/** While riding the rocket you can't shoot unless you're in shoot
	 mode, so we give you a useless 'null weapon' that doesn't really
	 do anything.
**/
function handleInv(bool ejected) {
	// u.debug("handleInv(" $ ejected $ "): weapon:" $ u.sname(pilot.weapon) $ " last:" $ u.sname(lastWeapon));

	 if (bShootMode || ejected) {
		  // I don't know in what case it's none. If they're dead?
		  if (pilot.weapon != none) {
			   // Hopefully this is always right.
			   if (pilot.weapon.isA('nullweapon')) {
					pilot.weapon = none;
					pilot.deleteInventory(nw);
					pilot.pendingWeapon = lastWeapon;
					pilot.changedWeapon();
					lastWeapon = none;
			   } else {
					u.err("handleInv(): Switching weapon back, but current is not a null.");
			   }
		  }
	   } else {
			// Store the previous weapon.
			lastWeapon = pilot.weapon;
			if (nw == none)
			   nw = createnullweapon();
			// Give it to them.
			nw.giveTo(pilot);
			pilot.pendingWeapon = nw;
		  //pilot.weapon.gotoState('DownWeapon');
		  pilot.changedWeapon();
	 }
}


/** We don't need to check for arena mutators anymore. Mine takes care
	 of it - screw everyone else's. :)
*/
function nullweapon createnullweapon() {

	 local nullweapon nw;
	nw = spawn(class'nullweapon', self);
	nw.sl = self;
	 return nw;
}
simulated function addHUD (PlayerPawn P)
{
	local SLHUD M;
	if ( U.UTPureOn(P) )
	{
		foreach AllActors(Class'SLHUD',M)
		{
			goto JL0081;
			continue;
JL0081:
		}
	}
	else
	{
		M=SLHUD(U.getHUDMutator(P,HUDClass.Name));
	}
	if ( M != None )
	{
		M.Reset(self);
	}
	else
	{

		Spawn(HUDClass,self);
	}
	addedHUD=True;
}


/** This is the old controller tick().
*/
simulated function ctick(float delta) {
	// u.debug("ctick(): loc: " $ u.sv(location) $ " ticked: " $ (bTicked == level.bTicked) $ " pilot: " $ u.sname(pilot) $ " gunner: " $ u.sname(gunner), DL_Normal, 5.0);

	 if (gunner != none) {
		  if (slc == none && level.netmode == NM_Client && u.hasViewPort(gunner))
			   slc = spawn(Class'Controller', self);
	 }
		  // -10 is a fudge factor...
		  if (!bWahooPlayed && vsize(velocity) >= (minspeed - 10)) {
			   playSound(sndWahoo, SLOT_None, 3.0);
			   bWahooPlayed = true;
		  }
		  // Here so client will get this call.
		  if (!addedHUD && u.hasViewPort(pilot))
			   addHUD(PlayerPawn(pilot));
  //   }
	 if (role == ROLE_Authority) {
		  handleEjects(pilot, pInfo);
		   handleEjects(gunner, gInfo);
	   }
	 // The dedicated server receives goShootMode() calls from the client.

	 if (level.netmode != NM_DedicatedServer && pilot != none && pilot.isA('PlayerPawn')) {
		  if (PlayerPawn(pilot).bDuck != bDuck) {
			   PlayerPawn(pilot).bDuck = 0;
			   bDuck = 0;
			 //  u.debug("tick(): calling goShootMode()");
			   goShootMode();
		  }
	 }
	 if (pilot != none)
		  adjustThrot(delta);
	 updateSound(delta);
	 if (bAfterburn && gunner != none && PlayerPawn(gunner) != none) {
		  PlayerPawn(gunner).shakeView(delta, 400, 7.5);
	 }
	 if (role >= ROLE_AutonomousProxy)
		  accelerate(delta);
	 // Limit this to being executed on pilot and gunner clients only? FIX.
	 // This is broken. Can't switch owners and auto proxies on the fly.
	 //takeover(delta);
	 burnFuel(delta);
	 // Last but not least, the heart and soul...
	 updateRiders();
}
function handleEjects(Pawn p, RiderInfo info) {
	 if (p != none) {
		  if (p.health <= 0) {
			   clearRider(p, info, 'Shot');
		p.bHidden = false;
		  } else if (info.bDelayedEject) {
			   eject(p);
		p.bHidden = false;
		  } else if (level.netmode != NM_Standalone && jumped(p, info)) {

			   eject(p);
	p.bHidden = false;
		 

		  }
	 }
}
/** d == 0 means this we're switching modes.

*/
function updateSound(float d) {
	 // The drop sound overrides all others. We set it manually in eject().

	 if (ambientSound == sndDrop) {
		  soundRadius = 64.0;
		  soundVolume = 255;
		  soundPitch = 64.0;
		  return;
	 }

	 if (updateMarch(d))
		  return;

	 // Adjust ambient pitch and volume.
	 soundPitch = 24 + 40 * (vsize(velocity) / MaxSpeed);

	 
		if (bNoFuel) {
		  if (d == 0)
	          PlaySound(Sound'RX6T4.NXSounds.ab_FadeSound', SLOT_None, 149.0, , , 1.3);

		  ambientSound = none;
	
 } else if (bAfterburn) {
		  
                  if (d == 0)
		 

 PlaySound(Sound'RX6T4.NXSounds.ab_KickSound');

		  ambientSound = abLoopSound;
		  soundRadius = 180;
		  soundVolume = 255;
                  soundPitch = 24 + 40 * (vsize(velocity) / MaxSpeed);

	 } else {
                 
		  if (d == 0)


	          PlaySound(Sound'RX6T4.NXSounds.ab_FadeSound');

		  soundRadius = 180;
		  soundVolume = Min(255, 150 + 55 * (vsize(velocity) / MaxSpeed));
		  ambientSound = ambsound;
                  soundPitch = 24 + 40 * (vsize(velocity) / MaxSpeed);
	 }
}




simulated function bool updateMarch (float Delta)
{
	local int shields;
	local Inventory i; 


	if ( pilot == None )
	{
		return False;
	}
	shields=0;
	i=pilot.Inventory;
JL0028:
	if ( i != None )
	{
		if ( i.bIsAnArmor )
		{
			shields += i.Charge;
		}
		i=i.Inventory;
		goto JL0028;
	}
	if ( (pilot.Health >= 199) && (shields >= 150) && (Armor >= Default.Armor) && (Pawn(Owner).PlayerReplicationInfo.Team == 0 )) 

  {
	                        if (sndTotalComm != None)             
				MaxSpeed = 3500;
				SlideFX = 255;
                                AirBrakes=255;
				bMarchPlaying=True;
 				
				
				SetDisplayProperties(ERenderStyle.STY_none, 
									 FireTexture'Unrealshare.Belt_fx.Redshield',
									 true,
									 true);

				
				
			AmbientSound=sndMarchLoop;
			SoundVolume=255;
			SoundPitch=64;
			return True;
			bMarchUnder=True;
		        marchWait=0.00;
				

				
}				
	if ( (pilot.Health >= 199) && (shields >= 150) && (Armor >= Default.Armor) && (Pawn(Owner).PlayerReplicationInfo.Team == 1 )) 

  {
	                        if (sndTotalComm != None)             
				MaxSpeed = 3500;
				SlideFX = 255;
				AirBrakes=255;
				bMarchPlaying = True;
 				SetDisplayProperties(ERenderStyle.STY_none, 
									 FireTexture'Unrealshare.Belt_fx.Blueshield',
									 true,
									 true);
				
			AmbientSound=sndMarchLoop;
			SoundVolume=255;
			SoundPitch=64;
			return True;
			bMarchUnder=True;
		        marchWait=0.00;
				




	}		
				if (sndTotalComm == None) {
				MaxSpeed = default.MaxSpeed;
				SlideFX = default.SlideFX;
                                AirBrakes=default.AirBrakes;
				
				}

		if ( bMarchUnder ) {

			bMarchPlaying=True;
			if ( marchWait != -1.00 )
			{
				if ( marchWait > 4.50 )
				{

						playSound(sndTotalComm, SLOT_None, 1.0);

					marchWait=-1.00;
				}
				else
				{
					marchWait += Delta;
				}
			}
			AmbientSound=sndMarchLoop;
			SoundVolume=255;
			SoundPitch=64;
			return True;
			bMarchUnder=True;
		        marchWait=0.00;
		       
		}
	}


/** Loop for updating trailers.
*/

simulated function getTrailers() {
	 if (role == ROLE_AutonomousProxy || level.netmode == NM_StandAlone) {
		  findTrailers(pilot, pInfo);
		  findTrailers(gunner, gInfo);
	 }
}
simulated function findTrailers(Pawn p, out RiderInfo info) {
	 local Actor t;
	 local int i;

   //  u.debug("findTrailers(" $ u.sname(p) $ ")", DL_Verbose);

	 i = 0;
	 info.trailers[i] = none;
	 if (p != none) {
		  foreach p.childActors(class'Actor', t) {
			   if (t.physics == PHYS_Trailer) {

					info.trailers[i] = t;
					i++;
			   }
			   // We can only hold so many...
			   if (i == arrayCount(info.trailers))
					break;
		  }
	 }
}
/** Set the acceleration based on the throttle level.
*/
simulated function accelerate(float delta) {
	 local float max, amax;
	 local float desired, speed;
	 local float dfx;

	 if (DamageFX == true)
		  dfx = (armor / default.armor);
	 if (DamageFX != true)
		  dfx = 1;
	 if (dfx >= 0.65)
		  {
		  if (bAfterburn)
			   {
			   max = MaxSpeed;

			   }
	 else
		  if (!bAfterburn)

			   {
			   max = fullspeed;
			   }

		  }
	 if (dfx < 0.65)
		  {
		  if (bAfterburn)
			   {
			   max = (MaxSpeed * 0.85);

			   }

	 else
		  if (!bAfterburn)

			   {
			   max = (fullspeed * 0.80);

			   }
	 }

	 // Both the pilot and gunner add drag and reduce the max speed.

	 speed = vsize(velocity);
	 desired = lerp(fmin(throttle, 1.0), minspeed, max);
	 amax = (AccelMax * dfx);


	 if (desired < speed)
		  // No reverse jets!
		  amax *= ((AirBrakes * -0.0098) * dfx); // Airbrakes ratio. (0 to -3)
	 if (bAfterburn)


	 amax *= (2.0 * (dfx * 2));

	 // If we're close, just zero it.
	 if (abs(speed - desired) < 0.5)
		  acceleration = vect(0, 0, 0);

	 else
		  // Within 50, slow down.

		  acceleration = vector(rotation) * (fmin(abs(speed - desired) / 50.0, 1.0) * amax);

}
/** Called on the client to determine what's up with the
	 throttle. Adjustments are sent to the server with clientSendThrot()
	 when let go.
*/


simulated function adjustThrot(float delta) {
	 if (pilot.isA('PlayerPawn') && ViewPort(PlayerPawn(pilot).player) != none && !bAfterburn) {
		  if ((PlayerPawn(pilot).bWasForward || throtDir == 1) && thlvl < 1.0) {
			   thlvl = fmin(thlvl + delta * thrate, 1.0);
			   bThrotSent = false;
		  } else if ((PlayerPawn(pilot).bWasBack || throtDir == -1) && thlvl > 0.0) {
			   thlvl = fmax(thlvl - delta * thrate, 0.0);
			   bThrotSent = false;
		  } else {
			   // Did they let go?
			   if (!bThrotSent) {
					//if (role < ROLE_Authority) {
						 clientSendThrot(thlvl);
					//} else {
						 //throttle = thlvl;
					//}
					bThrotSent = true;
			   }
		  }

		  if (thlvl == 0.0 || thlvl == 1.0)
			   throtDir = 0;
	 }
}

/** Client sends the adjusted throttle result to the server.

*/
function clientSendThrot(float thr) {

	// u.debug("clientSendThrot(" $ thr $ ")");
	 // Make sure they're sending a valid throttle.
	 throttle = FClamp(thr, 0.0, 1.0);
}

/** Client sends the adjusted throttle result to the server.
*/
simulated function updateRiders() {


     local vector x, y, z, loc;
     // Minimum safe distance.

     local float d, mx, my, th;
      local Pawn p;
     // This positions the rider slightly behind and above the
     // rocket's center, so it looks between their legs.



     getAxes(rotation, x, y, z);
     loc = location;

     if (pilot != none) {


          // Hmm, this sorta works. FIX.
          if (pilot.isA('PlayerPawn') && PlayerPawn(pilot).isInState('FeigningDeath')) {


               //PlayerPawn(pilot).rise();
               PlayerPawn(pilot).gotoState('PlayerWalking');
               PlayerPawn(pilot).weapon = nw;
          }

          loc += x * pilotOffset.x;     // + 50);   //(FireOffset.Y - 95) * Y
          loc += y * pilotOffset.y;
          loc += z * pilotOffset.z;

          // Adjust z for speed. Hug the rocket.
          loc -= z * (10 * vsize(velocity) / MaxSpeed);

          // Brain controls the rotation, not the bot.
          // CSHP - Only update rotation if the authority.
          if (pilot.isA('Bot') && !bShootMode && role == ROLE_Authority) {
               pilot.clientSetRotation(rotation);



          }



          updateRider(pilot, pInfo, loc);
     }
     // The closest way to pack two vertically oriented cylinders along
     // a line, depending on the the angle of the line:
     //
     // case 1: side by side (x is fixed - mx)

     // case 2: stacked (y is fixed - my).
     //
     // We have theta, solve for the hypotenuse.




     if (gunner != none) {




          if (pilot != none) {
               loc = pilot.location;

               // Min x and y distances.
              mx = (pilot.collisionRadius * 5 + gunner.collisionRadius);
              my = (pilot.collisionHeight * 3 + gunner.collisionHeight);


               //    mx = (pilot.collisionRadius + gunner.collisionRadius);



                //   my = (pilot.collisionHeight + gunner.collisionHeight);

               th = rotation.pitch / 10430.2192;

               if ((mx * tan(th)) < my) {
                    // Side by side.
                    d = mx / cos(th);
               } else {
                    // Stacked.
                    d = my / sin(th);

               }

               d += 1; // FUDGE FACTOR
               loc += x * -d;
          } else {
               // Just use the gunner's collision radius to guesstimate the pilot's.
               loc = location;

               loc += x * pilotOffset.x; // - gunner.collisionRadius);
               loc += y * pilotOffset.y;

               loc += z * pilotOffset.z;
          }

          updateRider(gunner, gInfo, loc);
     }

}

simulated function updateRider(Pawn p, RiderInfo info, vector loc) {
     local EPhysics phys;

     // In order to intercept jump commands (with JumpDetector), we
     // have to set this to walking. Only for standalone games.
     if (level.netmode == NM_Standalone) {
          phys = phys_walking;
     } else {
          phys = PHYS_None;


     }


     info.lastLoc = p.location;
     p.setLocation(loc);
     //p.move(loc - p.location);
     p.velocity = velocity;

     updateTrailers(p, info);
     p.setPhysics(phys);
}


/** We need to update any trailers because we just moved their
     owner. We don't need to update the trailer if it hasn't been ticked
     yet, though.

*/
simulated function updateTrailers(Pawn p, RiderInfo info) {
     local int i;


     for (i = 0; i < arrayCount(info.trailers) && info.trailers[i] != none; i++)

          if (info.trailers[i] != none && info.trailers[i].bTicked)
               info.trailers[i].autonomousPhysics(0);

}


/** Ejects somebody. In standalone games we have to suppress the jump
     velocity to keep the behavior consistent with net games. We can't do
     that here because it's set in PlayerPawn.doJump() *after*
    Inventory.ownerJumped() is called. So we wait one tick and do the
    eject which resets the velocity.
*/
function eject(Actor a, optional int delay, optional bool bForced) {

     local vector x, y, z, loc;
     local EPhysics phys;
     local pawn p;

  //   u.debug("eject(" $ u.sname(a) $ ")", DL_Normal);

     if (Pawn(a) != None) {
          if (delay > 0) {
            //  u.debug("eject(): delaying one tick", DL_Normal);
               if (a == pilot)
                   
                    pInfo.bDelayedEject = true;


              else 
  	
                    gInfo.bDelayedEject = true;


          } else {
               // We aren't setting the velocity on eject
               // anymore. Every tick.
               // In standalone games, the rider has PHYS_Walking
               // set, which limits their velocity. We need to reset
               // it here, and the velocity.
               if (level.netmode == NM_Standalone) {
                    resetPhysics(Pawn(a));

                    a.velocity = velocity;
               }

               // Add little upward eject motion
               getAxes(a.rotation, x, y, z);


               a.velocity += z * 100; 
              // a.velocity += x * -200;

               if (a == pilot) {
                    if (!bForced) {

                         ambientSound = sndDrop;

                         a.playSound(sndPilotEj, SLOT_None, 4.0 * Pawn(a).soundDampening);


                         // We're ejecting. Time to arm the donuts.
                        autoArm();
                    }
                    clearRider(pilot, pInfo);
               } else {
                    // Gunner.
                    if (!bForced)
                         a.playSound(sndGunnerEj, SLOT_None, 4.0 * Pawn(a).soundDampening);
                    clearRider(gunner, gInfo);



//============================================================================================
//    Reset a pawn's physics based on what type of zone it's in, fixes freezing in waterzones=
//============================================================================================
     p = pawn(a);
     
     if (p.region.zone.bWaterZone) {

          phys = PHYS_swimming;

     } else {

          phys = PHYS_Walking; }

     p.setPhysics(phys);


//=============================================================================

               }



          }
     }
}


/** Removes the pilot. Normally called from eject(). If called from
     StrangeShell.destroy(), we are passed the damage type when we were


     destroyed.
*/
function clearRider(Pawn p, RiderInfo info, optional name dtype) {


     if (p == none)
          return;

    // u.debug("clearRider(" $ u.sname(p) $ ")");


     if (p == pilot) {
          handleInv(true);

          if (pilot.isA('PlayerPawn')) {
               PlayerPawn(pilot).bob = savedBob;

               if (!u.hasViewPort(pilot) && bFlipY) {

                    PlayerPawn(pilot).bInvertMouse = !(PlayerPawn(pilot).bInvertMouse);

                    bFlipY = false;
               }
          }

          // If they're in shoot mode, let them keep the same rotation.
          if (!bShootMode)
               pilot.clientSetRotation(rotation);

          // Reset the fog is it's on. Might not be if we're in shoot mode.
        //  if (bFog)
//               adjustGlow();


          // Hmm, iffy. Need to unset the owner so we can get the "real" data.
          newOwner(none);
          remoteRole = ROLE_SimulatedProxy;
          pilot = none;

     } else if (p == gunner) {
          gunner = none;

     } else {
          u.err("clearRider(): Tried to clear a non-rider!");
          return;
     }



     if (p.isA('Bot')) {
          if (info.brain != none) {


               if (dtype != '')
                    info.brain.deathBy(dtype);


               info.brain.destroy();



          }
          p.bCanFly = false;

          p.bCanWalk = true;
     }
     p.bWarping = false;


     //p.bCollideWorld = true;
     resetPhysics(p);
     clearJD(p);
     storeEject(p);

}
function resetPhysics(Pawn a) {
     local EPhysics phys;

     if (a.region.zone.bWaterZone) {

          phys = PHYS_swimming;
     } else {
          phys = PHYS_Falling;
     }

     a.setPhysics(phys);
}




/** Only used for standalone games. Gives the pawn an inventory item
     which detects jumps and calls eject. Other netmodes use
     bJumpStatus.
*/
/** Returns true in network games if they've jumped.
*/
function bool jumped(Pawn p, RiderInfo info) {

	return (p != none && p.isA('PlayerPawn') && PlayerPawn(p).bJumpStatus != info.bOldJumpStatus);
}

function giveJD(Pawn p) {

     local JumpDetector jd;



     if (p.isA('PlayerPawn') && (level.netmode == NM_Standalone || (level.netmode == NM_ListenServer && u.hasViewPort(p)))) {
        //  u.debug("giveJD(" $ u.sname(p) $ ")");

          jd = spawn(class'JumpDetector', self);
          jd.giveTo(p);
          jd.sl = self;

     }
}
/** Clears the jump detector.
*/
function clearJD(Pawn p) {
     local Inventory i;

    // u.debug("clearJD(" $ u.sname(p) $ ")");

     if (level.netmode == NM_Standalone) {
          i = p.inventory;
          while (i != none) {
               if (i.isA('JumpDetector')) {
                    i.destroy();
                    return;
               }
               i = i.inventory;
          }
     }

}

function WarnCannons()
{
     local Pawn P;

     for ( P=Level.Pawnlist; P!=None; P=P.NextPawn )
          if ( P.IsA('TeamCannon') && !P.IsInState('TrackWarhead') && P.LineOfSightTo(self) )
          {
               P.target = self;
               P.GotoState('TrackWarhead');
          }
}

//=================================================================
// Addded in case player dies in flight and Player display dosent reset
//
function pawnHealth() {

if ( Pawn(Owner).Health <= 0 );
          Pawn(Owner).bHidden=False;
          Pawn(Owner).Visibility = Pawn(Owner).Default.Visibility;
          Pawn(Owner).SetDefaultDisplayProperties();
}

//=======================================================================


simulated function bool sameTeam(Pawn p, Pawn p2) {
     return (p != none && p2 != none && level.game.isA('TeamGamePlus') && p.bIsPlayer && p2.bIsPlayer && p.playerReplicationInfo.team == p2.playerReplicationInfo.team);


}

defaultproperties
{
    SlideFX=140
    AirBrakes=100
    speed=500.00
    MaxSpeed=1550.00
    AccelMax=150.00
    DamageFX=True
    baseFuelRate=1.00
    afterburnRate=2.00
    Armor=150.00
    MaxArmor=500.00
    fuel=150.00
    pilotOffset=(X=25.00,Y=3.00,Z=20.00),
    minspeed=500.00
    fullspeed=1150.00
    thrate=1.20
    HUDClass=Class'SLHud'
    ExhaustPuffClass=Class'ExhaustPuff'
    DamagePuffClass=Class'DamagePuff'
    detClass2=Class'StrangeWave'
    puffOffset=70.00
    crushAngle=0.35
    gunnerSound=Sound'SLV2Sounds.Rocket.gunnermount'
    crashSound=Sound'NXSounds.impact'
    warnSound=Sound'SLV2Sounds.Rocket.Warning'
    abLoopSound=Sound'NXSounds.ab_Loop'
    AmbSound=Sound'NXSounds.AmbSound'
    refuelSound=Sound'SLV2Sounds.Rocket.refuel'
    hullHits(0)=Sound'NXSounds.hullhit'
    hullHits(1)=Sound'NXSounds.hullhit2'
    hullHits(2)=Sound'NXSounds.hullhit3'
    hullHits(3)=Sound'NXSounds.hullhit4'
    bounces(0)=Sound'NXSounds.VehicleCollision01'
    bounces(1)=Sound'NXSounds.VehicleCollision02'
    bounces(2)=Sound'NXSounds.VehicleCollision03'
    bounces(3)=Sound'NXSounds.VehicleCollision04'
    bounces(4)=Sound'NXSounds.VehicleCollision05'
    bCanOverride=True
    touchLapse=2.00
    normDamStr="%os got more holes in %oop than a horse trader's mule."
    normSelfDamStr="That's What %k Get's For Treating %kpa Rocket Like A Toy"
    ramDamStr="%o Stood In The Way And Got Splattered By %k."
    ramSelfDamStr="%k Needs An Eye Test"
    ramSelf2DamStr="That's What %k Get's For Treating %kpa Rocket Like A Toy"
    shotDamStr="%k Took The RX6T4 Out From %os 's crotch OUCH."
    shotSelfDamStr="%k Just Owned Himself."
    hitWallDamStr="%k Seemed To Believe They Could Fly Through Walls."
    hitWall2DamStr="%k Needs To Open their eyes when flying."
    hitSLDamStr(0)="%k Being An Idiot, Smacked Into An Unmanned RX6."
    hitSLDamStr(1)="%k is Flying like they have their Eyes closed"
    hitSLDamStr(2)="%k isnt good at dodging, smacked into an empty RX6."
    hitSLDamStr(3)="%k was reduced to a stain on the ground"
    hitSLDamStr(4)="%k Needs to learn to NOT fly into another jet."
    hitSLDamStr2="%k and %o Thought They Would Play Chicken And Get It Wrong."
    lvlimit=600.00
    sndPilotEj=Sound'SLV2Sounds.Rocket.piloteject'
    sndGunnerEj=Sound'SLV2Sounds.Rocket.gunnereject'
    sndDrop=Sound'NXSounds.Warning'
    bBotsObeyOrders=True
    sndMarchLoop=Sound'NXSounds.March2'
    sndTotalComm=Sound'SLV2Sounds.Rocket.totalcomm'
    gunnerMountStr(0)="%k is now the gunner On %os RX6!"
    gunnerMountStr(1)="%k teams up and jumps on %os RX6!"
    gunnerMountStr(2)="%k Has been picked up by %os RX6!"
    gunnerMountStr2(0)="%k leaps onto a rogue RX5!"
    gunnerMountStr2(1)="%k commandeers an unusable RX6."
    gunnerMountStr2(2)="%k has jumped on a useless RX6."
    MyDamageType=SpecialDamage
    ImpactSound=Sound'NXSounds.detonate'
    MiscSound=Sound'NXSounds.impact'
    bCanTeleport=True
    bOwnerNoSee=True
    LifeSpan=0.00
    LODBias=4.00
    Texture=None
    Mesh=LodMesh'X6RP.SLFRed'
    DrawScale=2.00
    bGameRelevant=False
    SoundRadius=40
    SoundVolume=215
    CollisionRadius=25.00
    CollisionHeight=6.00
    bBounce=True
    bFixedRotationDir=True
    NetPriority=3.50
}
